/*
 * Decompiled with CFR 0.152.
 */
package iguanaman.iguanatweakstconstruct.tweaks;

import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.World;
import net.minecraftforge.oredict.RecipeSorter;
import tconstruct.library.crafting.ModifyBuilder;
import tconstruct.library.modifier.ItemModifier;
import tconstruct.library.tools.ToolCore;
import tconstruct.modifiers.tools.ModToolRepair;

public class RepairCraftingRecipe
implements IRecipe {
    private ModToolRepair modifier = null;
    private ItemStack modifiedTool = null;

    public RepairCraftingRecipe() {
        for (ItemModifier mod : ModifyBuilder.instance.itemModifiers) {
            if (!(mod instanceof ModToolRepair)) continue;
            this.modifier = (ModToolRepair)mod;
            break;
        }
    }

    public boolean matches(InventoryCrafting inventoryCrafting, World world) {
        ItemStack tool = null;
        ItemStack[] input = new ItemStack[inventoryCrafting.getSizeInventory()];
        for (int i = 0; i < inventoryCrafting.getSizeInventory(); ++i) {
            ItemStack slot = inventoryCrafting.getStackInSlot(i);
            if (slot == null) continue;
            if (slot.getItem() instanceof ToolCore) {
                tool = slot;
                continue;
            }
            input[i] = slot;
        }
        if (tool == null) {
            return false;
        }
        if (this.modifier.matches(input, tool)) {
            this.modifiedTool = tool.copy();
            this.modifier.modify(input, this.modifiedTool);
            return true;
        }
        this.modifiedTool = null;
        return false;
    }

    public ItemStack getCraftingResult(InventoryCrafting inventoryCrafting) {
        this.matches(inventoryCrafting, null);
        return this.modifiedTool;
    }

    public int getRecipeSize() {
        return 2;
    }

    public ItemStack getRecipeOutput() {
        return this.modifiedTool;
    }

    static {
        RecipeSorter.register((String)"IguanaTweaksTConstruct:repair", RepairCraftingRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"");
    }
}

