/*
 * Decompiled with CFR 0.152.
 */
package iguanaman.hungeroverhaul.module.json;

import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistryEntry;
import squeek.applecore.api.food.FoodValues;

public class Food {
    public String name;
    public String oreName;
    public int meta = 0;
    public int count = 1;
    public float saturationModifier = 0.0f;
    public int hunger = 0;

    public boolean hasOredictEntry() {
        return this.oreName.isEmpty();
    }

    public ItemStack toItemStack() {
        Block block;
        ResourceLocation loc = new ResourceLocation(this.name);
        Item item = (Item)ForgeRegistries.ITEMS.getValue(loc);
        if (item == Items.AIR && (block = (Block)ForgeRegistries.BLOCKS.getValue(loc)) != null) {
            item = Item.getItemFromBlock((Block)block);
        }
        return item == null ? ItemStack.EMPTY : new ItemStack((Item)ForgeRegistries.ITEMS.getValue(loc), this.count, this.meta);
    }

    public FoodValues toFoodValues() {
        return new FoodValues(this.hunger, this.saturationModifier);
    }

    public static Food fromItemStack(ItemStack is, FoodValues fv) {
        return Food.fromItemStack(is, Float.valueOf(fv.saturationModifier), fv.hunger);
    }

    public static Food fromItemStack(ItemStack is, Float saturationModifier, int hunger) {
        Food fd = new Food();
        fd.name = ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)is.getItem()).toString();
        if (fd.name == null || fd.name.isEmpty()) {
            fd.name = ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)Block.getBlockFromItem((Item)is.getItem())).toString();
        }
        if (fd.name == null || fd.name.isEmpty()) {
            return null;
        }
        fd.meta = is.getItemDamage();
        fd.count = is.getCount();
        int[] oreIds = OreDictionary.getOreIDs((ItemStack)is);
        if (oreIds.length > 0) {
            fd.oreName = OreDictionary.getOreName((int)oreIds[0]);
        }
        fd.saturationModifier = saturationModifier.floatValue();
        fd.hunger = hunger;
        return fd;
    }
}

