/*
 * Decompiled with CFR 0.152.
 */
package iguanaman.hungeroverhaul.common.config;

import iguanaman.hungeroverhaul.common.config.ConfigCategory;
import iguanaman.hungeroverhaul.common.config.ConfigOption;
import iguanaman.hungeroverhaul.library.Util;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.logging.log4j.Logger;

public class Config {
    public static Config instance = new Config();
    public static Logger log = Util.getLogger("Config");
    public static final List<ConfigCategory> configCategories = new ArrayList<ConfigCategory>();
    public static final List<ConfigOption<?>> configOptions = new ArrayList();
    public static final ConfigCategory CATEGORY_GETTING_SEEDS = Config.addCategory("getting seeds", "Options for obtaining seeds");
    public static final ConfigCategory CATEGORY_DELAYS = Config.addCategory("delays", "Delays for various obtaining food related activities");
    public static final ConfigCategory CATEGORY_HARVESTING = Config.addCategory("harvesting", "Options related to drops from crops");
    public static final ConfigCategory CATEGORY_CUSTOM_FIELD = Config.addCategory("custom field", "Options for enabling and manipulating a custom field in Villages");
    public static final ConfigCategory CATEGORY_DIFFICULTY_SCALING = Config.addCategory("difficulty scaling", "Options to scale the difficulty of certain elements based on game difficulty");
    public static final ConfigCategory CATEGORY_FOOD = Config.addCategory("food", "Food related options");
    public static final ConfigCategory CATEGORY_HARVESTCRAFT = Config.addCategory("harvestcraft", "Options related to HarvestCraft.\n" + TextFormatting.RED + "Only works if HarvestCraft is installed!");
    public static final ConfigCategory CATEGORY_NATURA = Config.addCategory("natura", "Options related to Natura.\n" + TextFormatting.RED + "Only works if Natura is installed!");
    public static final ConfigCategory CATEGORY_HUNGER = Config.addCategory("hunger", "Options related to hunger");
    public static final ConfigCategory CATEGORY_LOW_STATS = Config.addCategory("low stats", "Options for how to handle when the player get low health/hunger");
    public static final ConfigCategory CATEGORY_HEALTH = Config.addCategory("health", "Options related to health");
    public static final ConfigOption<Boolean> allSeedsEqualOption = Config.addOption(CATEGORY_GETTING_SEEDS, "allSeedsEqual", true, false, "Each seed has an equal chance to drop (grass drops and via hoes)");
    public static boolean allSeedsEqual;
    public static final ConfigOption<Boolean> removeTallGrassSeedsOption;
    public static boolean removeTallGrassSeeds;
    public static final ConfigOption<Boolean> modifyHoeUseOption;
    public static boolean modifyHoeUse;
    public static final ConfigOption<Boolean> removeHoeRecipesOption;
    public static boolean removeHoeRecipes;
    public static final ConfigOption<Integer> hoeToolDamageMultiplierOption;
    public static int hoeToolDamageMultiplier;
    public static final ConfigOption<Integer> seedChanceOption;
    public static int seedChance;
    public static final ConfigOption<Boolean> addSeedsCraftingRecipeOption;
    public static boolean addSeedsCraftingRecipe;
    public static final ConfigOption<Float> noSunlightRegrowthMultiplierOption;
    public static float noSunlightRegrowthMultiplier;
    public static final ConfigOption<Float> wrongBiomeRegrowthMultiplierOption;
    public static float wrongBiomeRegrowthMultiplier;
    public static final ConfigOption<Float> wrongBiomeRegrowthMultiplierSugarcaneOption;
    public static float wrongBiomeRegrowthMultiplierSugarcane;
    public static final ConfigOption<Float> flowerRegrowthMultiplierOption;
    public static float flowerRegrowthMultiplier;
    public static final ConfigOption<Float> cropRegrowthMultiplierOption;
    public static float cropRegrowthMultiplier;
    public static final ConfigOption<Float> cactusRegrowthMultiplierOption;
    public static float cactusRegrowthMultiplier;
    public static final ConfigOption<Float> cocoaRegrowthMultiplierOption;
    public static float cocoaRegrowthMultiplier;
    public static final ConfigOption<Float> sugarcaneRegrowthMultiplierOption;
    public static float sugarcaneRegrowthMultiplier;
    public static final ConfigOption<Float> treeCropRegrowthMultiplierOption;
    public static float treeCropRegrowthMultiplier;
    public static final ConfigOption<Float> saplingRegrowthMultiplierOption;
    public static float saplingRegrowthMultiplier;
    public static final ConfigOption<Float> netherWartRegrowthMultiplierOption;
    public static float netherWartRegrowthMultiplier;
    public static final ConfigOption<Float> dryingRackTimeMultiplierOption;
    public static float dryingRackTimeMultiplier;
    public static final ConfigOption<Float> eggTimeoutMultiplierOption;
    public static float eggTimeoutMultiplier;
    public static final ConfigOption<Float> breedingTimeoutMultiplierOption;
    public static float breedingTimeoutMultiplier;
    public static final ConfigOption<Float> childDurationMultiplierOption;
    public static float childDurationMultiplier;
    public static final ConfigOption<Integer> milkedTimeoutOption;
    public static int milkedTimeout;
    public static final ConfigOption<Boolean> enableRightClickHarvestingOption;
    public static boolean enableRightClickHarvesting;
    public static final ConfigOption<Boolean> modifyCropDropsRightClickOption;
    public static boolean modifyCropDropsRightClick;
    public static final ConfigOption<Boolean> modifyCropDropsBreakOption;
    public static boolean modifyCropDropsBreak;
    public static final ConfigOption<Integer> seedsPerHarvestRightClickMinOption;
    public static int seedsPerHarvestRightClickMin;
    public static final ConfigOption<Integer> seedsPerHarvestRightClickMaxOption;
    public static int seedsPerHarvestRightClickMax;
    public static final ConfigOption<Integer> seedsPerHarvestBreakMinOption;
    public static int seedsPerHarvestBreakMin;
    public static final ConfigOption<Integer> seedsPerHarvestBreakMaxOption;
    public static int seedsPerHarvestBreakMax;
    public static final ConfigOption<Integer> producePerHarvestRightClickMinOption;
    public static int producePerHarvestRightClickMin;
    public static final ConfigOption<Integer> producePerHarvestRightClickMaxOption;
    public static int producePerHarvestRightClickMax;
    public static final ConfigOption<Integer> producePerHarvestBreakMinOption;
    public static int producePerHarvestBreakMin;
    public static final ConfigOption<Integer> producePerHarvestBreakMaxOption;
    public static int producePerHarvestBreakMax;
    public static final ConfigOption<Float> bonemealEffectivenessOption;
    public static float bonemealEffectiveness;
    public static final ConfigOption<Boolean> modifyBonemealGrowthOption;
    public static boolean modifyBonemealGrowth;
    public static final ConfigOption<Boolean> addCustomVillageFieldOption;
    public static boolean addCustomVillageField;
    public static final ConfigOption<Integer> fieldNormalWeightOption;
    public static int fieldNormalWeight;
    public static final ConfigOption<Integer> fieldReedWeightOption;
    public static int fieldReedWeight;
    public static final ConfigOption<Integer> fieldStemWeightOption;
    public static int fieldStemWeight;
    public static final ConfigOption<Boolean> difficultyScalingOption;
    public static boolean difficultyScaling;
    public static final ConfigOption<Boolean> difficultyScalingBoneMealOption;
    public static boolean difficultyScalingBoneMeal;
    public static final ConfigOption<Boolean> difficultyScalingEffectsOption;
    public static boolean difficultyScalingEffects;
    public static final ConfigOption<Boolean> difficultyScalingHealingOption;
    public static boolean difficultyScalingHealing;
    public static final ConfigOption<Boolean> difficultyScalingHungerOption;
    public static boolean difficultyScalingHunger;
    public static final ConfigOption<Boolean> difficultyScalingRespawnHungerOption;
    public static boolean difficultyScalingRespawnHunger;
    public static final ConfigOption<Boolean> modifyFoodValuesOption;
    public static boolean modifyFoodValues;
    public static final ConfigOption<Boolean> useHOFoodValuesOption;
    public static boolean useHOFoodValues;
    public static final ConfigOption<Boolean> addFoodTooltipsOption;
    public static boolean addFoodTooltips;
    public static final ConfigOption<Boolean> modifyFoodStackSizeOption;
    public static boolean modifyFoodStackSize;
    public static final ConfigOption<Boolean> modifyFoodEatingSpeedOption;
    public static boolean modifyFoodEatingSpeed;
    public static final ConfigOption<Integer> foodStackSizeMultiplierOption;
    public static int foodStackSizeMultiplier;
    public static final ConfigOption<Float> foodHungerDividerOption;
    public static float foodHungerDivider;
    public static final ConfigOption<Float> foodSaturationDividerOption;
    public static float foodSaturationDivider;
    public static final ConfigOption<Float> foodHungerToSaturationDividerOption;
    public static float foodHungerToSaturationDivider;
    public static final ConfigOption<Boolean> addWellFedEffectOption;
    public static boolean addWellFedEffect;
    public static final ConfigOption<Float> wellFedDurationMultiplierOption;
    public static float wellFedDurationMultiplier;
    public static final ConfigOption<Float> wellFedEffectivenessOption;
    public static float wellFedEffectiveness;
    public static final ConfigOption<Boolean> addTradesButcherOption;
    public static boolean addTradesButcher;
    public static final ConfigOption<Boolean> addCropTradesFarmerOption;
    public static boolean addTradesFarmer;
    public static final ConfigOption<Boolean> addSaplingTradesFarmerOption;
    public static boolean addSaplingTradesFarmer;
    public static final ConfigOption<Boolean> addHarvestCraftChestLootOption;
    public static boolean addHarvestCraftChestLoot;
    public static final ConfigOption<Integer> chestLootMaxStackSizeOption;
    public static int chestLootMaxStackSize;
    public static final ConfigOption<Float> chestLootChanceOption;
    public static float chestLootChance;
    public static final ConfigOption<Boolean> foodsUnplantableOption;
    public static boolean foodsUnplantable;
    public static final ConfigOption<Boolean> removeNaturaFlourCraftingRecipesOption;
    public static boolean removeNaturaFlourCraftingRecipes;
    public static final ConfigOption<Boolean> removeNaturaFlourSmeltingRecipeOption;
    public static boolean removeNaturaFlourSmeltingRecipe;
    public static final ConfigOption<Boolean> addAlternateNaturaFlourCraftingRecipesOption;
    public static boolean addAlternateNaturaFlourCraftingRecipes;
    public static final ConfigOption<Boolean> constantHungerLossOption;
    public static boolean constantHungerLoss;
    public static final ConfigOption<Integer> damageOnStarveOption;
    public static int damageOnStarve;
    public static final ConfigOption<Boolean> enableRespawnHungerOption;
    public static boolean enableRespawnHunger;
    public static final ConfigOption<Integer> respawnHungerValueOption;
    public static int respawnHungerValue;
    public static final ConfigOption<Integer> respawnHungerDifficultyModifierOption;
    public static int respawnHungerDifficultyModifier;
    public static final ConfigOption<Boolean> disableHealingHungerDrainOption;
    public static boolean disableHealingHungerDrain;
    public static final ConfigOption<Float> hungerLossRatePercentageOption;
    public static float hungerLossRatePercentage;
    public static final ConfigOption<Boolean> addGuiTextOption;
    public static boolean addGuiText;
    public static final ConfigOption<Boolean> addLowStatEffectsOption;
    public static boolean addLowStatEffects;
    public static final ConfigOption<Boolean> addLowHealthNauseaOption;
    public static boolean addLowHealthNausea;
    public static final ConfigOption<Boolean> addLowHungerNauseaOption;
    public static boolean addLowHungerNausea;
    public static final ConfigOption<Boolean> addLowHealthSlownessOption;
    public static boolean addLowHealthSlowness;
    public static final ConfigOption<Boolean> addLowHungerSlownessOption;
    public static boolean addLowHungerSlowness;
    public static final ConfigOption<Boolean> addLowHealthWeaknessOption;
    public static boolean addLowHealthWeakness;
    public static final ConfigOption<Boolean> addLowHungerWeaknessOption;
    public static boolean addLowHungerWeakness;
    public static final ConfigOption<Boolean> addLowHealthMiningSlowdownOption;
    public static boolean addLowHealthMiningSlowdown;
    public static final ConfigOption<Boolean> addLowHungerMiningSlowdownOption;
    public static boolean addLowHungerMiningSlowdown;
    public static final ConfigOption<Integer> minHungerToHealOption;
    public static int minHungerToHeal;
    public static final ConfigOption<Boolean> foodRegensHealthOption;
    public static boolean foodRegensHealth;
    public static final ConfigOption<Integer> foodHealDividerOption;
    public static int foodHealDivider;
    public static final ConfigOption<Integer> healthRegenRatePercentageOption;
    public static int healthRegenRatePercentage;
    public static final ConfigOption<Boolean> modifyRegenRateOnLowHealthOption;
    public static boolean modifyRegenRateOnLowHealth;
    public static final ConfigOption<Integer> lowHealthRegenRateModifierOption;
    public static int lowHealthRegenRateModifier;
    static Configuration config;
    static Configuration blankSlateConfig;
    static Configuration defaultConfig;

    private Config() {
    }

    public static void load(FMLPreInitializationEvent event) {
        File configurationDir = new File(event.getModConfigurationDirectory(), "hungeroverhaul");
        if (!configurationDir.exists()) {
            try {
                if (!configurationDir.mkdir()) {
                    log.error("Could not create config directory {}", (Object)configurationDir);
                    return;
                }
            }
            catch (SecurityException e) {
                log.error("Could not create config directory {}", (Object)configurationDir, (Object)e);
                return;
            }
        }
        File configFile = new File(configurationDir, "HungerOverhaul.cfg");
        File defaultConfigFile = new File(configurationDir, "default.cfg");
        File blankSlateConfigFile = new File(configurationDir, "blankslate.cfg");
        File oldConfigFile = event.getSuggestedConfigurationFile();
        if (oldConfigFile.exists()) {
            try {
                if (!oldConfigFile.renameTo(configFile)) {
                    log.error("Could not move old config file {}", (Object)oldConfigFile);
                }
            }
            catch (SecurityException e) {
                log.error("Could not move old config file {}", (Object)oldConfigFile, (Object)e);
            }
        }
        config = new Configuration(configFile, "0.0.0", false);
        defaultConfig = new Configuration(defaultConfigFile, "0.0.0", false);
        blankSlateConfig = new Configuration(blankSlateConfigFile, "0.0.0", false);
        MinecraftForge.EVENT_BUS.register((Object)instance);
        Config.syncMainConfig();
        Config.syncDefaultConfig();
        Config.syncBlankStateConfig();
    }

    @SubscribeEvent
    public void update(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("hungeroverhaul")) {
            Config.syncMainConfig();
        }
    }

    public static boolean syncMainConfig() {
        if (config == null) {
            return false;
        }
        for (ConfigCategory configCategory : configCategories) {
            configCategory.create(config);
        }
        if (config.hasCategory(" ")) {
            config.removeCategory(config.getCategory(" "));
        }
        allSeedsEqual = allSeedsEqualOption.get(config);
        removeHoeRecipes = removeHoeRecipesOption.get(config);
        modifyHoeUse = modifyHoeUseOption.get(config);
        removeTallGrassSeeds = removeTallGrassSeedsOption.get(config);
        seedChance = seedChanceOption.get(config);
        hoeToolDamageMultiplier = hoeToolDamageMultiplierOption.get(config);
        addSeedsCraftingRecipe = addSeedsCraftingRecipeOption.get(config);
        noSunlightRegrowthMultiplier = noSunlightRegrowthMultiplierOption.get(config).floatValue();
        wrongBiomeRegrowthMultiplier = wrongBiomeRegrowthMultiplierOption.get(config).floatValue();
        wrongBiomeRegrowthMultiplierSugarcane = wrongBiomeRegrowthMultiplierSugarcaneOption.get(config).floatValue();
        flowerRegrowthMultiplier = flowerRegrowthMultiplierOption.get(config).floatValue();
        cropRegrowthMultiplier = cropRegrowthMultiplierOption.get(config).floatValue();
        sugarcaneRegrowthMultiplier = sugarcaneRegrowthMultiplierOption.get(config).floatValue();
        cactusRegrowthMultiplier = cactusRegrowthMultiplierOption.get(config).floatValue();
        cocoaRegrowthMultiplier = cocoaRegrowthMultiplierOption.get(config).floatValue();
        treeCropRegrowthMultiplier = treeCropRegrowthMultiplierOption.get(config).floatValue();
        saplingRegrowthMultiplier = saplingRegrowthMultiplierOption.get(config).floatValue();
        netherWartRegrowthMultiplier = netherWartRegrowthMultiplierOption.get(config).floatValue();
        dryingRackTimeMultiplier = dryingRackTimeMultiplierOption.get(config).floatValue();
        eggTimeoutMultiplier = eggTimeoutMultiplierOption.get(config).floatValue();
        breedingTimeoutMultiplier = breedingTimeoutMultiplierOption.get(config).floatValue();
        childDurationMultiplier = childDurationMultiplierOption.get(config).floatValue();
        milkedTimeout = milkedTimeoutOption.get(config);
        enableRightClickHarvesting = enableRightClickHarvestingOption.get(config);
        modifyCropDropsBreak = modifyCropDropsBreakOption.get(config);
        modifyCropDropsRightClick = modifyCropDropsRightClickOption.get(config);
        seedsPerHarvestRightClickMin = seedsPerHarvestRightClickMinOption.get(config);
        seedsPerHarvestRightClickMax = seedsPerHarvestRightClickMaxOption.get(config);
        seedsPerHarvestBreakMin = seedsPerHarvestBreakMinOption.get(config);
        seedsPerHarvestBreakMax = seedsPerHarvestBreakMaxOption.get(config);
        producePerHarvestRightClickMin = producePerHarvestRightClickMinOption.get(config);
        producePerHarvestRightClickMax = producePerHarvestRightClickMaxOption.get(config);
        producePerHarvestBreakMin = producePerHarvestBreakMinOption.get(config);
        producePerHarvestBreakMax = producePerHarvestBreakMaxOption.get(config);
        bonemealEffectiveness = bonemealEffectivenessOption.get(config).floatValue();
        modifyBonemealGrowth = modifyBonemealGrowthOption.getBackwardsCompatible(config, difficultyScalingBoneMealOption);
        addCustomVillageField = addCustomVillageFieldOption.get(config);
        fieldNormalWeight = fieldNormalWeightOption.get(config);
        fieldReedWeight = fieldReedWeightOption.get(config);
        fieldStemWeight = fieldStemWeightOption.get(config);
        difficultyScaling = difficultyScalingOption.get(config);
        difficultyScalingBoneMeal = difficultyScalingBoneMealOption.get(config) != false && difficultyScaling;
        difficultyScalingEffects = difficultyScalingEffectsOption.get(config) != false && difficultyScaling;
        difficultyScalingHealing = difficultyScalingHealingOption.get(config) != false && difficultyScaling;
        difficultyScalingHunger = difficultyScalingHungerOption.get(config) != false && difficultyScaling;
        difficultyScalingRespawnHunger = difficultyScalingRespawnHungerOption.get(config) != false && difficultyScaling;
        modifyFoodValues = modifyFoodValuesOption.get(config);
        useHOFoodValues = useHOFoodValuesOption.get(config);
        addFoodTooltips = addFoodTooltipsOption.get(config);
        modifyFoodEatingSpeed = modifyFoodEatingSpeedOption.get(config);
        modifyFoodStackSize = modifyFoodStackSizeOption.get(config);
        foodStackSizeMultiplier = foodStackSizeMultiplierOption.get(config);
        foodHungerDivider = foodHungerDividerOption.get(config).floatValue();
        foodSaturationDivider = foodSaturationDividerOption.get(config).floatValue();
        foodHungerToSaturationDivider = foodHungerToSaturationDividerOption.get(config).floatValue();
        addWellFedEffect = addWellFedEffectOption.get(config);
        wellFedDurationMultiplier = wellFedDurationMultiplierOption.get(config).floatValue();
        wellFedEffectiveness = wellFedEffectivenessOption.get(config).floatValue();
        addTradesButcher = addTradesButcherOption.get(config);
        addTradesFarmer = addCropTradesFarmerOption.get(config);
        addSaplingTradesFarmer = addSaplingTradesFarmerOption.get(config);
        addHarvestCraftChestLoot = addHarvestCraftChestLootOption.get(config);
        chestLootMaxStackSize = chestLootMaxStackSizeOption.get(config);
        chestLootChance = chestLootChanceOption.get(config).floatValue();
        foodsUnplantable = foodsUnplantableOption.get(config);
        removeNaturaFlourCraftingRecipes = removeNaturaFlourCraftingRecipesOption.get(config);
        removeNaturaFlourSmeltingRecipe = removeNaturaFlourSmeltingRecipeOption.get(config);
        addAlternateNaturaFlourCraftingRecipes = addAlternateNaturaFlourCraftingRecipesOption.get(config);
        constantHungerLoss = constantHungerLossOption.get(config);
        damageOnStarve = damageOnStarveOption.get(config);
        enableRespawnHunger = enableRespawnHungerOption.get(config);
        respawnHungerValue = respawnHungerValueOption.get(config);
        respawnHungerDifficultyModifier = respawnHungerDifficultyModifierOption.get(config);
        disableHealingHungerDrain = disableHealingHungerDrainOption.get(config);
        hungerLossRatePercentage = hungerLossRatePercentageOption.get(config).floatValue();
        addGuiText = addGuiTextOption.get(config);
        addLowStatEffects = addLowStatEffectsOption.get(config);
        addLowHealthNausea = addLowHealthNauseaOption.get(config);
        addLowHungerNausea = addLowHungerNauseaOption.get(config);
        addLowHealthSlowness = addLowHealthSlownessOption.get(config);
        addLowHungerSlowness = addLowHungerSlownessOption.get(config);
        addLowHealthWeakness = addLowHealthWeaknessOption.get(config);
        addLowHungerWeakness = addLowHungerWeaknessOption.get(config);
        addLowHealthMiningSlowdown = addLowHealthMiningSlowdownOption.get(config);
        addLowHungerMiningSlowdown = addLowHungerMiningSlowdownOption.get(config);
        foodRegensHealth = foodRegensHealthOption.get(config);
        minHungerToHeal = minHungerToHealOption.get(config);
        healthRegenRatePercentage = healthRegenRatePercentageOption.get(config);
        modifyRegenRateOnLowHealth = modifyRegenRateOnLowHealthOption.get(config);
        lowHealthRegenRateModifier = lowHealthRegenRateModifierOption.get(config);
        foodHealDivider = foodHealDividerOption.get(config);
        boolean configChanged = config.hasChanged();
        if (configChanged) {
            config.save();
        }
        return configChanged;
    }

    public static boolean syncDefaultConfig() {
        if (defaultConfig == null) {
            return false;
        }
        defaultConfig.addCustomCategoryComment(" ", "This config contains all of the default Hunger Overhaul settings.\nIt's intended to serve as an easy backup for returning to the defaults.\nTo use, rename this file to HungerOverhaul.cfg (overwriting your current HungerOverhaul.cfg)");
        for (ConfigCategory configCategory : configCategories) {
            configCategory.create(defaultConfig);
        }
        for (ConfigOption configOption : configOptions) {
            configOption.setToDefault(defaultConfig);
        }
        boolean configChanged = defaultConfig.hasChanged();
        if (configChanged) {
            defaultConfig.save();
        }
        return configChanged;
    }

    public static boolean syncBlankStateConfig() {
        if (blankSlateConfig == null) {
            return false;
        }
        blankSlateConfig.addCustomCategoryComment(" ", "This config contains settings that will disable all of the changes that Hunger Overhaul makes.\nIt's intended to serve as a starting point for anyone wanting to only enable a few things and leave everything else untouched.\nTo use, rename this file to HungerOverhaul.cfg (overwriting your current HungerOverhaul.cfg)");
        for (ConfigCategory configCategory : configCategories) {
            configCategory.create(blankSlateConfig);
        }
        for (ConfigOption configOption : configOptions) {
            configOption.setToBlankSlate(blankSlateConfig);
        }
        boolean configChanged = blankSlateConfig.hasChanged();
        if (configChanged) {
            blankSlateConfig.save();
        }
        return configChanged;
    }

    public static ConfigCategory addCategory(String name, String comment) {
        return Config.putCategoryInList(name, comment, configCategories);
    }

    public static ConfigCategory putCategoryInList(String name, String comment, List<ConfigCategory> list) {
        ConfigCategory category = new ConfigCategory(name, comment);
        list.add(category);
        return category;
    }

    public static <T> ConfigOption<T> addOption(ConfigCategory category, String name, T defaultValue, T blankSlate, String comment) {
        return Config.addOption(category, name, defaultValue, null, null, blankSlate, comment);
    }

    public static <T> ConfigOption<T> addOption(ConfigCategory category, String name, T defaultValue, T minValue, T maxValue, T blankSlate, String comment) {
        return Config.putOptionInList(category, name, defaultValue, minValue, maxValue, blankSlate, comment, configOptions);
    }

    public static <T> ConfigOption<T> putOptionInList(ConfigCategory category, String name, T defaultValue, T minValue, T maxValue, T blankSlate, String comment, List<ConfigOption<?>> list) {
        ConfigOption<T> configOption = new ConfigOption<T>(category.name, name, defaultValue, minValue, maxValue, blankSlate, comment);
        list.add(configOption);
        return configOption;
    }

    static {
        removeTallGrassSeedsOption = Config.addOption(CATEGORY_GETTING_SEEDS, "removeTallGrassSeeds", true, false, "Removes seed drops when breaking tall grass");
        modifyHoeUseOption = Config.addOption(CATEGORY_GETTING_SEEDS, "modifyHoeUse", true, false, "Changes the use of hoes depending on the availability of water");
        removeHoeRecipesOption = Config.addOption(CATEGORY_GETTING_SEEDS, "removeHoeRecipes", true, false, "Whether wood and stone hoe recipes are removed");
        hoeToolDamageMultiplierOption = Config.addOption(CATEGORY_GETTING_SEEDS, "hoeToolDamageMultiplier", 5, 1, null, 1, "Multiplier on tool damage taken when a hoe is used ('modifyHoeUse' must be true)");
        seedChanceOption = Config.addOption(CATEGORY_GETTING_SEEDS, "seedChance", 20, 0, 100, 20, "Percent chance for seed to drop from hoe use on normal difficulty ('modifyHoeUse' must be true)");
        addSeedsCraftingRecipeOption = Config.addOption(CATEGORY_GETTING_SEEDS, "addSeedsCraftingRecipe", true, false, "Adds a crafting recipe to turn 1 wheat into 1 seed");
        noSunlightRegrowthMultiplierOption = Config.addOption(CATEGORY_DELAYS, "noSunlightRegrowthMultiplier", Float.valueOf(2.0f), Float.valueOf(0.0f), null, Float.valueOf(1.0f), "Multipier on crop growth time without sunlight (1 to disable feature, 0 to make crops only grow in sunlight)");
        wrongBiomeRegrowthMultiplierOption = Config.addOption(CATEGORY_DELAYS, "wrongBiomeRegrowthMultiplier", Float.valueOf(2.0f), Float.valueOf(0.0f), null, Float.valueOf(1.0f), "Multipier on crop growth time (except sugarcane) in the wrong biome (1 to disable feature, 0 to make crops only grow in correct biome)");
        wrongBiomeRegrowthMultiplierSugarcaneOption = Config.addOption(CATEGORY_DELAYS, "wrongBiomeRegrowthMultiplierSugarcane", Float.valueOf(2.0f), Float.valueOf(0.0f), null, Float.valueOf(1.0f), "Multipier on sugarcane growth time in the wrong biome (1 to disable feature, 0 to make sugarcane only grow in correct biome)");
        flowerRegrowthMultiplierOption = Config.addOption(CATEGORY_DELAYS, "flowerRegrowthMultiplier", Float.valueOf(1.0f), Float.valueOf(0.0f), null, Float.valueOf(1.0f), "Multiplier on the time it takes a WeeeFlower crop to grow");
        cropRegrowthMultiplierOption = Config.addOption(CATEGORY_DELAYS, "cropRegrowthMultiplier", Float.valueOf(4.0f), Float.valueOf(0.0f), null, Float.valueOf(1.0f), "Multiplier on the time it takes a non-tree crop to grow");
        cactusRegrowthMultiplierOption = Config.addOption(CATEGORY_DELAYS, "cactusRegrowthMultiplier", Float.valueOf(4.0f), Float.valueOf(0.0f), null, Float.valueOf(1.0f), "Multiplier on the time it takes cactus to grow");
        cocoaRegrowthMultiplierOption = Config.addOption(CATEGORY_DELAYS, "cocoaRegrowthMultiplier", Float.valueOf(4.0f), Float.valueOf(0.0f), null, Float.valueOf(1.0f), "Multiplier on the time it takes cocoa to grow");
        sugarcaneRegrowthMultiplierOption = Config.addOption(CATEGORY_DELAYS, "sugarcaneRegrowthMultiplier", Float.valueOf(4.0f), Float.valueOf(0.0f), null, Float.valueOf(1.0f), "Multiplier on the time it takes sugarcane to grow");
        treeCropRegrowthMultiplierOption = Config.addOption(CATEGORY_DELAYS, "treeCropRegrowthMultiplier", Float.valueOf(4.0f), Float.valueOf(0.0f), null, Float.valueOf(1.0f), "Multiplier on the time it takes a tree crop to grow");
        saplingRegrowthMultiplierOption = Config.addOption(CATEGORY_DELAYS, "saplingRegrowthMultiplier", Float.valueOf(4.0f), Float.valueOf(0.0f), null, Float.valueOf(1.0f), "Multiplier on the time it takes a sapling to grow into a tree");
        netherWartRegrowthMultiplierOption = Config.addOption(CATEGORY_DELAYS, "netherWartRegrowthMultiplier", Float.valueOf(4.0f), Float.valueOf(0.0f), null, Float.valueOf(1.0f), "Multiplier on the time it takes nether wart to grow");
        dryingRackTimeMultiplierOption = Config.addOption(CATEGORY_DELAYS, "dryingRackTimeMultiplier", Float.valueOf(4.0f), Float.valueOf(0.0f), null, Float.valueOf(1.0f), "Multiplier on the time it takes food to dry on Tinkers' Construct drying racks");
        eggTimeoutMultiplierOption = Config.addOption(CATEGORY_DELAYS, "eggTimeoutMultiplier", Float.valueOf(4.0f), Float.valueOf(0.0f), null, Float.valueOf(1.0f), "Multiplier applied to the delay between chicken egg laying");
        breedingTimeoutMultiplierOption = Config.addOption(CATEGORY_DELAYS, "breedingTimeoutMultiplier", Float.valueOf(4.0f), Float.valueOf(0.0f), null, Float.valueOf(1.0f), "Multiplier applied to the delay between breeding entities");
        childDurationMultiplierOption = Config.addOption(CATEGORY_DELAYS, "childDurationMultiplier", Float.valueOf(4.0f), Float.valueOf(0.0f), null, Float.valueOf(1.0f), "Multiplier applied to the delay before children become adults");
        milkedTimeoutOption = Config.addOption(CATEGORY_DELAYS, "milkedTimeout", 20, 0, null, 0, "Delay (in minutes) after milking a cow before it can be milked again");
        enableRightClickHarvestingOption = Config.addOption(CATEGORY_HARVESTING, "enableRightClickHarvesting", true, false, "Enables/disables harvest crops by right clicking them");
        modifyCropDropsRightClickOption = Config.addOption(CATEGORY_HARVESTING, "modifyCropDropsRightClick", true, false, "Enables/disables modification of the item drops of crops when right clicking them (produce and seeds)");
        modifyCropDropsBreakOption = Config.addOption(CATEGORY_HARVESTING, "modifyCropDropsBreak", true, false, "Enables/disables modification of the item drops of crops when breaking them (produce and seeds)");
        seedsPerHarvestRightClickMinOption = Config.addOption(CATEGORY_HARVESTING, "seedsPerHarvestRightClickMin", 0, 0, null, 0, "Minimum number of seeds you get when harvesting a non-tree crop with right click (modifyCropDrops must be true)");
        seedsPerHarvestRightClickMaxOption = Config.addOption(CATEGORY_HARVESTING, "seedsPerHarvestRightClickMax", 0, 0, null, 0, "Maximum number of seeds you get when harvesting a non-tree crop with right click (modifyCropDrops must be true)");
        seedsPerHarvestBreakMinOption = Config.addOption(CATEGORY_HARVESTING, "seedsPerHarvestBreakMin", 0, 0, null, 0, "Minimum number of seeds you get when harvesting a non-tree crop by breaking it (modifyCropDrops must be true)");
        seedsPerHarvestBreakMaxOption = Config.addOption(CATEGORY_HARVESTING, "seedsPerHarvestBreakMax", 0, 0, null, 0, "Maximum number of seeds you get when harvesting a non-tree crop by breaking it (modifyCropDrops must be tree)");
        producePerHarvestRightClickMinOption = Config.addOption(CATEGORY_HARVESTING, "producePerHarvestRightClickMin", 2, 0, null, 2, "Minimum number of produce you get when harvesting a non-tree crop with right click (modifyCropDrops must be true)");
        producePerHarvestRightClickMaxOption = Config.addOption(CATEGORY_HARVESTING, "producePerHarvestRightClickMax", 4, 0, null, 4, "Maximum number of produce you get when harvesting a non-tree crop with right click (modifyCropDrops must be true)");
        producePerHarvestBreakMinOption = Config.addOption(CATEGORY_HARVESTING, "producePerHarvestBreakMin", 2, 0, null, 2, "Minimum number of produce you get when harvesting a non-tree crop by breaking it (modifyCropDrops must be true)");
        producePerHarvestBreakMaxOption = Config.addOption(CATEGORY_HARVESTING, "producePerHarvestBreakMax", 4, 0, null, 4, "Maximum number of produce you get when harvesting a non-tree crop by breaking it (modifyCropDrops must be true)");
        bonemealEffectivenessOption = Config.addOption(CATEGORY_HARVESTING, "bonemealEffectiveness", Float.valueOf(0.5f), Float.valueOf(0.0f), Float.valueOf(1.0f), Float.valueOf(1.0f), "Multiplier on the effectiveness of bonemeal; the smaller this is, the more often bonemeal will fail to create growth. Set to 0 to disable bonemeal completely.");
        modifyBonemealGrowthOption = Config.addOption(CATEGORY_HARVESTING, "modifyBonemealGrowth", true, false, "Reduces the amount of growth from a successful bonemeal on certain plants (uses IguanaMan's opinionated values)");
        addCustomVillageFieldOption = Config.addOption(CATEGORY_CUSTOM_FIELD, "addCustomVillageField", true, false, "Adds a custom field to villages");
        fieldNormalWeightOption = Config.addOption(CATEGORY_CUSTOM_FIELD, "fieldNormalWeight", 70, 0, null, 0, "Weighted chance for custom field to contain 'normal' crops");
        fieldReedWeightOption = Config.addOption(CATEGORY_CUSTOM_FIELD, "fieldReedWeight", 10, 0, null, 0, "Weighted chance for custom field to contain reeds");
        fieldStemWeightOption = Config.addOption(CATEGORY_CUSTOM_FIELD, "fieldStemWeight", 10, 0, null, 0, "Weighted chance for custom field to contain pumpkins/melons");
        difficultyScalingOption = Config.addOption(CATEGORY_DIFFICULTY_SCALING, "difficultyScaling", true, false, "Enable/Disable all difficulty scaling effect in one setting");
        difficultyScalingBoneMealOption = Config.addOption(CATEGORY_DIFFICULTY_SCALING, "difficultyScalingBoneMeal", true, false, "Effects of bone meal dependant of difficulty ('difficultyScaling' and 'modifyBonemealGrowth' must be true)");
        difficultyScalingEffectsOption = Config.addOption(CATEGORY_DIFFICULTY_SCALING, "difficultyScalingEffects", true, false, "Negative effects on low health/hunger scale by difficulty ('difficultyScaling' must be true)");
        difficultyScalingHealingOption = Config.addOption(CATEGORY_DIFFICULTY_SCALING, "difficultyScalingHealing", true, false, "Healing rate scales by difficulty ('difficultyScaling' must be true)");
        difficultyScalingHungerOption = Config.addOption(CATEGORY_DIFFICULTY_SCALING, "difficultyScalingHunger", true, false, "Hunger loss rate scales by difficulty ('difficultyScaling' must be true)");
        difficultyScalingRespawnHungerOption = Config.addOption(CATEGORY_DIFFICULTY_SCALING, "difficultyScalingRespawnHunger", true, false, "Hunger value after respawn is affected by difficulty ('difficultyScaling' must be true)");
        modifyFoodValuesOption = Config.addOption(CATEGORY_FOOD, "modifyFoodValues", true, false, "Enables/disables all food value modification");
        useHOFoodValuesOption = Config.addOption(CATEGORY_FOOD, "useHOFoodValues", true, false, "Enables/disables Hunger Overhaul manually setting the food values for supported mods ('modifyFoodValues' must be true)");
        addFoodTooltipsOption = Config.addOption(CATEGORY_FOOD, "addFoodTooltips", true, false, "Add tooltips to food items showing hints at food value");
        modifyFoodStackSizeOption = Config.addOption(CATEGORY_FOOD, "modifyFoodStackSize", true, false, "Changes the stack size of food to be dependant on the food's replenishment value");
        modifyFoodEatingSpeedOption = Config.addOption(CATEGORY_FOOD, "modifyFoodEatingSpeed", true, false, "Changes the eating animation speed to be dependant on the food's replenishment value");
        foodStackSizeMultiplierOption = Config.addOption(CATEGORY_FOOD, "foodStackSizeMultiplier", 1, 1, null, 1, "Multiplier on the stack size of food ('modifyFoodStackSize' must be true)");
        foodHungerDividerOption = Config.addOption(CATEGORY_FOOD, "foodHungerDivider", Float.valueOf(4.0f), Float.valueOf(1.0f), "Food values not manually set (see 'useHOFoodValues') will have their hunger value divided by this ('modifyFoodValues' must be true)");
        foodSaturationDividerOption = Config.addOption(CATEGORY_FOOD, "foodSaturationDivider", Float.valueOf(1.0f), Float.valueOf(1.0f), "Food values not manually set (see 'useHOFoodValues') will have their saturation modifier divided by this ('modifyFoodValues' must be true)\nNote: Gets applied after 'foodHungerToSaturationDivider'");
        foodHungerToSaturationDividerOption = Config.addOption(CATEGORY_FOOD, "foodHungerToSaturationDivider", Float.valueOf(20.0f), Float.valueOf(0.0f), "Food values not manually set (see 'useHOFoodValues') will have their saturation modifier set to <modified hunger> divided by this ('modifyFoodValues' must be true)\nSet to 0 to disable");
        addWellFedEffectOption = Config.addOption(CATEGORY_FOOD, "addWellFedEffect", true, false, "Adds a 'well fed' effect that gives slight health regen");
        wellFedDurationMultiplierOption = Config.addOption(CATEGORY_FOOD, "wellFedDurationMultiplier", Float.valueOf(1.0f), Float.valueOf(1.0f), "The base duration (in ticks) for the Well fed effect is (hunger_value * 100)^1.2\nThe result above will be multiplied by this value");
        wellFedEffectivenessOption = Config.addOption(CATEGORY_FOOD, "wellFedEffectiveness", Float.valueOf(0.25f), Float.valueOf(0.25f), "How much faster the well fed effect will make health regen. E.g. 0.25 means that the health will regen 25% faster. Setting this to 1 means that health will regen at maximum speed (about 1 hp per tick)");
        addTradesButcherOption = Config.addOption(CATEGORY_HARVESTCRAFT, "addTradesButcher", true, false, "Add high tier HarvestCraft foods to the items butcher villagers will sell (HarvestCraft)");
        addCropTradesFarmerOption = Config.addOption(CATEGORY_HARVESTCRAFT, "addCropTradesFarmer", true, false, "Add HarvestCraft crop produce to the items farmer villagers will buy (HarvestCraft)");
        addSaplingTradesFarmerOption = Config.addOption(CATEGORY_HARVESTCRAFT, "addSaplingTradesFarmer", true, false, "Add HarvestCraft saplings to the items farmer villagers will sell (HarvestCraft)");
        addHarvestCraftChestLootOption = Config.addOption(CATEGORY_HARVESTCRAFT, "addHarvestCraftChestLoot", true, false, "HarvestCraft items added to dungeon/temple chests (Harvestcraft)");
        chestLootMaxStackSizeOption = Config.addOption(CATEGORY_HARVESTCRAFT, "chestLootMaxStackSize", 16, 1, null, 64, "Max stack size for food to be found in chests (addHarvestCraftChestLoot must be true)");
        chestLootChanceOption = Config.addOption(CATEGORY_HARVESTCRAFT, "chestLootChance", Float.valueOf(1.0f), Float.valueOf(0.0f), Float.valueOf(1.0f), Float.valueOf(1.0f), "Weighted chance for food to be found in chests (addHarvestCraftChestLoot must be true) Value must be between 0.0 and 1.0.");
        foodsUnplantableOption = Config.addOption(CATEGORY_HARVESTCRAFT, "foodsUnplantable", true, false, "Makes HarvestCraft foods unplantable, meaning seeds are required to plant crops");
        removeNaturaFlourCraftingRecipesOption = Config.addOption(CATEGORY_NATURA, "removeNaturaFlourCraftingRecipes", true, false, "Removes the default barley/wheat -> flour recipes.\nNote: These recipes are always removed if 'addSeedsCraftingRecipe' in 'getting seeds' is true because otherwise they'd conflict.");
        removeNaturaFlourSmeltingRecipeOption = Config.addOption(CATEGORY_NATURA, "removeNaturaFlourSmeltingRecipe", true, false, "Removes the default barley/wheat flour -> bread smelting recipes.");
        addAlternateNaturaFlourCraftingRecipesOption = Config.addOption(CATEGORY_NATURA, "addAlternateNaturaFlourCraftingRecipes", false, false, "Adds alternate recipes to turn barley/wheat into flour: 2x wheat/barley -> flour.");
        constantHungerLossOption = Config.addOption(CATEGORY_HUNGER, "constantHungerLoss", true, false, "You lose hunger (very slowly) at all times");
        damageOnStarveOption = Config.addOption(CATEGORY_HUNGER, "damageOnStarve", 200, 2, "Amount of damage you take when hunger hits zero");
        enableRespawnHungerOption = Config.addOption(CATEGORY_HUNGER, "enableRespawnHunger", true, false, "Enable setting hunger after respawning (see 'respawnHungerValue')");
        respawnHungerValueOption = Config.addOption(CATEGORY_HUNGER, "respawnHungerValue", 20, 0, null, 20, "hunger value set after respawning for peaceful/easy difficulty");
        respawnHungerDifficultyModifierOption = Config.addOption(CATEGORY_HUNGER, "respawnHungerDifficultyModifier", 4, 0, null, 4, "The amount difficulty modifies the hunger value set after respawning  ('difficultyScaling' and 'difficultyScalingRespawnHunger' must be true)");
        disableHealingHungerDrainOption = Config.addOption(CATEGORY_HUNGER, "disableHealingHungerDrain", true, false, "Disable the hunger drain when healing that was introduced in vanilla 1.6.2");
        hungerLossRatePercentageOption = Config.addOption(CATEGORY_HUNGER, "hungerLossRatePercentage", Float.valueOf(133.33334f), Float.valueOf(0.0f), null, Float.valueOf(100.0f), "Speed up or slow down the rate that hunger drops (set to 0 to disable hunger loss)");
        addGuiTextOption = Config.addOption(CATEGORY_LOW_STATS, "addGuiText", true, false, "Shows onscreen text when hunger/health is low");
        addLowStatEffectsOption = Config.addOption(CATEGORY_LOW_STATS, "addLowStatEffects", true, false, "Enables/disables all low hunger/health effects");
        addLowHealthNauseaOption = Config.addOption(CATEGORY_LOW_STATS, "addLowHealthNausea", true, false, "Nausea effect when health is really low ('addLowStatEffects' must be true)");
        addLowHungerNauseaOption = Config.addOption(CATEGORY_LOW_STATS, "addLowHungerNausea", true, false, "Nausea effect when hunger is really low ('addLowStatEffects' must be true)");
        addLowHealthSlownessOption = Config.addOption(CATEGORY_LOW_STATS, "addLowHealthSlowness", true, false, "Slowness effect when health is low ('addLowStatEffects' must be true)");
        addLowHungerSlownessOption = Config.addOption(CATEGORY_LOW_STATS, "addLowHungerSlowness", true, false, "Slowness effect when hunger is low ('addLowStatEffects' must be true)");
        addLowHealthWeaknessOption = Config.addOption(CATEGORY_LOW_STATS, "addLowHealthWeakness", true, false, "Weakness effect when health is low ('addLowStatEffects' must be true)");
        addLowHungerWeaknessOption = Config.addOption(CATEGORY_LOW_STATS, "addLowHungerWeakness", true, false, "Weakness effect when hunger is low ('addLowStatEffects' must be true)");
        addLowHealthMiningSlowdownOption = Config.addOption(CATEGORY_LOW_STATS, "addLowHealthMiningSlowdown", true, false, "Mining slowdown effect when health is low ('addLowStatEffects' must be true)");
        addLowHungerMiningSlowdownOption = Config.addOption(CATEGORY_LOW_STATS, "addLowHungerMiningSlowdown", true, false, "Mining slowdown effect when hunger is low ('addLowStatEffects' must be true)");
        minHungerToHealOption = Config.addOption(CATEGORY_HEALTH, "minHungerToHeal", 7, 0, null, 18, "Minimum hunger level before healing starts");
        foodRegensHealthOption = Config.addOption(CATEGORY_HEALTH, "foodRegensHealth", false, false, "Eating food regenerates health");
        foodHealDividerOption = Config.addOption(CATEGORY_HEALTH, "foodHealDivider", 4, 0, null, 4, "Amount of health food restores is the food value divided by this number (foodRegensHealth must be true)");
        healthRegenRatePercentageOption = Config.addOption(CATEGORY_HEALTH, "healthRegenRatePercentage", 100, 0, null, 100, "Speed up or slow down the rate that health regenerates (0 to disable regen)");
        modifyRegenRateOnLowHealthOption = Config.addOption(CATEGORY_HEALTH, "modifyRegenRateOnLowHealth", true, false, "The lower your health the longer it takes to regen");
        lowHealthRegenRateModifierOption = Config.addOption(CATEGORY_HEALTH, "lowHealthRegenRateModifier", 5, 0, null, 5, "The lower your health the longer it takes to regen, modify the effect here (lower = less effect) (modifyRegenRateOnLowHealth must be true)");
    }
}

