/*
 * Decompiled with CFR 0.152.
 */
package iguanaman.hungeroverhaul.util;

import com.google.common.collect.Lists;
import cpw.mods.fml.common.Loader;
import iguanaman.hungeroverhaul.config.IguanaConfig;
import iguanaman.hungeroverhaul.module.PamsModsHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.StructureVillagePieces;
import net.minecraftforge.common.BiomeDictionary;

public class ComponentVillageCustomField
extends StructureVillagePieces.Village {
    private int averageGroundLevel = -1;
    private fieldType typeA;
    private fieldType typeB;

    public ComponentVillageCustomField() {
    }

    public ComponentVillageCustomField(StructureVillagePieces.Start par1ComponentVillageStartPiece, int par2, Random par3Random, StructureBoundingBox par4StructureBoundingBox, int par5) {
        super(par1ComponentVillageStartPiece, par2);
        this.coordBaseMode = par5;
        this.boundingBox = par4StructureBoundingBox;
    }

    private Block getRandomStemCrop(Random par1Random) {
        ArrayList crops = Lists.newArrayList();
        crops.add(Blocks.pumpkin_stem);
        crops.add(Blocks.melon_stem);
        return (Block)crops.get(par1Random.nextInt(crops.size() - 1));
    }

    private Block getRandomCrop(Random random) {
        return Loader.isModLoaded((String)"harvestcraft") ? this.getRandomCropHarvestCraft(random) : this.getRandomCropVanilla(random);
    }

    private Block getRandomCropVanilla(Random random) {
        ArrayList<Block> crops = new ArrayList<Block>();
        crops.add(Blocks.wheat);
        crops.add(Blocks.carrots);
        crops.add(Blocks.potatoes);
        return (Block)crops.get(random.nextInt(crops.size()));
    }

    private Block getRandomCropHarvestCraft(Random random) {
        int length = PamsModsHelper.PamCrops.length;
        return random.nextInt(length + 3) <= length ? PamsModsHelper.PamCrops[random.nextInt(length)] : this.getRandomCropVanilla(random);
    }

    private int getCropMeta(Block block, Random random) {
        return random.nextInt(5);
    }

    public static ComponentVillageCustomField buildComponent(StructureVillagePieces.Start par0Start, List par1List, Random par2Random, int par3, int par4, int par5, int par6, int par7) {
        StructureBoundingBox var8 = StructureBoundingBox.getComponentToAddBoundingBox((int)par3, (int)par4, (int)par5, (int)0, (int)0, (int)0, (int)13, (int)4, (int)9, (int)par6);
        return ComponentVillageCustomField.canVillageGoDeeper((StructureBoundingBox)var8) && StructureComponent.findIntersecting((List)par1List, (StructureBoundingBox)var8) == null ? new ComponentVillageCustomField(par0Start, par7, par2Random, var8, par6) : null;
    }

    private fieldType randomFieldType(BiomeGenBase biome, Random random) {
        int weights;
        int rnd;
        int normalWeight = IguanaConfig.fieldNormalWeight;
        int reedWeight = IguanaConfig.fieldReedWeight;
        int stemWeight = IguanaConfig.fieldStemWeight;
        if (BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.JUNGLE) || BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SWAMP)) {
            reedWeight *= 2;
            stemWeight *= 2;
        }
        if ((rnd = random.nextInt(weights = normalWeight + reedWeight + stemWeight)) < reedWeight) {
            return fieldType.REED;
        }
        if (rnd < reedWeight + stemWeight) {
            return fieldType.STEM;
        }
        return fieldType.NORMAL;
    }

    public boolean addComponentParts(World par1World, Random par2Random, StructureBoundingBox par3StructureBoundingBox) {
        Block crop2B;
        Block crop1B;
        Block crop2A;
        Block crop1A;
        if (this.averageGroundLevel < 0) {
            this.averageGroundLevel = this.getAverageGroundLevel(par1World, par3StructureBoundingBox);
            if (this.averageGroundLevel < 0) {
                return true;
            }
            this.boundingBox.offset(0, this.averageGroundLevel - this.boundingBox.maxY + 4 - 1, 0);
        }
        int x = par3StructureBoundingBox.getCenterX();
        int z = par3StructureBoundingBox.getCenterZ();
        BiomeGenBase biome = par1World.getBiomeGenForCoords(x, z);
        this.typeA = this.randomFieldType(biome, par2Random);
        this.typeB = this.randomFieldType(biome, par2Random);
        Object blockOutA = Blocks.farmland;
        BlockLiquid blockInA = Blocks.flowing_water;
        Object blockOutB = Blocks.farmland;
        BlockLiquid blockInB = Blocks.flowing_water;
        if (this.typeA == fieldType.REED) {
            blockOutA = BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SANDY) ? Blocks.sand : Blocks.dirt;
            crop1A = Blocks.reeds;
            crop2A = Blocks.reeds;
        } else if (this.typeA == fieldType.STEM) {
            crop1A = this.getRandomStemCrop(par2Random);
            crop2A = this.getRandomStemCrop(par2Random);
        } else {
            crop1A = this.getRandomCrop(par2Random);
            crop2A = this.getRandomCrop(par2Random);
        }
        if (this.typeB == fieldType.REED) {
            blockOutB = BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SANDY) ? Blocks.sand : Blocks.dirt;
            crop1B = Blocks.reeds;
            crop2B = Blocks.reeds;
        } else if (this.typeA == fieldType.STEM) {
            crop1B = this.getRandomStemCrop(par2Random);
            crop2B = this.getRandomStemCrop(par2Random);
        } else {
            crop1B = this.getRandomCrop(par2Random);
            crop2B = this.getRandomCrop(par2Random);
        }
        int cropMeta1A = this.getCropMeta(crop1A, par2Random);
        int cropMeta2A = this.getCropMeta(crop2A, par2Random);
        int cropMeta1B = this.getCropMeta(crop1B, par2Random);
        int cropMeta2B = this.getCropMeta(crop2B, par2Random);
        this.fillWithBlocks(par1World, par3StructureBoundingBox, 0, 1, 0, 12, 4, 8, Blocks.air, Blocks.air, false);
        this.fillWithBlocks(par1World, par3StructureBoundingBox, 0, 0, 0, 0, 0, 8, Blocks.log, Blocks.log, false);
        this.fillWithBlocks(par1World, par3StructureBoundingBox, 6, 0, 0, 6, 0, 8, Blocks.log, Blocks.log, false);
        this.fillWithBlocks(par1World, par3StructureBoundingBox, 12, 0, 0, 12, 0, 8, Blocks.log, Blocks.log, false);
        this.fillWithBlocks(par1World, par3StructureBoundingBox, 1, 0, 0, 11, 0, 0, Blocks.log, Blocks.log, false);
        this.fillWithBlocks(par1World, par3StructureBoundingBox, 1, 0, 8, 11, 0, 8, Blocks.log, Blocks.log, false);
        this.fillWithBlocks(par1World, par3StructureBoundingBox, 1, 0, 1, 2, 0, 7, (Block)blockOutA, (Block)blockOutA, false);
        this.fillWithBlocks(par1World, par3StructureBoundingBox, 3, 0, 1, 3, 0, 7, (Block)blockInA, (Block)blockInA, false);
        this.fillWithBlocks(par1World, par3StructureBoundingBox, 4, 0, 1, 5, 0, 7, (Block)blockOutA, (Block)blockOutA, false);
        this.fillWithBlocks(par1World, par3StructureBoundingBox, 7, 0, 1, 8, 0, 7, (Block)blockOutB, (Block)blockOutB, false);
        this.fillWithBlocks(par1World, par3StructureBoundingBox, 9, 0, 1, 9, 0, 7, (Block)blockInB, (Block)blockInB, false);
        this.fillWithBlocks(par1World, par3StructureBoundingBox, 10, 0, 1, 11, 0, 7, (Block)blockOutB, (Block)blockOutB, false);
        for (int tmp = 1; tmp <= 7; ++tmp) {
            if (this.typeA == fieldType.NORMAL) {
                this.placeCropAtCurrentPosition(par1World, crop1A, cropMeta1A, 1, 1, tmp, par3StructureBoundingBox);
            }
            this.placeCropAtCurrentPosition(par1World, crop1A, cropMeta1A, 2, 1, tmp, par3StructureBoundingBox);
            this.placeCropAtCurrentPosition(par1World, crop2A, cropMeta2A, 4, 1, tmp, par3StructureBoundingBox);
            if (this.typeA == fieldType.NORMAL) {
                this.placeCropAtCurrentPosition(par1World, crop2A, cropMeta2A, 5, 1, tmp, par3StructureBoundingBox);
            }
            if (this.typeA == fieldType.NORMAL) {
                this.placeCropAtCurrentPosition(par1World, crop1B, cropMeta1B, 7, 1, tmp, par3StructureBoundingBox);
            }
            this.placeCropAtCurrentPosition(par1World, crop1B, cropMeta1B, 8, 1, tmp, par3StructureBoundingBox);
            this.placeCropAtCurrentPosition(par1World, crop2B, cropMeta2B, 10, 1, tmp, par3StructureBoundingBox);
            if (this.typeA != fieldType.NORMAL) continue;
            this.placeCropAtCurrentPosition(par1World, crop2B, cropMeta2B, 11, 1, tmp, par3StructureBoundingBox);
        }
        for (int var4 = 0; var4 < 9; ++var4) {
            for (int var5 = 0; var5 < 13; ++var5) {
                this.clearCurrentPositionBlocksUpwards(par1World, var5, 4, var4, par3StructureBoundingBox);
                this.func_151554_b(par1World, Blocks.dirt, 0, var5, -1, var4, par3StructureBoundingBox);
            }
        }
        return true;
    }

    private void placeCropAtCurrentPosition(World world, Block block, int meta, int offsetX, int offsetY, int offsetZ, StructureBoundingBox box) {
        if (Loader.isModLoaded((String)"harvestcraft")) {
            this.placeHarvestCraftCropAtCurrentPosition(world, block, meta, offsetX, offsetY, offsetZ, box);
        } else {
            this.placeBlockAtCurrentPosition(world, block, meta, offsetX, offsetY, offsetZ, box);
        }
    }

    private void placeHarvestCraftCropAtCurrentPosition(World world, Block block, int meta, int offsetX, int offsetY, int offsetZ, StructureBoundingBox box) {
        int z;
        int y;
        int x = this.getXWithOffset(offsetX, offsetZ);
        if (box.isVecInside(x, y = this.getYWithOffset(offsetY), z = this.getZWithOffset(offsetX, offsetZ))) {
            world.setBlock(x, y, z, block, meta, 2);
        }
    }

    private static enum fieldType {
        NORMAL,
        REED,
        STEM;

    }
}

