/*
 * Decompiled with CFR 0.152.
 */
package iguanaman.hungeroverhaul.module;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import iguanaman.hungeroverhaul.config.IguanaConfig;
import iguanaman.hungeroverhaul.util.BonemealModification;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.world.EnumDifficulty;
import net.minecraftforge.event.entity.player.BonemealEvent;

public class ModuleBonemeal {
    private static HashMap<Class<? extends Block>, BonemealModification> bonemealModificationsByBlockClass = new HashMap();
    private static HashMap<Block, BonemealModification> bonemealModificationsByBlock = new HashMap();

    public static void registerBonemealModifier(Class<? extends Block> blockClass, BonemealModification bonemealModification) {
        bonemealModificationsByBlockClass.put(blockClass, bonemealModification);
    }

    public static void registerBonemealModifier(Block block, BonemealModification bonemealModification) {
        bonemealModificationsByBlock.put(block, bonemealModification);
    }

    public static BonemealModification getBonemealModification(Block block) {
        BonemealModification bonemealModification = bonemealModificationsByBlock.get(block);
        if (bonemealModification != null) {
            return bonemealModification;
        }
        return ModuleBonemeal.getBonemealModification(block.getClass());
    }

    public static BonemealModification getBonemealModification(Class<? extends Block> blockClass) {
        BonemealModification bonemealModification = bonemealModificationsByBlockClass.get(blockClass);
        if (bonemealModification == null) {
            for (Map.Entry<Class<? extends Block>, BonemealModification> entry : bonemealModificationsByBlockClass.entrySet()) {
                if (!entry.getKey().isInstance(blockClass)) continue;
                return entry.getValue();
            }
        }
        return bonemealModification;
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onBonemealUsed(BonemealEvent event) {
        int resultingMeta;
        if (event.world.isRemote) {
            return;
        }
        if (!IguanaConfig.difficultyScalingBoneMeal || event.isCanceled()) {
            return;
        }
        BonemealModification bonemealModification = ModuleBonemeal.getBonemealModification(event.block);
        if (bonemealModification == null) {
            return;
        }
        if (event.world.difficultySetting == EnumDifficulty.HARD) {
            event.setCanceled(true);
            event.setResult(Event.Result.DENY);
            return;
        }
        int meta = event.world.getBlockMetadata(event.x, event.y, event.z);
        if (meta != (resultingMeta = bonemealModification.getNewMeta(event.world, event.x, event.y, event.z, event.block, meta))) {
            event.world.setBlockMetadataWithNotify(event.x, event.y, event.z, resultingMeta, 3);
        }
        bonemealModification.onBonemeal(event.world, event.x, event.y, event.z, event.block, resultingMeta);
        event.setResult(Event.Result.ALLOW);
    }
}

