/*
 * Decompiled with CFR 0.152.
 */
package iguanaman.hungeroverhaul.util;

import com.pam.harvestcraft.BlockPamSapling;
import com.pam.harvestcraft.ItemPamSeedFood;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.registry.VillagerRegistry;
import iguanaman.hungeroverhaul.config.IguanaConfig;
import iguanaman.hungeroverhaul.util.TradeHandlerCrop;
import iguanaman.hungeroverhaul.util.TradeHandlerFood;
import iguanaman.hungeroverhaul.util.TradeHandlerSapling;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraftforge.common.ChestGenHooks;
import squeek.applecore.api.AppleCoreAPI;
import squeek.applecore.api.food.FoodValues;

public class ItemTweaks {
    public static void init() {
        boolean worthLooping;
        boolean bl = worthLooping = IguanaConfig.modifyFoodStackSize || IguanaConfig.addTradesButcher || IguanaConfig.addHarvestCraftChestLoot || IguanaConfig.addTradesFarmer || IguanaConfig.addSaplingTradesFarmer;
        if (worthLooping) {
            for (Object obj : Item.field_150901_e) {
                Block block;
                Item item = (Item)obj;
                if (AppleCoreAPI.accessor.isFood(new ItemStack(item))) {
                    ItemStack stack = new ItemStack(item);
                    FoodValues values = FoodValues.get((ItemStack)stack);
                    if (IguanaConfig.modifyFoodStackSize) {
                        ItemTweaks.modifyStackSize(item, stack, values);
                    }
                    if (values.hunger > 9) {
                        if (IguanaConfig.addTradesButcher) {
                            ItemTweaks.addButcherTrade(item, stack, values);
                        }
                        if (IguanaConfig.addHarvestCraftChestLoot) {
                            ItemTweaks.addChestLoot(item, stack, values);
                        }
                    }
                    if (!Loader.isModLoaded((String)"harvestcraft") || !IguanaConfig.addTradesFarmer || !(item instanceof ItemPamSeedFood)) continue;
                    ItemTweaks.addCropTrade(item);
                    continue;
                }
                if (!Loader.isModLoaded((String)"harvestcraft") || !IguanaConfig.addSaplingTradesFarmer || !(item instanceof ItemBlock) || !((block = Block.func_149634_a((Item)item)) instanceof BlockPamSapling)) continue;
                ItemTweaks.addSaplingTrade(block);
            }
        }
    }

    public static void modifyStackSize(Item item, ItemStack stack, FoodValues values) {
        int curStackSize;
        int newStackSize = curStackSize = item.getItemStackLimit(stack);
        newStackSize = values.hunger <= 2 ? 16 * IguanaConfig.foodStackSizeMultiplier : (values.hunger <= 5 ? 8 * IguanaConfig.foodStackSizeMultiplier : (values.hunger <= 8 ? 4 * IguanaConfig.foodStackSizeMultiplier : (values.hunger <= 11 ? 2 * IguanaConfig.foodStackSizeMultiplier : IguanaConfig.foodStackSizeMultiplier)));
        if (curStackSize > newStackSize) {
            item.func_77625_d(newStackSize);
        }
    }

    public static void addButcherTrade(Item item, ItemStack stack, FoodValues values) {
        VillagerRegistry.instance().registerVillageTradeHandler(VillagerType.BUTCHER.ordinal(), (VillagerRegistry.IVillageTradeHandler)new TradeHandlerFood(item, item.getItemStackLimit(stack)));
    }

    public static void addSaplingTrade(Block block) {
        VillagerRegistry.instance().registerVillageTradeHandler(VillagerType.FARMER.ordinal(), (VillagerRegistry.IVillageTradeHandler)new TradeHandlerSapling(block));
    }

    public static void addCropTrade(Item item) {
        VillagerRegistry.instance().registerVillageTradeHandler(VillagerType.FARMER.ordinal(), (VillagerRegistry.IVillageTradeHandler)new TradeHandlerCrop(item));
    }

    public static void addChestLoot(Item item, ItemStack stack, FoodValues values) {
        int maxStackSize = Math.min(IguanaConfig.chestLootMaxStackSize, item.getItemStackLimit(stack));
        ChestGenHooks.getInfo((String)"dungeonChest").addItem(new WeightedRandomChestContent(stack, 0, maxStackSize, IguanaConfig.chestLootChance));
        ChestGenHooks.getInfo((String)"mineshaftCorridor").addItem(new WeightedRandomChestContent(stack, 0, maxStackSize, IguanaConfig.chestLootChance));
        ChestGenHooks.getInfo((String)"pyramidDesertyChest").addItem(new WeightedRandomChestContent(stack, 0, maxStackSize, IguanaConfig.chestLootChance));
        ChestGenHooks.getInfo((String)"pyramidJungleChest").addItem(new WeightedRandomChestContent(stack, 0, maxStackSize, IguanaConfig.chestLootChance));
    }

    public static enum VillagerType {
        FARMER,
        LIBRARIAN,
        PRIEST,
        SMITH,
        BUTCHER;

    }
}

