/*
 * Decompiled with CFR 0.152.
 */
package iguanaman.hungeroverhaul.food;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import iguanaman.hungeroverhaul.HungerOverhaul;
import iguanaman.hungeroverhaul.config.IguanaConfig;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.world.EnumDifficulty;
import net.minecraftforge.event.entity.player.PlayerUseItemEvent;
import squeek.applecore.api.AppleCoreAPI;
import squeek.applecore.api.food.FoodEvent;
import squeek.applecore.api.food.FoodValues;
import squeek.applecore.api.hunger.ExhaustionEvent;
import squeek.applecore.api.hunger.HealthRegenEvent;
import squeek.applecore.api.hunger.StarvationEvent;

public class FoodEventHandler {
    @SubscribeEvent
    public void onFoodEaten(FoodEvent.FoodEaten event) {
        int duration;
        if (!event.player.worldObj.isRemote && event.player.worldObj.getGameRules().getGameRuleBooleanValue("naturalRegeneration") && IguanaConfig.healthRegenRatePercentage > 0 && IguanaConfig.addWellFedEffect && (duration = (int)Math.pow(event.foodValues.hunger * 100, 1.2)) >= 30) {
            PotionEffect currentEffect = event.player.getActivePotionEffect(HungerOverhaul.potionWellFed);
            if (currentEffect != null) {
                duration += currentEffect.getDuration();
            }
            event.player.addPotionEffect(new PotionEffect(HungerOverhaul.potionWellFed.id, duration, 0, true));
        }
        if (IguanaConfig.foodRegensHealth) {
            float canHeal;
            float toHeal = Math.round((float)event.foodValues.hunger / (float)IguanaConfig.foodHealDivider);
            if (toHeal > (canHeal = event.player.getMaxHealth() - event.player.getHealth())) {
                toHeal = canHeal;
            }
            if (toHeal > 0.0f) {
                event.player.heal(toHeal);
            }
        }
    }

    @SubscribeEvent
    public void allowExhaustion(ExhaustionEvent.AllowExhaustion event) {
        if (IguanaConfig.hungerLossRatePercentage == 0) {
            AppleCoreAPI.mutator.setHunger(event.player, 19);
            AppleCoreAPI.mutator.setSaturation(event.player, 0.0f);
            AppleCoreAPI.mutator.setExhaustion(event.player, 0.0f);
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public void getMaxExhaustion(ExhaustionEvent.GetMaxExhaustion event) {
        EnumDifficulty difficulty = event.player.worldObj.difficultySetting;
        float hungerLossRate = 3.0f;
        if (IguanaConfig.difficultyScalingHunger) {
            if (difficulty == EnumDifficulty.PEACEFUL) {
                hungerLossRate = 5.0f;
            } else if (difficulty == EnumDifficulty.EASY) {
                hungerLossRate = 4.0f;
            }
        }
        event.maxExhaustionLevel = hungerLossRate / ((float)IguanaConfig.hungerLossRatePercentage / 100.0f);
    }

    @SubscribeEvent
    public void onExhausted(ExhaustionEvent.Exhausted event) {
        if (event.player.getFoodStats().getSaturationLevel() <= 0.0f) {
            event.deltaHunger = -1;
        }
    }

    @SubscribeEvent
    public void allowHealthRegen(HealthRegenEvent.AllowRegen event) {
        if (event.player.getFoodStats().getFoodLevel() >= IguanaConfig.minHungerToHeal && IguanaConfig.healthRegenRatePercentage > 0 && event.player.worldObj.getGameRules().getGameRuleBooleanValue("naturalRegeneration") && event.player.shouldHeal()) {
            event.setResult(Event.Result.ALLOW);
        } else {
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public void onHealthRegenTick(HealthRegenEvent.GetRegenTickPeriod event) {
        float wellfedModifier = 1.0f;
        if (event.player.isPotionActive(HungerOverhaul.potionWellFed)) {
            wellfedModifier = 0.75f;
        }
        EnumDifficulty difficulty = event.player.worldObj.difficultySetting;
        float difficultyModifierHealing = 1.0f;
        if (IguanaConfig.difficultyScalingHealing) {
            if (difficulty.getDifficultyId() <= EnumDifficulty.EASY.getDifficultyId()) {
                difficultyModifierHealing = 0.75f;
            } else if (difficulty == EnumDifficulty.HARD) {
                difficultyModifierHealing = 1.5f;
            }
        }
        float lowHealthModifier = event.player.getMaxHealth() - event.player.getHealth();
        lowHealthModifier *= (float)IguanaConfig.lowHealthRegenRateModifier / 100.0f;
        lowHealthModifier *= difficultyModifierHealing;
        lowHealthModifier = (float)Math.pow(lowHealthModifier + 1.0f, 1.5);
        event.regenTickPeriod = Math.round(80.0f * difficultyModifierHealing * wellfedModifier * lowHealthModifier / ((float)IguanaConfig.healthRegenRatePercentage / 100.0f));
    }

    @SubscribeEvent
    public void onHealthRegen(HealthRegenEvent.Regen event) {
        if (IguanaConfig.disableHealingHungerDrain) {
            event.deltaExhaustion = 0.0f;
        }
    }

    @SubscribeEvent
    public void onStarve(StarvationEvent.Starve event) {
        event.starveDamage = IguanaConfig.damageOnStarve;
    }

    @SubscribeEvent
    public void onFoodStatsAddition(FoodEvent.FoodStatsAddition event) {
        if (IguanaConfig.hungerLossRatePercentage == 0) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onFoodStartEating(PlayerUseItemEvent.Start event) {
        int hunger;
        if (IguanaConfig.modifyFoodEatingSpeed && event.item != null && event.item.getItem() instanceof ItemFood && (hunger = FoodValues.get((ItemStack)event.item).hunger) > 0) {
            event.duration = hunger * 8 + 8;
        }
    }
}

