/*
 * Decompiled with CFR 0.152.
 */
package iguanaman.hungeroverhaul.util;

import com.pam.harvestcraft.ItemPamSeedFood;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import iguanaman.hungeroverhaul.config.IguanaConfig;
import iguanaman.hungeroverhaul.module.ModuleGrassSeeds;
import iguanaman.hungeroverhaul.module.ModulePlantGrowth;
import iguanaman.hungeroverhaul.module.PamsModsHelper;
import iguanaman.hungeroverhaul.util.BlockHelper;
import iguanaman.hungeroverhaul.util.ClientHelper;
import iguanaman.hungeroverhaul.util.PlantGrowthModification;
import iguanaman.hungeroverhaul.util.RandomHelper;
import java.util.Random;
import mods.natura.blocks.crops.CropBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityMooshroom;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemBucket;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.StatCollector;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.EntityInteractEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.UseHoeEvent;
import net.minecraftforge.event.world.BlockEvent;
import squeek.applecore.api.AppleCoreAPI;
import squeek.applecore.api.food.FoodValues;

public class IguanaEventHook {
    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        Random rand = new Random();
        if (event.entityLiving instanceof EntityAnimal) {
            NBTTagCompound tags;
            int rndBreed = rand.nextInt(IguanaConfig.breedingTimeoutMultiplier);
            int rndChild = rand.nextInt(IguanaConfig.childDurationMultiplier);
            EntityAgeable ageable = (EntityAgeable)event.entityLiving;
            int growingAge = ageable.func_70874_b();
            if (growingAge > 0 && rndBreed != 0) {
                ageable.func_70873_a(++growingAge);
            } else if (growingAge < 0 && rndChild != 0) {
                ageable.func_70873_a(--growingAge);
            }
            if (IguanaConfig.eggTimeoutMultiplier > 1 && event.entityLiving instanceof EntityChicken) {
                int rnd = rand.nextInt(IguanaConfig.eggTimeoutMultiplier);
                EntityChicken chicken = (EntityChicken)event.entityLiving;
                if (chicken.field_70887_j > 0 && rnd != 0) {
                    ++chicken.field_70887_j;
                }
            }
            if (IguanaConfig.milkedTimeout > 0 && event.entityLiving instanceof EntityCow && event.entityLiving.field_70170_p.func_72820_D() % 20L == 0L && (tags = event.entityLiving.getEntityData()).func_74764_b("Milked")) {
                int milked = tags.func_74762_e("Milked");
                if (--milked <= 0) {
                    tags.func_82580_o("Milked");
                } else {
                    tags.func_74768_a("Milked", milked);
                }
            }
        }
        if (!event.entityLiving.field_70170_p.field_72995_K) {
            NBTTagCompound tags = event.entityLiving.getEntityData();
            if (tags.func_74764_b("HungerOverhaulCheck")) {
                int lastCheck = tags.func_74762_e("HungerOverhaulCheck");
                if (--lastCheck <= 0) {
                    tags.func_82580_o("HungerOverhaulCheck");
                } else {
                    tags.func_74768_a("HungerOverhaulCheck", lastCheck);
                }
            } else {
                EntityPlayer player;
                float healthPercent = event.entityLiving.func_110143_aJ() / event.entityLiving.func_110138_aP();
                int foodLevel = 20;
                boolean creative = false;
                boolean isPlayer = false;
                if (event.entityLiving instanceof EntityPlayer) {
                    player = (EntityPlayer)event.entityLiving;
                    creative = player.field_71075_bZ.field_75098_d;
                    foodLevel = player.func_71024_bL().func_75116_a();
                    isPlayer = true;
                } else {
                    healthPercent /= 2.0f;
                }
                if (event.entityLiving instanceof EntityPlayer && IguanaConfig.constantHungerLoss) {
                    player = (EntityPlayer)event.entityLiving;
                    if (!player.field_71075_bZ.field_75098_d && !player.field_70128_L) {
                        player.func_71020_j(0.01f);
                    }
                }
                if (IguanaConfig.addLowStatEffects) {
                    int difficultyModifierEffects = 2;
                    if (IguanaConfig.difficultyScalingEffects) {
                        difficultyModifierEffects = event.entityLiving.field_70170_p.field_73013_u.func_151525_a();
                        if (!(event.entityLiving instanceof EntityPlayer)) {
                            difficultyModifierEffects = difficultyModifierEffects * -1 + 3;
                        }
                    }
                    if (!creative && isPlayer && !event.entityLiving.field_70128_L && healthPercent > 0.0f) {
                        if (IguanaConfig.addLowStatSlowness) {
                            if (foodLevel <= 1 || healthPercent <= 0.05f) {
                                event.entityLiving.func_70690_d(new PotionEffect(Potion.field_76421_d.field_76415_H, 19, 1 + difficultyModifierEffects, true));
                            } else if (foodLevel <= 2 || healthPercent <= 0.1f) {
                                event.entityLiving.func_70690_d(new PotionEffect(Potion.field_76421_d.field_76415_H, 19, difficultyModifierEffects, true));
                            } else if ((foodLevel <= 3 || healthPercent <= 0.15f) && difficultyModifierEffects >= 1) {
                                event.entityLiving.func_70690_d(new PotionEffect(Potion.field_76421_d.field_76415_H, 19, -1 + difficultyModifierEffects, true));
                            } else if ((foodLevel <= 4 || healthPercent <= 0.2f) && difficultyModifierEffects >= 2) {
                                event.entityLiving.func_70690_d(new PotionEffect(Potion.field_76421_d.field_76415_H, 19, -2 + difficultyModifierEffects, true));
                            } else if ((foodLevel <= 5 || healthPercent <= 0.25f) && difficultyModifierEffects >= 3) {
                                event.entityLiving.func_70690_d(new PotionEffect(Potion.field_76421_d.field_76415_H, 19, -3 + difficultyModifierEffects, true));
                            }
                        }
                        if (IguanaConfig.addLowStatMiningSlowdown) {
                            if (foodLevel <= 1 || healthPercent <= 0.05f) {
                                event.entityLiving.func_70690_d(new PotionEffect(Potion.field_76419_f.field_76415_H, 19, 1 + difficultyModifierEffects, true));
                            } else if (foodLevel <= 2 || healthPercent <= 0.1f) {
                                event.entityLiving.func_70690_d(new PotionEffect(Potion.field_76419_f.field_76415_H, 19, difficultyModifierEffects, true));
                            } else if ((foodLevel <= 3 || healthPercent <= 0.15f) && difficultyModifierEffects >= 1) {
                                event.entityLiving.func_70690_d(new PotionEffect(Potion.field_76419_f.field_76415_H, 19, -1 + difficultyModifierEffects, true));
                            } else if ((foodLevel <= 4 || healthPercent <= 0.2f) && difficultyModifierEffects >= 2) {
                                event.entityLiving.func_70690_d(new PotionEffect(Potion.field_76419_f.field_76415_H, 19, -2 + difficultyModifierEffects, true));
                            } else if ((foodLevel <= 5 || healthPercent <= 0.25f) && difficultyModifierEffects >= 3) {
                                event.entityLiving.func_70690_d(new PotionEffect(Potion.field_76419_f.field_76415_H, 19, -3 + difficultyModifierEffects, true));
                            }
                        }
                        if (IguanaConfig.addLowStatWeakness) {
                            if ((foodLevel <= 1 || healthPercent <= 0.05f) && difficultyModifierEffects >= 1) {
                                event.entityLiving.func_70690_d(new PotionEffect(Potion.field_76437_t.field_76415_H, 19, -1 + difficultyModifierEffects, true));
                            } else if ((foodLevel <= 2 || healthPercent <= 0.1f) && difficultyModifierEffects >= 2) {
                                event.entityLiving.func_70690_d(new PotionEffect(Potion.field_76437_t.field_76415_H, 19, -2 + difficultyModifierEffects, true));
                            } else if ((foodLevel <= 3 || healthPercent <= 0.15f) && difficultyModifierEffects >= 3) {
                                event.entityLiving.func_70690_d(new PotionEffect(Potion.field_76437_t.field_76415_H, 19, -3 + difficultyModifierEffects, true));
                            }
                        }
                        if (IguanaConfig.addLowStatNausea && isPlayer && (foodLevel <= 1 || healthPercent <= 0.05f)) {
                            event.entityLiving.func_70690_d(new PotionEffect(Potion.field_76431_k.field_76415_H, 19, 0, true));
                        }
                    }
                }
                tags.func_74768_a("HungerOverhaulCheck", 9);
            }
        }
    }

    @SubscribeEvent
    public void onUseHoe(UseHoeEvent event) {
        if (IguanaConfig.modifyHoeUse) {
            Block block = event.world.func_147439_a(event.x, event.y, event.z);
            if ((block == Blocks.field_150346_d || block == Blocks.field_150349_c) && this.isWaterNearby(event.world, event.x, event.y, event.z)) {
                if (IguanaConfig.hoeToolDamageMultiplier > 1) {
                    event.current.func_77972_a(IguanaConfig.hoeToolDamageMultiplier - 1, (EntityLivingBase)event.entityPlayer);
                }
            } else if (block == Blocks.field_150349_c && !this.isWaterNearby(event.world, event.x, event.y, event.z)) {
                Block block1 = Blocks.field_150458_ak;
                event.world.func_72908_a((double)((float)event.x + 0.5f), (double)((float)event.y + 0.5f), (double)((float)event.z + 0.5f), block1.field_149762_H.field_150501_a, (block1.field_149762_H.func_150497_c() + 1.0f) / 2.0f, block1.field_149762_H.func_150494_d() * 0.8f);
                if (!event.world.field_72995_K && IguanaConfig.seedChance > 0) {
                    ItemStack seed;
                    int seedChance = IguanaConfig.seedChance;
                    if (event.world.field_73013_u.func_151525_a() < 2) {
                        seedChance *= 2;
                    } else if (event.world.field_73013_u.func_151525_a() == 3) {
                        seedChance = Math.max(Math.round((float)seedChance / 2.0f), 1);
                    }
                    if (event.world.field_73012_v.nextInt(100) <= seedChance && (seed = ModuleGrassSeeds.getSeedFromTillingGrass(event.world)) != null) {
                        block.func_149642_a(event.world, event.x, event.y, event.z, seed);
                    }
                    event.world.func_147449_b(event.x, event.y, event.z, Blocks.field_150346_d);
                }
                if (IguanaConfig.hoeToolDamageMultiplier > 1) {
                    event.current.func_77972_a(IguanaConfig.hoeToolDamageMultiplier - 1, (EntityLivingBase)event.entityPlayer);
                }
                event.setResult(Event.Result.ALLOW);
            } else {
                event.setCanceled(true);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onRenderGameOverlay(RenderGameOverlayEvent.Text event) {
        if (IguanaConfig.addGuiText) {
            Minecraft mc = Minecraft.func_71410_x();
            EntityClientPlayerMP player = mc.field_71439_g;
            if (!(player.field_70128_L || player.field_71075_bZ.field_75098_d || mc.field_71474_y.field_74330_P)) {
                float healthPercent = player.func_110143_aJ() / player.func_110138_aP();
                if (healthPercent <= 0.15f) {
                    event.left.add("\u00a7cDying\u00a7r");
                } else if (healthPercent <= 0.3f) {
                    event.left.add("\u00a7eInjured\u00a7r");
                } else if (healthPercent < 0.5f) {
                    event.left.add("\u00a7fHurt\u00a7r");
                }
                if (player.func_71024_bL().func_75116_a() <= 6) {
                    event.right.add("\u00a7cStarving\u00a7r");
                } else if (player.func_71024_bL().func_75116_a() <= 10) {
                    event.right.add("\u00a7eHungry\u00a7r");
                } else if (player.func_71024_bL().func_75116_a() <= 14) {
                    event.right.add("\u00a7fPeckish\u00a7r");
                }
            }
        }
    }

    @SubscribeEvent
    public void onEntityInteractEvent(EntityInteractEvent event) {
        if (IguanaConfig.milkedTimeout > 0 && event.entityPlayer != null && event.target != null && event.target instanceof EntityCow) {
            Item item;
            EntityCow cow = (EntityCow)event.target;
            EntityPlayer player = event.entityPlayer;
            ItemStack equipped = player.func_71045_bC();
            if (equipped != null && equipped.func_77973_b() != null && ((item = equipped.func_77973_b()) instanceof ItemBucket && ((ItemBucket)item).field_77876_a == Blocks.field_150350_a || cow instanceof EntityMooshroom && item == Items.field_151054_z)) {
                NBTTagCompound tags = cow.getEntityData();
                if (tags.func_74764_b("Milked")) {
                    event.setCanceled(true);
                    if (!player.field_70170_p.field_72995_K) {
                        cow.func_85030_a("mob.cow.hurt", 0.4f, (event.entity.field_70170_p.field_73012_v.nextFloat() - event.entity.field_70170_p.field_73012_v.nextFloat()) * 0.2f + 1.0f);
                    }
                } else {
                    tags.func_74768_a("Milked", IguanaConfig.milkedTimeout * 60);
                }
            }
        }
    }

    @SubscribeEvent
    public void onLivingHurtEvent(LivingHurtEvent event) {
        if (event.entityLiving instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.entityLiving;
            AppleCoreAPI.mutator.setHealthRegenTickCounter(player, 0);
        }
    }

    @SubscribeEvent
    public void onPlayerInteraction(PlayerInteractEvent event) {
        if (event.action != PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        if (IguanaConfig.foodsUnplantable && Loader.isModLoaded((String)"harvestcraft") && event.entityPlayer.func_70694_bm() != null && event.entityPlayer.func_70694_bm().func_77973_b() instanceof ItemPamSeedFood) {
            if (event.world.field_72995_K) {
                if (PamsModsHelper.canPlantSeedFoodAt(event.entityPlayer, event.entityPlayer.func_70694_bm(), event.world, event.x, event.y, event.z, event.face)) {
                    event.setCanceled(true);
                }
            } else {
                event.useItem = Event.Result.DENY;
            }
            return;
        }
        Block clicked = event.world.func_147439_a(event.x, event.y, event.z);
        int meta = event.world.func_72805_g(event.x, event.y, event.z);
        int resultingMeta = -1;
        if (Loader.isModLoaded((String)"Natura") && clicked instanceof CropBlock) {
            if (meta == 3 || meta == 8) {
                resultingMeta = meta == 3 ? 0 : 4;
            }
        } else if (clicked instanceof BlockCrops && meta >= 7) {
            resultingMeta = 0;
        }
        if (resultingMeta >= 0) {
            clicked.func_149697_b(event.world, event.x, event.y, event.z, meta, 0);
            event.world.func_72921_c(event.x, event.y, event.z, resultingMeta, 2);
            if (event.world.field_72995_K) {
                ClientHelper.sendRightClickPacket(event.x, event.y, event.z, event.face, event.entityPlayer.field_71071_by.func_70448_g(), 0.0f, 0.0f, 0.0f);
                event.setCanceled(true);
            } else {
                event.useItem = Event.Result.DENY;
            }
        }
    }

    @SubscribeEvent
    public void onBlockHarvested(BlockEvent.HarvestDropsEvent event) {
        boolean isNaturaCrop;
        boolean bl = isNaturaCrop = Loader.isModLoaded((String)"Natura") && event.block instanceof CropBlock;
        if (isNaturaCrop || event.block instanceof BlockCrops) {
            event.drops.clear();
            if (!isNaturaCrop && event.blockMetadata >= 7 || isNaturaCrop && event.blockMetadata == 3 || event.blockMetadata == 8) {
                int seeds;
                int produce = RandomHelper.getRandomIntFromRange(IguanaConfig.producePerHarvestMin, IguanaConfig.producePerHarvestMax);
                if (produce > 0) {
                    event.drops.add(BlockHelper.getProduceOfBlock(event.block, event.blockMetadata, produce));
                }
                if ((seeds = RandomHelper.getRandomIntFromRange(IguanaConfig.seedsPerHarvestMin, IguanaConfig.seedsPerHarvestMax)) > 0) {
                    event.drops.add(BlockHelper.getSeedsOfBlock(event.block, event.blockMetadata, seeds));
                }
            } else {
                event.drops.add(BlockHelper.getSeedOfBlock(event.block, event.blockMetadata));
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void renderTooltips(ItemTooltipEvent event) {
        if (IguanaConfig.addFoodTooltips && AppleCoreAPI.accessor.isFood(event.itemStack)) {
            FoodValues values = FoodValues.get((ItemStack)event.itemStack);
            int hungerFill = values.hunger;
            float satiation = values.saturationModifier * 20.0f - (float)hungerFill;
            String mealDescriptor = "";
            String adjective = null;
            String noun = hungerFill <= 1 ? "morsel" : (hungerFill <= 2 ? "snack" : (hungerFill <= 5 ? "lightmeal" : (hungerFill <= 8 ? "meal" : (hungerFill <= 11 ? "largemeal" : "feast"))));
            if (satiation >= 3.0f) {
                adjective = "hearty";
            } else if (satiation >= 2.0f) {
                adjective = "wholesome";
            } else if (satiation > 0.0f) {
                adjective = "nourishing";
            } else if (satiation < 0.0f) {
                adjective = "unfulfilling";
            }
            if (adjective != null && StatCollector.func_94522_b((String)("hungeroverhaul." + adjective + "." + noun))) {
                mealDescriptor = StatCollector.func_74838_a((String)("hungeroverhaul." + adjective + "." + noun));
            } else {
                mealDescriptor = StatCollector.func_74838_a((String)("hungeroverhaul." + noun));
                if (adjective != null) {
                    mealDescriptor = StatCollector.func_74837_a((String)StatCollector.func_74838_a((String)("hungeroverhaul." + adjective)), (Object[])new Object[]{mealDescriptor});
                }
            }
            int topIndex = event.toolTip.size() > 0 ? 1 : 0;
            event.toolTip.add(topIndex, mealDescriptor.substring(0, 1).toUpperCase() + mealDescriptor.substring(1));
        }
        if (IguanaConfig.wrongBiomeRegrowthMultiplier > 1) {
            PlantGrowthModification growthModification = null;
            if (event.itemStack.func_77973_b() instanceof IPlantable) {
                growthModification = ModulePlantGrowth.getPlantGrowthModification(((IPlantable)event.itemStack.func_77973_b()).getPlant((IBlockAccess)event.entityPlayer.field_70170_p, 0, 0, 0));
            } else if (event.itemStack.func_77973_b() instanceof ItemBlock) {
                Block block = Block.func_149634_a((Item)event.itemStack.func_77973_b());
                if (block != null) {
                    growthModification = ModulePlantGrowth.getPlantGrowthModification(block);
                }
            } else {
                Block block = PamsModsHelper.fruitItemToBlockMap.get(event.itemStack.func_77973_b());
                if (block != null) {
                    growthModification = ModulePlantGrowth.getPlantGrowthModification(block);
                }
            }
            if (growthModification != null && !growthModification.biomeGrowthModifiers.isEmpty()) {
                String tooltip = "";
                for (BiomeDictionary.Type biomeType : growthModification.biomeGrowthModifiers.keySet()) {
                    tooltip = tooltip + biomeType.toString().substring(0, 1).toUpperCase() + biomeType.toString().substring(1).toLowerCase() + ", ";
                }
                event.toolTip.add(StatCollector.func_74838_a((String)"hungeroverhaul.crop.grows.best.in"));
                event.toolTip.add(tooltip.substring(0, tooltip.length() - 2));
            }
        }
    }

    private boolean isWaterNearby(World par1World, int par2, int par3, int par4) {
        for (int l = par2 - 4; l <= par2 + 4; ++l) {
            for (int i1 = par3; i1 <= par3 + 1; ++i1) {
                for (int j1 = par4 - 4; j1 <= par4 + 4; ++j1) {
                    if (par1World.func_147439_a(l, i1, j1).func_149688_o() != Material.field_151586_h) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

