package iguanaman.hungeroverhaul.module.village.generation;

import com.google.common.collect.Lists;
import iguanaman.hungeroverhaul.common.config.Config;
import iguanaman.hungeroverhaul.module.harvestcraft.helper.PamsModsHelper;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.StructureVillagePieces.PieceWeight;
import net.minecraft.world.gen.structure.StructureVillagePieces.Start;
import net.minecraft.world.gen.structure.StructureVillagePieces.Village;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.BiomeDictionary.Type;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.registry.VillagerRegistry.IVillageCreationHandler;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class VillageCustomField extends Village
{
    private FieldType typeA;

    private FieldType typeB;

    private int groundLevel = -1;

    public VillageCustomField()
    {
    }

    public VillageCustomField(Start villagePiece, int par2, Random par3Random, StructureBoundingBox par4StructureBoundingBox, EnumFacing facing)
    {
        super(villagePiece, par2);
        this.func_186164_a(facing);
        this.field_74887_e = par4StructureBoundingBox;
    }

    @SuppressWarnings("deprecation")
    @Override
    public boolean func_74875_a(World worldIn, Random randomIn, StructureBoundingBox structureBoundingBoxIn)
    {
        if (this.groundLevel < 0)
        {
            this.groundLevel = this.func_74889_b(worldIn, structureBoundingBoxIn);

            if (this.groundLevel < 0)
            {
                return true;
            }

            this.field_74887_e.func_78886_a(0, this.groundLevel - this.field_74887_e.field_78894_e + 4 - 1, 0);
        }

        BlockPos center = new BlockPos(this.getCenter(this.field_74887_e));

        Biome biome = worldIn.func_180494_b(center);

        this.typeA = this.randomFieldType(biome, randomIn);
        this.typeB = this.randomFieldType(biome, randomIn);

        IBlockState blockStateOutA = Blocks.field_150458_ak.func_176223_P();
        IBlockState blockStateInA = Blocks.field_150358_i.func_176223_P();
        IBlockState blockStateOutB = Blocks.field_150458_ak.func_176223_P();
        IBlockState blockStateInB = Blocks.field_150358_i.func_176223_P();

        IBlockState AIR = Blocks.field_150350_a.func_176223_P();
        IBlockState LOG = this.func_175847_a(Blocks.field_150364_r.func_176223_P());

        Block crop1A;
        Block crop2A;
        Block crop1B;
        Block crop2B;

        if (this.typeA == FieldType.REED)
        {
            if (BiomeDictionary.hasType(biome, Type.SANDY))
            {
                blockStateOutA = Blocks.field_150354_m.func_176223_P();
            }
            else
            {
                blockStateOutA = Blocks.field_150346_d.func_176223_P();
            }
            crop1A = Blocks.field_150436_aH;
            crop2A = Blocks.field_150436_aH;
        }
        else if (this.typeA == FieldType.STEM)
        {
            crop1A = this.getRandomStemCrop(randomIn);
            crop2A = this.getRandomStemCrop(randomIn);
        }
        else
        {
            crop1A = this.getRandomCrop(randomIn);
            crop2A = this.getRandomCrop(randomIn);
        }

        if (this.typeB == FieldType.REED)
        {
            if (BiomeDictionary.hasType(biome, Type.SANDY))
            {
                blockStateOutB = Blocks.field_150354_m.func_176223_P();
            }
            else
            {
                blockStateOutB = Blocks.field_150346_d.func_176223_P();
            }
            crop1B = Blocks.field_150436_aH;
            crop2B = Blocks.field_150436_aH;
        }
        else if (this.typeA == FieldType.STEM)
        {
            crop1B = this.getRandomStemCrop(randomIn);
            crop2B = this.getRandomStemCrop(randomIn);
        }
        else
        {
            crop1B = this.getRandomCrop(randomIn);
            crop2B = this.getRandomCrop(randomIn);
        }

        int cropMeta1A = this.getCropMeta(crop1A, randomIn);
        int cropMeta2A = this.getCropMeta(crop2A, randomIn);
        int cropMeta1B = this.getCropMeta(crop1B, randomIn);
        int cropMeta2B = this.getCropMeta(crop2B, randomIn);

        //BASE
        this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 1, 0, 12, 4, 8, AIR, AIR, false);
        this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 0, 0, 0, 0, 8, LOG, LOG, false);
        this.func_175804_a(worldIn, structureBoundingBoxIn, 6, 0, 0, 6, 0, 8, LOG, LOG, false);
        this.func_175804_a(worldIn, structureBoundingBoxIn, 12, 0, 0, 12, 0, 8, LOG, LOG, false);
        this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 0, 0, 11, 0, 0, LOG, LOG, false);
        this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 0, 8, 11, 0, 8, LOG, LOG, false);

        //A
        this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 0, 1, 2, 0, 7, blockStateOutA, blockStateOutA, false);
        this.func_175804_a(worldIn, structureBoundingBoxIn, 3, 0, 1, 3, 0, 7, blockStateInA, blockStateInA, false);
        this.func_175804_a(worldIn, structureBoundingBoxIn, 4, 0, 1, 5, 0, 7, blockStateOutA, blockStateOutA, false);

        //B
        this.func_175804_a(worldIn, structureBoundingBoxIn, 7, 0, 1, 8, 0, 7, blockStateOutB, blockStateOutB, false);
        this.func_175804_a(worldIn, structureBoundingBoxIn, 9, 0, 1, 9, 0, 7, blockStateInB, blockStateInB, false);
        this.func_175804_a(worldIn, structureBoundingBoxIn, 10, 0, 1, 11, 0, 7, blockStateOutB, blockStateOutB, false);

        //CROPS
        for (int i = 1; i <= 7; i++)
        {
            if (this.typeA == FieldType.NORMAL)
            {
                this.placeCropAtCurrentPosition(worldIn, crop1A.func_176203_a(cropMeta1A), 1, 1, i, structureBoundingBoxIn);
            }

            this.placeCropAtCurrentPosition(worldIn, crop1A.func_176203_a(cropMeta1A), 2, 1, i, structureBoundingBoxIn);
            this.placeCropAtCurrentPosition(worldIn, crop2A.func_176203_a(cropMeta2A), 4, 1, i, structureBoundingBoxIn);

            if (this.typeA == FieldType.NORMAL)
            {
                this.placeCropAtCurrentPosition(worldIn, crop2A.func_176203_a(cropMeta2A), 5, 1, i, structureBoundingBoxIn);
            }
            if (this.typeA == FieldType.NORMAL)
            {
                this.placeCropAtCurrentPosition(worldIn, crop1B.func_176203_a(cropMeta1B), 7, 1, i, structureBoundingBoxIn);
            }

            this.placeCropAtCurrentPosition(worldIn, crop1B.func_176203_a(cropMeta1B), 8, 1, i, structureBoundingBoxIn);
            this.placeCropAtCurrentPosition(worldIn, crop2B.func_176203_a(cropMeta2B), 10, 1, i, structureBoundingBoxIn);

            if (this.typeA == FieldType.NORMAL)
            {
                this.placeCropAtCurrentPosition(worldIn, crop2B.func_176203_a(cropMeta2B), 11, 1, i, structureBoundingBoxIn);
            }
        }

        //FILLER
        for (int j2 = 0; j2 < 9; ++j2)
        {
            for (int k2 = 0; k2 < 13; ++k2)
            {
                this.func_74871_b(worldIn, k2, 4, j2, structureBoundingBoxIn);
                this.func_175808_b(worldIn, Blocks.field_150346_d.func_176223_P(), k2, -1, j2, structureBoundingBoxIn);
            }
        }

        return true;
    }

    public Vec3i getCenter(StructureBoundingBox boundingBox)
    {
        return new BlockPos(boundingBox.field_78897_a + (boundingBox.field_78893_d - boundingBox.field_78897_a + 1) / 2, boundingBox.field_78895_b + (boundingBox.field_78894_e - boundingBox.field_78895_b + 1) / 2, boundingBox.field_78896_c + (boundingBox.field_78892_f - boundingBox.field_78896_c + 1) / 2);
    }

    private enum FieldType
    {
        NORMAL, REED, STEM
    }

    /**
     * Returns a crop type to be planted on this field.
     */
    private Block getRandomStemCrop(Random par1Random)
    {
        ArrayList<Block> crops = Lists.newArrayList();

        crops.add(Blocks.field_150393_bb);
        crops.add(Blocks.field_150394_bc);

        return crops.get(par1Random.nextInt(crops.size() - 1));
    }

    private Block getRandomCrop(Random random)
    {
        return Loader.isModLoaded("harvestcraft") ? this.getRandomCropHarvestCraft(random) : this.getRandomCropVanilla(random);
    }

    private Block getRandomCropVanilla(Random random)
    {
        ArrayList<Block> crops = new ArrayList<Block>();

        crops.add(Blocks.field_150464_aj);
        crops.add(Blocks.field_150459_bM);
        crops.add(Blocks.field_150469_bN);

        return crops.get(random.nextInt(crops.size()));
    }

    private Block getRandomCropHarvestCraft(Random random)
    {
        int length = PamsModsHelper.PamCrops.length;

        return random.nextInt(length + 3) <= length ? PamsModsHelper.PamCrops[random.nextInt(length)] : this.getRandomCropVanilla(random);
    }

    private int getCropMeta(Block block, Random random)
    {
        return random.nextInt(4);
    }

    private FieldType randomFieldType(Biome biome, Random random)
    {
        int normalWeight = Config.fieldNormalWeight;
        int reedWeight = Config.fieldReedWeight;
        int stemWeight = Config.fieldStemWeight;

        if (BiomeDictionary.hasType(biome, Type.JUNGLE) || BiomeDictionary.hasType(biome, Type.SWAMP))
        {
            reedWeight *= 2;
            stemWeight *= 2;
        }

        int weights = normalWeight + reedWeight + stemWeight;
        int rnd = random.nextInt(weights);

        if (rnd < reedWeight)
        {
            return FieldType.REED;
        }
        else if (rnd < reedWeight + stemWeight)
        {
            return FieldType.STEM;
        }
        else
        {
            return FieldType.NORMAL;
        }

    }

    private void placeCropAtCurrentPosition(World worldIn, IBlockState blockstateIn, int x, int y, int z, StructureBoundingBox boundingboxIn)
    {
        if (Loader.isModLoaded("harvestcraft"))
        {
            this.placeHarvestCraftCropAtCurrentPosition(worldIn, blockstateIn, x, y, z, boundingboxIn);
        }
        else
        {
            this.func_175808_b(worldIn, blockstateIn, x, y, z, boundingboxIn);
        }
    }

    private void placeHarvestCraftCropAtCurrentPosition(World worldIn, IBlockState blockstateIn, int x, int y, int z, StructureBoundingBox boundingboxIn)
    {
        int i = this.func_74865_a(x, z);
        int j = this.func_74862_a(y);
        int k = this.func_74873_b(x, z);

        BlockPos pos = new BlockPos(i, j, k);

        if (boundingboxIn.func_175898_b(pos))
        {
            worldIn.func_180501_a(pos, blockstateIn, 2);
        }
    }

    public static class VillageManager implements IVillageCreationHandler
    {
        @Override
        public Village buildComponent(PieceWeight villagePiece, Start startPiece, List<StructureComponent> pieces, Random random, int p1, int p2, int p3, EnumFacing facing, int p5)
        {
            StructureBoundingBox box = StructureBoundingBox.func_175897_a(p1, p2, p3, 0, 0, 0, 13, 4, 9, facing);
            return (!func_74895_a(box)) || (StructureComponent.func_74883_a(pieces, box) != null) ? null : new VillageCustomField(startPiece, p5, random, box, facing);
        }

        @Override
        public PieceWeight getVillagePieceWeight(Random random, int i)
        {
            return new PieceWeight(VillageCustomField.class, 15, MathHelper.func_76136_a(random, 0 + i, 1 + i));
        }

        @Override
        public Class<?> getComponentClass()
        {
            return VillageCustomField.class;
        }
    }

}
