/*
 * Decompiled with CFR 0.152.
 */
package iguanaman.hungeroverhaul;

import com.google.common.collect.ImmutableList;
import iguanaman.hungeroverhaul.common.config.Config;
import iguanaman.hungeroverhaul.module.biomesoplenty.BiomesOPlentyModule;
import iguanaman.hungeroverhaul.module.bonemeal.BonemealModule;
import iguanaman.hungeroverhaul.module.commands.HOCommand;
import iguanaman.hungeroverhaul.module.event.HungerOverhaulEventHook;
import iguanaman.hungeroverhaul.module.event.IMCHandler;
import iguanaman.hungeroverhaul.module.food.FoodEventHandler;
import iguanaman.hungeroverhaul.module.food.FoodModifier;
import iguanaman.hungeroverhaul.module.growth.PlantGrowthModule;
import iguanaman.hungeroverhaul.module.harvestcraft.HarvestCraftModule;
import iguanaman.hungeroverhaul.module.harvestcraft.helper.PamsModsHelper;
import iguanaman.hungeroverhaul.module.hunger.RespawnHungerModule;
import iguanaman.hungeroverhaul.module.json.JsonModule;
import iguanaman.hungeroverhaul.module.loot.LootModule;
import iguanaman.hungeroverhaul.module.natura.NaturaModule;
import iguanaman.hungeroverhaul.module.natura.helper.NaturaHelper;
import iguanaman.hungeroverhaul.module.reflection.ReflectionModule;
import iguanaman.hungeroverhaul.module.tinkersconstruct.TinkersConstructModule;
import iguanaman.hungeroverhaul.module.tweak.TweaksModule;
import iguanaman.hungeroverhaul.module.vanilla.VanillaModule;
import iguanaman.hungeroverhaul.module.vanilla.potion.PotionWellFed;
import iguanaman.hungeroverhaul.module.village.VillageModule;
import java.io.File;
import net.minecraft.command.ICommand;
import net.minecraft.potion.Potion;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="hungeroverhaul", name="Hunger Overhaul", version="1.12.2-1.3.0.jenkins130", dependencies="required-after:forge@[14.21.1.2387,);required-after:applecore;after:tconstruct;after:harvestcraft;after:natura@[1.12-4.3.0.17,);after:ic2;after:*", acceptedMinecraftVersions="[1.12, 1.13)")
public class HungerOverhaul {
    public static final String modID = "hungeroverhaul";
    public static final String modVersion = "1.12.2-1.3.0.jenkins130";
    public static final String modName = "Hunger Overhaul";
    public static final Logger log = LogManager.getLogger((String)"hungeroverhaul");
    @Mod.Instance(value="hungeroverhaul")
    public static HungerOverhaul instance;
    public static Potion potionWellFed;
    public static File configPath;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        Config.load(event);
        configPath = event.getModConfigurationDirectory();
        JsonModule.preinit(configPath);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new FoodEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)new FoodModifier());
        MinecraftForge.EVENT_BUS.register((Object)new PlantGrowthModule());
        MinecraftForge.EVENT_BUS.register((Object)new BonemealModule());
        VanillaModule.init();
        if (Loader.isModLoaded((String)"harvestcraft")) {
            PamsModsHelper.loadHC();
            HarvestCraftModule.init();
        }
        if (Loader.isModLoaded((String)"tconstruct")) {
            TinkersConstructModule.init();
        }
        if (Loader.isModLoaded((String)"natura")) {
            NaturaHelper.loadNatura();
            NaturaModule.init();
        }
        if (Loader.isModLoaded((String)"biomesoplenty")) {
            BiomesOPlentyModule.init();
        }
        JsonModule.init();
        VillageModule.init();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        VanillaModule.postInit();
        ReflectionModule.postInit();
        TweaksModule.postInit();
        VillageModule.postInit();
        LootModule.postInit();
        MinecraftForge.EVENT_BUS.register((Object)new HungerOverhaulEventHook());
        MinecraftForge.EVENT_BUS.register((Object)new RespawnHungerModule());
        MinecraftForge.EVENT_BUS.register((Object)new LootModule());
    }

    @SubscribeEvent
    public void registerPotions(RegistryEvent.Register<Potion> event) {
        IForgeRegistry registry = event.getRegistry();
        registry.register((IForgeRegistryEntry)potionWellFed);
    }

    @Mod.EventHandler
    private void serverStarting(FMLServerStartingEvent evt) {
        evt.registerServerCommand((ICommand)new HOCommand(evt.getServer()));
    }

    @Mod.EventHandler
    public void handleIMCMessages(FMLInterModComms.IMCEvent event) {
        IMCHandler.processMessages((ImmutableList<FMLInterModComms.IMCMessage>)event.getMessages());
    }

    static {
        potionWellFed = new PotionWellFed();
    }
}

