package iguanaman.hungeroverhaul.module.event;

import java.util.List;
import java.util.Random;

import com.pam.harvestcraft.blocks.growables.BlockPamCrop;
import com.pam.harvestcraft.blocks.growables.BlockPamFruit;
import com.pam.harvestcraft.blocks.growables.BlockPamFruitLog;
import com.pam.harvestcraft.item.items.ItemPamSeedFood;
import com.progwml6.natura.overworld.block.crops.BlockNaturaBarley;
import com.progwml6.natura.overworld.block.crops.BlockNaturaCotton;

import iguanaman.hungeroverhaul.common.BlockHelper;
import iguanaman.hungeroverhaul.common.ClientHelper;
import iguanaman.hungeroverhaul.common.RandomHelper;
import iguanaman.hungeroverhaul.common.config.Config;
import iguanaman.hungeroverhaul.library.ItemAndBlockList;
import iguanaman.hungeroverhaul.module.growth.PlantGrowthModule;
import iguanaman.hungeroverhaul.module.growth.modification.PlantGrowthModification;
import iguanaman.hungeroverhaul.module.harvestcraft.helper.PamsModsHelper;
import iguanaman.hungeroverhaul.module.reflection.ReflectionModule;
import iguanaman.hungeroverhaul.module.seed.GrassSeedsModule;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBeetroot;
import net.minecraft.block.BlockCarrot;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.BlockPotato;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityMooshroom;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemBucket;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockPos.MutableBlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent.Text;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.event.entity.living.LivingEvent.LivingUpdateEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent.EntityInteract;
import net.minecraftforge.event.entity.player.PlayerInteractEvent.RightClickBlock;
import net.minecraftforge.event.entity.player.UseHoeEvent;
import net.minecraftforge.event.world.BlockEvent.HarvestDropsEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.eventhandler.Event.Result;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import squeek.applecore.api.AppleCoreAPI;
import squeek.applecore.api.food.FoodValues;

@SuppressWarnings("deprecation")
public class HungerOverhaulEventHook
{
    private static long lastRightClickCrop = 0;

    public static ItemAndBlockList rightClickHarvestBlacklist = new ItemAndBlockList();

    public static ItemAndBlockList harvestDropsBlacklist = new ItemAndBlockList();

    static
    {
        if (Loader.isModLoaded("extrautils2"))
        {
            Block enderLilly = Block.func_149684_b("extrautils2:enderlilly");

            if (enderLilly != null)
            {
                rightClickHarvestBlacklist.add(enderLilly);
                harvestDropsBlacklist.add(enderLilly);
            }
        }
    }

    @SubscribeEvent
    public void onLivingUpdate(LivingUpdateEvent event)
    {
        Random rand = new Random();

        // Slow growth and egg rates
        if (event.getEntityLiving() instanceof EntityAnimal)
        {
            float rndBreed = RandomHelper.nextFloat(rand, Config.breedingTimeoutMultiplier);
            float rndChild = RandomHelper.nextFloat(rand, Config.childDurationMultiplier);

            EntityAgeable ageable = (EntityAgeable) event.getEntityLiving();
            int growingAge = ageable.func_70874_b();

            if (growingAge > 0 && rndBreed >= 1)
            {
                ageable.func_70873_a(++growingAge);
            }
            else if (growingAge < 0 && rndChild >= 1)
            {
                ageable.func_70873_a(--growingAge);
            }

            if (Config.eggTimeoutMultiplier > 1 && event.getEntityLiving() instanceof EntityChicken)
            {
                float rnd = RandomHelper.nextFloat(rand, Config.eggTimeoutMultiplier);
                EntityChicken chicken = (EntityChicken) event.getEntityLiving();

                if (chicken.field_70887_j > 0 && rnd >= 1)
                {
                    chicken.field_70887_j += 1;
                }
            }

            // Reduced milked value every second
            if (Config.milkedTimeout > 0 && event.getEntityLiving() instanceof EntityCow && event.getEntityLiving().field_70170_p.func_82737_E() % 20 == 0)
            {
                NBTTagCompound tags = event.getEntityLiving().getEntityData();

                if (tags.func_74764_b("Milked"))
                {
                    int milked = tags.func_74762_e("Milked");

                    if (--milked <= 0)
                    {
                        tags.func_82580_o("Milked");
                    }
                    else
                    {
                        tags.func_74768_a("Milked", milked);
                    }
                }
            }
        }

        if (!event.getEntityLiving().field_70170_p.field_72995_K)
        {
            NBTTagCompound tags = event.getEntityLiving().getEntityData();

            // low stat effects
            if (tags.func_74764_b("HungerOverhaulCheck"))
            {
                int lastCheck = tags.func_74762_e("HungerOverhaulCheck");

                if (--lastCheck <= 0)
                {
                    tags.func_82580_o("HungerOverhaulCheck");
                }
                else
                {
                    tags.func_74768_a("HungerOverhaulCheck", lastCheck);
                }
            }
            else
            {
                float healthPercent = event.getEntityLiving().func_110143_aJ() / event.getEntityLiving().func_110138_aP();
                int foodLevel = 20;
                boolean creative = false;
                boolean isPlayer = false;

                if (event.getEntityLiving() instanceof EntityPlayer)
                {
                    EntityPlayer player = (EntityPlayer) event.getEntityLiving();
                    creative = player.field_71075_bZ.field_75098_d;
                    foodLevel = player.func_71024_bL().func_75116_a();
                    isPlayer = true;
                }
                else
                {
                    healthPercent /= 2;
                }

                if (event.getEntityLiving() instanceof EntityPlayer && Config.constantHungerLoss)
                {
                    EntityPlayer player = (EntityPlayer) event.getEntityLiving();

                    if (!player.field_71075_bZ.field_75098_d && !player.field_70128_L)
                    {
                        player.func_71020_j(0.01F);
                    }
                }

                if (Config.addLowStatEffects)
                {
                    int difficultyModifierEffects = 2;

                    if (Config.difficultyScalingEffects && event.getEntityLiving().field_70170_p.func_175659_aa() != null)
                    {
                        difficultyModifierEffects = event.getEntityLiving().field_70170_p.func_175659_aa().func_151525_a();

                        if (!(event.getEntityLiving() instanceof EntityPlayer))
                        {
                            difficultyModifierEffects = difficultyModifierEffects * -1 + 3;
                        }
                    }

                    // low stat effects
                    if (!creative && isPlayer && !event.getEntityLiving().field_70128_L && healthPercent > 0f)
                    {
                        if (Config.addLowHealthSlowness || Config.addLowHungerSlowness)
                        {
                            if ((Config.addLowHungerSlowness && foodLevel <= 1) || (Config.addLowHealthSlowness && healthPercent <= 0.05F))
                            {
                                event.getEntityLiving().func_70690_d(new PotionEffect(MobEffects.field_76421_d, 19, 1 + difficultyModifierEffects, true, true));
                            }
                            else if ((Config.addLowHungerSlowness && foodLevel <= 2) || (Config.addLowHealthSlowness && healthPercent <= 0.10F))
                            {
                                event.getEntityLiving().func_70690_d(new PotionEffect(MobEffects.field_76421_d, 19, difficultyModifierEffects, true, true));
                            }
                            else if (((Config.addLowHungerSlowness && foodLevel <= 3) || (Config.addLowHealthSlowness && healthPercent <= 0.15F)) && difficultyModifierEffects >= 1)
                            {
                                event.getEntityLiving().func_70690_d(new PotionEffect(MobEffects.field_76421_d, 19, -1 + difficultyModifierEffects, true, true));
                            }
                            else if (((Config.addLowHungerSlowness && foodLevel <= 4) || (Config.addLowHealthSlowness && healthPercent <= 0.20F)) && difficultyModifierEffects >= 2)
                            {
                                event.getEntityLiving().func_70690_d(new PotionEffect(MobEffects.field_76421_d, 19, -2 + difficultyModifierEffects, true, true));
                            }
                            else if (((Config.addLowHungerSlowness && foodLevel <= 5) || (Config.addLowHealthSlowness && healthPercent <= 0.25F)) && difficultyModifierEffects >= 3)
                            {
                                event.getEntityLiving().func_70690_d(new PotionEffect(MobEffects.field_76421_d, 19, -3 + difficultyModifierEffects, true, true));
                            }
                        }

                        if (Config.addLowHealthMiningSlowdown || Config.addLowHungerMiningSlowdown)
                        {
                            if ((Config.addLowHungerMiningSlowdown && foodLevel <= 1) || (Config.addLowHealthMiningSlowdown && healthPercent <= 0.05F))
                            {
                                event.getEntityLiving().func_70690_d(new PotionEffect(MobEffects.field_76419_f, 19, 1 + difficultyModifierEffects, true, true));
                            }
                            else if ((Config.addLowHungerMiningSlowdown && foodLevel <= 2) || (Config.addLowHealthMiningSlowdown && healthPercent <= 0.10F))
                            {
                                event.getEntityLiving().func_70690_d(new PotionEffect(MobEffects.field_76419_f, 19, difficultyModifierEffects, true, true));
                            }
                            else if (((Config.addLowHungerMiningSlowdown && foodLevel <= 3) || (Config.addLowHealthMiningSlowdown && healthPercent <= 0.15F)) && difficultyModifierEffects >= 1)
                            {
                                event.getEntityLiving().func_70690_d(new PotionEffect(MobEffects.field_76419_f, 19, -1 + difficultyModifierEffects, true, true));
                            }
                            else if (((Config.addLowHungerMiningSlowdown && foodLevel <= 4) || (Config.addLowHealthMiningSlowdown && healthPercent <= 0.20F)) && difficultyModifierEffects >= 2)
                            {
                                event.getEntityLiving().func_70690_d(new PotionEffect(MobEffects.field_76419_f, 19, -2 + difficultyModifierEffects, true, true));
                            }
                            else if (((Config.addLowHungerMiningSlowdown && foodLevel <= 5) || (Config.addLowHealthMiningSlowdown && healthPercent <= 0.25F)) && difficultyModifierEffects >= 3)
                            {
                                event.getEntityLiving().func_70690_d(new PotionEffect(MobEffects.field_76419_f, 19, -3 + difficultyModifierEffects, true, true));
                            }
                        }

                        if (Config.addLowHealthWeakness || Config.addLowHungerWeakness)
                        {
                            //Weakness effect
                            if (((Config.addLowHungerWeakness && foodLevel <= 1) || (Config.addLowHealthWeakness && healthPercent <= 0.05F)) && difficultyModifierEffects >= 1)
                            {
                                event.getEntityLiving().func_70690_d(new PotionEffect(MobEffects.field_76437_t, 19, -1 + difficultyModifierEffects, true, true));
                            }
                            else if (((Config.addLowHungerWeakness && foodLevel <= 2) || (Config.addLowHealthWeakness && healthPercent <= 0.10F)) && difficultyModifierEffects >= 2)
                            {
                                event.getEntityLiving().func_70690_d(new PotionEffect(MobEffects.field_76437_t, 19, -2 + difficultyModifierEffects, true, true));
                            }
                            else if (((Config.addLowHungerWeakness && foodLevel <= 3) || (Config.addLowHealthWeakness && healthPercent <= 0.15F)) && difficultyModifierEffects >= 3)
                            {
                                event.getEntityLiving().func_70690_d(new PotionEffect(MobEffects.field_76437_t, 19, -3 + difficultyModifierEffects, true, true));
                            }
                        }

                        if ((Config.addLowHungerNausea && foodLevel <= 1) || (Config.addLowHealthNausea && healthPercent <= 0.05F))
                        {
                            event.getEntityLiving().func_70690_d(new PotionEffect(MobEffects.field_76431_k, 19, 0, true, true));
                        }
                    }
                }

                tags.func_74768_a("HungerOverhaulCheck", 9);
            }
        }
    }

    @SubscribeEvent
    public void onUseHoe(UseHoeEvent event)
    {
        if (Config.modifyHoeUse)
        {
            World world = event.getWorld();
            BlockPos pos = event.getPos();
            ItemStack itemStack = event.getCurrent();
            EntityPlayer player = event.getEntityPlayer();
            IBlockState state = world.func_180495_p(pos);
            Block block = state.func_177230_c();

            if ((block == Blocks.field_150346_d || block == Blocks.field_150349_c) && this.isWaterNearby(world, pos))
            {
                if (Config.hoeToolDamageMultiplier > 1)
                {
                    itemStack.func_77972_a(Config.hoeToolDamageMultiplier - 1, player);
                }
            }
            else if (block == Blocks.field_150349_c && !this.isWaterNearby(world, pos))
            {
                Block farmland = Blocks.field_150458_ak;
                SoundType soundtype = farmland.getSoundType(farmland.func_176223_P(), world, pos, player);

                world.func_184133_a(player, pos, soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0F) / 2.0F, soundtype.func_185847_b() * 0.8F);

                if (!event.getWorld().field_72995_K && Config.seedChance > 0)
                {
                    int seedChance = Config.seedChance;

                    if (world.func_175659_aa().func_151525_a() < 2)
                    {
                        seedChance *= 2;
                    }
                    else if (world.func_175659_aa().func_151525_a() == 3)
                    {
                        seedChance = Math.max(Math.round(seedChance / 2f), 1);
                    }

                    if (event.getWorld().field_73012_v.nextInt(100) <= seedChance)
                    {
                        ItemStack seed = GrassSeedsModule.getSeedFromTillingGrass(event.getWorld().field_73012_v);

                        if (!seed.func_190926_b())
                        {
                            EntityItem ei = new EntityItem(world, pos.func_177958_n() + .5, pos.func_177956_o() + .5, pos.func_177952_p() + .5, seed.func_77946_l());
                            ei.field_70181_x = 0.025000000372529D;

                            world.func_72838_d(ei);
                        }
                    }
                    world.func_175656_a(pos, Blocks.field_150346_d.func_176223_P());
                }

                if (Config.hoeToolDamageMultiplier > 1)
                {
                    itemStack.func_77972_a(Config.hoeToolDamageMultiplier - 1, player);
                }
                event.setResult(Result.ALLOW);
            }
            else
            {
                event.setCanceled(true);
            }
        }
    }

    @SideOnly(Side.CLIENT)
    @SubscribeEvent
    public void onRenderGameOverlay(Text event)
    {
        if (Config.addGuiText)
        {
            Minecraft mc = Minecraft.func_71410_x();
            EntityPlayer player = mc.field_71439_g;

            if (!player.field_70128_L && !player.field_71075_bZ.field_75098_d && !mc.field_71474_y.field_74330_P)
            {
                float healthPercent = player.func_110143_aJ() / player.func_110138_aP();

                if (healthPercent <= 0.15F)
                {
                    event.getLeft().add(TextFormatting.RED + I18n.func_74838_a("ui.health.dying") + TextFormatting.RESET);
                }
                else if (healthPercent <= 0.3F)
                {
                    event.getLeft().add(TextFormatting.YELLOW + I18n.func_74838_a("ui.health.injured") + TextFormatting.RESET);
                }
                else if (healthPercent < 0.5F)
                {
                    event.getLeft().add(TextFormatting.WHITE + I18n.func_74838_a("ui.health.hurt") + TextFormatting.RESET);
                }

                if (player.func_71024_bL().func_75116_a() <= 6)
                {
                    event.getRight().add(TextFormatting.RED + I18n.func_74838_a("ui.hunger.starving") + TextFormatting.RESET);
                }
                else if (player.func_71024_bL().func_75116_a() <= 10)
                {
                    event.getRight().add(TextFormatting.YELLOW + I18n.func_74838_a("ui.hunger.hungry") + TextFormatting.RESET);
                }
                else if (player.func_71024_bL().func_75116_a() <= 14)
                {
                    event.getRight().add(TextFormatting.WHITE + I18n.func_74838_a("ui.hunger.peckish") + TextFormatting.RESET);
                }
            }
        }
    }

    @SubscribeEvent
    public void onEntityInteractEvent(EntityInteract event)
    {
        if (Config.milkedTimeout > 0 && event.getEntityPlayer() != null && event.getTarget() != null && event.getTarget() instanceof EntityCow)
        {
            EntityCow cow = (EntityCow) event.getTarget();
            EntityPlayer player = event.getEntityPlayer();
            EnumHand hand = event.getHand();
            ItemStack equipped = player.func_184586_b(hand);

            if (!equipped.func_190926_b() && equipped.func_77973_b() != Items.field_190931_a)
            {
                Item item = equipped.func_77973_b();

                if (item instanceof ItemBucket && FluidStack.loadFluidStackFromNBT(equipped.func_77978_p()) == null || cow instanceof EntityMooshroom && item == Items.field_151054_z)
                {
                    NBTTagCompound tags = cow.getEntityData();

                    if (tags.func_74764_b("Milked"))
                    {
                        event.setCanceled(true);

                        if (!player.field_70170_p.field_72995_K)
                        {
                            cow.func_184185_a(SoundEvents.field_187562_am, 0.4F, (event.getEntity().field_70170_p.field_73012_v.nextFloat() - event.getEntity().field_70170_p.field_73012_v.nextFloat()) * 0.2F + 1.0F);
                        }
                    }
                    else
                    {
                        tags.func_74768_a("Milked", Config.milkedTimeout * 60);
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void onLivingHurtEvent(LivingHurtEvent event)
    {
        if (event.getEntityLiving() instanceof EntityPlayer)
        {
            EntityPlayer player = (EntityPlayer) event.getEntityLiving();

            AppleCoreAPI.mutator.setHealthRegenTickCounter(player, 0);
        }
    }

    @SubscribeEvent
    public void onRightClickBlock(RightClickBlock event)
    {
        if (lastRightClickCrop == event.getWorld().func_82737_E())
        {
            event.setCanceled(true);
        }

        if (Config.foodsUnplantable && Loader.isModLoaded("harvestcraft") && !event.getEntityPlayer().func_184586_b(event.getHand()).func_190926_b() && event.getEntityPlayer().func_184586_b(event.getHand()).func_77973_b() instanceof ItemPamSeedFood)
        {
            if (event.getWorld().field_72995_K)
            {
                if (PamsModsHelper.canPlantSeedFoodAt(event.getEntityPlayer().func_184586_b(event.getHand()), event.getEntityPlayer(), event.getWorld(), event.getPos(), event.getFace()))
                {
                    event.setCanceled(true);
                    return;
                }
            }
            else
            {
                event.setUseItem(Result.DENY);
            }

            return;
        }

        if (!Config.enableRightClickHarvesting)
        {
            return;
        }

        IBlockState clicked_state = event.getWorld().func_180495_p(event.getPos());
        IBlockState real_state = clicked_state.func_177230_c().func_176221_a(clicked_state, event.getWorld(), event.getPos());

        Block clicked_block = clicked_state.func_177230_c();

        IBlockState resultingState = null;

        if (rightClickHarvestBlacklist.contains(clicked_block))
        {
            return;
        }

        if (Loader.isModLoaded("natura") && clicked_block.getClass() == BlockNaturaCotton.class)
        {
            if (real_state.func_177229_b(BlockNaturaCotton.AGE) == 4)
            {
                resultingState = real_state.func_177226_a(BlockNaturaCotton.AGE, 0);
            }
        }
        else if (Loader.isModLoaded("natura") && clicked_block.getClass() == BlockNaturaBarley.class)
        {
            if (real_state.func_177229_b(BlockNaturaBarley.AGE) == 3)
            {
                resultingState = real_state.func_177226_a(BlockNaturaBarley.AGE, 0);
            }
        }
        else if (clicked_block.getClass() == BlockCrops.class || clicked_block.getClass() == BlockCarrot.class || clicked_block.getClass() == BlockPotato.class)
        {
            if (real_state.func_177229_b(BlockCrops.field_176488_a) >= 7)
            {
                resultingState = real_state.func_177226_a(BlockCrops.field_176488_a, 0);
            }
        }
        else if (clicked_block.getClass() == BlockBeetroot.class)
        {
            if (real_state.func_177229_b(BlockBeetroot.field_185531_a) >= 3)
            {
                resultingState = real_state.func_177226_a(BlockBeetroot.field_185531_a, 0);
            }
        }
        //TODO: REMOVE REFLECTION HELPER IN 1.11
        else if (Loader.isModLoaded("harvestcraft") && clicked_block.getClass() == BlockPamCrop.class)
        {
            if (ReflectionModule.pamCropAgeFound && real_state.func_177229_b(ReflectionModule.pamCropAge) >= 3)
            {
                resultingState = real_state.func_177226_a(ReflectionModule.pamCropAge, 0);
            }
        }
        else if (Loader.isModLoaded("harvestcraft") && clicked_block.getClass() == BlockPamFruit.class)
        {
            if (ReflectionModule.pamFruitAgeFound && real_state.func_177229_b(ReflectionModule.pamFruitAge) >= 2)
            {
                resultingState = real_state.func_177226_a(ReflectionModule.pamFruitAge, 0);
            }
        }
        else if (Loader.isModLoaded("harvestcraft") && clicked_block.getClass() == BlockPamFruitLog.class)
        {
            if (ReflectionModule.pamFruitLogAgeFound && real_state.func_177229_b(ReflectionModule.pamFruitLogAge) >= 2)
            {
                resultingState = real_state.func_177226_a(ReflectionModule.pamFruitLogAge, 0);
            }
        }

        if (resultingState != null)
        {
            if (!event.getWorld().field_72995_K && !event.getWorld().restoringBlockSnapshots)
            {
                List<ItemStack> drops = clicked_block.getDrops(event.getWorld(), event.getPos(), clicked_state, 0);

                List<ItemStack> modifiedDrops = BlockHelper.modifyCropDrops(drops, clicked_state, Config.seedsPerHarvestRightClickMin, Config.seedsPerHarvestRightClickMax, Config.producePerHarvestRightClickMin, Config.producePerHarvestRightClickMax);

                for (ItemStack drop : modifiedDrops)
                {
                    Block.func_180635_a(event.getWorld(), event.getPos(), drop);
                }
            }

            event.getWorld().func_180501_a(event.getPos(), resultingState, 2);

            lastRightClickCrop = event.getWorld().func_82737_E();

            if (event.getWorld().field_72995_K)
            {
                ClientHelper.sendRightClickPacket(event.getPos(), event.getFace(), event.getHand(), 0f, 0f, 0f);
                event.setCanceled(true);
            }
            else
            {
                event.setUseItem(Result.DENY);
            }
        }
    }

    @SubscribeEvent
    public void onBlockHarvested(HarvestDropsEvent event)
    {
        //TODO: REMOVE REFLECTION HELPER IN 1.11

        if (!Config.modifyCropDropsBreak)
        {
            return;
        }

        // certain things we don't want to modify the drops of
        if (HungerOverhaulEventHook.harvestDropsBlacklist.contains(event.getState().func_177230_c()))
        {
            return;
        }

        IBlockState state = event.getState();
        Block block = state.func_177230_c();

        boolean isPamCrop = Loader.isModLoaded("harvestcraft") && block.getClass() == BlockPamCrop.class;
        boolean isPamFruit = Loader.isModLoaded("harvestcraft") && block.getClass() == BlockPamFruit.class;
        boolean isPamFruitLog = Loader.isModLoaded("harvestcraft") && block.getClass() == BlockPamFruitLog.class;

        boolean isCottonCrop = Loader.isModLoaded("natura") && block.getClass() == BlockNaturaCotton.class;
        boolean isBarleyCrop = Loader.isModLoaded("natura") && block.getClass() == BlockNaturaBarley.class;

        boolean isBeetrootCrop = block.getClass() == BlockBeetroot.class;

        boolean isVanillaCrop = block.getClass() == BlockCrops.class || block.getClass() == BlockCarrot.class || block.getClass() == BlockPotato.class;

        boolean eligable = isCottonCrop || isBarleyCrop || isVanillaCrop || isBeetrootCrop || isPamCrop || isPamFruit || isPamFruitLog;

        if (!eligable)
        {
            return;
        }

        boolean fullyGrown = (isVanillaCrop && state.func_177229_b(BlockCrops.field_176488_a) >= 7)
                || (isBeetrootCrop && state.func_177229_b(BlockBeetroot.field_185531_a) >= 3)
                || (isCottonCrop && state.func_177229_b(BlockNaturaCotton.AGE) == 4)
                || (isBarleyCrop && state.func_177229_b(BlockNaturaBarley.AGE) == 3)
                || (ReflectionModule.pamCropAgeFound && (isPamCrop && state.func_177229_b(ReflectionModule.pamCropAge) == 3))
                || (ReflectionModule.pamFruitAgeFound && (isPamFruit && state.func_177229_b(ReflectionModule.pamFruitAge) == 2))
                || (ReflectionModule.pamFruitLogAgeFound && (isPamFruitLog && state.func_177229_b(ReflectionModule.pamFruitLogAge) == 2));

        if (!fullyGrown)
        {
            return;
        }

        List<ItemStack> modifiedDrops = BlockHelper.modifyCropDrops(event.getDrops(), state, Config.seedsPerHarvestBreakMin, Config.seedsPerHarvestBreakMax, Config.producePerHarvestBreakMin, Config.producePerHarvestBreakMax);
        event.getDrops().clear();

        for (ItemStack drop : modifiedDrops)
        {
            event.getDrops().add(drop);
        }
    }

    @SubscribeEvent(priority = EventPriority.LOWEST)
    public void renderTooltips(ItemTooltipEvent event)
    {
        if (Config.addFoodTooltips && AppleCoreAPI.accessor.isFood(event.getItemStack()))
        {
            FoodValues values = FoodValues.get(event.getItemStack());
            int hungerFill = values.hunger;
            float satiation = values.saturationModifier * 20 - hungerFill;

            String mealDescriptor = "";
            String noun;
            String adjective = null;

            if (hungerFill <= 1)
            {
                noun = "morsel";
            }
            else if (hungerFill <= 2)
            {
                noun = "snack";
            }
            else if (hungerFill <= 5)
            {
                noun = "lightmeal";
            }
            else if (hungerFill <= 8)
            {
                noun = "meal";
            }
            else if (hungerFill <= 11)
            {
                noun = "largemeal";
            }
            else
            {
                noun = "feast";
            }

            if (satiation >= 3.0F)
            {
                adjective = "hearty";
            }
            else if (satiation >= 2.0F)
            {
                adjective = "wholesome";
            }
            else if (satiation > 0.0F)
            {
                adjective = "nourishing";
            }
            else if (satiation < 0.0F)
            {
                adjective = "unfulfilling";
            }

            if (adjective != null && I18n.func_94522_b("tooltip.meal." + adjective + "_" + noun))
            {
                mealDescriptor = I18n.func_74838_a("tooltip.meal." + adjective + "_" + noun);
            }
            else
            {
                mealDescriptor = I18n.func_74838_a("tooltip.meal." + noun);

                if (adjective != null)
                {
                    mealDescriptor = I18n.func_74837_a(I18n.func_74838_a("tooltip.meal." + adjective), mealDescriptor);
                }
            }

            int topIndex = event.getToolTip().size() > 0 ? 1 : 0;

            event.getToolTip().add(topIndex, mealDescriptor.substring(0, 1).toUpperCase() + mealDescriptor.substring(1));
        }

        if (Config.wrongBiomeRegrowthMultiplier > 1)
        {
            PlantGrowthModification growthModification = null;

            if (event.getItemStack().func_77973_b() instanceof IPlantable)
            {
                growthModification = PlantGrowthModule.getPlantGrowthModification(((IPlantable) event.getItemStack().func_77973_b()).getPlant(event.getEntityPlayer().field_70170_p, BlockPos.field_177992_a).func_177230_c());
            }
            else if (event.getItemStack().func_77973_b() instanceof ItemBlock)
            {
                Block block = Block.func_149634_a(event.getItemStack().func_77973_b());

                if (block != null)
                {
                    growthModification = PlantGrowthModule.getPlantGrowthModification(block);
                }
            }
            else
            {
                if (Loader.isModLoaded("harvestcraft"))
                {
                    Block block = PamsModsHelper.fruitItemToBlockMap.get(event.getItemStack().func_77973_b());

                    if (block != null)
                    {
                        growthModification = PlantGrowthModule.getPlantGrowthModification(block);
                    }
                }
            }

            if (growthModification != null && !growthModification.biomeGrowthModifiers.isEmpty())
            {
                String tooltip = "";

                for (BiomeDictionary.Type biomeType : growthModification.biomeGrowthModifiers.keySet())
                {
                    tooltip += biomeType.toString().substring(0, 1).toUpperCase() + biomeType.toString().substring(1).toLowerCase() + ", ";
                }

                event.getToolTip().add(I18n.func_74838_a("tooltip.meal.crop_grows_best_in"));
                event.getToolTip().add(tooltip.substring(0, tooltip.length() - 2));
            }
        }
    }

    /**
     * returns true if there's water nearby (x-4 to x+4, y to y+1, k-4 to k+4)
     */
    private boolean isWaterNearby(World world, BlockPos pos)
    {
        int i = pos.func_177958_n();
        int j = pos.func_177956_o();
        int k = pos.func_177952_p();
        MutableBlockPos mutableblockpos = new MutableBlockPos();

        for (int l = i - 4; l <= i + 4; ++l)
        {
            for (int i1 = j; i1 <= j + 1; ++i1)
            {
                for (int j1 = k - 4; j1 <= k + 4; ++j1)
                {
                    if (world.func_180495_p(mutableblockpos.func_181079_c(l, i1, j1)).func_185904_a() == Material.field_151586_h)
                    {
                        return true;
                    }
                }
            }
        }

        return false;
    }
}
