/*
 * Decompiled with CFR 0.152.
 */
package iguanaman.hungeroverhaul.module.loot;

import com.google.common.collect.ImmutableSet;
import iguanaman.hungeroverhaul.common.config.Config;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootEntryItem;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.conditions.RandomChance;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraft.world.storage.loot.functions.SetMetadata;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import squeek.applecore.api.food.FoodValues;

public class LootModule {
    private static final Set<String> LOOT_LOCATIONS = ImmutableSet.builder().add((Object)LootTableList.field_186422_d.toString()).add((Object)LootTableList.field_186424_f.toString()).add((Object)LootTableList.field_186429_k.toString()).add((Object)LootTableList.field_186430_l.toString()).build();
    private static final Set<LootPool> lootPools = new HashSet<LootPool>();

    public static void postInit() {
        boolean worthLooping;
        boolean bl = worthLooping = Config.modifyFoodStackSize || Config.addTradesButcher || Config.addHarvestCraftChestLoot || Config.addTradesFarmer || Config.addSaplingTradesFarmer;
        if (worthLooping) {
            for (Object obj : Item.field_150901_e) {
                Item item = (Item)obj;
                if (!(item instanceof ItemFood)) continue;
                ItemStack stack = new ItemStack(item);
                FoodValues values = FoodValues.get((ItemStack)stack);
                if (values.hunger <= 9 || !Config.addHarvestCraftChestLoot) continue;
                LootModule.addChestLoot(item, stack, values);
            }
        }
    }

    @SubscribeEvent
    public void onLootTableLoad(LootTableLoadEvent event) {
        if (LOOT_LOCATIONS.contains(event.getName().toString())) {
            for (LootPool pool : lootPools) {
                event.getTable().addPool(pool);
            }
        }
    }

    public static void addChestLoot(Item item, ItemStack stack, FoodValues values) {
        int maxStackSize = Math.min(Config.chestLootMaxStackSize, item.getItemStackLimit(stack));
        LootCondition[] lootConditions = new LootCondition[]{};
        LootFunction[] setMeta = new LootFunction[]{new SetMetadata(lootConditions, new RandomValueRange((float)stack.func_77960_j()))};
        LootEntryItem entry = new LootEntryItem(stack.func_77973_b(), 1, maxStackSize, setMeta, lootConditions, stack.func_77977_a());
        RandomChance chance = new RandomChance((float)Config.chestLootChance);
        lootPools.add(new LootPool(new LootEntry[]{entry}, new LootCondition[]{chance}, new RandomValueRange(1.0f), new RandomValueRange(0.0f), stack.func_77977_a()));
    }
}

