/*
 * Decompiled with CFR 0.152.
 */
package iguanaman.hungeroverhaul.module.village;

import com.pam.harvestcraft.blocks.growables.BlockPamSapling;
import com.pam.harvestcraft.item.items.ItemPamSeedFood;
import iguanaman.hungeroverhaul.common.config.Config;
import iguanaman.hungeroverhaul.module.village.generation.VillageCustomField;
import iguanaman.hungeroverhaul.module.village.trade.EmeraldForItemstack;
import iguanaman.hungeroverhaul.module.village.trade.ItemstackForEmerald;
import net.minecraft.block.Block;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.gen.structure.MapGenStructureIO;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.VillagerRegistry;
import squeek.applecore.api.food.FoodValues;

public class VillageModule {
    public static void init() {
        if (Config.addCustomVillageField && Config.fieldNormalWeight + Config.fieldReedWeight + Config.fieldStemWeight > 0) {
            VillagerRegistry.instance().registerVillageCreationHandler((VillagerRegistry.IVillageCreationHandler)new VillageCustomField.VillageManager());
            MapGenStructureIO.registerStructureComponent(VillageCustomField.class, (String)"hungeroverhaul:CustomField");
        }
    }

    public static void postInit() {
        boolean worthLooping;
        boolean bl = worthLooping = Config.modifyFoodStackSize || Config.addTradesButcher || Config.addHarvestCraftChestLoot || Config.addTradesFarmer || Config.addSaplingTradesFarmer;
        if (worthLooping) {
            for (Object obj : Item.REGISTRY) {
                Block block;
                Item item = (Item)obj;
                if (item instanceof ItemFood) {
                    ItemStack stack = new ItemStack(item);
                    FoodValues values = FoodValues.get((ItemStack)stack);
                    if (values.hunger > 9 && Config.addTradesButcher) {
                        VillageModule.addButcherTrade(item, stack, values);
                    }
                    if (!Loader.isModLoaded((String)"harvestcraft") || !Config.addTradesFarmer || !(item instanceof ItemPamSeedFood)) continue;
                    VillageModule.addCropTrade(item);
                    continue;
                }
                if (!Loader.isModLoaded((String)"harvestcraft") || !Config.addSaplingTradesFarmer || !(item instanceof ItemBlock) || !((block = Block.getBlockFromItem((Item)item)) instanceof BlockPamSapling)) continue;
                VillageModule.addSaplingTrade(block);
            }
        }
    }

    public static void addButcherTrade(Item item, ItemStack stack, FoodValues values) {
        VillagerRegistry.VillagerProfession butcher = (VillagerRegistry.VillagerProfession)ForgeRegistries.VILLAGER_PROFESSIONS.getValue(new ResourceLocation("minecraft:butcher"));
        VillagerRegistry.VillagerCareer butcher_career = butcher.getCareer(0);
        butcher_career.addTrade(1, new EntityVillager.ITradeList[]{new ItemstackForEmerald(new ItemStack(item, item.getItemStackLimit(stack), 0), null)});
    }

    public static void addSaplingTrade(Block block) {
        VillagerRegistry.VillagerProfession farmer = (VillagerRegistry.VillagerProfession)ForgeRegistries.VILLAGER_PROFESSIONS.getValue(new ResourceLocation("minecraft:farmer"));
        VillagerRegistry.VillagerCareer farmer_career = farmer.getCareer(0);
        farmer_career.addTrade(1, new EntityVillager.ITradeList[]{new ItemstackForEmerald(new ItemStack(block, 1, 0), null)});
    }

    public static void addCropTrade(Item item) {
        VillagerRegistry.VillagerProfession farmer = (VillagerRegistry.VillagerProfession)ForgeRegistries.VILLAGER_PROFESSIONS.getValue(new ResourceLocation("minecraft:farmer"));
        VillagerRegistry.VillagerCareer farmer_career = farmer.getCareer(0);
        farmer_career.addTrade(1, new EntityVillager.ITradeList[]{new EmeraldForItemstack(new ItemStack(item, 1, 0), new EntityVillager.PriceInfo(16, 16))});
    }
}

