package iguanaman.hungeroverhaul.module.natura;

import java.util.Random;

import com.progwml6.natura.Natura;
import com.progwml6.natura.common.block.BlockEnumBerryBush;
import com.progwml6.natura.nether.NaturaNether;
import com.progwml6.natura.nether.block.bush.BlockNetherBerryBush;
import com.progwml6.natura.overworld.NaturaOverworld;
import com.progwml6.natura.overworld.block.bush.BlockOverworldBerryBush;
import com.progwml6.natura.overworld.block.crops.BlockNaturaBarley;
import com.progwml6.natura.overworld.block.crops.BlockNaturaCotton;
import com.progwml6.natura.shared.NaturaCommons;

import iguanaman.hungeroverhaul.common.config.Config;
import iguanaman.hungeroverhaul.module.bonemeal.BonemealModule;
import iguanaman.hungeroverhaul.module.bonemeal.modification.BonemealModification;
import iguanaman.hungeroverhaul.module.food.FoodModifier;
import iguanaman.hungeroverhaul.module.growth.PlantGrowthModule;
import iguanaman.hungeroverhaul.module.growth.modification.PlantGrowthModification;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraftforge.common.BiomeDictionary.Type;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import slimeknights.mantle.util.RecipeRemover;
import squeek.applecore.api.food.FoodValues;

public class NaturaModule
{
    public static Random random = new Random();

    private static Boolean isNaturaOverworldLoaded = Natura.pulseManager.isPulseLoaded(NaturaOverworld.PulseId);

    private static Boolean isNaturaNetherLoaded = Natura.pulseManager.isPulseLoaded(NaturaNether.PulseId);

    public static void init()
    {
        random.setSeed(2 ^ 16 + 2 ^ 8 + (4 * 3 * 271));

        ItemStack barley = NaturaCommons.barley.func_77946_l();
        ItemStack barleySeeds = NaturaOverworld.barley_seeds.func_77946_l();
        ItemStack barleyFlour = NaturaCommons.barleyFlour.func_77946_l();
        ItemStack wheatFlour = NaturaCommons.wheatFlour.func_77946_l();

        if (Config.addSeedsCraftingRecipe && isNaturaOverworldLoaded)
        {
            GameRegistry.addRecipe(new ShapelessOreRecipe(barleySeeds, barley));
        }

        // seed recipe conflicts with the default flour recipe, so remove it
        if (Config.removeNaturaFlourCraftingRecipes || Config.addSeedsCraftingRecipe)
        {
            RecipeRemover.removeAnyRecipe(barleyFlour);
            RecipeRemover.removeAnyRecipe(wheatFlour);
        }

        if (Config.removeNaturaFlourSmeltingRecipe)
        {
            RecipeRemover.removeFurnaceRecipe(barleyFlour);
            RecipeRemover.removeFurnaceRecipe(wheatFlour);
        }

        if (Config.addAlternateNaturaFlourCraftingRecipes)
        {
            GameRegistry.addRecipe(new ShapelessOreRecipe(barleyFlour, barley, barley));
            GameRegistry.addRecipe(new ShapelessOreRecipe(wheatFlour, Items.field_151015_O, Items.field_151015_O));
        }

        /*
         * Food values
         */
        if (Config.modifyFoodValues && Config.useHOFoodValues)
        {
            if (isNaturaOverworldLoaded)
            {
                FoodModifier.setModifiedFoodValues(NaturaCommons.raspberry, new FoodValues(1, 0.1F));
                FoodModifier.setModifiedFoodValues(NaturaCommons.blueberry, new FoodValues(1, 0.1F));
                FoodModifier.setModifiedFoodValues(NaturaCommons.blackberry, new FoodValues(1, 0.1F));
                FoodModifier.setModifiedFoodValues(NaturaCommons.maloberry, new FoodValues(1, 0.1F));
            }

            if (isNaturaNetherLoaded)
            {
                FoodModifier.setModifiedFoodValues(NaturaCommons.blightberry, new FoodValues(1, 0.1F));
                FoodModifier.setModifiedFoodValues(NaturaCommons.duskberry, new FoodValues(1, 0.1F));
                FoodModifier.setModifiedFoodValues(NaturaCommons.skyberry, new FoodValues(1, 0.1F));
                FoodModifier.setModifiedFoodValues(NaturaCommons.stingberry, new FoodValues(1, 0.1F));
            }

            if (isNaturaOverworldLoaded)
            {
                FoodModifier.setModifiedFoodValues(NaturaCommons.berryMedley, new FoodValues(3, 0.15F));
            }
        }

        /*
         * Plant growth
         */
        PlantGrowthModification cottonGrowthModification = new PlantGrowthModification().setNeedsSunlight(true).setGrowthTickProbability(Config.cropRegrowthMultiplier).setBiomeGrowthModifier(Type.FOREST, 1).setBiomeGrowthModifier(Type.PLAINS, 1);
        PlantGrowthModule.registerPlantGrowthModifier(BlockNaturaCotton.class, cottonGrowthModification);

        PlantGrowthModification barleyGrowthModification = new PlantGrowthModification().setNeedsSunlight(true).setGrowthTickProbability(Config.cropRegrowthMultiplier).setBiomeGrowthModifier(Type.FOREST, 1).setBiomeGrowthModifier(Type.PLAINS, 1);
        PlantGrowthModule.registerPlantGrowthModifier(BlockNaturaBarley.class, barleyGrowthModification);

        /*
         * TODO: FIX
         * PlantGrowthModification saguaroGrowthModification = new PlantGrowthModification().setNeedsSunlight(false).setGrowthTickProbability(Config.cactusRegrowthMultiplier).setBiomeGrowthModifier(Type.SANDY, 1);
         * PlantGrowthModule.registerPlantGrowthModifier(SaguaroBlock.class, saguaroGrowthModification);
        */

        PlantGrowthModification berryBushGrowthModification = new PlantGrowthModification().setNeedsSunlight(true).setGrowthTickProbability(Config.cropRegrowthMultiplier).setBiomeGrowthModifier(Type.FOREST, 1).setBiomeGrowthModifier(Type.PLAINS, 1);
        PlantGrowthModule.registerPlantGrowthModifier(BlockOverworldBerryBush.class, berryBushGrowthModification);

        PlantGrowthModification netherBushGrowthModification = new PlantGrowthModification().setNeedsSunlight(false).setGrowthTickProbability(Config.cropRegrowthMultiplier).setBiomeGrowthModifier(Type.NETHER, 1);
        PlantGrowthModule.registerPlantGrowthModifier(BlockNetherBerryBush.class, netherBushGrowthModification);

        /*
         * Bonemeal
         */
        BonemealModification naturaCottonBonemealModification = new BonemealModification()
        {
            @Override
            public IBlockState getNewState(World world, BlockPos pos, IBlockState currentState)
            {
                int currentMeta = currentState.func_177229_b(BlockNaturaCotton.AGE);
                int metaFullyGrown = 4;
                int metaIncrease = 0;

                if (currentMeta != metaFullyGrown)
                {
                    metaIncrease = 1;

                    if (Config.difficultyScalingBoneMeal && world.func_175659_aa().ordinal() < EnumDifficulty.NORMAL.ordinal())
                    {
                        int metaRandomIncreaseRange = currentMeta < 3 ? 2 : 3;
                        metaIncrease += random.nextInt(metaRandomIncreaseRange);
                    }
                }

                return currentState.func_177226_a(BlockNaturaCotton.AGE, Math.min(currentMeta + metaIncrease, metaFullyGrown));
            }
        };
        BonemealModule.registerBonemealModifier(BlockNaturaCotton.class, naturaCottonBonemealModification);

        BonemealModification naturaBarleyBonemealModification = new BonemealModification()
        {
            @Override
            public IBlockState getNewState(World world, BlockPos pos, IBlockState currentState)
            {
                int currentMeta = currentState.func_177229_b(BlockNaturaBarley.AGE);
                int metaFullyGrown = 3;
                int metaIncrease = 0;

                if (currentMeta != metaFullyGrown)
                {
                    metaIncrease = 1;

                    if (Config.difficultyScalingBoneMeal && world.func_175659_aa().ordinal() < EnumDifficulty.NORMAL.ordinal())
                    {
                        int metaRandomIncreaseRange = currentMeta < 3 ? 2 : 3;
                        metaIncrease += random.nextInt(metaRandomIncreaseRange);
                    }
                }

                return currentState.func_177226_a(BlockNaturaBarley.AGE, Math.min(currentMeta + metaIncrease, metaFullyGrown));
            }
        };
        BonemealModule.registerBonemealModifier(BlockNaturaBarley.class, naturaBarleyBonemealModification);

        BonemealModification naturaBushBonemealModification = new BonemealModification()
        {
            @Override
            public IBlockState getNewState(World world, BlockPos pos, IBlockState currentState)
            {
                int currentMeta = currentState.func_177229_b(BlockEnumBerryBush.AGE);

                int resultingMeta = currentMeta;

                if (currentMeta / 4 < 2)
                {
                    if (!(currentState.func_177230_c() instanceof BlockNetherBerryBush) || world.field_73012_v.nextBoolean())
                    {
                        int setMeta = world.field_73012_v.nextInt(2) + 1 + currentMeta / 4;

                        if (setMeta > 2)
                        {
                            setMeta = 2;
                        }
                        if (Config.difficultyScalingBoneMeal && world.func_175659_aa().ordinal() >= EnumDifficulty.NORMAL.ordinal())
                        {
                            setMeta = 1;
                        }

                        resultingMeta = currentMeta % 4 + setMeta * 4;
                    }
                }
                return currentState.func_177226_a(BlockEnumBerryBush.AGE, resultingMeta);
            }

            @Override
            public void onBonemeal(World world, BlockPos pos, IBlockState state, IBlockState resultingState)
            {
                BlockPos posUp = pos.func_177984_a();
                IBlockState stateAbove = world.func_180495_p(posUp);

                if (stateAbove == null || stateAbove.func_177230_c().isAir(stateAbove, world, posUp))
                {
                    int randomRange = state.func_177230_c() instanceof BlockNetherBerryBush ? 6 : 3;

                    if (world.field_73012_v.nextInt(randomRange) == 0)
                    {
                        world.func_180501_a(posUp, state.func_177226_a(BlockEnumBerryBush.AGE, resultingState.func_177229_b(BlockEnumBerryBush.AGE) % 4), 3);
                    }
                }
            }
        };
        BonemealModule.registerBonemealModifier(BlockOverworldBerryBush.class, naturaBushBonemealModification);
        BonemealModule.registerBonemealModifier(BlockNetherBerryBush.class, naturaBushBonemealModification);
    }

}
