/*
 * Decompiled with CFR 0.152.
 */
package mods.natura.blocks.trees;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import mods.natura.common.NaturaTab;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;
import net.minecraft.world.World;

public class DarkTreeBlock
extends Block {
    public Icon[] icons;
    public String[] textureNames = new String[]{"darkwood_bark", "darkwood_heart", "fusewood_bark", "fusewood_heart"};

    public DarkTreeBlock(int id) {
        super(id, Material.field_76245_d);
        this.func_71848_c(3.5f);
        this.func_71894_b(40.0f);
        this.func_71884_a(Block.field_71967_e);
        this.func_71849_a(NaturaTab.tab);
    }

    @SideOnly(value=Side.CLIENT)
    public Icon func_71858_a(int side, int metadata) {
        int tex = metadata % 4 * 2;
        int orientation = metadata / 4;
        switch (orientation) {
            case 0: {
                if (side != 0 && side != 1) break;
                return this.icons[tex + 1];
            }
            case 1: {
                if (side != 4 && side != 5) break;
                return this.icons[tex + 1];
            }
            case 2: {
                if (side != 2 && side != 3) break;
                return this.icons[tex + 1];
            }
        }
        return this.icons[tex];
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94332_a(IconRegister iconRegister) {
        this.icons = new Icon[this.textureNames.length];
        for (int i = 0; i < this.icons.length; ++i) {
            this.icons[i] = iconRegister.func_94245_a("natura:" + this.textureNames[i]);
        }
    }

    public int func_71885_a(int par1, Random par2Random, int par3) {
        return this.field_71990_ca;
    }

    public void func_71852_a(World par1World, int par2, int par3, int par4, int par5, int par6) {
        int b0 = 4;
        int j1 = b0 + 1;
        if (par1World.func_72904_c(par2 - j1, par3 - j1, par4 - j1, par2 + j1, par3 + j1, par4 + j1)) {
            for (int k1 = -b0; k1 <= b0; ++k1) {
                for (int l1 = -b0; l1 <= b0; ++l1) {
                    for (int i2 = -b0; i2 <= b0; ++i2) {
                        int j2 = par1World.func_72798_a(par2 + k1, par3 + l1, par4 + i2);
                        if (Block.field_71973_m[j2] == null) continue;
                        Block.field_71973_m[j2].beginLeavesDecay(par1World, par2 + k1, par3 + l1, par4 + i2);
                    }
                }
            }
        }
    }

    public int func_85104_a(World par1World, int par2, int par3, int par4, int par5, float par6, float par7, float par8, int par9) {
        int j1 = par9 & 3;
        int b0 = 0;
        switch (par5) {
            case 0: 
            case 1: {
                b0 = 0;
                break;
            }
            case 2: 
            case 3: {
                b0 = 8;
                break;
            }
            case 4: 
            case 5: {
                b0 = 4;
            }
        }
        return j1 | b0;
    }

    public int func_71899_b(int par1) {
        return par1 & 3;
    }

    public static int limitToValidMetadata(int par0) {
        return par0 & 3;
    }

    protected ItemStack func_71880_c_(int par1) {
        return new ItemStack(this.field_71990_ca, 1, DarkTreeBlock.limitToValidMetadata(par1));
    }

    public boolean isBlockReplaceable(World world, int x, int y, int z) {
        return false;
    }

    public void func_71846_a(World world, int x, int y, int z, int meta, EntityPlayer player) {
        if (meta % 4 == 1) {
            if (world.field_73013_u > 2) {
                world.func_72876_a(null, (double)x, (double)y, (double)z, 1.75f, false);
            } else {
                world.func_72876_a(null, (double)x, (double)y, (double)z, 2.0f, false);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_71879_a(int par1, CreativeTabs par2CreativeTabs, List par3List) {
        for (int i = 0; i < this.icons.length / 2; ++i) {
            par3List.add(new ItemStack(par1, 1, i));
        }
    }

    public boolean canSustainLeaves(World world, int x, int y, int z) {
        return true;
    }

    public boolean isWood(World world, int x, int y, int z) {
        return true;
    }
}

