/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.library.armor;

import ic2.api.item.IBoxable;
import ic2.api.item.ICustomElectricItem;
import net.minecraft.block.BlockDispenser;
import net.minecraft.dispenser.IBehaviorDispenseItem;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumArmorMaterial;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraftforge.common.ISpecialArmor;
import tconstruct.library.armor.BehaviorDispenseArmorCopy;
import tconstruct.library.armor.EnumArmorPart;

public abstract class ArmorCore
extends ItemArmor
implements ICustomElectricItem,
IBoxable,
ISpecialArmor {
    public static final String SET_NAME = "InfiArmor";
    public final EnumArmorPart armorPart;
    private static final IBehaviorDispenseItem dispenserBehavior = new BehaviorDispenseArmorCopy();
    public final int baseProtection;

    public ArmorCore(int par1, int baseProtection, EnumArmorPart part) {
        super(par1, EnumArmorMaterial.CHAIN, 0, 0);
        this.field_77777_bU = 1;
        this.func_77656_e(100);
        this.func_77655_b(SET_NAME);
        this.armorPart = part;
        this.baseProtection = baseProtection;
        BlockDispenser.field_82527_a.func_82595_a((Object)this, (Object)dispenserBehavior);
    }

    public String getArmorName() {
        return this.getClass().getSimpleName();
    }

    public ItemStack func_77659_a(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer) {
        int i = EntityLiving.func_82159_b((ItemStack)par1ItemStack) - 1;
        ItemStack itemstack1 = par3EntityPlayer.func_82169_q(i);
        if (itemstack1 == null) {
            par3EntityPlayer.func_70062_b(i + 1, par1ItemStack.func_77946_l());
            par1ItemStack.field_77994_a = 0;
        }
        return par1ItemStack;
    }

    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, ItemStack armor, DamageSource source, double damage, int slot) {
        NBTTagCompound tags = armor.func_77978_p();
        if (tags == null) {
            return new ISpecialArmor.ArmorProperties(0, damage / (double)this.baseProtection, this.baseProtection);
        }
        NBTTagCompound data = tags.func_74775_l(SET_NAME);
        return new ISpecialArmor.ArmorProperties(0, (double)data.func_74762_e("damageReduction") / damage, data.func_74762_e("maxAbsorb"));
    }

    public int getArmorDisplay(EntityPlayer player, ItemStack armor, int slot) {
        return armor.func_77978_p() != null && armor.func_77978_p().func_74775_l(SET_NAME) != null ? armor.func_77978_p().func_74775_l(SET_NAME).func_74762_e("maxAbsorb") : this.baseProtection;
    }

    public void damageArmor(EntityLivingBase entity, ItemStack stack, DamageSource source, int damage, int slot) {
        NBTTagCompound data;
        NBTTagCompound tags = stack.func_77978_p();
        if (tags == null) {
            tags = new NBTTagCompound();
            stack.func_77982_d(tags);
            data = new NBTTagCompound();
            tags.func_74766_a(SET_NAME, data);
            data.func_74768_a("damageReduction", this.baseProtection);
            data.func_74768_a("maxAbsorb", this.baseProtection);
        }
        data = tags.func_74775_l(SET_NAME);
        if (tags.func_74764_b("charge")) {
            int charge = tags.func_74762_e("charge");
            if (charge > damage) {
                tags.func_74768_a("charge", charge -= damage);
                return;
            }
            tags.func_74768_a("charge", 0);
            int dmg = data.func_74762_e("Damage");
            data.func_74768_a("Damage", dmg += (damage -= charge));
        } else {
            int dmg = data.func_74762_e("Damage");
            data.func_74768_a("Damage", dmg += damage);
        }
    }

    @Override
    public boolean canBeStoredInToolbox(ItemStack stack) {
        return true;
    }

    @Override
    public boolean canProvideEnergy(ItemStack stack) {
        NBTTagCompound tags = stack.func_77978_p();
        return tags.func_74764_b("charge");
    }

    @Override
    public int getChargedItemId(ItemStack stack) {
        return this.field_77779_bT;
    }

    @Override
    public int getEmptyItemId(ItemStack stack) {
        return this.field_77779_bT;
    }

    @Override
    public int getMaxCharge(ItemStack stack) {
        NBTTagCompound tags = stack.func_77978_p();
        return tags.func_74764_b("charge") ? 10000 : 0;
    }

    @Override
    public int getTier(ItemStack stack) {
        return 0;
    }

    @Override
    public int getTransferLimit(ItemStack stack) {
        NBTTagCompound tags = stack.func_77978_p();
        return tags.func_74764_b("charge") ? 32 : 0;
    }

    @Override
    public int charge(ItemStack stack, int amount, int tier, boolean ignoreTransferLimit, boolean simulate) {
        NBTTagCompound tags = stack.func_77978_p();
        if (!tags.func_74764_b("charge")) {
            return 0;
        }
        if (amount > 0) {
            if (amount > this.getTransferLimit(stack) && !ignoreTransferLimit) {
                amount = this.getTransferLimit(stack);
            }
            int charge = tags.func_74762_e("charge");
            if (amount > this.getMaxCharge(stack)) {
                amount = this.getMaxCharge(stack);
            }
            charge += amount;
            if (!simulate) {
                tags.func_74768_a("charge", charge);
                stack.func_77964_b(1 + (this.getMaxCharge(stack) - charge) * (stack.func_77958_k() - 2) / this.getMaxCharge(stack));
            }
            return amount;
        }
        return 0;
    }

    @Override
    public int discharge(ItemStack stack, int amount, int tier, boolean ignoreTransferLimit, boolean simulate) {
        NBTTagCompound tags = stack.func_77978_p();
        if (!tags.func_74764_b("charge")) {
            return 0;
        }
        if (amount > 0) {
            int charge;
            if (amount > this.getTransferLimit(stack)) {
                amount = this.getTransferLimit(stack);
            }
            if (amount > (charge = tags.func_74762_e("charge"))) {
                amount = charge;
            }
            charge -= amount;
            if (!simulate) {
                tags.func_74768_a("charge", charge);
                stack.func_77964_b(1 + (this.getMaxCharge(stack) - charge) * (stack.func_77958_k() - 1) / this.getMaxCharge(stack));
            }
            return charge;
        }
        return 0;
    }

    @Override
    public boolean canUse(ItemStack stack, int amount) {
        return false;
    }

    @Override
    public boolean canShowChargeToolTip(ItemStack stack) {
        return false;
    }

    public boolean func_77616_k(ItemStack par1ItemStack) {
        return false;
    }

    public boolean func_82789_a(ItemStack par1ItemStack, ItemStack par2ItemStack) {
        return false;
    }

    public boolean isRepairable() {
        return false;
    }

    public int func_77619_b() {
        return 0;
    }

    public boolean func_77662_d() {
        return true;
    }

    public boolean isValidArmor(ItemStack stack, int armorType, Entity entity) {
        return this.armorPart.getPartId() == armorType;
    }

    public int getItemMaxDamageFromStack(ItemStack stack) {
        int charge;
        NBTTagCompound tags = stack.func_77978_p();
        if (tags == null) {
            return 0;
        }
        if (tags.func_74764_b("charge") && (charge = tags.func_74762_e("charge")) > 0) {
            return this.getMaxCharge(stack);
        }
        return tags.func_74775_l(SET_NAME).func_74762_e("TotalDurability");
    }

    public int getItemMaxDamageFromStackForDisplay(ItemStack stack) {
        int charge;
        NBTTagCompound tags = stack.func_77978_p();
        if (tags == null) {
            return 0;
        }
        if (tags.func_74764_b("charge") && (charge = tags.func_74762_e("charge")) > 0) {
            return this.getMaxCharge(stack) - charge;
        }
        return tags.func_74775_l(SET_NAME).func_74762_e("Damage");
    }
}

