/*
 * Decompiled with CFR 0.152.
 */
package mods.natura.blocks.trees;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import mods.natura.common.NContent;
import mods.natura.common.NaturaTab;
import mods.natura.common.PHNatura;
import mods.natura.worldgen.BloodTreeLargeGen;
import mods.natura.worldgen.BushTreeGen;
import mods.natura.worldgen.DarkwoodGen;
import mods.natura.worldgen.EucalyptusTreeGenShort;
import mods.natura.worldgen.FusewoodGen;
import mods.natura.worldgen.RedwoodTreeGen;
import mods.natura.worldgen.SakuraTreeGen;
import mods.natura.worldgen.WhiteTreeGen;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSapling;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.IPlantable;

public class NSaplingBlock
extends BlockSapling {
    public Icon[] icons;
    public String[] textureNames = new String[]{"redwood", "eucalyptus", "hopseed", "sakura", "ghostwood", "bloodwood", "darkwood", "fusewood"};

    public NSaplingBlock(int id) {
        super(id);
        float f = 0.4f;
        this.func_71905_a(0.5f - f, 0.0f, 0.5f - f, 0.5f + f, f * 2.0f, 0.5f + f);
        this.func_71848_c(0.0f);
        this.func_71884_a(Block.field_71965_g);
        this.func_71849_a(NaturaTab.tab);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94332_a(IconRegister iconRegister) {
        this.icons = new Icon[this.textureNames.length];
        for (int i = 0; i < this.icons.length; ++i) {
            this.icons[i] = iconRegister.func_94245_a("natura:" + this.textureNames[i] + "_sapling");
        }
    }

    public boolean func_71930_b(World world, int x, int y, int z) {
        int blockID = world.func_72798_a(x, y, z);
        Block block = Block.field_71973_m[blockID];
        if (block == null || block.isBlockReplaceable(world, x, y, z)) {
            int lowerID = world.func_72798_a(x, y - 1, z);
            if (!this.func_72263_d_(lowerID)) {
                int upperID = world.func_72798_a(x, y + 1, z);
                return this.func_72263_d_(upperID);
            }
            return true;
        }
        return false;
    }

    public boolean func_72263_d_(int id) {
        return id == Block.field_71980_u.field_71990_ca || id == Block.field_71979_v.field_71990_ca || id == Block.field_72013_bc.field_71990_ca || id == Block.field_72012_bb.field_71990_ca || id == NContent.taintedSoil.field_71990_ca;
    }

    public boolean func_71854_d(World world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z) % 8;
        switch (meta) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                int blockID = world.func_72798_a(x, y - 1, z);
                Block soil = field_71973_m[blockID];
                return (world.func_72883_k(x, y, z) >= 8 || world.func_72937_j(x, y, z)) && soil != null && soil.canSustainPlant(world, x, y - 1, z, ForgeDirection.UP, (IPlantable)this);
            }
            case 4: 
            case 6: 
            case 7: {
                int belowID = world.func_72798_a(x, y - 1, z);
                Block netherSoil = field_71973_m[belowID];
                return netherSoil != null && (netherSoil == Block.field_72012_bb || netherSoil.canSustainPlant(world, x, y - 1, z, ForgeDirection.UP, (IPlantable)this));
            }
            case 5: {
                int aboveID = world.func_72798_a(x, y + 1, z);
                Block nSoil = field_71973_m[aboveID];
                return nSoil != null && (nSoil == Block.field_72012_bb || nSoil == Block.field_72013_bc || nSoil == NContent.taintedSoil);
            }
        }
        return true;
    }

    public EnumPlantType getPlantType(World world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z) % 8;
        if (meta <= 3) {
            return EnumPlantType.Plains;
        }
        return EnumPlantType.Nether;
    }

    public void func_71847_b(World world, int x, int y, int z, Random random) {
        if (world.field_72995_K) {
            return;
        }
        super.func_71847_b(world, x, y, z, random);
        int md = world.func_72805_g(x, y, z);
        if (md % 8 == 0) {
            if (world.func_72957_l(x, y + 1, z) >= 9 && random.nextInt(120) == 0) {
                if ((md & 8) == 0) {
                    world.func_72921_c(x, y, z, md | 8, 4);
                } else {
                    int zee;
                    int ecks;
                    int zPos;
                    int xPos;
                    int numSaplings = 0;
                    for (xPos = -3; xPos <= 3; ++xPos) {
                        for (zPos = -3; zPos <= 3; ++zPos) {
                            ecks = x + xPos;
                            zee = z + zPos;
                            if (world.func_72798_a(x + xPos, y, z + zPos) != this.field_71990_ca || world.func_72805_g(x + xPos, y, z + zPos) % 8 != 0) continue;
                            ++numSaplings;
                        }
                    }
                    if (numSaplings >= 40) {
                        for (xPos = -4; xPos <= 4; ++xPos) {
                            for (zPos = -4; zPos <= 4; ++zPos) {
                                ecks = x + xPos;
                                zee = z + zPos;
                                if (world.func_72798_a(ecks, y, zee) != this.field_71990_ca || world.func_72805_g(ecks, y, zee) % 8 != 0) continue;
                                world.func_72832_d(ecks, y, zee, 0, 0, 4);
                            }
                        }
                        this.func_72269_c(world, x, y, z, random);
                    }
                }
            }
        } else if (md % 8 <= 3) {
            if (random.nextInt(10) == 0 && world.func_72957_l(x, y + 1, z) >= 9) {
                if ((md & 8) == 0) {
                    world.func_72921_c(x, y, z, md | 8, 4);
                } else {
                    this.func_72269_c(world, x, y, z, random);
                }
            }
        } else if (random.nextInt(10) == 0) {
            if ((md & 8) == 0) {
                world.func_72921_c(x, y, z, md | 8, 4);
            } else {
                this.func_72269_c(world, x, y, z, random);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public Icon func_71858_a(int side, int meta) {
        return this.icons[meta % 8];
    }

    public void func_96477_c(World world, int x, int y, int z, Random random) {
        this.boneFertilize(world, x, y, z, random);
    }

    public boolean boneFertilize(World world, int x, int y, int z, Random random) {
        int meta = world.func_72805_g(x, y, z);
        if (meta % 8 == 0) {
            return false;
        }
        if ((meta & 8) == 0) {
            world.func_72921_c(x, y, z, meta | 8, 4);
        } else {
            this.func_72269_c(world, x, y, z, random);
        }
        return true;
    }

    public void func_72269_c(World world, int x, int y, int z, Random random) {
        int md = world.func_72805_g(x, y, z) % 8;
        world.func_94575_c(x, y, z, 0);
        WorldGenerator obj = null;
        obj = md == 1 ? new EucalyptusTreeGenShort(0, 1) : (md == 2 ? new BushTreeGen(true, 2, 3, 2) : (md == 3 ? new SakuraTreeGen(true, 1, 0) : (md == 4 ? new WhiteTreeGen(true, 2, 1) : (md == 5 ? new BloodTreeLargeGen(3, 2) : (md == 6 ? new DarkwoodGen(true, 3, 0) : (md == 7 ? new FusewoodGen(true, 3, 1) : new RedwoodTreeGen(true, PHNatura.redwoodID)))))));
        if (!obj.func_76484_a(world, random, x, y, z)) {
            world.func_72832_d(x, y, z, this.field_71990_ca, md + 8, 3);
        }
    }

    public int func_71899_b(int i) {
        return i % 8;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_71879_a(int par1, CreativeTabs par2CreativeTabs, List par3List) {
        for (int i = 0; i < 8; ++i) {
            par3List.add(new ItemStack(par1, 1, i));
        }
    }
}

