/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.library.tools;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import tconstruct.library.tools.ToolCore;

public abstract class Weapon
extends ToolCore {
    public static Material[] web = new Material[]{Material.web};
    public static Material[] none = new Material[0];

    public Weapon(int itemID, int baseDamage) {
        super(itemID, baseDamage);
    }

    protected float baseSpeed() {
        return 1.5f;
    }

    protected float effectiveSpeed() {
        return 15.0f;
    }

    @Override
    public float getStrVsBlock(ItemStack stack, Block block, int meta) {
        if (stack.getTagCompound().getCompoundTag("InfiTool").getBoolean("Broken")) {
            return 0.1f;
        }
        for (int i = 0; i < web.length; ++i) {
            if (web[i] != block.blockMaterial) continue;
            return this.effectiveSpeed();
        }
        return this.baseSpeed();
    }

    public EnumAction getItemUseAction(ItemStack par1ItemStack) {
        return EnumAction.block;
    }

    public int getMaxItemUseDuration(ItemStack par1ItemStack) {
        return 72000;
    }

    public ItemStack onItemRightClick(ItemStack stack, World world, EntityPlayer player) {
        player.setItemInUse(stack, this.getMaxItemUseDuration(stack));
        return stack;
    }

    @Override
    public boolean onItemUse(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float clickX, float clickY, float clickZ) {
        return false;
    }

    public boolean canHarvestBlock(Block block) {
        for (int i = 0; i < web.length; ++i) {
            if (block.blockMaterial != web[i]) continue;
            return true;
        }
        return super.canHarvestBlock(block);
    }

    protected Material[] getEffectiveMaterials() {
        return web;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onUpdate(ItemStack stack, World world, Entity entity, int par4, boolean par5) {
        EntityPlayerSP player;
        ItemStack usingItem;
        super.onUpdate(stack, world, entity, par4, par5);
        if (entity instanceof EntityPlayerSP && (usingItem = (player = (EntityPlayerSP)entity).getItemInUse()) != null && usingItem.getItem() == this) {
            player.movementInput.moveForward *= 2.5f;
            player.movementInput.moveStrafe *= 2.5f;
        }
    }

    @Override
    public String[] toolCategories() {
        return new String[]{"weapon", "melee"};
    }
}

