/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.library.blocks;

import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import tconstruct.library.blocks.InventoryLogic;

public abstract class ExpandableInventoryLogic
extends InventoryLogic
implements IInventory {
    protected ArrayList<ItemStack> inventory = new ArrayList();
    protected String invName;

    public ExpandableInventoryLogic() {
        super(0);
    }

    @Override
    public ItemStack func_70301_a(int slot) {
        return slot < this.inventory.size() ? this.inventory.get(slot) : null;
    }

    @Override
    public boolean isStackInSlot(int slot) {
        return slot < this.inventory.size() && this.inventory.get(slot) != null;
    }

    @Override
    public int func_70302_i_() {
        return this.inventory.size();
    }

    public int getMaxSize() {
        return 64;
    }

    @Override
    public int func_70297_j_() {
        return 64;
    }

    @Override
    public boolean canDropInventorySlot(int slot) {
        return true;
    }

    @Override
    public void func_70299_a(int slot, ItemStack itemstack) {
        if (slot < this.inventory.size()) {
            this.inventory.set(slot, itemstack);
        } else if (slot == this.inventory.size()) {
            this.inventory.add(itemstack);
        } else if (slot < this.getMaxSize()) {
            this.inventory.ensureCapacity(slot);
            this.inventory.set(slot, itemstack);
        } else {
            return;
        }
        if (itemstack != null && itemstack.field_77994_a > this.func_70297_j_()) {
            itemstack.field_77994_a = this.func_70297_j_();
        }
    }

    @Override
    public ItemStack func_70298_a(int slot, int quantity) {
        if (slot < this.inventory.size() && this.inventory.get(slot) != null) {
            if (this.inventory.get((int)slot).field_77994_a <= quantity) {
                ItemStack stack = this.inventory.get(slot);
                this.inventory.set(slot, null);
                return stack;
            }
            ItemStack split = this.inventory.get(slot).func_77979_a(quantity);
            if (this.inventory.get((int)slot).field_77994_a == 0) {
                this.inventory.set(slot, null);
            }
            return split;
        }
        return null;
    }

    @Override
    public boolean func_70300_a(EntityPlayer entityplayer) {
        if (this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m, this.field_70327_n) != this) {
            return false;
        }
        return entityplayer.getDistance((double)this.field_70329_l + 0.5, (double)this.field_70330_m + 0.5, (double)this.field_70327_n + 0.5) <= 64.0;
    }

    @Override
    public abstract Container getGuiContainer(InventoryPlayer var1, World var2, int var3, int var4, int var5);

    @Override
    public void func_70307_a(NBTTagCompound tags) {
        super.func_70307_a(tags);
        this.invName = tags.func_74779_i("InvName");
        NBTTagList nbttaglist = tags.func_74761_m("Items");
        this.inventory = new ArrayList();
        this.inventory.ensureCapacity(nbttaglist.func_74745_c() > this.getMaxSize() ? this.getMaxSize() : nbttaglist.func_74745_c());
        for (int iter = 0; iter < nbttaglist.func_74745_c(); ++iter) {
            NBTTagCompound tagList = (NBTTagCompound)nbttaglist.func_74743_b(iter);
            byte slotID = tagList.func_74771_c("Slot");
            if (slotID < 0 || slotID >= this.inventory.size()) continue;
            this.inventory.set(slotID, ItemStack.func_77949_a((NBTTagCompound)tagList));
        }
    }

    @Override
    public void func_70310_b(NBTTagCompound tags) {
        super.func_70310_b(tags);
        if (this.invName != null) {
            tags.func_74778_a("InvName", this.invName);
        }
        NBTTagList nbttaglist = new NBTTagList();
        for (int iter = 0; iter < this.inventory.size(); ++iter) {
            if (this.inventory.get(iter) == null) continue;
            NBTTagCompound tagList = new NBTTagCompound();
            tagList.func_74774_a("Slot", (byte)iter);
            this.inventory.get(iter).func_77955_b(tagList);
            nbttaglist.func_74742_a((NBTBase)tagList);
        }
        tags.func_74782_a("Items", (NBTBase)nbttaglist);
    }

    @Override
    public ItemStack func_70304_b(int slot) {
        return null;
    }

    @Override
    public void func_70295_k_() {
    }

    @Override
    public void func_70305_f() {
    }

    @Override
    protected abstract String getDefaultName();

    @Override
    public void setInvName(String name) {
        this.invName = name;
    }

    @Override
    public String func_70303_b() {
        return this.func_94042_c() ? this.invName : this.getDefaultName();
    }

    @Override
    public boolean func_94042_c() {
        return this.invName != null && this.invName.length() > 0;
    }

    public void cleanInventory() {
        Iterator<ItemStack> i1 = this.inventory.iterator();
        while (i1.hasNext()) {
            if (i1.next() != null) continue;
            i1.remove();
        }
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack itemstack) {
        if (slot < this.func_70302_i_()) {
            return this.inventory.get(slot) == null || itemstack.field_77994_a + this.inventory.get((int)slot).field_77994_a <= this.func_70297_j_();
        }
        return slot < this.getMaxSize();
    }
}

