/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.library.blocks;

import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public abstract class InventoryLogic
extends TileEntity
implements IInventory {
    protected ItemStack[] inventory;
    protected String invName;

    public InventoryLogic(int invSize) {
        this.inventory = new ItemStack[invSize];
    }

    public ItemStack func_70301_a(int slot) {
        return this.inventory[slot];
    }

    public boolean isStackInSlot(int slot) {
        return this.inventory[slot] != null;
    }

    public int func_70302_i_() {
        return this.inventory.length;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean canDropInventorySlot(int slot) {
        return true;
    }

    public void func_70299_a(int slot, ItemStack itemstack) {
        this.inventory[slot] = itemstack;
        if (itemstack != null && itemstack.field_77994_a > this.func_70297_j_()) {
            itemstack.field_77994_a = this.func_70297_j_();
        }
    }

    public ItemStack func_70298_a(int slot, int quantity) {
        if (this.inventory[slot] != null) {
            if (this.inventory[slot].field_77994_a <= quantity) {
                ItemStack stack = this.inventory[slot];
                this.inventory[slot] = null;
                return stack;
            }
            ItemStack split = this.inventory[slot].func_77979_a(quantity);
            if (this.inventory[slot].field_77994_a == 0) {
                this.inventory[slot] = null;
            }
            return split;
        }
        return null;
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        if (this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m, this.field_70327_n) != this) {
            return false;
        }
        return entityplayer.getDistance((double)this.field_70329_l + 0.5, (double)this.field_70330_m + 0.5, (double)this.field_70327_n + 0.5) <= 64.0;
    }

    public abstract Container getGuiContainer(InventoryPlayer var1, World var2, int var3, int var4, int var5);

    public void func_70307_a(NBTTagCompound tags) {
        super.func_70307_a(tags);
        this.readInventoryFromNBT(tags);
    }

    public void readInventoryFromNBT(NBTTagCompound tags) {
        super.func_70307_a(tags);
        this.invName = tags.func_74779_i("InvName");
        NBTTagList nbttaglist = tags.func_74761_m("Items");
        this.inventory = new ItemStack[this.func_70302_i_()];
        for (int iter = 0; iter < nbttaglist.func_74745_c(); ++iter) {
            NBTTagCompound tagList = (NBTTagCompound)nbttaglist.func_74743_b(iter);
            byte slotID = tagList.func_74771_c("Slot");
            if (slotID < 0 || slotID >= this.inventory.length) continue;
            this.inventory[slotID] = ItemStack.func_77949_a((NBTTagCompound)tagList);
        }
    }

    public void func_70310_b(NBTTagCompound tags) {
        super.func_70310_b(tags);
        this.writeInventoryToNBT(tags);
    }

    public void writeInventoryToNBT(NBTTagCompound tags) {
        if (this.invName != null) {
            tags.func_74778_a("InvName", this.invName);
        }
        NBTTagList nbttaglist = new NBTTagList();
        for (int iter = 0; iter < this.inventory.length; ++iter) {
            if (this.inventory[iter] == null) continue;
            NBTTagCompound tagList = new NBTTagCompound();
            tagList.func_74774_a("Slot", (byte)iter);
            this.inventory[iter].func_77955_b(tagList);
            nbttaglist.func_74742_a((NBTBase)tagList);
        }
        tags.func_74782_a("Items", (NBTBase)nbttaglist);
    }

    public void superReadFromNBT(NBTTagCompound tags) {
        super.func_70307_a(tags);
    }

    public void superWriteToNBT(NBTTagCompound tags) {
        super.func_70310_b(tags);
    }

    public ItemStack func_70304_b(int slot) {
        return null;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    protected abstract String getDefaultName();

    public void setInvName(String name) {
        this.invName = name;
    }

    public String func_70303_b() {
        return this.func_94042_c() ? this.invName : this.getDefaultName();
    }

    public boolean func_94042_c() {
        return this.invName != null && this.invName.length() > 0;
    }

    public boolean func_94041_b(int slot, ItemStack itemstack) {
        return slot < this.func_70302_i_() && (this.inventory[slot] == null || itemstack.field_77994_a + this.inventory[slot].field_77994_a <= this.func_70297_j_());
    }

    public void placeBlock(EntityLivingBase entity, ItemStack stack) {
    }

    public void removeBlock() {
    }
}

