/*
 * Decompiled with CFR 0.152.
 */
package mods.natura.blocks.trees;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import mods.natura.common.NContent;
import mods.natura.common.NaturaTab;
import mods.natura.worldgen.RareTreeGen;
import mods.natura.worldgen.WillowGen;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSapling;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.IPlantable;

public class OverworldSapling
extends BlockSapling {
    public Icon[] icons;
    public String[] textureNames = new String[]{"maple", "silverbell", "purpleheart", "tiger", "willow"};

    public OverworldSapling(int id) {
        super(id);
        float f = 0.4f;
        this.setBlockBounds(0.5f - f, 0.0f, 0.5f - f, 0.5f + f, f * 2.0f, 0.5f + f);
        this.setHardness(0.0f);
        this.setStepSound(Block.field_71965_g);
        this.setCreativeTab(NaturaTab.tab);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94332_a(IconRegister iconRegister) {
        this.icons = new Icon[this.textureNames.length];
        for (int i = 0; i < this.icons.length; ++i) {
            this.icons[i] = iconRegister.func_94245_a("natura:" + this.textureNames[i] + "_sapling");
        }
    }

    public boolean canPlaceBlockAt(World world, int x, int y, int z) {
        int blockID = world.func_72798_a(x, y, z);
        return blockID == 0 || OverworldSapling.blocksList[blockID].field_72018_cp.func_76222_j();
    }

    public boolean canThisPlantGrowOnThisBlockID(int id) {
        return id == Block.field_71980_u.blockID || id == Block.field_71979_v.field_71990_ca || id == Block.field_72013_bc.field_71990_ca || id == Block.field_72012_bb.field_71990_ca || id == NContent.taintedSoil.field_71990_ca;
    }

    public boolean canBlockStay(World world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z) % 8;
        switch (meta) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                int blockID = world.func_72798_a(x, y - 1, z);
                Block soil = blocksList[blockID];
                return (world.func_72883_k(x, y, z) >= 8 || world.func_72937_j(x, y, z)) && soil != null && soil.canSustainPlant(world, x, y - 1, z, ForgeDirection.UP, (IPlantable)this);
            }
        }
        return true;
    }

    public EnumPlantType getPlantType(World world, int x, int y, int z) {
        return EnumPlantType.Plains;
    }

    public void func_71847_b(World world, int x, int y, int z, Random random) {
        if (world.field_72995_K) {
            return;
        }
        super.func_71847_b(world, x, y, z, random);
        int md = world.func_72805_g(x, y, z);
        if (world.func_72957_l(x, y + 1, z) >= 9 && random.nextInt(120) == 0) {
            if ((md & 8) == 0) {
                world.func_72921_c(x, y, z, md | 8, 4);
            } else {
                this.func_72269_c(world, x, y, z, random);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public Icon func_71858_a(int side, int meta) {
        return this.icons[meta % 8];
    }

    public void func_96477_c(World world, int x, int y, int z, Random random) {
        this.boneFertilize(world, x, y, z, random);
    }

    public boolean boneFertilize(World world, int x, int y, int z, Random random) {
        int meta = world.func_72805_g(x, y, z);
        if ((meta & 8) == 0) {
            world.func_72921_c(x, y, z, meta | 8, 4);
        } else {
            this.func_72269_c(world, x, y, z, random);
        }
        return true;
    }

    public void func_72269_c(World world, int x, int y, int z, Random random) {
        int md = world.func_72805_g(x, y, z) % 8;
        world.func_94575_c(x, y, z, 0);
        WorldGenerator obj = null;
        obj = md == 1 ? new RareTreeGen(true, 4, 2, 1, 1) : (md == 2 ? new RareTreeGen(true, 9, 8, 2, 2) : (md == 3 ? new RareTreeGen(true, 6, 4, 3, 3) : (md == 4 ? new WillowGen(true) : new RareTreeGen(true, 4, 2, 0, 0))));
        if (!obj.func_76484_a(world, random, x, y, z)) {
            world.func_72832_d(x, y, z, this.blockID, md + 8, 3);
        }
    }

    public int func_71899_b(int i) {
        return i % 8;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_71879_a(int id, CreativeTabs tab, List list) {
        for (int iter = 0; iter < this.icons.length; ++iter) {
            list.add(new ItemStack(id, 1, iter));
        }
    }
}

