/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.library.blocks;

import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import tconstruct.library.blocks.InventoryLogic;
import tconstruct.library.util.IFacingLogic;

public abstract class AdaptiveInventoryLogic
extends InventoryLogic
implements IFacingLogic {
    Random random = new Random();
    protected int inventorySize;

    public AdaptiveInventoryLogic() {
        super(0);
    }

    protected void adjustInventory(int size, boolean forceAdjust) {
        if (size != this.inventorySize || forceAdjust) {
            this.inventorySize = size;
            ItemStack[] tempInv = this.inventory;
            this.inventory = new ItemStack[size];
            int invLength = tempInv.length > this.inventory.length ? this.inventory.length : tempInv.length;
            System.arraycopy(tempInv, 0, this.inventory, 0, invLength);
            if (tempInv.length > this.inventory.length) {
                for (int i = this.inventory.length; i < tempInv.length; ++i) {
                    ItemStack stack = tempInv[i];
                    if (stack == null) continue;
                    float jumpX = this.random.nextFloat() * 0.8f + 0.1f;
                    float jumpY = this.random.nextFloat() * 0.8f + 0.1f;
                    float jumpZ = this.random.nextFloat() * 0.8f + 0.1f;
                    int offsetX = 0;
                    int offsetY = 0;
                    int offsetZ = 0;
                    switch (this.getTossDirection()) {
                        case 0: {
                            --offsetY;
                            break;
                        }
                        case 1: {
                            ++offsetY;
                            break;
                        }
                        case 2: {
                            --offsetZ;
                            break;
                        }
                        case 3: {
                            ++offsetZ;
                            break;
                        }
                        case 4: {
                            --offsetX;
                            break;
                        }
                        case 5: {
                            ++offsetX;
                        }
                    }
                    while (stack.field_77994_a > 0) {
                        int itemSize = this.random.nextInt(21) + 10;
                        if (itemSize > stack.field_77994_a) {
                            itemSize = stack.field_77994_a;
                        }
                        stack.field_77994_a -= itemSize;
                        EntityItem entityitem = new EntityItem(this.field_70331_k, (double)((float)this.field_70329_l + jumpX + (float)offsetX), (double)((float)this.field_70330_m + jumpY), (double)((float)this.field_70327_n + jumpZ + (float)offsetZ), new ItemStack(stack.field_77993_c, itemSize, stack.func_77960_j()));
                        if (stack.func_77942_o()) {
                            entityitem.func_92059_d().func_77982_d((NBTTagCompound)stack.func_77978_p().func_74737_b());
                        }
                        float offset = 0.05f;
                        entityitem.motionX = (float)this.random.nextGaussian() * offset;
                        entityitem.motionY = (float)this.random.nextGaussian() * offset + 0.2f;
                        entityitem.motionZ = (float)this.random.nextGaussian() * offset;
                        this.field_70331_k.func_72838_d((Entity)entityitem);
                    }
                }
            }
        }
    }

    public int getTossDirection() {
        return this.getRenderDirection();
    }
}

