/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.library.tools;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import tconstruct.library.tools.ToolCore;

public abstract class ToolMod {
    public final String key;
    public final List stacks;
    public final int effectIndex;
    public static Random random = new Random();

    public ToolMod(ItemStack[] items, int effect, String dataKey) {
        ArrayList<ItemStack> itemstacks = new ArrayList<ItemStack>();
        for (int iter = 0; iter < items.length; ++iter) {
            itemstacks.add(items[iter]);
        }
        this.stacks = itemstacks;
        this.effectIndex = effect;
        this.key = dataKey;
    }

    public boolean matches(ItemStack[] input, ItemStack tool) {
        if (!this.canModify(tool, input)) {
            return false;
        }
        ArrayList list = new ArrayList(this.stacks);
        for (int iter = 0; iter < input.length; ++iter) {
            ItemStack craftingStack = input[iter];
            if (craftingStack == null) continue;
            boolean canCraft = false;
            for (ItemStack removeStack : list) {
                if (craftingStack.itemID != removeStack.itemID || removeStack.getItemDamage() != Short.MAX_VALUE && craftingStack.getItemDamage() != removeStack.getItemDamage()) continue;
                canCraft = true;
                list.remove(removeStack);
                break;
            }
            if (canCraft) continue;
            return false;
        }
        return list.isEmpty();
    }

    protected boolean canModify(ItemStack tool, ItemStack[] input) {
        NBTTagCompound tags = tool.getTagCompound().getCompoundTag("InfiTool");
        return tags.getInteger("Modifiers") > 0;
    }

    public abstract void modify(ItemStack[] var1, ItemStack var2);

    public void addMatchingEffect(ItemStack tool) {
        NBTTagCompound tags = tool.getTagCompound().getCompoundTag("InfiTool");
        if (tags.hasKey("Effect6") || tags.hasKey(this.key)) {
            return;
        }
        if (tags.hasKey("Effect5")) {
            tags.setInteger("Effect6", this.effectIndex);
        } else if (tags.hasKey("Effect4")) {
            tags.setInteger("Effect5", this.effectIndex);
        } else if (tags.hasKey("Effect3")) {
            tags.setInteger("Effect4", this.effectIndex);
        } else if (tags.hasKey("Effect2")) {
            tags.setInteger("Effect3", this.effectIndex);
        } else if (tags.hasKey("Effect1")) {
            tags.setInteger("Effect2", this.effectIndex);
        } else {
            tags.setInteger("Effect1", this.effectIndex);
        }
    }

    protected int addModifierTip(ItemStack tool, String modifierTip) {
        String tip;
        NBTTagCompound tags = tool.getTagCompound().getCompoundTag("InfiTool");
        int tipNum = 0;
        while (tags.hasKey(tip = "Tooltip" + ++tipNum)) {
        }
        tags.setString(tip, "");
        String modTip = "ModifierTip" + tipNum;
        tags.setString(modTip, modifierTip);
        return tipNum;
    }

    protected int addToolTip(ItemStack tool, String tooltip, String modifierTip) {
        String tip;
        String tag;
        NBTTagCompound tags = tool.getTagCompound().getCompoundTag("InfiTool");
        int tipNum = 0;
        do {
            if (tags.hasKey(tip = "Tooltip" + ++tipNum)) continue;
            tags.setString(tip, tooltip);
            String modTip = "ModifierTip" + tipNum;
            tags.setString(modTip, modifierTip);
            return tipNum;
        } while (!(tag = tags.getString(tip)).contains(tooltip));
        tags.setString(tip, this.getProperName(tooltip, tag));
        String modTip = "ModifierTip" + tipNum;
        tag = tags.getString(modTip);
        tags.setString(modTip, this.getProperName(modifierTip, tag));
        return tipNum;
    }

    protected String getProperName(String tooltip, String tag) {
        if (tag.equals(tooltip)) {
            return tooltip + " II";
        }
        if (tag.equals(tooltip + " II")) {
            return tooltip + " III";
        }
        if (tag.equals(tooltip + " III")) {
            return tooltip + " IV";
        }
        if (tag.equals(tooltip + " IV")) {
            return tooltip + " V";
        }
        if (tag.equals(tooltip + " V")) {
            return tooltip + " VI";
        }
        if (tag.equals(tooltip + " VI")) {
            return tooltip + " VII";
        }
        if (tag.equals(tooltip + " VII")) {
            return tooltip + " VIII";
        }
        if (tag.equals(tooltip + " VIII")) {
            return tooltip + " IX";
        }
        if (tag.equals(tooltip + " IX")) {
            return tooltip + " X";
        }
        return tooltip + " X+";
    }

    public boolean validType(ToolCore tool) {
        return true;
    }
}

