/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.library;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import tconstruct.library.ActiveToolMod;
import tconstruct.library.crafting.Detailing;
import tconstruct.library.crafting.LiquidCasting;
import tconstruct.library.crafting.ToolBuilder;
import tconstruct.library.tools.ArrowMaterial;
import tconstruct.library.tools.BowMaterial;
import tconstruct.library.tools.BowstringMaterial;
import tconstruct.library.tools.CustomMaterial;
import tconstruct.library.tools.FletchingMaterial;
import tconstruct.library.tools.ToolCore;
import tconstruct.library.tools.ToolMaterial;
import tconstruct.library.util.TabTools;

public class TConstructRegistry {
    public static TConstructRegistry instance = new TConstructRegistry();
    public static TabTools toolTab;
    public static TabTools materialTab;
    public static TabTools blockTab;
    public static HashMap<String, Item> itemDirectory;
    static HashMap<String, ItemStack> itemstackDirectory;
    public static ArrayList<ToolCore> tools;
    public static HashMap<List, ItemStack> patternPartMapping;
    public static HashMap<Integer, ToolMaterial> toolMaterials;
    public static HashMap<String, ToolMaterial> toolMaterialStrings;
    public static HashMap<Integer, BowMaterial> bowMaterials;
    public static HashMap<Integer, ArrowMaterial> arrowMaterials;
    public static ArrayList<CustomMaterial> customMaterials;
    public static ArrayList<ActiveToolMod> activeModifiers;
    public static int[] drawbridgeState;
    public static int[] interchangableBlockMapping;
    public static int[] blockToItemMapping;

    public static void addItemToDirectory(String name, Item itemstack) {
        Item add = itemDirectory.get(name);
        if (add != null) {
            System.out.println("[TCon API] " + name + " is already present in the Item directory");
        }
        itemDirectory.put(name, itemstack);
    }

    public static Item getItem(String name) {
        Item ret = itemDirectory.get(name);
        if (ret == null) {
            System.out.println("[TCon API] Could not find " + name + " in the Item directory");
        }
        return ret;
    }

    public static void addItemStackToDirectory(String name, ItemStack itemstack) {
        ItemStack add = itemstackDirectory.get(name);
        if (add != null) {
            System.out.println("[TCon API] " + name + " is already present in the ItemStack directory");
        }
        itemstackDirectory.put(name, itemstack);
    }

    public static ItemStack getItemStack(String name) {
        ItemStack ret = itemstackDirectory.get(name);
        if (ret == null) {
            System.out.println("[TCon API] Could not find " + name + " in the ItemStack directory");
        }
        return ret;
    }

    public static void addPartMapping(int patternID, int patternMeta, int materialID, ItemStack output) {
        patternPartMapping.put(Arrays.asList(patternID, patternMeta, materialID), output);
    }

    public static ItemStack getPartMapping(int itemID, int metadata, int materialID) {
        ItemStack stack = patternPartMapping.get(Arrays.asList(itemID, metadata, materialID));
        if (stack != null) {
            return stack.copy();
        }
        return null;
    }

    public static void addToolMapping(ToolCore tool) {
        tools.add(tool);
    }

    public static ArrayList<ToolCore> getToolMapping() {
        return tools;
    }

    public static void addToolRecipe(ToolCore output, Item ... parts) {
        ToolBuilder tb = ToolBuilder.instance;
        if (parts.length < 1 || parts.length > 4 || parts.length == 3) {
            System.out.println("[TCon API] Wrong amount of items to craft into a tool");
        }
        ToolBuilder.addToolRecipe(output, parts);
    }

    public static void addToolMaterial(int materialID, String materialName, int harvestLevel, int durability, int miningspeed, int attack, float handleModifier, int reinforced, float stonebound, String style, String ability) {
        ToolMaterial mat = toolMaterials.get(materialID);
        if (mat != null) {
            throw new IllegalArgumentException("[TCon API] Material ID " + materialID + " is already occupied by " + mat.materialName);
        }
        mat = new ToolMaterial(materialName, harvestLevel, durability, miningspeed, attack, handleModifier, reinforced, stonebound, style, ability);
        toolMaterials.put(materialID, mat);
        toolMaterialStrings.put(materialName, mat);
    }

    public static void addToolMaterial(int materialID, String materialName, String displayName, int harvestLevel, int durability, int miningspeed, int attack, float handleModifier, int reinforced, float stonebound, String style, String ability) {
        ToolMaterial mat = toolMaterials.get(materialID);
        if (mat != null) {
            throw new IllegalArgumentException("[TCon API] Material ID " + materialID + " is already occupied by " + mat.materialName);
        }
        mat = new ToolMaterial(materialName, displayName, harvestLevel, durability, miningspeed, attack, handleModifier, reinforced, stonebound, style, ability);
        toolMaterials.put(materialID, mat);
        toolMaterialStrings.put(materialName, mat);
    }

    public static void addtoolMaterial(int materialID, ToolMaterial material) {
        ToolMaterial mat = toolMaterials.get(materialID);
        if (mat != null) {
            throw new IllegalArgumentException("[TCon API] Material ID " + materialID + " is already occupied by " + mat.materialName);
        }
        toolMaterials.put(materialID, mat);
        toolMaterialStrings.put(material.name(), mat);
    }

    public static ToolMaterial getMaterial(int key) {
        return toolMaterials.get(key);
    }

    public static ToolMaterial getMaterial(String key) {
        return toolMaterialStrings.get(key);
    }

    public static void addBowMaterial(int materialID, int durability, int drawSpeed, float speedMax) {
        BowMaterial mat = bowMaterials.get(materialID);
        if (mat != null) {
            throw new IllegalArgumentException("[TCon API] Bow Material ID " + materialID + " is already occupied");
        }
        mat = new BowMaterial(durability, drawSpeed, speedMax);
        bowMaterials.put(materialID, mat);
    }

    public static boolean validBowMaterial(int materialID) {
        return bowMaterials.containsKey(materialID);
    }

    public static BowMaterial getBowMaterial(int materialID) {
        return bowMaterials.get(materialID);
    }

    public static void addArrowMaterial(int materialID, float mass, float breakChance, float accuracy) {
        ArrowMaterial mat = arrowMaterials.get(materialID);
        if (mat != null) {
            throw new IllegalArgumentException("[TCon API] Arrow Material ID " + materialID + " is already occupied");
        }
        mat = new ArrowMaterial(mass, breakChance, accuracy);
        arrowMaterials.put(materialID, mat);
    }

    public static boolean validArrowMaterial(int materialID) {
        return arrowMaterials.containsKey(materialID);
    }

    public static ArrowMaterial getArrowMaterial(int materialID) {
        return arrowMaterials.get(materialID);
    }

    public static void addCustomMaterial(CustomMaterial mat) {
        if (mat != null) {
            customMaterials.add(mat);
        }
    }

    public static void addBowstringMaterial(int materialID, int value, ItemStack input, ItemStack craftingMaterial, float durability, float drawSpeed, float flightSpeed) {
        BowstringMaterial mat = new BowstringMaterial(materialID, value, input, craftingMaterial, durability, drawSpeed, flightSpeed);
        customMaterials.add(mat);
    }

    public static void addFletchingMaterial(int materialID, int value, ItemStack input, ItemStack craftingMaterial, float accuracy, float breakChance, float mass) {
        FletchingMaterial mat = new FletchingMaterial(materialID, value, input, craftingMaterial, accuracy, breakChance, mass);
        customMaterials.add(mat);
    }

    public static CustomMaterial getCustomMaterial(int materialID, Class<? extends CustomMaterial> clazz) {
        for (CustomMaterial mat : customMaterials) {
            if (!mat.getClass().equals(clazz) || mat.materialID != materialID) continue;
            return mat;
        }
        return null;
    }

    public static CustomMaterial getCustomMaterial(ItemStack input, Class<? extends CustomMaterial> clazz) {
        for (CustomMaterial mat : customMaterials) {
            if (!mat.getClass().equals(clazz) || !input.isItemEqual(mat.input)) continue;
            return mat;
        }
        return null;
    }

    public static LiquidCasting getTableCasting() {
        return instance.tableCasting();
    }

    LiquidCasting tableCasting() {
        try {
            Class<?> clazz = Class.forName("tconstruct.TConstruct");
            Method method = clazz.getMethod("getTableCasting", new Class[0]);
            LiquidCasting lc = (LiquidCasting)method.invoke((Object)this, new Object[0]);
            return lc;
        }
        catch (Exception e) {
            System.out.println("[TCon API] Could not find casting table recipes.");
            return null;
        }
    }

    public static LiquidCasting getBasinCasting() {
        return instance.basinCasting();
    }

    LiquidCasting basinCasting() {
        try {
            Class<?> clazz = Class.forName("tconstruct.TConstruct");
            Method method = clazz.getMethod("getBasinCasting", new Class[0]);
            LiquidCasting lc = (LiquidCasting)method.invoke((Object)this, new Object[0]);
            return lc;
        }
        catch (Exception e) {
            System.out.println("[TCon API] Could not find casting basin recipes.");
            return null;
        }
    }

    public static Detailing getChiselDetailing() {
        return instance.chiselDetailing();
    }

    Detailing chiselDetailing() {
        try {
            Class<?> clazz = Class.forName("tconstruct.TConstruct");
            Method method = clazz.getMethod("getChiselDetailing", new Class[0]);
            Detailing lc = (Detailing)method.invoke((Object)this, new Object[0]);
            return lc;
        }
        catch (Exception e) {
            System.out.println("[TCon API] Could not find chisel detailing recipes.");
            return null;
        }
    }

    public static void registerActiveToolMod(ActiveToolMod mod) {
        activeModifiers.add(mod);
    }

    static void initializeDrawbridgeState() {
        TConstructRegistry.drawbridgeState[Block.stone.blockID] = 1;
        TConstructRegistry.drawbridgeState[Block.grass.blockID] = 1;
        TConstructRegistry.drawbridgeState[Block.dirt.blockID] = 1;
        TConstructRegistry.drawbridgeState[Block.cobblestone.blockID] = 1;
        TConstructRegistry.drawbridgeState[Block.bedrock.blockID] = 2;
        TConstructRegistry.drawbridgeState[Block.waterMoving.blockID] = 1;
        TConstructRegistry.drawbridgeState[Block.waterStill.blockID] = 1;
        TConstructRegistry.interchangableBlockMapping[Block.waterStill.blockID] = Block.waterMoving.blockID;
        TConstructRegistry.interchangableBlockMapping[Block.waterMoving.blockID] = Block.waterStill.blockID;
        TConstructRegistry.drawbridgeState[Block.lavaMoving.blockID] = 1;
        TConstructRegistry.drawbridgeState[Block.lavaStill.blockID] = 1;
        TConstructRegistry.interchangableBlockMapping[Block.lavaStill.blockID] = Block.lavaMoving.blockID;
        TConstructRegistry.interchangableBlockMapping[Block.lavaMoving.blockID] = Block.lavaStill.blockID;
        TConstructRegistry.drawbridgeState[Block.sand.blockID] = 1;
        TConstructRegistry.drawbridgeState[Block.gravel.blockID] = 1;
        TConstructRegistry.drawbridgeState[Block.oreGold.blockID] = 1;
        TConstructRegistry.drawbridgeState[Block.oreIron.blockID] = 1;
        TConstructRegistry.drawbridgeState[Block.oreCoal.blockID] = 1;
        TConstructRegistry.drawbridgeState[Block.sponge.blockID] = 1;
        TConstructRegistry.drawbridgeState[Block.oreLapis.blockID] = 1;
        TConstructRegistry.drawbridgeState[Block.blockLapis.blockID] = 1;
        TConstructRegistry.drawbridgeState[Block.dispenser.blockID] = 3;
        TConstructRegistry.drawbridgeState[Block.music.blockID] = 1;
        TConstructRegistry.drawbridgeState[Block.bed.blockID] = 2;
        TConstructRegistry.drawbridgeState[Block.railPowered.blockID] = 4;
        TConstructRegistry.drawbridgeState[Block.railDetector.blockID] = 4;
        TConstructRegistry.drawbridgeState[Block.pistonStickyBase.blockID] = 3;
        TConstructRegistry.drawbridgeState[Block.web.blockID] = 1;
        TConstructRegistry.drawbridgeState[Block.pistonBase.blockID] = 3;
        TConstructRegistry.drawbridgeState[Block.pistonExtension.blockID] = 2;
        TConstructRegistry.drawbridgeState[Block.plantYellow.blockID] = 1;
        TConstructRegistry.drawbridgeState[Block.plantRed.blockID] = 1;
        TConstructRegistry.drawbridgeState[Block.mushroomBrown.blockID] = 1;
        TConstructRegistry.drawbridgeState[Block.mushroomRed.blockID] = 1;
        TConstructRegistry.drawbridgeState[Block.blockGold.blockID] = 1;
        TConstructRegistry.drawbridgeState[Block.blockIron.blockID] = 1;
        TConstructRegistry.drawbridgeState[Block.brick.blockID] = 1;
        TConstructRegistry.drawbridgeState[Block.tnt.blockID] = 1;
        TConstructRegistry.drawbridgeState[Block.bookShelf.blockID] = 1;
        TConstructRegistry.drawbridgeState[Block.cobblestoneMossy.blockID] = 1;
        TConstructRegistry.drawbridgeState[Block.obsidian.blockID] = 1;
        TConstructRegistry.drawbridgeState[Block.torchWood.blockID] = 1;
        TConstructRegistry.drawbridgeState[Block.fire.blockID] = 1;
        TConstructRegistry.drawbridgeState[Block.mobSpawner.blockID] = 2;
        TConstructRegistry.drawbridgeState[Block.stairsWoodOak.blockID] = 3;
        TConstructRegistry.drawbridgeState[Block.chest.blockID] = 5;
        TConstructRegistry.drawbridgeState[Block.redstoneWire.blockID] = 1;
        TConstructRegistry.blockToItemMapping[Block.redstoneWire.blockID] = Item.redstone.itemID;
        TConstructRegistry.blockToItemMapping[Item.redstone.itemID] = Block.redstoneWire.blockID;
        TConstructRegistry.drawbridgeState[Block.oreDiamond.blockID] = 1;
        TConstructRegistry.drawbridgeState[Block.blockDiamond.blockID] = 1;
        TConstructRegistry.drawbridgeState[Block.workbench.blockID] = 1;
        TConstructRegistry.drawbridgeState[Block.crops.blockID] = 2;
        TConstructRegistry.drawbridgeState[Block.tilledField.blockID] = 1;
        TConstructRegistry.drawbridgeState[Block.furnaceIdle.blockID] = 3;
        TConstructRegistry.drawbridgeState[Block.furnaceBurning.blockID] = 3;
        TConstructRegistry.interchangableBlockMapping[Block.furnaceIdle.blockID] = Block.furnaceBurning.blockID;
        TConstructRegistry.interchangableBlockMapping[Block.furnaceBurning.blockID] = Block.furnaceIdle.blockID;
        TConstructRegistry.drawbridgeState[Block.tilledField.blockID] = 1;
        TConstructRegistry.drawbridgeState[Block.signPost.blockID] = 3;
        TConstructRegistry.drawbridgeState[Block.doorWood.blockID] = 2;
        TConstructRegistry.drawbridgeState[Block.ladder.blockID] = 1;
        TConstructRegistry.drawbridgeState[Block.rail.blockID] = 4;
        TConstructRegistry.drawbridgeState[Block.stairsCobblestone.blockID] = 3;
        TConstructRegistry.drawbridgeState[Block.signWall.blockID] = 3;
        TConstructRegistry.drawbridgeState[Block.lever.blockID] = 3;
        TConstructRegistry.drawbridgeState[Block.pressurePlateStone.blockID] = 1;
        TConstructRegistry.drawbridgeState[Block.doorIron.blockID] = 2;
        TConstructRegistry.drawbridgeState[Block.pressurePlatePlanks.blockID] = 1;
        TConstructRegistry.drawbridgeState[Block.oreRedstone.blockID] = 1;
        TConstructRegistry.drawbridgeState[Block.oreRedstoneGlowing.blockID] = 1;
        TConstructRegistry.drawbridgeState[Block.torchRedstoneIdle.blockID] = 1;
        TConstructRegistry.drawbridgeState[Block.torchRedstoneActive.blockID] = 1;
        TConstructRegistry.drawbridgeState[Block.stoneButton.blockID] = 3;
        TConstructRegistry.drawbridgeState[Block.snow.blockID] = 1;
        TConstructRegistry.drawbridgeState[Block.ice.blockID] = 1;
        TConstructRegistry.drawbridgeState[Block.blockSnow.blockID] = 1;
        TConstructRegistry.drawbridgeState[Block.cactus.blockID] = 2;
        TConstructRegistry.drawbridgeState[Block.blockClay.blockID] = 1;
        TConstructRegistry.drawbridgeState[Block.reed.blockID] = 1;
        TConstructRegistry.drawbridgeState[Block.jukebox.blockID] = 1;
        TConstructRegistry.drawbridgeState[Block.fence.blockID] = 1;
        TConstructRegistry.drawbridgeState[Block.pumpkin.blockID] = 1;
        TConstructRegistry.drawbridgeState[Block.netherrack.blockID] = 1;
        TConstructRegistry.drawbridgeState[Block.slowSand.blockID] = 1;
        TConstructRegistry.drawbridgeState[Block.glowStone.blockID] = 1;
        TConstructRegistry.drawbridgeState[Block.portal.blockID] = 2;
        TConstructRegistry.drawbridgeState[Block.pumpkinLantern.blockID] = 1;
        TConstructRegistry.drawbridgeState[Block.cake.blockID] = 2;
        TConstructRegistry.drawbridgeState[Block.redstoneRepeaterIdle.blockID] = 3;
        TConstructRegistry.drawbridgeState[Block.redstoneRepeaterActive.blockID] = 3;
        TConstructRegistry.interchangableBlockMapping[Block.redstoneRepeaterIdle.blockID] = Block.redstoneRepeaterActive.blockID;
        TConstructRegistry.interchangableBlockMapping[Block.redstoneRepeaterActive.blockID] = Block.redstoneRepeaterIdle.blockID;
        TConstructRegistry.blockToItemMapping[Block.redstoneRepeaterIdle.blockID] = Item.redstoneRepeater.itemID;
        TConstructRegistry.blockToItemMapping[Block.redstoneRepeaterActive.blockID] = Item.redstoneRepeater.itemID;
        TConstructRegistry.blockToItemMapping[Item.redstoneRepeater.itemID] = Block.redstoneRepeaterIdle.blockID;
        TConstructRegistry.drawbridgeState[Block.lockedChest.blockID] = 5;
        TConstructRegistry.drawbridgeState[Block.trapdoor.blockID] = 3;
        TConstructRegistry.drawbridgeState[Block.mushroomCapBrown.blockID] = 1;
        TConstructRegistry.drawbridgeState[Block.mushroomCapRed.blockID] = 1;
        TConstructRegistry.drawbridgeState[Block.fenceIron.blockID] = 1;
        TConstructRegistry.drawbridgeState[Block.thinGlass.blockID] = 1;
        TConstructRegistry.drawbridgeState[Block.melon.blockID] = 1;
        TConstructRegistry.drawbridgeState[Block.pumpkinStem.blockID] = 2;
        TConstructRegistry.drawbridgeState[Block.melonStem.blockID] = 2;
        TConstructRegistry.drawbridgeState[Block.vine.blockID] = 3;
        TConstructRegistry.drawbridgeState[Block.fenceGate.blockID] = 3;
        TConstructRegistry.drawbridgeState[Block.stairsBrick.blockID] = 3;
        TConstructRegistry.drawbridgeState[Block.stairsStoneBrick.blockID] = 3;
        TConstructRegistry.drawbridgeState[Block.mycelium.blockID] = 1;
        TConstructRegistry.drawbridgeState[Block.waterlily.blockID] = 1;
        TConstructRegistry.drawbridgeState[Block.netherBrick.blockID] = 1;
        TConstructRegistry.drawbridgeState[Block.netherFence.blockID] = 1;
        TConstructRegistry.drawbridgeState[Block.netherFence.blockID] = 3;
        TConstructRegistry.drawbridgeState[Block.netherStalk.blockID] = 2;
        TConstructRegistry.drawbridgeState[Block.enchantmentTable.blockID] = 1;
        TConstructRegistry.drawbridgeState[Block.brewingStand.blockID] = 1;
        TConstructRegistry.drawbridgeState[Block.cauldron.blockID] = 1;
        TConstructRegistry.drawbridgeState[Block.endPortal.blockID] = 2;
        TConstructRegistry.drawbridgeState[Block.dragonEgg.blockID] = 1;
        TConstructRegistry.drawbridgeState[Block.redstoneLampIdle.blockID] = 1;
        TConstructRegistry.drawbridgeState[Block.redstoneLampActive.blockID] = 1;
        TConstructRegistry.drawbridgeState[Block.cocoaPlant.blockID] = 2;
        TConstructRegistry.drawbridgeState[Block.stairsSandStone.blockID] = 3;
        TConstructRegistry.drawbridgeState[Block.oreEmerald.blockID] = 1;
        TConstructRegistry.drawbridgeState[Block.enderChest.blockID] = 5;
        TConstructRegistry.drawbridgeState[Block.tripWireSource.blockID] = 1;
        TConstructRegistry.drawbridgeState[Block.tripWire.blockID] = 1;
        TConstructRegistry.drawbridgeState[Block.blockEmerald.blockID] = 1;
        TConstructRegistry.drawbridgeState[Block.stairsWoodSpruce.blockID] = 3;
        TConstructRegistry.drawbridgeState[Block.stairsWoodBirch.blockID] = 3;
        TConstructRegistry.drawbridgeState[Block.stairsWoodJungle.blockID] = 3;
        TConstructRegistry.drawbridgeState[Block.commandBlock.blockID] = 1;
        TConstructRegistry.drawbridgeState[Block.beacon.blockID] = 1;
        TConstructRegistry.drawbridgeState[Block.cobblestoneWall.blockID] = 1;
        TConstructRegistry.drawbridgeState[Block.flowerPot.blockID] = 1;
        TConstructRegistry.drawbridgeState[Block.carrot.blockID] = 2;
        TConstructRegistry.drawbridgeState[Block.potato.blockID] = 1;
        TConstructRegistry.drawbridgeState[Block.woodenButton.blockID] = 3;
        TConstructRegistry.drawbridgeState[Block.skull.blockID] = 2;
        TConstructRegistry.drawbridgeState[Block.chestTrapped.blockID] = 5;
        TConstructRegistry.drawbridgeState[Block.pressurePlateGold.blockID] = 1;
        TConstructRegistry.drawbridgeState[Block.pressurePlateIron.blockID] = 1;
        TConstructRegistry.drawbridgeState[Block.redstoneComparatorIdle.blockID] = 1;
        TConstructRegistry.drawbridgeState[Block.redstoneComparatorActive.blockID] = 1;
        TConstructRegistry.interchangableBlockMapping[Block.redstoneComparatorIdle.blockID] = Block.redstoneComparatorActive.blockID;
        TConstructRegistry.interchangableBlockMapping[Block.redstoneComparatorActive.blockID] = Block.redstoneComparatorIdle.blockID;
        TConstructRegistry.blockToItemMapping[Block.redstoneComparatorIdle.blockID] = Item.comparator.itemID;
        TConstructRegistry.blockToItemMapping[Block.redstoneComparatorActive.blockID] = Item.comparator.itemID;
        TConstructRegistry.blockToItemMapping[Item.comparator.itemID] = Block.redstoneComparatorIdle.blockID;
        TConstructRegistry.drawbridgeState[Block.daylightSensor.blockID] = 1;
        TConstructRegistry.drawbridgeState[Block.blockRedstone.blockID] = 1;
        TConstructRegistry.drawbridgeState[Block.oreNetherQuartz.blockID] = 1;
        TConstructRegistry.drawbridgeState[Block.hopperBlock.blockID] = 3;
        TConstructRegistry.drawbridgeState[Block.blockNetherQuartz.blockID] = 1;
        TConstructRegistry.drawbridgeState[Block.stairsNetherQuartz.blockID] = 3;
        TConstructRegistry.drawbridgeState[Block.railActivator.blockID] = 4;
        TConstructRegistry.drawbridgeState[Block.dropper.blockID] = 3;
        TConstructRegistry.interchangableBlockMapping[Block.dirt.blockID] = Block.grass.blockID;
        TConstructRegistry.interchangableBlockMapping[Block.grass.blockID] = Block.dirt.blockID;
    }

    static {
        itemDirectory = new HashMap();
        itemstackDirectory = new HashMap();
        tools = new ArrayList(20);
        patternPartMapping = new HashMap();
        toolMaterials = new HashMap(40);
        toolMaterialStrings = new HashMap(40);
        bowMaterials = new HashMap(40);
        arrowMaterials = new HashMap(40);
        customMaterials = new ArrayList();
        activeModifiers = new ArrayList();
        drawbridgeState = new int[Block.blocksList.length];
        interchangableBlockMapping = new int[Block.blocksList.length];
        blockToItemMapping = new int[Item.itemsList.length];
        TConstructRegistry.initializeDrawbridgeState();
    }
}

