/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.storage;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;
import net.minecraft.world.storage.MapCoord;
import net.minecraft.world.storage.MapInfo;

public class MapData
extends WorldSavedData {
    public int field_76201_a;
    public int field_76199_b;
    public byte field_76200_c;
    public byte field_76197_d;
    public byte[] field_76198_e = new byte[16384];
    public List field_76196_g = new ArrayList();
    private Map field_76202_j = new HashMap();
    public Map field_76203_h = new LinkedHashMap();

    public MapData(String p_i2140_1_) {
        super(p_i2140_1_);
    }

    @Override
    public void func_76184_a(NBTTagCompound p_76184_1_) {
        this.field_76200_c = p_76184_1_.func_74771_c("dimension");
        this.field_76201_a = p_76184_1_.func_74762_e("xCenter");
        this.field_76199_b = p_76184_1_.func_74762_e("zCenter");
        this.field_76197_d = p_76184_1_.func_74771_c("scale");
        if (this.field_76197_d < 0) {
            this.field_76197_d = 0;
        }
        if (this.field_76197_d > 4) {
            this.field_76197_d = (byte)4;
        }
        int n = p_76184_1_.func_74765_d("width");
        int n2 = p_76184_1_.func_74765_d("height");
        if (n == 128 && n2 == 128) {
            this.field_76198_e = p_76184_1_.func_74770_j("colors");
        } else {
            byte[] byArray = p_76184_1_.func_74770_j("colors");
            this.field_76198_e = new byte[16384];
            int n3 = (128 - n) / 2;
            int n4 = (128 - n2) / 2;
            for (int i = 0; i < n2; ++i) {
                int n5 = i + n4;
                if (n5 < 0 && n5 >= 128) continue;
                for (int j = 0; j < n; ++j) {
                    int n6 = j + n3;
                    if (n6 < 0 && n6 >= 128) continue;
                    this.field_76198_e[n6 + n5 * 128] = byArray[j + i * n];
                }
            }
        }
    }

    @Override
    public void func_76187_b(NBTTagCompound p_76187_1_) {
        p_76187_1_.func_74774_a("dimension", this.field_76200_c);
        p_76187_1_.func_74768_a("xCenter", this.field_76201_a);
        p_76187_1_.func_74768_a("zCenter", this.field_76199_b);
        p_76187_1_.func_74774_a("scale", this.field_76197_d);
        p_76187_1_.func_74777_a("width", (short)128);
        p_76187_1_.func_74777_a("height", (short)128);
        p_76187_1_.func_74773_a("colors", this.field_76198_e);
    }

    public void func_76191_a(EntityPlayer p_76191_1_, ItemStack p_76191_2_) {
        if (!this.field_76202_j.containsKey(p_76191_1_)) {
            MapInfo mapInfo = new MapInfo(this, p_76191_1_);
            this.field_76202_j.put(p_76191_1_, mapInfo);
            this.field_76196_g.add(mapInfo);
        }
        if (!p_76191_1_.field_71071_by.func_70431_c(p_76191_2_)) {
            this.field_76203_h.remove(p_76191_1_.func_70005_c_());
        }
        for (int i = 0; i < this.field_76196_g.size(); ++i) {
            MapInfo mapInfo = (MapInfo)this.field_76196_g.get(i);
            if (mapInfo.field_76211_a.field_70128_L || !mapInfo.field_76211_a.field_71071_by.func_70431_c(p_76191_2_) && !p_76191_2_.func_82839_y()) {
                this.field_76202_j.remove(mapInfo.field_76211_a);
                this.field_76196_g.remove(mapInfo);
                continue;
            }
            if (p_76191_2_.func_82839_y() || mapInfo.field_76211_a.field_71093_bK != this.field_76200_c) continue;
            this.func_82567_a(0, mapInfo.field_76211_a.field_70170_p, mapInfo.field_76211_a.func_70005_c_(), mapInfo.field_76211_a.field_70165_t, mapInfo.field_76211_a.field_70161_v, mapInfo.field_76211_a.field_70177_z);
        }
        if (p_76191_2_.func_82839_y()) {
            this.func_82567_a(1, p_76191_1_.field_70170_p, "frame-" + p_76191_2_.func_82836_z().field_70157_k, p_76191_2_.func_82836_z().field_70523_b, p_76191_2_.func_82836_z().field_70521_d, p_76191_2_.func_82836_z().field_82332_a * 90);
        }
    }

    private void func_82567_a(int p_82567_1_, World p_82567_2_, String p_82567_3_, double p_82567_4_, double p_82567_6_, double p_82567_8_) {
        byte by;
        int n = 1 << this.field_76197_d;
        float f = (float)(p_82567_4_ - (double)this.field_76201_a) / (float)n;
        float f2 = (float)(p_82567_6_ - (double)this.field_76199_b) / (float)n;
        byte by2 = (byte)((double)(f * 2.0f) + 0.5);
        byte by3 = (byte)((double)(f2 * 2.0f) + 0.5);
        int n2 = 63;
        if (f >= (float)(-n2) && f2 >= (float)(-n2) && f <= (float)n2 && f2 <= (float)n2) {
            by = (byte)((p_82567_8_ += p_82567_8_ < 0.0 ? -8.0 : 8.0) * 16.0 / 360.0);
            if (this.field_76200_c < 0) {
                int n3 = (int)(p_82567_2_.func_72912_H().func_76073_f() / 10L);
                by = (byte)(n3 * n3 * 34187121 + n3 * 121 >> 15 & 0xF);
            }
        } else if (Math.abs(f) < 320.0f && Math.abs(f2) < 320.0f) {
            p_82567_1_ = 6;
            by = 0;
            if (f <= (float)(-n2)) {
                by2 = (byte)((double)(n2 * 2) + 2.5);
            }
            if (f2 <= (float)(-n2)) {
                by3 = (byte)((double)(n2 * 2) + 2.5);
            }
            if (f >= (float)n2) {
                by2 = (byte)(n2 * 2 + 1);
            }
            if (f2 >= (float)n2) {
                by3 = (byte)(n2 * 2 + 1);
            }
        } else {
            this.field_76203_h.remove(p_82567_3_);
            return;
        }
        this.field_76203_h.put(p_82567_3_, new MapCoord(this, (byte)p_82567_1_, by2, by3, by));
    }

    public byte[] func_76193_a(ItemStack p_76193_1_, World p_76193_2_, EntityPlayer p_76193_3_) {
        MapInfo mapInfo = (MapInfo)this.field_76202_j.get(p_76193_3_);
        if (mapInfo == null) {
            return null;
        }
        return mapInfo.func_76204_a(p_76193_1_);
    }

    public void func_76194_a(int p_76194_1_, int p_76194_2_, int p_76194_3_) {
        super.func_76185_a();
        for (int i = 0; i < this.field_76196_g.size(); ++i) {
            MapInfo mapInfo = (MapInfo)this.field_76196_g.get(i);
            if (mapInfo.field_76209_b[p_76194_1_] < 0 || mapInfo.field_76209_b[p_76194_1_] > p_76194_2_) {
                mapInfo.field_76209_b[p_76194_1_] = p_76194_2_;
            }
            if (mapInfo.field_76210_c[p_76194_1_] >= 0 && mapInfo.field_76210_c[p_76194_1_] >= p_76194_3_) continue;
            mapInfo.field_76210_c[p_76194_1_] = p_76194_3_;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_76192_a(byte[] p_76192_1_) {
        if (p_76192_1_[0] == 0) {
            int n = p_76192_1_[1] & 0xFF;
            int n2 = p_76192_1_[2] & 0xFF;
            for (int i = 0; i < p_76192_1_.length - 3; ++i) {
                this.field_76198_e[(i + n2) * 128 + n] = p_76192_1_[i + 3];
            }
            this.func_76185_a();
        } else if (p_76192_1_[0] == 1) {
            this.field_76203_h.clear();
            for (int i = 0; i < (p_76192_1_.length - 1) / 3; ++i) {
                byte by = (byte)(p_76192_1_[i * 3 + 1] >> 4);
                byte by2 = p_76192_1_[i * 3 + 2];
                byte by3 = p_76192_1_[i * 3 + 3];
                byte by4 = (byte)(p_76192_1_[i * 3 + 1] & 0xF);
                this.field_76203_h.put("icon-" + i, new MapCoord(this, by, by2, by3, by4));
            }
        } else if (p_76192_1_[0] == 2) {
            this.field_76197_d = p_76192_1_[1];
        }
    }

    public MapInfo func_82568_a(EntityPlayer p_82568_1_) {
        MapInfo mapInfo = (MapInfo)this.field_76202_j.get(p_82568_1_);
        if (mapInfo == null) {
            mapInfo = new MapInfo(this, p_82568_1_);
            this.field_76202_j.put(p_82568_1_, mapInfo);
            this.field_76196_g.add(mapInfo);
        }
        return mapInfo;
    }
}

