/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.util.IProgressUpdate;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import net.minecraft.world.gen.FlatGeneratorInfo;
import net.minecraft.world.gen.FlatLayerInfo;
import net.minecraft.world.gen.feature.MapGenScatteredFeature;
import net.minecraft.world.gen.feature.WorldGenDungeons;
import net.minecraft.world.gen.feature.WorldGenLakes;
import net.minecraft.world.gen.structure.MapGenMineshaft;
import net.minecraft.world.gen.structure.MapGenStronghold;
import net.minecraft.world.gen.structure.MapGenStructure;
import net.minecraft.world.gen.structure.MapGenVillage;

public class ChunkProviderFlat
implements IChunkProvider {
    private World field_73163_a;
    private Random field_73161_b;
    private final byte[] field_82700_c = new byte[256];
    private final byte[] field_82698_d = new byte[256];
    private final FlatGeneratorInfo field_82699_e;
    private final List field_82696_f = new ArrayList();
    private final boolean field_82697_g;
    private final boolean field_82702_h;
    private WorldGenLakes field_82703_i;
    private WorldGenLakes field_82701_j;

    public ChunkProviderFlat(World p_i2004_1_, long p_i2004_2_, boolean p_i2004_4_, String p_i2004_5_) {
        this.field_73163_a = p_i2004_1_;
        this.field_73161_b = new Random(p_i2004_2_);
        this.field_82699_e = FlatGeneratorInfo.func_82651_a(p_i2004_5_);
        if (p_i2004_4_) {
            Map map = this.field_82699_e.func_82644_b();
            if (map.containsKey("village")) {
                Object object = (Map)map.get("village");
                if (!object.containsKey("size")) {
                    object.put("size", "1");
                }
                this.field_82696_f.add(new MapGenVillage((Map)object));
            }
            if (map.containsKey("biome_1")) {
                this.field_82696_f.add(new MapGenScatteredFeature((Map)map.get("biome_1")));
            }
            if (map.containsKey("mineshaft")) {
                this.field_82696_f.add(new MapGenMineshaft((Map)map.get("mineshaft")));
            }
            if (map.containsKey("stronghold")) {
                this.field_82696_f.add(new MapGenStronghold((Map)map.get("stronghold")));
            }
        }
        this.field_82697_g = this.field_82699_e.func_82644_b().containsKey("decoration");
        if (this.field_82699_e.func_82644_b().containsKey("lake")) {
            this.field_82703_i = new WorldGenLakes(Block.field_71943_B.field_71990_ca);
        }
        if (this.field_82699_e.func_82644_b().containsKey("lava_lake")) {
            this.field_82701_j = new WorldGenLakes(Block.field_71938_D.field_71990_ca);
        }
        this.field_82702_h = this.field_82699_e.func_82644_b().containsKey("dungeon");
        for (Object object : this.field_82699_e.func_82650_c()) {
            for (int i = ((FlatLayerInfo)object).func_82656_d(); i < ((FlatLayerInfo)object).func_82656_d() + ((FlatLayerInfo)object).func_82657_a(); ++i) {
                this.field_82700_c[i] = (byte)(((FlatLayerInfo)object).func_82659_b() & 0xFF);
                this.field_82698_d[i] = (byte)((FlatLayerInfo)object).func_82658_c();
            }
        }
    }

    @Override
    public Chunk func_73158_c(int p_73158_1_, int p_73158_2_) {
        return this.func_73154_d(p_73158_1_, p_73158_2_);
    }

    @Override
    public Chunk func_73154_d(int p_73154_1_, int p_73154_2_) {
        Chunk chunk = new Chunk(this.field_73163_a, p_73154_1_, p_73154_2_);
        for (int i = 0; i < this.field_82700_c.length; ++i) {
            int n = i >> 4;
            ExtendedBlockStorage extendedBlockStorage = chunk.func_76587_i()[n];
            if (extendedBlockStorage == null) {
                chunk.func_76587_i()[n] = extendedBlockStorage = new ExtendedBlockStorage(i, !this.field_73163_a.field_73011_w.field_76576_e);
            }
            for (int j = 0; j < 16; ++j) {
                for (int k = 0; k < 16; ++k) {
                    extendedBlockStorage.func_76655_a(j, i & 0xF, k, this.field_82700_c[i] & 0xFF);
                    extendedBlockStorage.func_76654_b(j, i & 0xF, k, this.field_82698_d[i]);
                }
            }
        }
        chunk.func_76603_b();
        BiomeGenBase[] biomeGenBaseArray = this.field_73163_a.func_72959_q().func_76933_b(null, p_73154_1_ * 16, p_73154_2_ * 16, 16, 16);
        byte[] byArray = chunk.func_76605_m();
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = (byte)biomeGenBaseArray[i].field_76756_M;
        }
        for (MapGenStructure mapGenStructure : this.field_82696_f) {
            mapGenStructure.func_75036_a(this, this.field_73163_a, p_73154_1_, p_73154_2_, null);
        }
        chunk.func_76603_b();
        return chunk;
    }

    @Override
    public boolean func_73149_a(int p_73149_1_, int p_73149_2_) {
        return true;
    }

    @Override
    public void func_73153_a(IChunkProvider p_73153_1_, int p_73153_2_, int p_73153_3_) {
        int n;
        int n2 = p_73153_2_ * 16;
        int n3 = p_73153_3_ * 16;
        BiomeGenBase biomeGenBase = this.field_73163_a.func_72807_a(n2 + 16, n3 + 16);
        boolean bl = false;
        this.field_73161_b.setSeed(this.field_73163_a.func_72905_C());
        long l = this.field_73161_b.nextLong() / 2L * 2L + 1L;
        long l2 = this.field_73161_b.nextLong() / 2L * 2L + 1L;
        this.field_73161_b.setSeed((long)p_73153_2_ * l + (long)p_73153_3_ * l2 ^ this.field_73163_a.func_72905_C());
        for (MapGenStructure mapGenStructure : this.field_82696_f) {
            n = mapGenStructure.func_75051_a(this.field_73163_a, this.field_73161_b, p_73153_2_, p_73153_3_);
            if (!(mapGenStructure instanceof MapGenVillage)) continue;
            bl |= n;
        }
        if (this.field_82703_i != null && !bl && this.field_73161_b.nextInt(4) == 0) {
            int n4 = n2 + this.field_73161_b.nextInt(16) + 8;
            int n5 = this.field_73161_b.nextInt(128);
            n = n3 + this.field_73161_b.nextInt(16) + 8;
            this.field_82703_i.func_76484_a(this.field_73163_a, this.field_73161_b, n4, n5, n);
        }
        if (this.field_82701_j != null && !bl && this.field_73161_b.nextInt(8) == 0) {
            int n6 = n2 + this.field_73161_b.nextInt(16) + 8;
            int n7 = this.field_73161_b.nextInt(this.field_73161_b.nextInt(120) + 8);
            n = n3 + this.field_73161_b.nextInt(16) + 8;
            if (n7 < 63 || this.field_73161_b.nextInt(10) == 0) {
                this.field_82701_j.func_76484_a(this.field_73163_a, this.field_73161_b, n6, n7, n);
            }
        }
        if (this.field_82702_h) {
            for (int i = 0; i < 8; ++i) {
                int n8 = n2 + this.field_73161_b.nextInt(16) + 8;
                n = this.field_73161_b.nextInt(128);
                int n9 = n3 + this.field_73161_b.nextInt(16) + 8;
                new WorldGenDungeons().func_76484_a(this.field_73163_a, this.field_73161_b, n8, n, n9);
            }
        }
        if (this.field_82697_g) {
            biomeGenBase.func_76728_a(this.field_73163_a, this.field_73161_b, n2, n3);
        }
    }

    @Override
    public boolean func_73151_a(boolean p_73151_1_, IProgressUpdate p_73151_2_) {
        return true;
    }

    @Override
    public void func_104112_b() {
    }

    @Override
    public boolean func_73156_b() {
        return false;
    }

    @Override
    public boolean func_73157_c() {
        return true;
    }

    @Override
    public String func_73148_d() {
        return "FlatLevelSource";
    }

    @Override
    public List func_73155_a(EnumCreatureType p_73155_1_, int p_73155_2_, int p_73155_3_, int p_73155_4_) {
        BiomeGenBase biomeGenBase = this.field_73163_a.func_72807_a(p_73155_2_, p_73155_4_);
        if (biomeGenBase == null) {
            return null;
        }
        return biomeGenBase.func_76747_a(p_73155_1_);
    }

    @Override
    public ChunkPosition func_73150_a(World p_73150_1_, String p_73150_2_, int p_73150_3_, int p_73150_4_, int p_73150_5_) {
        if ("Stronghold".equals(p_73150_2_)) {
            for (MapGenStructure mapGenStructure : this.field_82696_f) {
                if (!(mapGenStructure instanceof MapGenStronghold)) continue;
                return mapGenStructure.func_75050_a(p_73150_1_, p_73150_3_, p_73150_4_, p_73150_5_);
            }
        }
        return null;
    }

    @Override
    public int func_73152_e() {
        return 0;
    }

    @Override
    public void func_82695_e(int p_82695_1_, int p_82695_2_) {
        for (MapGenStructure mapGenStructure : this.field_82696_f) {
            mapGenStructure.func_75036_a(this, this.field_73163_a, p_82695_1_, p_82695_2_, null);
        }
    }
}

