/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraft.world.WorldProviderEnd;
import net.minecraft.world.WorldProviderHell;
import net.minecraft.world.WorldProviderSurface;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.biome.WorldChunkManager;
import net.minecraft.world.biome.WorldChunkManagerHell;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.ChunkProviderFlat;
import net.minecraft.world.gen.ChunkProviderGenerate;
import net.minecraft.world.gen.FlatGeneratorInfo;

public abstract class WorldProvider {
    public static final float[] field_111203_a = new float[]{1.0f, 0.75f, 0.5f, 0.25f, 0.0f, 0.25f, 0.5f, 0.75f};
    public World field_76579_a;
    public WorldType field_76577_b;
    public String field_82913_c;
    public WorldChunkManager field_76578_c;
    public boolean field_76575_d;
    public boolean field_76576_e;
    public float[] field_76573_f = new float[16];
    public int field_76574_g;
    private float[] field_76580_h = new float[4];

    public final void func_76558_a(World p_76558_1_) {
        this.field_76579_a = p_76558_1_;
        this.field_76577_b = p_76558_1_.func_72912_H().func_76067_t();
        this.field_82913_c = p_76558_1_.func_72912_H().func_82571_y();
        this.func_76572_b();
        this.func_76556_a();
    }

    protected void func_76556_a() {
        float f = 0.0f;
        for (int i = 0; i <= 15; ++i) {
            float f2 = 1.0f - (float)i / 15.0f;
            this.field_76573_f[i] = (1.0f - f2) / (f2 * 3.0f + 1.0f) * (1.0f - f) + f;
        }
    }

    protected void func_76572_b() {
        if (this.field_76579_a.func_72912_H().func_76067_t() == WorldType.field_77138_c) {
            FlatGeneratorInfo flatGeneratorInfo = FlatGeneratorInfo.func_82651_a(this.field_76579_a.func_72912_H().func_82571_y());
            this.field_76578_c = new WorldChunkManagerHell(BiomeGenBase.field_76773_a[flatGeneratorInfo.func_82648_a()], 0.5f, 0.5f);
        } else {
            this.field_76578_c = new WorldChunkManager(this.field_76579_a);
        }
    }

    public IChunkProvider func_76555_c() {
        if (this.field_76577_b == WorldType.field_77138_c) {
            return new ChunkProviderFlat(this.field_76579_a, this.field_76579_a.func_72905_C(), this.field_76579_a.func_72912_H().func_76089_r(), this.field_82913_c);
        }
        return new ChunkProviderGenerate(this.field_76579_a, this.field_76579_a.func_72905_C(), this.field_76579_a.func_72912_H().func_76089_r());
    }

    public boolean func_76566_a(int p_76566_1_, int p_76566_2_) {
        int n = this.field_76579_a.func_72922_b(p_76566_1_, p_76566_2_);
        return n == Block.field_71980_u.field_71990_ca;
    }

    public float func_76563_a(long p_76563_1_, float p_76563_3_) {
        int n = (int)(p_76563_1_ % 24000L);
        float f = ((float)n + p_76563_3_) / 24000.0f - 0.25f;
        if (f < 0.0f) {
            f += 1.0f;
        }
        if (f > 1.0f) {
            f -= 1.0f;
        }
        float f2 = f;
        f = 1.0f - (float)((Math.cos((double)f * Math.PI) + 1.0) / 2.0);
        f = f2 + (f - f2) / 3.0f;
        return f;
    }

    public int func_76559_b(long p_76559_1_) {
        return (int)(p_76559_1_ / 24000L) % 8;
    }

    public boolean func_76569_d() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public float[] func_76560_a(float p_76560_1_, float p_76560_2_) {
        float f;
        float f2 = 0.4f;
        float f3 = MathHelper.func_76134_b(p_76560_1_ * (float)Math.PI * 2.0f) - 0.0f;
        if (f3 >= (f = -0.0f) - f2 && f3 <= f + f2) {
            float f4 = (f3 - f) / f2 * 0.5f + 0.5f;
            float f5 = 1.0f - (1.0f - MathHelper.func_76126_a(f4 * (float)Math.PI)) * 0.99f;
            f5 *= f5;
            this.field_76580_h[0] = f4 * 0.3f + 0.7f;
            this.field_76580_h[1] = f4 * f4 * 0.7f + 0.2f;
            this.field_76580_h[2] = f4 * f4 * 0.0f + 0.2f;
            this.field_76580_h[3] = f5;
            return this.field_76580_h;
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public Vec3 func_76562_b(float p_76562_1_, float p_76562_2_) {
        float f = MathHelper.func_76134_b(p_76562_1_ * (float)Math.PI * 2.0f) * 2.0f + 0.5f;
        if (f < 0.0f) {
            f = 0.0f;
        }
        if (f > 1.0f) {
            f = 1.0f;
        }
        float f2 = 0.7529412f;
        float f3 = 0.84705883f;
        float f4 = 1.0f;
        return this.field_76579_a.func_82732_R().func_72345_a(f2 *= f * 0.94f + 0.06f, f3 *= f * 0.94f + 0.06f, f4 *= f * 0.91f + 0.09f);
    }

    public boolean func_76567_e() {
        return true;
    }

    public static WorldProvider func_76570_a(int p_76570_0_) {
        if (p_76570_0_ == -1) {
            return new WorldProviderHell();
        }
        if (p_76570_0_ == 0) {
            return new WorldProviderSurface();
        }
        if (p_76570_0_ == 1) {
            return new WorldProviderEnd();
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public float func_76571_f() {
        return 128.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_76561_g() {
        return true;
    }

    public ChunkCoordinates func_76554_h() {
        return null;
    }

    public int func_76557_i() {
        if (this.field_76577_b == WorldType.field_77138_c) {
            return 4;
        }
        return 64;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_76564_j() {
        return this.field_76577_b != WorldType.field_77138_c && !this.field_76576_e;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_76565_k() {
        if (this.field_76577_b == WorldType.field_77138_c) {
            return 1.0;
        }
        return 0.03125;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_76568_b(int p_76568_1_, int p_76568_2_) {
        return false;
    }

    public abstract String func_80007_l();
}

