/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.village;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.village.Village;
import net.minecraft.village.VillageDoorInfo;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;

public class VillageCollection
extends WorldSavedData {
    private World field_75556_a;
    private final List field_75554_b = new ArrayList();
    private final List field_75555_c = new ArrayList();
    private final List field_75552_d = new ArrayList();
    private int field_75553_e;

    public VillageCollection(String p_i1677_1_) {
        super(p_i1677_1_);
    }

    public VillageCollection(World p_i1678_1_) {
        super("villages");
        this.field_75556_a = p_i1678_1_;
        this.func_76185_a();
    }

    public void func_82566_a(World p_82566_1_) {
        this.field_75556_a = p_82566_1_;
        for (Village village : this.field_75552_d) {
            village.func_82691_a(p_82566_1_);
        }
    }

    public void func_75551_a(int p_75551_1_, int p_75551_2_, int p_75551_3_) {
        if (this.field_75554_b.size() > 64) {
            return;
        }
        if (!this.func_75548_d(p_75551_1_, p_75551_2_, p_75551_3_)) {
            this.field_75554_b.add(new ChunkCoordinates(p_75551_1_, p_75551_2_, p_75551_3_));
        }
    }

    public void func_75544_a() {
        ++this.field_75553_e;
        for (Village village : this.field_75552_d) {
            village.func_75560_a(this.field_75553_e);
        }
        this.func_75549_c();
        this.func_75543_d();
        this.func_75545_e();
        if (this.field_75553_e % 400 == 0) {
            this.func_76185_a();
        }
    }

    private void func_75549_c() {
        Iterator iterator = this.field_75552_d.iterator();
        while (iterator.hasNext()) {
            Village village = (Village)iterator.next();
            if (!village.func_75566_g()) continue;
            iterator.remove();
            this.func_76185_a();
        }
    }

    public List func_75540_b() {
        return this.field_75552_d;
    }

    public Village func_75550_a(int p_75550_1_, int p_75550_2_, int p_75550_3_, int p_75550_4_) {
        Village village = null;
        float f = Float.MAX_VALUE;
        for (Village village2 : this.field_75552_d) {
            float f2;
            float f3 = village2.func_75577_a().func_71569_e(p_75550_1_, p_75550_2_, p_75550_3_);
            if (f3 >= f || f3 > (f2 = (float)(p_75550_4_ + village2.func_75568_b())) * f2) continue;
            village = village2;
            f = f3;
        }
        return village;
    }

    private void func_75543_d() {
        if (this.field_75554_b.isEmpty()) {
            return;
        }
        this.func_75546_a((ChunkCoordinates)this.field_75554_b.remove(0));
    }

    private void func_75545_e() {
        for (int i = 0; i < this.field_75555_c.size(); ++i) {
            VillageDoorInfo villageDoorInfo = (VillageDoorInfo)this.field_75555_c.get(i);
            boolean bl = false;
            for (Village village : this.field_75552_d) {
                int n;
                int n2 = (int)village.func_75577_a().func_71569_e(villageDoorInfo.field_75481_a, villageDoorInfo.field_75479_b, villageDoorInfo.field_75480_c);
                if (n2 > (n = 32 + village.func_75568_b()) * n) continue;
                village.func_75576_a(villageDoorInfo);
                bl = true;
                break;
            }
            if (bl) continue;
            Village village = new Village(this.field_75556_a);
            village.func_75576_a(villageDoorInfo);
            this.field_75552_d.add(village);
            this.func_76185_a();
        }
        this.field_75555_c.clear();
    }

    private void func_75546_a(ChunkCoordinates p_75546_1_) {
        int n = 16;
        int n2 = 4;
        int n3 = 16;
        for (int i = p_75546_1_.field_71574_a - n; i < p_75546_1_.field_71574_a + n; ++i) {
            for (int j = p_75546_1_.field_71572_b - n2; j < p_75546_1_.field_71572_b + n2; ++j) {
                for (int k = p_75546_1_.field_71573_c - n3; k < p_75546_1_.field_71573_c + n3; ++k) {
                    if (!this.func_75541_e(i, j, k)) continue;
                    VillageDoorInfo villageDoorInfo = this.func_75547_b(i, j, k);
                    if (villageDoorInfo == null) {
                        this.func_75542_c(i, j, k);
                        continue;
                    }
                    villageDoorInfo.field_75475_f = this.field_75553_e;
                }
            }
        }
    }

    private VillageDoorInfo func_75547_b(int p_75547_1_, int p_75547_2_, int p_75547_3_) {
        for (Object object : this.field_75555_c) {
            if (((VillageDoorInfo)object).field_75481_a != p_75547_1_ || ((VillageDoorInfo)object).field_75480_c != p_75547_3_ || Math.abs(((VillageDoorInfo)object).field_75479_b - p_75547_2_) > 1) continue;
            return object;
        }
        for (Object object : this.field_75552_d) {
            VillageDoorInfo villageDoorInfo = ((Village)object).func_75578_e(p_75547_1_, p_75547_2_, p_75547_3_);
            if (villageDoorInfo == null) continue;
            return villageDoorInfo;
        }
        return null;
    }

    private void func_75542_c(int p_75542_1_, int p_75542_2_, int p_75542_3_) {
        int n = ((BlockDoor)Block.field_72054_aE).func_72235_d(this.field_75556_a, p_75542_1_, p_75542_2_, p_75542_3_);
        if (n == 0 || n == 2) {
            int n2;
            int n3 = 0;
            for (n2 = -5; n2 < 0; ++n2) {
                if (!this.field_75556_a.func_72937_j(p_75542_1_ + n2, p_75542_2_, p_75542_3_)) continue;
                --n3;
            }
            for (n2 = 1; n2 <= 5; ++n2) {
                if (!this.field_75556_a.func_72937_j(p_75542_1_ + n2, p_75542_2_, p_75542_3_)) continue;
                ++n3;
            }
            if (n3 != 0) {
                this.field_75555_c.add(new VillageDoorInfo(p_75542_1_, p_75542_2_, p_75542_3_, n3 > 0 ? -2 : 2, 0, this.field_75553_e));
            }
        } else {
            int n4;
            int n5 = 0;
            for (n4 = -5; n4 < 0; ++n4) {
                if (!this.field_75556_a.func_72937_j(p_75542_1_, p_75542_2_, p_75542_3_ + n4)) continue;
                --n5;
            }
            for (n4 = 1; n4 <= 5; ++n4) {
                if (!this.field_75556_a.func_72937_j(p_75542_1_, p_75542_2_, p_75542_3_ + n4)) continue;
                ++n5;
            }
            if (n5 != 0) {
                this.field_75555_c.add(new VillageDoorInfo(p_75542_1_, p_75542_2_, p_75542_3_, 0, n5 > 0 ? -2 : 2, this.field_75553_e));
            }
        }
    }

    private boolean func_75548_d(int p_75548_1_, int p_75548_2_, int p_75548_3_) {
        for (ChunkCoordinates chunkCoordinates : this.field_75554_b) {
            if (chunkCoordinates.field_71574_a != p_75548_1_ || chunkCoordinates.field_71572_b != p_75548_2_ || chunkCoordinates.field_71573_c != p_75548_3_) continue;
            return true;
        }
        return false;
    }

    private boolean func_75541_e(int p_75541_1_, int p_75541_2_, int p_75541_3_) {
        int n = this.field_75556_a.func_72798_a(p_75541_1_, p_75541_2_, p_75541_3_);
        return n == Block.field_72054_aE.field_71990_ca;
    }

    @Override
    public void func_76184_a(NBTTagCompound p_76184_1_) {
        this.field_75553_e = p_76184_1_.func_74762_e("Tick");
        NBTTagList nBTTagList = p_76184_1_.func_74761_m("Villages");
        for (int i = 0; i < nBTTagList.func_74745_c(); ++i) {
            NBTTagCompound nBTTagCompound = (NBTTagCompound)nBTTagList.func_74743_b(i);
            Village village = new Village();
            village.func_82690_a(nBTTagCompound);
            this.field_75552_d.add(village);
        }
    }

    @Override
    public void func_76187_b(NBTTagCompound p_76187_1_) {
        p_76187_1_.func_74768_a("Tick", this.field_75553_e);
        NBTTagList nBTTagList = new NBTTagList("Villages");
        for (Village village : this.field_75552_d) {
            NBTTagCompound nBTTagCompound = new NBTTagCompound("Village");
            village.func_82689_b(nBTTagCompound);
            nBTTagList.func_74742_a(nBTTagCompound);
        }
        p_76187_1_.func_74782_a("Villages", nBTTagList);
    }
}

