/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.IProgressUpdate;
import net.minecraft.util.LongHashMap;
import net.minecraft.util.ReportedException;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.MinecraftException;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.EmptyChunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.chunk.storage.IChunkLoader;

public class ChunkProviderServer
implements IChunkProvider {
    private Set field_73248_b = new HashSet();
    private Chunk field_73249_c;
    private IChunkProvider field_73246_d;
    public IChunkLoader field_73247_e;
    public boolean field_73250_a = true;
    private LongHashMap field_73244_f = new LongHashMap();
    private List field_73245_g = new ArrayList();
    private WorldServer field_73251_h;

    public ChunkProviderServer(WorldServer p_i1520_1_, IChunkLoader p_i1520_2_, IChunkProvider p_i1520_3_) {
        this.field_73249_c = new EmptyChunk(p_i1520_1_, 0, 0);
        this.field_73251_h = p_i1520_1_;
        this.field_73247_e = p_i1520_2_;
        this.field_73246_d = p_i1520_3_;
    }

    @Override
    public boolean func_73149_a(int p_73149_1_, int p_73149_2_) {
        return this.field_73244_f.func_76161_b(ChunkCoordIntPair.func_77272_a(p_73149_1_, p_73149_2_));
    }

    public void func_73241_b(int p_73241_1_, int p_73241_2_) {
        if (this.field_73251_h.field_73011_w.func_76567_e()) {
            ChunkCoordinates chunkCoordinates = this.field_73251_h.func_72861_E();
            int n = p_73241_1_ * 16 + 8 - chunkCoordinates.field_71574_a;
            int n2 = p_73241_2_ * 16 + 8 - chunkCoordinates.field_71573_c;
            int n3 = 128;
            if (n < -n3 || n > n3 || n2 < -n3 || n2 > n3) {
                this.field_73248_b.add(ChunkCoordIntPair.func_77272_a(p_73241_1_, p_73241_2_));
            }
        } else {
            this.field_73248_b.add(ChunkCoordIntPair.func_77272_a(p_73241_1_, p_73241_2_));
        }
    }

    public void func_73240_a() {
        for (Chunk chunk : this.field_73245_g) {
            this.func_73241_b(chunk.field_76635_g, chunk.field_76647_h);
        }
    }

    @Override
    public Chunk func_73158_c(int p_73158_1_, int p_73158_2_) {
        long l = ChunkCoordIntPair.func_77272_a(p_73158_1_, p_73158_2_);
        this.field_73248_b.remove(l);
        Chunk chunk = (Chunk)this.field_73244_f.func_76164_a(l);
        if (chunk == null) {
            chunk = this.func_73239_e(p_73158_1_, p_73158_2_);
            if (chunk == null) {
                if (this.field_73246_d == null) {
                    chunk = this.field_73249_c;
                } else {
                    try {
                        chunk = this.field_73246_d.func_73154_d(p_73158_1_, p_73158_2_);
                    }
                    catch (Throwable throwable) {
                        CrashReport crashReport = CrashReport.func_85055_a(throwable, "Exception generating new chunk");
                        CrashReportCategory crashReportCategory = crashReport.func_85058_a("Chunk to be generated");
                        crashReportCategory.func_71507_a("Location", String.format("%d,%d", p_73158_1_, p_73158_2_));
                        crashReportCategory.func_71507_a("Position hash", l);
                        crashReportCategory.func_71507_a("Generator", this.field_73246_d.func_73148_d());
                        throw new ReportedException(crashReport);
                    }
                }
            }
            this.field_73244_f.func_76163_a(l, chunk);
            this.field_73245_g.add(chunk);
            if (chunk != null) {
                chunk.func_76631_c();
            }
            chunk.func_76624_a(this, this, p_73158_1_, p_73158_2_);
        }
        return chunk;
    }

    @Override
    public Chunk func_73154_d(int p_73154_1_, int p_73154_2_) {
        Chunk chunk = (Chunk)this.field_73244_f.func_76164_a(ChunkCoordIntPair.func_77272_a(p_73154_1_, p_73154_2_));
        if (chunk == null) {
            if (this.field_73251_h.field_72987_B || this.field_73250_a) {
                return this.func_73158_c(p_73154_1_, p_73154_2_);
            }
            return this.field_73249_c;
        }
        return chunk;
    }

    private Chunk func_73239_e(int p_73239_1_, int p_73239_2_) {
        if (this.field_73247_e == null) {
            return null;
        }
        try {
            Chunk chunk = this.field_73247_e.func_75815_a(this.field_73251_h, p_73239_1_, p_73239_2_);
            if (chunk != null) {
                chunk.field_76641_n = this.field_73251_h.func_82737_E();
                if (this.field_73246_d != null) {
                    this.field_73246_d.func_82695_e(p_73239_1_, p_73239_2_);
                }
            }
            return chunk;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private void func_73243_a(Chunk p_73243_1_) {
        if (this.field_73247_e == null) {
            return;
        }
        try {
            this.field_73247_e.func_75819_b(this.field_73251_h, p_73243_1_);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void func_73242_b(Chunk p_73242_1_) {
        if (this.field_73247_e == null) {
            return;
        }
        try {
            p_73242_1_.field_76641_n = this.field_73251_h.func_82737_E();
            this.field_73247_e.func_75816_a(this.field_73251_h, p_73242_1_);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (MinecraftException minecraftException) {
            minecraftException.printStackTrace();
        }
    }

    @Override
    public void func_73153_a(IChunkProvider p_73153_1_, int p_73153_2_, int p_73153_3_) {
        Chunk chunk = this.func_73154_d(p_73153_2_, p_73153_3_);
        if (!chunk.field_76646_k) {
            chunk.field_76646_k = true;
            if (this.field_73246_d != null) {
                this.field_73246_d.func_73153_a(p_73153_1_, p_73153_2_, p_73153_3_);
                chunk.func_76630_e();
            }
        }
    }

    @Override
    public boolean func_73151_a(boolean p_73151_1_, IProgressUpdate p_73151_2_) {
        int n = 0;
        for (int i = 0; i < this.field_73245_g.size(); ++i) {
            Chunk chunk = (Chunk)this.field_73245_g.get(i);
            if (p_73151_1_) {
                this.func_73243_a(chunk);
            }
            if (!chunk.func_76601_a(p_73151_1_)) continue;
            this.func_73242_b(chunk);
            chunk.field_76643_l = false;
            if (++n != 24 || p_73151_1_) continue;
            return false;
        }
        return true;
    }

    @Override
    public void func_104112_b() {
        if (this.field_73247_e != null) {
            this.field_73247_e.func_75818_b();
        }
    }

    @Override
    public boolean func_73156_b() {
        if (!this.field_73251_h.field_73058_d) {
            for (int i = 0; i < 100; ++i) {
                if (this.field_73248_b.isEmpty()) continue;
                Long l = (Long)this.field_73248_b.iterator().next();
                Chunk chunk = (Chunk)this.field_73244_f.func_76164_a(l);
                chunk.func_76623_d();
                this.func_73242_b(chunk);
                this.func_73243_a(chunk);
                this.field_73248_b.remove(l);
                this.field_73244_f.func_76159_d(l);
                this.field_73245_g.remove(chunk);
            }
            if (this.field_73247_e != null) {
                this.field_73247_e.func_75817_a();
            }
        }
        return this.field_73246_d.func_73156_b();
    }

    @Override
    public boolean func_73157_c() {
        return !this.field_73251_h.field_73058_d;
    }

    @Override
    public String func_73148_d() {
        return "ServerChunkCache: " + this.field_73244_f.func_76162_a() + " Drop: " + this.field_73248_b.size();
    }

    @Override
    public List func_73155_a(EnumCreatureType p_73155_1_, int p_73155_2_, int p_73155_3_, int p_73155_4_) {
        return this.field_73246_d.func_73155_a(p_73155_1_, p_73155_2_, p_73155_3_, p_73155_4_);
    }

    @Override
    public ChunkPosition func_73150_a(World p_73150_1_, String p_73150_2_, int p_73150_3_, int p_73150_4_, int p_73150_5_) {
        return this.field_73246_d.func_73150_a(p_73150_1_, p_73150_2_, p_73150_3_, p_73150_4_, p_73150_5_);
    }

    @Override
    public int func_73152_e() {
        return this.field_73244_f.func_76162_a();
    }

    @Override
    public void func_82695_e(int p_82695_1_, int p_82695_2_) {
    }
}

