/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagEnd;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.ReportedException;

public abstract class NBTBase {
    public static final String[] field_82578_b = new String[]{"END", "BYTE", "SHORT", "INT", "LONG", "FLOAT", "DOUBLE", "BYTE[]", "STRING", "LIST", "COMPOUND", "INT[]"};
    private String field_74741_a;

    abstract void func_74734_a(DataOutput var1) throws IOException;

    abstract void func_74735_a(DataInput var1, int var2) throws IOException;

    public abstract byte func_74732_a();

    protected NBTBase(String p_i1391_1_) {
        this.field_74741_a = p_i1391_1_ == null ? "" : p_i1391_1_;
    }

    public NBTBase func_74738_o(String p_74738_1_) {
        this.field_74741_a = p_74738_1_ == null ? "" : p_74738_1_;
        return this;
    }

    public String func_74740_e() {
        if (this.field_74741_a == null) {
            return "";
        }
        return this.field_74741_a;
    }

    public static NBTBase func_74739_b(DataInput p_74739_0_) throws IOException {
        return NBTBase.func_130104_b(p_74739_0_, 0);
    }

    public static NBTBase func_130104_b(DataInput p_130104_0_, int p_130104_1_) throws IOException {
        byte by = p_130104_0_.readByte();
        if (by == 0) {
            return new NBTTagEnd();
        }
        String string = p_130104_0_.readUTF();
        NBTBase nBTBase = NBTBase.func_74733_a(by, string);
        try {
            nBTBase.func_74735_a(p_130104_0_, p_130104_1_);
        }
        catch (IOException iOException) {
            CrashReport crashReport = CrashReport.func_85055_a(iOException, "Loading NBT data");
            CrashReportCategory crashReportCategory = crashReport.func_85058_a("NBT Tag");
            crashReportCategory.func_71507_a("Tag name", string);
            crashReportCategory.func_71507_a("Tag type", by);
            throw new ReportedException(crashReport);
        }
        return nBTBase;
    }

    public static void func_74731_a(NBTBase p_74731_0_, DataOutput p_74731_1_) throws IOException {
        p_74731_1_.writeByte(p_74731_0_.func_74732_a());
        if (p_74731_0_.func_74732_a() == 0) {
            return;
        }
        p_74731_1_.writeUTF(p_74731_0_.func_74740_e());
        p_74731_0_.func_74734_a(p_74731_1_);
    }

    public static NBTBase func_74733_a(byte p_74733_0_, String p_74733_1_) {
        switch (p_74733_0_) {
            case 0: {
                return new NBTTagEnd();
            }
            case 1: {
                return new NBTTagByte(p_74733_1_);
            }
            case 2: {
                return new NBTTagShort(p_74733_1_);
            }
            case 3: {
                return new NBTTagInt(p_74733_1_);
            }
            case 4: {
                return new NBTTagLong(p_74733_1_);
            }
            case 5: {
                return new NBTTagFloat(p_74733_1_);
            }
            case 6: {
                return new NBTTagDouble(p_74733_1_);
            }
            case 7: {
                return new NBTTagByteArray(p_74733_1_);
            }
            case 11: {
                return new NBTTagIntArray(p_74733_1_);
            }
            case 8: {
                return new NBTTagString(p_74733_1_);
            }
            case 9: {
                return new NBTTagList(p_74733_1_);
            }
            case 10: {
                return new NBTTagCompound(p_74733_1_);
            }
        }
        return null;
    }

    public static String func_74736_a(byte p_74736_0_) {
        switch (p_74736_0_) {
            case 0: {
                return "TAG_End";
            }
            case 1: {
                return "TAG_Byte";
            }
            case 2: {
                return "TAG_Short";
            }
            case 3: {
                return "TAG_Int";
            }
            case 4: {
                return "TAG_Long";
            }
            case 5: {
                return "TAG_Float";
            }
            case 6: {
                return "TAG_Double";
            }
            case 7: {
                return "TAG_Byte_Array";
            }
            case 11: {
                return "TAG_Int_Array";
            }
            case 8: {
                return "TAG_String";
            }
            case 9: {
                return "TAG_List";
            }
            case 10: {
                return "TAG_Compound";
            }
        }
        return "UNKNOWN";
    }

    public abstract NBTBase func_74737_b();

    public boolean equals(Object p_equals_1_) {
        if (!(p_equals_1_ instanceof NBTBase)) {
            return false;
        }
        NBTBase nBTBase = (NBTBase)p_equals_1_;
        if (this.func_74732_a() != nBTBase.func_74732_a()) {
            return false;
        }
        if (this.field_74741_a == null && nBTBase.field_74741_a != null || this.field_74741_a != null && nBTBase.field_74741_a == null) {
            return false;
        }
        return this.field_74741_a == null || this.field_74741_a.equals(nBTBase.field_74741_a);
    }

    public int hashCode() {
        return this.field_74741_a.hashCode() ^ this.func_74732_a();
    }
}

