/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client;

import com.google.common.collect.Lists;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.Proxy;
import java.nio.ByteBuffer;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import javax.imageio.ImageIO;
import net.minecraft.block.Block;
import net.minecraft.client.CallableClientMemoryStats;
import net.minecraft.client.CallableClientProfiler;
import net.minecraft.client.CallableGLInfo;
import net.minecraft.client.CallableLWJGLVersion;
import net.minecraft.client.CallableLaunchedVersion;
import net.minecraft.client.CallableModded;
import net.minecraft.client.CallableParticleScreenName;
import net.minecraft.client.CallableTexturePack;
import net.minecraft.client.CallableType2;
import net.minecraft.client.CallableUpdatingScreenName;
import net.minecraft.client.ClientBrandRetriever;
import net.minecraft.client.MinecraftINNER13;
import net.minecraft.client.StatStringFormatKeyInv;
import net.minecraft.client.ThreadClientSleep;
import net.minecraft.client.audio.SoundManager;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiChat;
import net.minecraft.client.gui.GuiGameOver;
import net.minecraft.client.gui.GuiIngame;
import net.minecraft.client.gui.GuiIngameMenu;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.client.gui.GuiMemoryErrorScreen;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiSleepMP;
import net.minecraft.client.gui.LoadingScreenRenderer;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.gui.achievement.GuiAchievement;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.client.multiplayer.GuiConnecting;
import net.minecraft.client.multiplayer.NetClientHandler;
import net.minecraft.client.multiplayer.PlayerControllerMP;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.resources.DefaultResourcePack;
import net.minecraft.client.resources.FoliageColorReloadListener;
import net.minecraft.client.resources.GrassColorReloadListener;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.resources.LanguageManager;
import net.minecraft.client.resources.ReloadableResourceManager;
import net.minecraft.client.resources.ResourceManager;
import net.minecraft.client.resources.ResourcePackRepository;
import net.minecraft.client.resources.ResourcePackRepositoryEntry;
import net.minecraft.client.resources.SimpleReloadableResourceManager;
import net.minecraft.client.resources.data.AnimationMetadataSection;
import net.minecraft.client.resources.data.AnimationMetadataSectionSerializer;
import net.minecraft.client.resources.data.FontMetadataSection;
import net.minecraft.client.resources.data.FontMetadataSectionSerializer;
import net.minecraft.client.resources.data.LanguageMetadataSection;
import net.minecraft.client.resources.data.LanguageMetadataSectionSerializer;
import net.minecraft.client.resources.data.MetadataSerializer;
import net.minecraft.client.resources.data.PackMetadataSection;
import net.minecraft.client.resources.data.PackMetadataSectionSerializer;
import net.minecraft.client.resources.data.TextureMetadataSection;
import net.minecraft.client.resources.data.TextureMetadataSectionSerializer;
import net.minecraft.client.settings.EnumOptions;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.entity.EntityLeashKnot;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.item.EntityPainting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.logging.ILogAgent;
import net.minecraft.logging.LogAgent;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.MemoryConnection;
import net.minecraft.profiler.IPlayerUsage;
import net.minecraft.profiler.PlayerUsageSnooper;
import net.minecraft.profiler.Profiler;
import net.minecraft.profiler.ProfilerResult;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.integrated.IntegratedServer;
import net.minecraft.stats.AchievementList;
import net.minecraft.stats.StatFileWriter;
import net.minecraft.stats.StatList;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EnumMovingObjectType;
import net.minecraft.util.EnumOS;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MinecraftError;
import net.minecraft.util.MouseHelper;
import net.minecraft.util.MovementInputFromOptions;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.ReportedException;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.ScreenShotHelper;
import net.minecraft.util.Session;
import net.minecraft.util.Timer;
import net.minecraft.util.Util;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.chunk.storage.AnvilSaveConverter;
import net.minecraft.world.storage.ISaveFormat;
import net.minecraft.world.storage.ISaveHandler;
import net.minecraft.world.storage.WorldInfo;
import org.lwjgl.LWJGLException;
import org.lwjgl.Sys;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.ContextCapabilities;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.DisplayMode;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GLContext;
import org.lwjgl.opengl.PixelFormat;
import org.lwjgl.util.glu.GLU;

@SideOnly(value=Side.CLIENT)
public class Minecraft
implements IPlayerUsage {
    private static final ResourceLocation field_110444_H = new ResourceLocation("textures/gui/title/mojang.png");
    public static final boolean field_142025_a = Util.func_110647_a() == EnumOS.MACOS;
    public static byte[] field_71444_a = new byte[0xA00000];
    private static final List field_110445_I = Lists.newArrayList((Object[])new DisplayMode[]{new DisplayMode(2560, 1600), new DisplayMode(2880, 1800)});
    private final ILogAgent field_94139_O;
    private final File field_130070_K;
    private ServerData field_71422_O;
    public TextureManager field_71446_o;
    private static Minecraft field_71432_P;
    public PlayerControllerMP field_71442_b;
    private boolean field_71431_Q;
    private boolean field_71434_R;
    private CrashReport field_71433_S;
    public int field_71443_c;
    public int field_71440_d;
    private Timer field_71428_T = new Timer(20.0f);
    private PlayerUsageSnooper field_71427_U = new PlayerUsageSnooper("client", this, MinecraftServer.func_130071_aq());
    public WorldClient field_71441_e;
    public RenderGlobal field_71438_f;
    public EntityClientPlayerMP field_71439_g;
    public EntityLivingBase field_71451_h;
    public EntityLivingBase field_96291_i;
    public EffectRenderer field_71452_i;
    private final Session field_71449_j;
    private boolean field_71445_n;
    public FontRenderer field_71466_p;
    public FontRenderer field_71464_q;
    public GuiScreen field_71462_r;
    public LoadingScreenRenderer field_71461_s;
    public EntityRenderer field_71460_t;
    private int field_71429_W;
    private int field_71436_X;
    private int field_71435_Y;
    private IntegratedServer field_71437_Z;
    public GuiAchievement field_71458_u;
    public GuiIngame field_71456_v;
    public boolean field_71454_w;
    public MovingObjectPosition field_71476_x;
    public GameSettings field_71474_y;
    public SoundManager field_71416_A;
    public MouseHelper field_71417_B;
    public final File field_71412_D;
    private final File field_110446_Y;
    private final String field_110447_Z;
    private final Proxy field_110453_aa;
    private ISaveFormat field_71469_aa;
    private static int field_71470_ab;
    private int field_71467_ac;
    private boolean field_71468_ad;
    public StatFileWriter field_71413_E;
    private String field_71475_ae;
    private int field_71477_af;
    boolean field_71414_F;
    public boolean field_71415_G;
    long field_71423_H = Minecraft.func_71386_F();
    private int field_71457_ai;
    private final boolean field_71459_aj;
    private INetworkManager field_71453_ak;
    private boolean field_71455_al;
    public final Profiler field_71424_I = new Profiler();
    private long field_83002_am = -1L;
    private ReloadableResourceManager field_110451_am;
    private final MetadataSerializer field_110452_an = new MetadataSerializer();
    private List field_110449_ao = Lists.newArrayList();
    private DefaultResourcePack field_110450_ap;
    private ResourcePackRepository field_110448_aq;
    private LanguageManager field_135017_as;
    public volatile boolean field_71425_J = true;
    public String field_71426_K = "";
    long field_71419_L = Minecraft.func_71386_F();
    int field_71420_M;
    long field_71421_N = -1L;
    private String field_71465_an = "root";

    public Minecraft(Session p_i1014_1_, int p_i1014_2_, int p_i1014_3_, boolean p_i1014_4_, boolean p_i1014_5_, File p_i1014_6_, File p_i1014_7_, File p_i1014_8_, Proxy p_i1014_9_, String p_i1014_10_) {
        field_71432_P = this;
        this.field_94139_O = new LogAgent("Minecraft-Client", " [CLIENT]", new File(p_i1014_6_, "output-client.log").getAbsolutePath());
        this.field_71412_D = p_i1014_6_;
        this.field_110446_Y = p_i1014_7_;
        this.field_130070_K = p_i1014_8_;
        this.field_110447_Z = p_i1014_10_;
        this.field_110450_ap = new DefaultResourcePack(this.field_110446_Y);
        this.func_110435_P();
        this.field_110453_aa = p_i1014_9_;
        this.func_71389_H();
        this.field_71449_j = p_i1014_1_;
        this.field_94139_O.func_98233_a("Setting user: " + p_i1014_1_.func_111285_a());
        this.field_94139_O.func_98233_a("(Session ID is " + p_i1014_1_.func_111286_b() + ")");
        this.field_71459_aj = p_i1014_5_;
        this.field_71443_c = p_i1014_2_;
        this.field_71440_d = p_i1014_3_;
        this.field_71436_X = p_i1014_2_;
        this.field_71435_Y = p_i1014_3_;
        this.field_71431_Q = p_i1014_4_;
        ImageIO.setUseCache(false);
        StatList.func_75919_a();
    }

    private void func_71389_H() {
        ThreadClientSleep threadClientSleep = new ThreadClientSleep(this, "Timer hack thread");
        threadClientSleep.setDaemon(true);
        threadClientSleep.start();
    }

    public void func_71404_a(CrashReport p_71404_1_) {
        this.field_71434_R = true;
        this.field_71433_S = p_71404_1_;
    }

    public void func_71377_b(CrashReport p_71377_1_) {
        File file = new File(Minecraft.func_71410_x().field_71412_D, "crash-reports");
        File file2 = new File(file, "crash-" + new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss").format(new Date()) + "-client.txt");
        System.out.println(p_71377_1_.func_71502_e());
        if (p_71377_1_.func_71497_f() != null) {
            System.out.println("#@!@# Game crashed! Crash report saved to: #@!@# " + p_71377_1_.func_71497_f());
            System.exit(-1);
        } else if (p_71377_1_.func_71508_a(file2, this.func_98033_al())) {
            System.out.println("#@!@# Game crashed! Crash report saved to: #@!@# " + file2.getAbsolutePath());
            System.exit(-1);
        } else {
            System.out.println("#@?@# Game crashed! Crash report could not be saved. #@?@#");
            System.exit(-2);
        }
    }

    public void func_71367_a(String p_71367_1_, int p_71367_2_) {
        this.field_71475_ae = p_71367_1_;
        this.field_71477_af = p_71367_2_;
    }

    private void func_71384_a() throws LWJGLException {
        this.field_71474_y = new GameSettings(this, this.field_71412_D);
        if (this.field_71474_y.field_92119_C > 0 && this.field_71474_y.field_92118_B > 0) {
            this.field_71443_c = this.field_71474_y.field_92118_B;
            this.field_71440_d = this.field_71474_y.field_92119_C;
        }
        if (this.field_71431_Q) {
            Display.setFullscreen((boolean)true);
            this.field_71443_c = Display.getDisplayMode().getWidth();
            this.field_71440_d = Display.getDisplayMode().getHeight();
            if (this.field_71443_c <= 0) {
                this.field_71443_c = 1;
            }
            if (this.field_71440_d <= 0) {
                this.field_71440_d = 1;
            }
        } else {
            Display.setDisplayMode((DisplayMode)new DisplayMode(this.field_71443_c, this.field_71440_d));
        }
        Display.setResizable((boolean)true);
        Display.setTitle((String)"Minecraft 1.6.4");
        this.func_98033_al().func_98233_a("LWJGL Version: " + Sys.getVersion());
        if (Util.func_110647_a() != EnumOS.MACOS) {
            try {
                Display.setIcon((ByteBuffer[])new ByteBuffer[]{this.func_110439_b(new File(this.field_110446_Y, "/icons/icon_16x16.png")), this.func_110439_b(new File(this.field_110446_Y, "/icons/icon_32x32.png"))});
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        try {
            Display.create((PixelFormat)new PixelFormat().withDepthBits(24));
        }
        catch (LWJGLException lWJGLException) {
            lWJGLException.printStackTrace();
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.field_71431_Q) {
                this.func_110441_Q();
            }
            Display.create();
        }
        OpenGlHelper.func_77474_a();
        this.field_71458_u = new GuiAchievement(this);
        this.field_110452_an.func_110504_a(new TextureMetadataSectionSerializer(), TextureMetadataSection.class);
        this.field_110452_an.func_110504_a(new FontMetadataSectionSerializer(), FontMetadataSection.class);
        this.field_110452_an.func_110504_a(new AnimationMetadataSectionSerializer(), AnimationMetadataSection.class);
        this.field_110452_an.func_110504_a(new PackMetadataSectionSerializer(), PackMetadataSection.class);
        this.field_110452_an.func_110504_a(new LanguageMetadataSectionSerializer(), LanguageMetadataSection.class);
        this.field_71469_aa = new AnvilSaveConverter(new File(this.field_71412_D, "saves"));
        this.field_110448_aq = new ResourcePackRepository(this.field_130070_K, this.field_110450_ap, this.field_110452_an, this.field_71474_y);
        this.field_110451_am = new SimpleReloadableResourceManager(this.field_110452_an);
        this.field_135017_as = new LanguageManager(this.field_110452_an, this.field_71474_y.field_74363_ab);
        this.field_110451_am.func_110542_a(this.field_135017_as);
        this.func_110436_a();
        this.field_71446_o = new TextureManager(this.field_110451_am);
        this.field_110451_am.func_110542_a(this.field_71446_o);
        this.field_71416_A = new SoundManager(this.field_110451_am, this.field_71474_y, this.field_110446_Y);
        this.field_110451_am.func_110542_a(this.field_71416_A);
        this.func_71357_I();
        this.field_71466_p = new FontRenderer(this.field_71474_y, new ResourceLocation("textures/font/ascii.png"), this.field_71446_o, false);
        if (this.field_71474_y.field_74363_ab != null) {
            this.field_71466_p.func_78264_a(this.field_135017_as.func_135042_a());
            this.field_71466_p.func_78275_b(this.field_135017_as.func_135044_b());
        }
        this.field_71464_q = new FontRenderer(this.field_71474_y, new ResourceLocation("textures/font/ascii_sga.png"), this.field_71446_o, false);
        this.field_110451_am.func_110542_a(this.field_71466_p);
        this.field_110451_am.func_110542_a(this.field_71464_q);
        this.field_110451_am.func_110542_a(new GrassColorReloadListener());
        this.field_110451_am.func_110542_a(new FoliageColorReloadListener());
        RenderManager.field_78727_a.field_78721_f = new ItemRenderer(this);
        this.field_71460_t = new EntityRenderer(this);
        this.field_71413_E = new StatFileWriter(this.field_71449_j, this.field_71412_D);
        AchievementList.field_76004_f.func_75988_a(new StatStringFormatKeyInv(this));
        this.field_71417_B = new MouseHelper();
        this.func_71361_d("Pre startup");
        GL11.glEnable((int)3553);
        GL11.glShadeModel((int)7425);
        GL11.glClearDepth((double)1.0);
        GL11.glEnable((int)2929);
        GL11.glDepthFunc((int)515);
        GL11.glEnable((int)3008);
        GL11.glAlphaFunc((int)516, (float)0.1f);
        GL11.glCullFace((int)1029);
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glMatrixMode((int)5888);
        this.func_71361_d("Startup");
        this.field_71438_f = new RenderGlobal(this);
        this.field_71446_o.func_130088_a(TextureMap.field_110575_b, new TextureMap(0, "textures/blocks"));
        this.field_71446_o.func_130088_a(TextureMap.field_110576_c, new TextureMap(1, "textures/items"));
        GL11.glViewport((int)0, (int)0, (int)this.field_71443_c, (int)this.field_71440_d);
        this.field_71452_i = new EffectRenderer(this.field_71441_e, this.field_71446_o);
        this.func_71361_d("Post startup");
        this.field_71456_v = new GuiIngame(this);
        if (this.field_71475_ae != null) {
            this.func_71373_a(new GuiConnecting(new GuiMainMenu(), this, this.field_71475_ae, this.field_71477_af));
        } else {
            this.func_71373_a(new GuiMainMenu());
        }
        this.field_71461_s = new LoadingScreenRenderer(this);
        if (this.field_71474_y.field_74353_u && !this.field_71431_Q) {
            this.func_71352_k();
        }
    }

    public void func_110436_a() {
        ArrayList arrayList = Lists.newArrayList((Iterable)this.field_110449_ao);
        for (ResourcePackRepositoryEntry resourcePackRepositoryEntry : this.field_110448_aq.func_110613_c()) {
            arrayList.add(resourcePackRepositoryEntry.func_110514_c());
        }
        this.field_135017_as.func_135043_a(arrayList);
        this.field_110451_am.func_110541_a(arrayList);
        if (this.field_71438_f != null) {
            this.field_71438_f.func_72712_a();
        }
    }

    private void func_110435_P() {
        this.field_110449_ao.add(this.field_110450_ap);
    }

    private ByteBuffer func_110439_b(File p_110439_1_) throws IOException {
        BufferedImage bufferedImage = ImageIO.read(p_110439_1_);
        int[] nArray = bufferedImage.getRGB(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight(), null, 0, bufferedImage.getWidth());
        ByteBuffer byteBuffer = ByteBuffer.allocate(4 * nArray.length);
        for (int n : nArray) {
            byteBuffer.putInt(n << 8 | n >> 24 & 0xFF);
        }
        byteBuffer.flip();
        return byteBuffer;
    }

    private void func_110441_Q() throws LWJGLException {
        HashSet hashSet = new HashSet();
        Collections.addAll(hashSet, Display.getAvailableDisplayModes());
        DisplayMode displayMode = Display.getDesktopDisplayMode();
        if (!hashSet.contains(displayMode) && Util.func_110647_a() == EnumOS.MACOS) {
            block0: for (DisplayMode displayMode2 : field_110445_I) {
                boolean bl = true;
                for (DisplayMode displayMode3 : hashSet) {
                    if (displayMode3.getBitsPerPixel() != 32 || displayMode3.getWidth() != displayMode2.getWidth() || displayMode3.getHeight() != displayMode2.getHeight()) continue;
                    bl = false;
                    break;
                }
                if (bl) continue;
                for (DisplayMode displayMode3 : hashSet) {
                    if (displayMode3.getBitsPerPixel() != 32 || displayMode3.getWidth() != displayMode2.getWidth() / 2 || displayMode3.getHeight() != displayMode2.getHeight() / 2) continue;
                    displayMode = displayMode3;
                    continue block0;
                }
            }
        }
        Display.setDisplayMode((DisplayMode)displayMode);
        this.field_71443_c = displayMode.getWidth();
        this.field_71440_d = displayMode.getHeight();
    }

    private void func_71357_I() throws LWJGLException {
        ScaledResolution scaledResolution = new ScaledResolution(this.field_71474_y, this.field_71443_c, this.field_71440_d);
        GL11.glClear((int)16640);
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glOrtho((double)0.0, (double)scaledResolution.func_78327_c(), (double)scaledResolution.func_78324_d(), (double)0.0, (double)1000.0, (double)3000.0);
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-2000.0f);
        GL11.glViewport((int)0, (int)0, (int)this.field_71443_c, (int)this.field_71440_d);
        GL11.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        GL11.glDisable((int)2896);
        GL11.glEnable((int)3553);
        GL11.glDisable((int)2912);
        this.field_71446_o.func_110577_a(field_110444_H);
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78378_d(0xFFFFFF);
        tessellator.func_78374_a(0.0, this.field_71440_d, 0.0, 0.0, 0.0);
        tessellator.func_78374_a(this.field_71443_c, this.field_71440_d, 0.0, 0.0, 0.0);
        tessellator.func_78374_a(this.field_71443_c, 0.0, 0.0, 0.0, 0.0);
        tessellator.func_78374_a(0.0, 0.0, 0.0, 0.0, 0.0);
        tessellator.func_78381_a();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        tessellator.func_78378_d(0xFFFFFF);
        int n = 256;
        int n2 = 256;
        this.func_71392_a((scaledResolution.func_78326_a() - n) / 2, (scaledResolution.func_78328_b() - n2) / 2, 0, 0, n, n2);
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2912);
        GL11.glEnable((int)3008);
        GL11.glAlphaFunc((int)516, (float)0.1f);
        Display.update();
    }

    public void func_71392_a(int p_71392_1_, int p_71392_2_, int p_71392_3_, int p_71392_4_, int p_71392_5_, int p_71392_6_) {
        float f = 0.00390625f;
        float f2 = 0.00390625f;
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a(p_71392_1_ + 0, p_71392_2_ + p_71392_6_, 0.0, (float)(p_71392_3_ + 0) * f, (float)(p_71392_4_ + p_71392_6_) * f2);
        tessellator.func_78374_a(p_71392_1_ + p_71392_5_, p_71392_2_ + p_71392_6_, 0.0, (float)(p_71392_3_ + p_71392_5_) * f, (float)(p_71392_4_ + p_71392_6_) * f2);
        tessellator.func_78374_a(p_71392_1_ + p_71392_5_, p_71392_2_ + 0, 0.0, (float)(p_71392_3_ + p_71392_5_) * f, (float)(p_71392_4_ + 0) * f2);
        tessellator.func_78374_a(p_71392_1_ + 0, p_71392_2_ + 0, 0.0, (float)(p_71392_3_ + 0) * f, (float)(p_71392_4_ + 0) * f2);
        tessellator.func_78381_a();
    }

    public ISaveFormat func_71359_d() {
        return this.field_71469_aa;
    }

    public void func_71373_a(GuiScreen p_71373_1_) {
        if (this.field_71462_r != null) {
            this.field_71462_r.func_73874_b();
        }
        this.field_71413_E.func_77446_d();
        if (p_71373_1_ == null && this.field_71441_e == null) {
            p_71373_1_ = new GuiMainMenu();
        } else if (p_71373_1_ == null && this.field_71439_g.func_110143_aJ() <= 0.0f) {
            p_71373_1_ = new GuiGameOver();
        }
        if (p_71373_1_ instanceof GuiMainMenu) {
            this.field_71474_y.field_74330_P = false;
            this.field_71456_v.func_73827_b().func_73761_a();
        }
        this.field_71462_r = p_71373_1_;
        if (p_71373_1_ != null) {
            this.func_71364_i();
            ScaledResolution scaledResolution = new ScaledResolution(this.field_71474_y, this.field_71443_c, this.field_71440_d);
            int n = scaledResolution.func_78326_a();
            int n2 = scaledResolution.func_78328_b();
            p_71373_1_.func_73872_a(this, n, n2);
            this.field_71454_w = false;
        } else {
            this.func_71381_h();
        }
    }

    private void func_71361_d(String p_71361_1_) {
        int n = GL11.glGetError();
        if (n != 0) {
            String string = GLU.gluErrorString((int)n);
            this.func_98033_al().func_98232_c("########## GL ERROR ##########");
            this.func_98033_al().func_98232_c("@ " + p_71361_1_);
            this.func_98033_al().func_98232_c(n + ": " + string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_71405_e() {
        try {
            this.field_71413_E.func_77446_d();
            this.func_98033_al().func_98233_a("Stopping!");
            try {
                this.func_71403_a(null);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                GLAllocation.func_74525_a();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.field_71416_A.func_77370_b();
        }
        finally {
            Display.destroy();
            if (!this.field_71434_R) {
                System.exit(0);
            }
        }
        System.gc();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_99999_d() {
        this.field_71425_J = true;
        try {
            this.func_71384_a();
        }
        catch (Throwable throwable) {
            CrashReport crashReport = CrashReport.func_85055_a(throwable, "Initializing game");
            crashReport.func_85058_a("Initialization");
            this.func_71377_b(this.func_71396_d(crashReport));
            return;
        }
        try {
            while (this.field_71425_J) {
                if (this.field_71434_R && this.field_71433_S != null) {
                    this.func_71377_b(this.field_71433_S);
                    return;
                }
                if (this.field_71468_ad) {
                    this.field_71468_ad = false;
                    this.func_110436_a();
                }
                try {
                    this.func_71411_J();
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    this.func_71398_f();
                    this.func_71373_a(new GuiMemoryErrorScreen());
                    System.gc();
                }
            }
        }
        catch (MinecraftError minecraftError) {
        }
        catch (ReportedException reportedException) {
            this.func_71396_d(reportedException.func_71575_a());
            this.func_71398_f();
            reportedException.printStackTrace();
            this.func_71377_b(reportedException.func_71575_a());
        }
        catch (Throwable throwable) {
            CrashReport crashReport = this.func_71396_d(new CrashReport("Unexpected error", throwable));
            this.func_71398_f();
            throwable.printStackTrace();
            this.func_71377_b(crashReport);
        }
        finally {
            this.func_71405_e();
        }
    }

    private void func_71411_J() {
        AxisAlignedBB.func_72332_a().func_72298_a();
        if (this.field_71441_e != null) {
            this.field_71441_e.func_82732_R().func_72343_a();
        }
        this.field_71424_I.func_76320_a("root");
        if (Display.isCloseRequested()) {
            this.func_71400_g();
        }
        if (this.field_71445_n && this.field_71441_e != null) {
            float f = this.field_71428_T.field_74281_c;
            this.field_71428_T.func_74275_a();
            this.field_71428_T.field_74281_c = f;
        } else {
            this.field_71428_T.func_74275_a();
        }
        long l = System.nanoTime();
        this.field_71424_I.func_76320_a("tick");
        for (int i = 0; i < this.field_71428_T.field_74280_b; ++i) {
            this.func_71407_l();
        }
        this.field_71424_I.func_76318_c("preRenderErrors");
        long l2 = System.nanoTime() - l;
        this.func_71361_d("Pre render");
        RenderBlocks.field_78667_b = this.field_71474_y.field_74347_j;
        this.field_71424_I.func_76318_c("sound");
        this.field_71416_A.func_77369_a(this.field_71439_g, this.field_71428_T.field_74281_c);
        if (!this.field_71445_n) {
            this.field_71416_A.func_92071_g();
        }
        this.field_71424_I.func_76319_b();
        this.field_71424_I.func_76320_a("render");
        this.field_71424_I.func_76320_a("display");
        GL11.glEnable((int)3553);
        if (!Keyboard.isKeyDown((int)65)) {
            Display.update();
        }
        if (this.field_71439_g != null && this.field_71439_g.func_70094_T()) {
            this.field_71474_y.field_74320_O = 0;
        }
        this.field_71424_I.func_76319_b();
        if (!this.field_71454_w) {
            this.field_71424_I.func_76318_c("gameRenderer");
            this.field_71460_t.func_78480_b(this.field_71428_T.field_74281_c);
            this.field_71424_I.func_76319_b();
        }
        GL11.glFlush();
        this.field_71424_I.func_76319_b();
        if (!Display.isActive() && this.field_71431_Q) {
            this.func_71352_k();
        }
        if (this.field_71474_y.field_74330_P && this.field_71474_y.field_74329_Q) {
            if (!this.field_71424_I.field_76327_a) {
                this.field_71424_I.func_76317_a();
            }
            this.field_71424_I.field_76327_a = true;
            this.func_71366_a(l2);
        } else {
            this.field_71424_I.field_76327_a = false;
            this.field_71421_N = System.nanoTime();
        }
        this.field_71458_u.func_73847_a();
        this.field_71424_I.func_76320_a("root");
        Thread.yield();
        if (Keyboard.isKeyDown((int)65)) {
            Display.update();
        }
        this.func_71365_K();
        if (!this.field_71431_Q && Display.wasResized()) {
            this.field_71443_c = Display.getWidth();
            this.field_71440_d = Display.getHeight();
            if (this.field_71443_c <= 0) {
                this.field_71443_c = 1;
            }
            if (this.field_71440_d <= 0) {
                this.field_71440_d = 1;
            }
            this.func_71370_a(this.field_71443_c, this.field_71440_d);
        }
        this.func_71361_d("Post render");
        ++this.field_71420_M;
        boolean bl = this.field_71445_n;
        boolean bl2 = this.field_71445_n = this.func_71356_B() && this.field_71462_r != null && this.field_71462_r.func_73868_f() && !this.field_71437_Z.func_71344_c();
        if (this.func_71387_A() && this.field_71439_g != null && this.field_71439_g.field_71174_a != null && this.field_71445_n != bl) {
            ((MemoryConnection)this.field_71439_g.field_71174_a.func_72548_f()).func_74437_a(this.field_71445_n);
        }
        while (Minecraft.func_71386_F() >= this.field_71419_L + 1000L) {
            field_71470_ab = this.field_71420_M;
            this.field_71426_K = field_71470_ab + " fps, " + WorldRenderer.field_78922_b + " chunk updates";
            WorldRenderer.field_78922_b = 0;
            this.field_71419_L += 1000L;
            this.field_71420_M = 0;
            this.field_71427_U.func_76471_b();
            if (this.field_71427_U.func_76468_d()) continue;
            this.field_71427_U.func_76463_a();
        }
        this.field_71424_I.func_76319_b();
        if (this.func_90020_K() > 0) {
            Display.sync((int)EntityRenderer.func_78465_a(this.func_90020_K()));
        }
    }

    private int func_90020_K() {
        if (this.field_71462_r != null && this.field_71462_r instanceof GuiMainMenu) {
            return 2;
        }
        return this.field_71474_y.field_74350_i;
    }

    public void func_71398_f() {
        try {
            field_71444_a = new byte[0];
            this.field_71438_f.func_72728_f();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            System.gc();
            AxisAlignedBB.func_72332_a().func_72300_b();
            this.field_71441_e.func_82732_R().func_72344_b();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            System.gc();
            this.func_71403_a(null);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        System.gc();
    }

    private void func_71365_K() {
        if (Keyboard.isKeyDown((int)60)) {
            if (!this.field_71414_F) {
                this.field_71414_F = true;
                this.field_71456_v.func_73827_b().func_73765_a(ScreenShotHelper.func_74291_a(this.field_71412_D, this.field_71443_c, this.field_71440_d));
            }
        } else {
            this.field_71414_F = false;
        }
    }

    private void func_71383_b(int p_71383_1_) {
        List list = this.field_71424_I.func_76321_b(this.field_71465_an);
        if (list == null || list.isEmpty()) {
            return;
        }
        ProfilerResult profilerResult = (ProfilerResult)list.remove(0);
        if (p_71383_1_ == 0) {
            int n;
            if (profilerResult.field_76331_c.length() > 0 && (n = this.field_71465_an.lastIndexOf(".")) >= 0) {
                this.field_71465_an = this.field_71465_an.substring(0, n);
            }
        } else if (--p_71383_1_ < list.size() && !((ProfilerResult)list.get((int)p_71383_1_)).field_76331_c.equals("unspecified")) {
            if (this.field_71465_an.length() > 0) {
                this.field_71465_an = this.field_71465_an + ".";
            }
            this.field_71465_an = this.field_71465_an + ((ProfilerResult)list.get((int)p_71383_1_)).field_76331_c;
        }
    }

    private void func_71366_a(long p_71366_1_) {
        int n;
        Object object;
        if (!this.field_71424_I.field_76327_a) {
            return;
        }
        List list = this.field_71424_I.func_76321_b(this.field_71465_an);
        ProfilerResult profilerResult = (ProfilerResult)list.remove(0);
        GL11.glClear((int)256);
        GL11.glMatrixMode((int)5889);
        GL11.glEnable((int)2903);
        GL11.glLoadIdentity();
        GL11.glOrtho((double)0.0, (double)this.field_71443_c, (double)this.field_71440_d, (double)0.0, (double)1000.0, (double)3000.0);
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-2000.0f);
        GL11.glLineWidth((float)1.0f);
        GL11.glDisable((int)3553);
        Tessellator tessellator = Tessellator.field_78398_a;
        int n2 = 160;
        int n3 = this.field_71443_c - n2 - 10;
        int n4 = this.field_71440_d - n2 * 2;
        GL11.glEnable((int)3042);
        tessellator.func_78382_b();
        tessellator.func_78384_a(0, 200);
        tessellator.func_78377_a((float)n3 - (float)n2 * 1.1f, (float)n4 - (float)n2 * 0.6f - 16.0f, 0.0);
        tessellator.func_78377_a((float)n3 - (float)n2 * 1.1f, n4 + n2 * 2, 0.0);
        tessellator.func_78377_a((float)n3 + (float)n2 * 1.1f, n4 + n2 * 2, 0.0);
        tessellator.func_78377_a((float)n3 + (float)n2 * 1.1f, (float)n4 - (float)n2 * 0.6f - 16.0f, 0.0);
        tessellator.func_78381_a();
        GL11.glDisable((int)3042);
        double d = 0.0;
        for (int i = 0; i < list.size(); ++i) {
            float f;
            float f2;
            float f3;
            int n5;
            object = (ProfilerResult)list.get(i);
            n = MathHelper.func_76128_c(((ProfilerResult)object).field_76332_a / 4.0) + 1;
            tessellator.func_78371_b(6);
            tessellator.func_78378_d(((ProfilerResult)object).func_76329_a());
            tessellator.func_78377_a(n3, n4, 0.0);
            for (n5 = n; n5 >= 0; --n5) {
                f3 = (float)((d + ((ProfilerResult)object).field_76332_a * (double)n5 / (double)n) * 3.1415927410125732 * 2.0 / 100.0);
                f2 = MathHelper.func_76126_a(f3) * (float)n2;
                f = MathHelper.func_76134_b(f3) * (float)n2 * 0.5f;
                tessellator.func_78377_a((float)n3 + f2, (float)n4 - f, 0.0);
            }
            tessellator.func_78381_a();
            tessellator.func_78371_b(5);
            tessellator.func_78378_d((((ProfilerResult)object).func_76329_a() & 0xFEFEFE) >> 1);
            for (n5 = n; n5 >= 0; --n5) {
                f3 = (float)((d + ((ProfilerResult)object).field_76332_a * (double)n5 / (double)n) * 3.1415927410125732 * 2.0 / 100.0);
                f2 = MathHelper.func_76126_a(f3) * (float)n2;
                f = MathHelper.func_76134_b(f3) * (float)n2 * 0.5f;
                tessellator.func_78377_a((float)n3 + f2, (float)n4 - f, 0.0);
                tessellator.func_78377_a((float)n3 + f2, (float)n4 - f + 10.0f, 0.0);
            }
            tessellator.func_78381_a();
            d += ((ProfilerResult)object).field_76332_a;
        }
        DecimalFormat decimalFormat = new DecimalFormat("##0.00");
        GL11.glEnable((int)3553);
        object = "";
        if (!profilerResult.field_76331_c.equals("unspecified")) {
            object = (String)object + "[0] ";
        }
        object = profilerResult.field_76331_c.length() == 0 ? (String)object + "ROOT " : (String)object + profilerResult.field_76331_c + " ";
        n = 0xFFFFFF;
        this.field_71466_p.func_78261_a((String)object, n3 - n2, n4 - n2 / 2 - 16, n);
        object = decimalFormat.format(profilerResult.field_76330_b) + "%";
        this.field_71466_p.func_78261_a((String)object, n3 + n2 - this.field_71466_p.func_78256_a((String)object), n4 - n2 / 2 - 16, n);
        for (int i = 0; i < list.size(); ++i) {
            ProfilerResult profilerResult2 = (ProfilerResult)list.get(i);
            String string = "";
            string = profilerResult2.field_76331_c.equals("unspecified") ? string + "[?] " : string + "[" + (i + 1) + "] ";
            string = string + profilerResult2.field_76331_c;
            this.field_71466_p.func_78261_a(string, n3 - n2, n4 + n2 / 2 + i * 8 + 20, profilerResult2.func_76329_a());
            string = decimalFormat.format(profilerResult2.field_76332_a) + "%";
            this.field_71466_p.func_78261_a(string, n3 + n2 - 50 - this.field_71466_p.func_78256_a(string), n4 + n2 / 2 + i * 8 + 20, profilerResult2.func_76329_a());
            string = decimalFormat.format(profilerResult2.field_76330_b) + "%";
            this.field_71466_p.func_78261_a(string, n3 + n2 - this.field_71466_p.func_78256_a(string), n4 + n2 / 2 + i * 8 + 20, profilerResult2.func_76329_a());
        }
    }

    public void func_71400_g() {
        this.field_71425_J = false;
    }

    public void func_71381_h() {
        if (!Display.isActive()) {
            return;
        }
        if (this.field_71415_G) {
            return;
        }
        this.field_71415_G = true;
        this.field_71417_B.func_74372_a();
        this.func_71373_a(null);
        this.field_71429_W = 10000;
    }

    public void func_71364_i() {
        if (!this.field_71415_G) {
            return;
        }
        KeyBinding.func_74506_a();
        this.field_71415_G = false;
        this.field_71417_B.func_74373_b();
    }

    public void func_71385_j() {
        if (this.field_71462_r != null) {
            return;
        }
        this.func_71373_a(new GuiIngameMenu());
        if (this.func_71356_B() && !this.field_71437_Z.func_71344_c()) {
            this.field_71416_A.func_82466_e();
        }
    }

    private void func_71399_a(int p_71399_1_, boolean p_71399_2_) {
        if (!p_71399_2_) {
            this.field_71429_W = 0;
        }
        if (p_71399_1_ == 0 && this.field_71429_W > 0) {
            return;
        }
        if (p_71399_2_ && this.field_71476_x != null && this.field_71476_x.field_72313_a == EnumMovingObjectType.TILE && p_71399_1_ == 0) {
            int n = this.field_71476_x.field_72311_b;
            int n2 = this.field_71476_x.field_72312_c;
            int n3 = this.field_71476_x.field_72309_d;
            this.field_71442_b.func_78759_c(n, n2, n3, this.field_71476_x.field_72310_e);
            if (this.field_71439_g.func_82246_f(n, n2, n3)) {
                this.field_71452_i.func_78867_a(n, n2, n3, this.field_71476_x.field_72310_e);
                this.field_71439_g.func_71038_i();
            }
        } else {
            this.field_71442_b.func_78767_c();
        }
    }

    private void func_71402_c(int p_71402_1_) {
        ItemStack itemStack;
        if (p_71402_1_ == 0 && this.field_71429_W > 0) {
            return;
        }
        if (p_71402_1_ == 0) {
            this.field_71439_g.func_71038_i();
        }
        if (p_71402_1_ == 1) {
            this.field_71467_ac = 4;
        }
        boolean bl = true;
        ItemStack itemStack2 = this.field_71439_g.field_71071_by.func_70448_g();
        if (this.field_71476_x == null) {
            if (p_71402_1_ == 0 && this.field_71442_b.func_78762_g()) {
                this.field_71429_W = 10;
            }
        } else if (this.field_71476_x.field_72313_a == EnumMovingObjectType.ENTITY) {
            if (p_71402_1_ == 0) {
                this.field_71442_b.func_78764_a(this.field_71439_g, this.field_71476_x.field_72308_g);
            }
            if (p_71402_1_ == 1 && this.field_71442_b.func_78768_b(this.field_71439_g, this.field_71476_x.field_72308_g)) {
                bl = false;
            }
        } else if (this.field_71476_x.field_72313_a == EnumMovingObjectType.TILE) {
            int n = this.field_71476_x.field_72311_b;
            int n2 = this.field_71476_x.field_72312_c;
            int n3 = this.field_71476_x.field_72309_d;
            int n4 = this.field_71476_x.field_72310_e;
            if (p_71402_1_ == 0) {
                this.field_71442_b.func_78743_b(n, n2, n3, this.field_71476_x.field_72310_e);
            } else {
                int n5;
                int n6 = n5 = itemStack2 != null ? itemStack2.field_77994_a : 0;
                if (this.field_71442_b.func_78760_a(this.field_71439_g, this.field_71441_e, itemStack2, n, n2, n3, n4, this.field_71476_x.field_72307_f)) {
                    bl = false;
                    this.field_71439_g.func_71038_i();
                }
                if (itemStack2 == null) {
                    return;
                }
                if (itemStack2.field_77994_a == 0) {
                    this.field_71439_g.field_71071_by.field_70462_a[this.field_71439_g.field_71071_by.field_70461_c] = null;
                } else if (itemStack2.field_77994_a != n5 || this.field_71442_b.func_78758_h()) {
                    this.field_71460_t.field_78516_c.func_78444_b();
                }
            }
        }
        if (bl && p_71402_1_ == 1 && (itemStack = this.field_71439_g.field_71071_by.func_70448_g()) != null && this.field_71442_b.func_78769_a(this.field_71439_g, this.field_71441_e, itemStack)) {
            this.field_71460_t.field_78516_c.func_78445_c();
        }
    }

    public void func_71352_k() {
        try {
            boolean bl = this.field_71431_Q = !this.field_71431_Q;
            if (this.field_71431_Q) {
                this.func_110441_Q();
                this.field_71443_c = Display.getDisplayMode().getWidth();
                this.field_71440_d = Display.getDisplayMode().getHeight();
                if (this.field_71443_c <= 0) {
                    this.field_71443_c = 1;
                }
                if (this.field_71440_d <= 0) {
                    this.field_71440_d = 1;
                }
            } else {
                Display.setDisplayMode((DisplayMode)new DisplayMode(this.field_71436_X, this.field_71435_Y));
                this.field_71443_c = this.field_71436_X;
                this.field_71440_d = this.field_71435_Y;
                if (this.field_71443_c <= 0) {
                    this.field_71443_c = 1;
                }
                if (this.field_71440_d <= 0) {
                    this.field_71440_d = 1;
                }
            }
            if (this.field_71462_r != null) {
                this.func_71370_a(this.field_71443_c, this.field_71440_d);
            }
            Display.setFullscreen((boolean)this.field_71431_Q);
            Display.setVSyncEnabled((boolean)this.field_71474_y.field_74352_v);
            Display.update();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void func_71370_a(int p_71370_1_, int p_71370_2_) {
        this.field_71443_c = p_71370_1_ <= 0 ? 1 : p_71370_1_;
        int n = this.field_71440_d = p_71370_2_ <= 0 ? 1 : p_71370_2_;
        if (this.field_71462_r != null) {
            ScaledResolution scaledResolution = new ScaledResolution(this.field_71474_y, p_71370_1_, p_71370_2_);
            int n2 = scaledResolution.func_78326_a();
            int n3 = scaledResolution.func_78328_b();
            this.field_71462_r.func_73872_a(this, n2, n3);
        }
    }

    public void func_71407_l() {
        if (this.field_71467_ac > 0) {
            --this.field_71467_ac;
        }
        this.field_71424_I.func_76320_a("stats");
        this.field_71413_E.func_77449_e();
        this.field_71424_I.func_76318_c("gui");
        if (!this.field_71445_n) {
            this.field_71456_v.func_73831_a();
        }
        this.field_71424_I.func_76318_c("pick");
        this.field_71460_t.func_78473_a(1.0f);
        this.field_71424_I.func_76318_c("gameMode");
        if (!this.field_71445_n && this.field_71441_e != null) {
            this.field_71442_b.func_78765_e();
        }
        this.field_71424_I.func_76318_c("textures");
        if (!this.field_71445_n) {
            this.field_71446_o.func_110550_d();
        }
        if (this.field_71462_r == null && this.field_71439_g != null) {
            if (this.field_71439_g.func_110143_aJ() <= 0.0f) {
                this.func_71373_a(null);
            } else if (this.field_71439_g.func_70608_bn() && this.field_71441_e != null) {
                this.func_71373_a(new GuiSleepMP());
            }
        } else if (this.field_71462_r != null && this.field_71462_r instanceof GuiSleepMP && !this.field_71439_g.func_70608_bn()) {
            this.func_71373_a(null);
        }
        if (this.field_71462_r != null) {
            this.field_71429_W = 10000;
        }
        if (this.field_71462_r != null) {
            try {
                this.field_71462_r.func_73862_m();
            }
            catch (Throwable throwable) {
                CrashReport crashReport = CrashReport.func_85055_a(throwable, "Updating screen events");
                CrashReportCategory crashReportCategory = crashReport.func_85058_a("Affected screen");
                crashReportCategory.func_71500_a("Screen name", new CallableUpdatingScreenName(this));
                throw new ReportedException(crashReport);
            }
            if (this.field_71462_r != null) {
                try {
                    this.field_71462_r.func_73876_c();
                }
                catch (Throwable throwable) {
                    CrashReport crashReport = CrashReport.func_85055_a(throwable, "Ticking screen");
                    CrashReportCategory crashReportCategory = crashReport.func_85058_a("Affected screen");
                    crashReportCategory.func_71500_a("Screen name", new CallableParticleScreenName(this));
                    throw new ReportedException(crashReport);
                }
            }
        }
        if (this.field_71462_r == null || this.field_71462_r.field_73885_j) {
            int n;
            this.field_71424_I.func_76318_c("mouse");
            while (Mouse.next()) {
                long l;
                n = Mouse.getEventButton();
                if (field_142025_a && n == 0 && (Keyboard.isKeyDown((int)29) || Keyboard.isKeyDown((int)157))) {
                    n = 1;
                }
                KeyBinding.func_74510_a(n - 100, Mouse.getEventButtonState());
                if (Mouse.getEventButtonState()) {
                    KeyBinding.func_74507_a(n - 100);
                }
                if ((l = Minecraft.func_71386_F() - this.field_71423_H) > 200L) continue;
                int n2 = Mouse.getEventDWheel();
                if (n2 != 0) {
                    this.field_71439_g.field_71071_by.func_70453_c(n2);
                    if (this.field_71474_y.field_74331_S) {
                        if (n2 > 0) {
                            n2 = 1;
                        }
                        if (n2 < 0) {
                            n2 = -1;
                        }
                        this.field_71474_y.field_74328_V += (float)n2 * 0.25f;
                    }
                }
                if (this.field_71462_r == null) {
                    if (this.field_71415_G || !Mouse.getEventButtonState()) continue;
                    this.func_71381_h();
                    continue;
                }
                if (this.field_71462_r == null) continue;
                this.field_71462_r.func_73867_d();
            }
            if (this.field_71429_W > 0) {
                --this.field_71429_W;
            }
            this.field_71424_I.func_76318_c("keyboard");
            while (Keyboard.next()) {
                KeyBinding.func_74510_a(Keyboard.getEventKey(), Keyboard.getEventKeyState());
                if (Keyboard.getEventKeyState()) {
                    KeyBinding.func_74507_a(Keyboard.getEventKey());
                }
                if (this.field_83002_am > 0L) {
                    if (Minecraft.func_71386_F() - this.field_83002_am >= 6000L) {
                        throw new ReportedException(new CrashReport("Manually triggered debug crash", new Throwable()));
                    }
                    if (!Keyboard.isKeyDown((int)46) || !Keyboard.isKeyDown((int)61)) {
                        this.field_83002_am = -1L;
                    }
                } else if (Keyboard.isKeyDown((int)46) && Keyboard.isKeyDown((int)61)) {
                    this.field_83002_am = Minecraft.func_71386_F();
                }
                if (!Keyboard.getEventKeyState()) continue;
                if (Keyboard.getEventKey() == 87) {
                    this.func_71352_k();
                    continue;
                }
                if (this.field_71462_r != null) {
                    this.field_71462_r.func_73860_n();
                } else {
                    if (Keyboard.getEventKey() == 1) {
                        this.func_71385_j();
                    }
                    if (Keyboard.getEventKey() == 31 && Keyboard.isKeyDown((int)61)) {
                        this.func_110436_a();
                    }
                    if (Keyboard.getEventKey() == 20 && Keyboard.isKeyDown((int)61)) {
                        this.func_110436_a();
                    }
                    if (Keyboard.getEventKey() == 33 && Keyboard.isKeyDown((int)61)) {
                        n = Keyboard.isKeyDown((int)42) | Keyboard.isKeyDown((int)54);
                        this.field_71474_y.func_74306_a(EnumOptions.RENDER_DISTANCE, n != 0 ? -1 : 1);
                    }
                    if (Keyboard.getEventKey() == 30 && Keyboard.isKeyDown((int)61)) {
                        this.field_71438_f.func_72712_a();
                    }
                    if (Keyboard.getEventKey() == 35 && Keyboard.isKeyDown((int)61)) {
                        this.field_71474_y.field_82882_x = !this.field_71474_y.field_82882_x;
                        this.field_71474_y.func_74303_b();
                    }
                    if (Keyboard.getEventKey() == 48 && Keyboard.isKeyDown((int)61)) {
                        boolean bl = RenderManager.field_85095_o = !RenderManager.field_85095_o;
                    }
                    if (Keyboard.getEventKey() == 25 && Keyboard.isKeyDown((int)61)) {
                        this.field_71474_y.field_82881_y = !this.field_71474_y.field_82881_y;
                        this.field_71474_y.func_74303_b();
                    }
                    if (Keyboard.getEventKey() == 59) {
                        boolean bl = this.field_71474_y.field_74319_N = !this.field_71474_y.field_74319_N;
                    }
                    if (Keyboard.getEventKey() == 61) {
                        this.field_71474_y.field_74330_P = !this.field_71474_y.field_74330_P;
                        this.field_71474_y.field_74329_Q = GuiScreen.func_73877_p();
                    }
                    if (Keyboard.getEventKey() == 63) {
                        ++this.field_71474_y.field_74320_O;
                        if (this.field_71474_y.field_74320_O > 2) {
                            this.field_71474_y.field_74320_O = 0;
                        }
                    }
                    if (Keyboard.getEventKey() == 66) {
                        this.field_71474_y.field_74326_T = !this.field_71474_y.field_74326_T;
                    }
                }
                for (n = 0; n < 9; ++n) {
                    if (Keyboard.getEventKey() != 2 + n) continue;
                    this.field_71439_g.field_71071_by.field_70461_c = n;
                }
                if (!this.field_71474_y.field_74330_P || !this.field_71474_y.field_74329_Q) continue;
                if (Keyboard.getEventKey() == 11) {
                    this.func_71383_b(0);
                }
                for (n = 0; n < 9; ++n) {
                    if (Keyboard.getEventKey() != 2 + n) continue;
                    this.func_71383_b(n + 1);
                }
            }
            int n3 = n = this.field_71474_y.field_74343_n != 2 ? 1 : 0;
            while (this.field_71474_y.field_74315_B.func_74509_c()) {
                if (this.field_71442_b.func_110738_j()) {
                    this.field_71439_g.func_110322_i();
                    continue;
                }
                this.func_71373_a(new GuiInventory(this.field_71439_g));
            }
            while (this.field_71474_y.field_74316_C.func_74509_c()) {
                this.field_71439_g.func_71040_bB(GuiScreen.func_73861_o());
            }
            while (this.field_71474_y.field_74310_D.func_74509_c() && n != 0) {
                this.func_71373_a(new GuiChat());
            }
            if (this.field_71462_r == null && this.field_71474_y.field_74323_J.func_74509_c() && n != 0) {
                this.func_71373_a(new GuiChat("/"));
            }
            if (this.field_71439_g.func_71039_bw()) {
                if (!this.field_71474_y.field_74313_G.field_74513_e) {
                    this.field_71442_b.func_78766_c(this.field_71439_g);
                }
                while (this.field_71474_y.field_74312_F.func_74509_c()) {
                }
                while (this.field_71474_y.field_74313_G.func_74509_c()) {
                }
                while (this.field_71474_y.field_74322_I.func_74509_c()) {
                }
            } else {
                while (this.field_71474_y.field_74312_F.func_74509_c()) {
                    this.func_71402_c(0);
                }
                while (this.field_71474_y.field_74313_G.func_74509_c()) {
                    this.func_71402_c(1);
                }
                while (this.field_71474_y.field_74322_I.func_74509_c()) {
                    this.func_71397_M();
                }
            }
            if (this.field_71474_y.field_74313_G.field_74513_e && this.field_71467_ac == 0 && !this.field_71439_g.func_71039_bw()) {
                this.func_71402_c(1);
            }
            this.func_71399_a(0, this.field_71462_r == null && this.field_71474_y.field_74312_F.field_74513_e && this.field_71415_G);
        }
        if (this.field_71441_e != null) {
            if (this.field_71439_g != null) {
                ++this.field_71457_ai;
                if (this.field_71457_ai == 30) {
                    this.field_71457_ai = 0;
                    this.field_71441_e.func_72897_h(this.field_71439_g);
                }
            }
            this.field_71424_I.func_76318_c("gameRenderer");
            if (!this.field_71445_n) {
                this.field_71460_t.func_78464_a();
            }
            this.field_71424_I.func_76318_c("levelRenderer");
            if (!this.field_71445_n) {
                this.field_71438_f.func_72734_e();
            }
            this.field_71424_I.func_76318_c("level");
            if (!this.field_71445_n) {
                if (this.field_71441_e.field_73016_r > 0) {
                    --this.field_71441_e.field_73016_r;
                }
                this.field_71441_e.func_72939_s();
            }
            if (!this.field_71445_n) {
                this.field_71441_e.func_72891_a(this.field_71441_e.field_73013_u > 0, true);
                try {
                    this.field_71441_e.func_72835_b();
                }
                catch (Throwable throwable) {
                    CrashReport crashReport = CrashReport.func_85055_a(throwable, "Exception in world tick");
                    if (this.field_71441_e == null) {
                        CrashReportCategory crashReportCategory = crashReport.func_85058_a("Affected level");
                        crashReportCategory.func_71507_a("Problem", "Level is null!");
                    } else {
                        this.field_71441_e.func_72914_a(crashReport);
                    }
                    throw new ReportedException(crashReport);
                }
            }
            this.field_71424_I.func_76318_c("animateTick");
            if (!this.field_71445_n && this.field_71441_e != null) {
                this.field_71441_e.func_73029_E(MathHelper.func_76128_c(this.field_71439_g.field_70165_t), MathHelper.func_76128_c(this.field_71439_g.field_70163_u), MathHelper.func_76128_c(this.field_71439_g.field_70161_v));
            }
            this.field_71424_I.func_76318_c("particles");
            if (!this.field_71445_n) {
                this.field_71452_i.func_78868_a();
            }
        } else if (this.field_71453_ak != null) {
            this.field_71424_I.func_76318_c("pendingConnection");
            this.field_71453_ak.func_74428_b();
        }
        this.field_71424_I.func_76319_b();
        this.field_71423_H = Minecraft.func_71386_F();
    }

    public void func_71371_a(String p_71371_1_, String p_71371_2_, WorldSettings p_71371_3_) {
        Object object;
        this.func_71403_a(null);
        System.gc();
        ISaveHandler iSaveHandler = this.field_71469_aa.func_75804_a(p_71371_1_, false);
        WorldInfo worldInfo = iSaveHandler.func_75757_d();
        if (worldInfo == null && p_71371_3_ != null) {
            worldInfo = new WorldInfo(p_71371_3_, p_71371_1_);
            iSaveHandler.func_75761_a(worldInfo);
        }
        if (p_71371_3_ == null) {
            p_71371_3_ = new WorldSettings(worldInfo);
        }
        this.field_71413_E.func_77450_a(StatList.field_75936_f, 1);
        this.field_71437_Z = new IntegratedServer(this, p_71371_1_, p_71371_2_, p_71371_3_);
        this.field_71437_Z.func_71256_s();
        this.field_71455_al = true;
        this.field_71461_s.func_73720_a(I18n.func_135053_a("menu.loadingLevel"));
        while (!this.field_71437_Z.func_71200_ad()) {
            object = this.field_71437_Z.func_71195_b_();
            if (object != null) {
                this.field_71461_s.func_73719_c(I18n.func_135053_a((String)object));
            } else {
                this.field_71461_s.func_73719_c("");
            }
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.func_71373_a(null);
        try {
            object = new NetClientHandler(this, this.field_71437_Z);
            this.field_71453_ak = ((NetClientHandler)object).func_72548_f();
        }
        catch (IOException iOException) {
            this.func_71377_b(this.func_71396_d(new CrashReport("Connecting to integrated server", iOException)));
        }
    }

    public void func_71403_a(WorldClient p_71403_1_) {
        this.func_71353_a(p_71403_1_, "");
    }

    public void func_71353_a(WorldClient p_71353_1_, String p_71353_2_) {
        this.field_71413_E.func_77446_d();
        if (p_71353_1_ == null) {
            NetClientHandler netClientHandler = this.func_71391_r();
            if (netClientHandler != null) {
                netClientHandler.func_72547_c();
            }
            if (this.field_71453_ak != null) {
                this.field_71453_ak.func_74431_f();
            }
            if (this.field_71437_Z != null) {
                this.field_71437_Z.func_71263_m();
            }
            this.field_71437_Z = null;
        }
        this.field_71451_h = null;
        this.field_71453_ak = null;
        if (this.field_71461_s != null) {
            this.field_71461_s.func_73721_b(p_71353_2_);
            this.field_71461_s.func_73719_c("");
        }
        if (p_71353_1_ == null && this.field_71441_e != null) {
            this.func_71351_a(null);
            this.field_71455_al = false;
        }
        this.field_71416_A.func_77368_a(null, 0.0f, 0.0f, 0.0f);
        this.field_71416_A.func_82464_d();
        this.field_71441_e = p_71353_1_;
        if (p_71353_1_ != null) {
            if (this.field_71438_f != null) {
                this.field_71438_f.func_72732_a(p_71353_1_);
            }
            if (this.field_71452_i != null) {
                this.field_71452_i.func_78870_a(p_71353_1_);
            }
            if (this.field_71439_g == null) {
                this.field_71439_g = this.field_71442_b.func_78754_a(p_71353_1_);
                this.field_71442_b.func_78745_b(this.field_71439_g);
            }
            this.field_71439_g.func_70065_x();
            p_71353_1_.func_72838_d(this.field_71439_g);
            this.field_71439_g.field_71158_b = new MovementInputFromOptions(this.field_71474_y);
            this.field_71442_b.func_78748_a(this.field_71439_g);
            this.field_71451_h = this.field_71439_g;
        } else {
            this.field_71469_aa.func_75800_d();
            this.field_71439_g = null;
        }
        System.gc();
        this.field_71423_H = 0L;
    }

    public String func_71393_m() {
        return this.field_71438_f.func_72735_c();
    }

    public String func_71408_n() {
        return this.field_71438_f.func_72723_d();
    }

    public String func_71388_o() {
        return this.field_71441_e.func_72827_u();
    }

    public String func_71374_p() {
        return "P: " + this.field_71452_i.func_78869_b() + ". T: " + this.field_71441_e.func_72981_t();
    }

    public void func_71354_a(int p_71354_1_) {
        this.field_71441_e.func_72974_f();
        this.field_71441_e.func_73022_a();
        int n = 0;
        String string = null;
        if (this.field_71439_g != null) {
            n = this.field_71439_g.field_70157_k;
            this.field_71441_e.func_72900_e(this.field_71439_g);
            string = this.field_71439_g.func_142021_k();
        }
        this.field_71451_h = null;
        this.field_71439_g = this.field_71442_b.func_78754_a(this.field_71441_e);
        this.field_71439_g.field_71093_bK = p_71354_1_;
        this.field_71451_h = this.field_71439_g;
        this.field_71439_g.func_70065_x();
        this.field_71439_g.func_142020_c(string);
        this.field_71441_e.func_72838_d(this.field_71439_g);
        this.field_71442_b.func_78745_b(this.field_71439_g);
        this.field_71439_g.field_71158_b = new MovementInputFromOptions(this.field_71474_y);
        this.field_71439_g.field_70157_k = n;
        this.field_71442_b.func_78748_a(this.field_71439_g);
        if (this.field_71462_r instanceof GuiGameOver) {
            this.func_71373_a(null);
        }
    }

    public final boolean func_71355_q() {
        return this.field_71459_aj;
    }

    public NetClientHandler func_71391_r() {
        if (this.field_71439_g != null) {
            return this.field_71439_g.field_71174_a;
        }
        return null;
    }

    public static boolean func_71382_s() {
        return field_71432_P == null || !Minecraft.field_71432_P.field_71474_y.field_74319_N;
    }

    public static boolean func_71375_t() {
        return field_71432_P != null && Minecraft.field_71432_P.field_71474_y.field_74347_j;
    }

    public static boolean func_71379_u() {
        return field_71432_P != null && Minecraft.field_71432_P.field_71474_y.field_74348_k != 0;
    }

    public boolean func_71409_c(String p_71409_1_) {
        return false;
    }

    private void func_71397_M() {
        int n;
        int n2;
        if (this.field_71476_x == null) {
            return;
        }
        boolean bl = this.field_71439_g.field_71075_bZ.field_75098_d;
        int n3 = 0;
        boolean bl2 = false;
        if (this.field_71476_x.field_72313_a == EnumMovingObjectType.TILE) {
            n2 = this.field_71476_x.field_72311_b;
            int n4 = this.field_71476_x.field_72312_c;
            int n5 = this.field_71476_x.field_72309_d;
            Block block = Block.field_71973_m[this.field_71441_e.func_72798_a(n2, n4, n5)];
            if (block == null) {
                return;
            }
            n = block.func_71922_a(this.field_71441_e, n2, n4, n5);
            if (n == 0) {
                return;
            }
            bl2 = Item.field_77698_e[n].func_77614_k();
            int n6 = n >= 256 || Block.field_71973_m[block.field_71990_ca].func_82505_u_() ? block.field_71990_ca : n;
            n3 = Block.field_71973_m[n6].func_71873_h(this.field_71441_e, n2, n4, n5);
        } else if (this.field_71476_x.field_72313_a == EnumMovingObjectType.ENTITY && this.field_71476_x.field_72308_g != null && bl) {
            if (this.field_71476_x.field_72308_g instanceof EntityPainting) {
                n = Item.field_77780_as.field_77779_bT;
            } else if (this.field_71476_x.field_72308_g instanceof EntityLeashKnot) {
                n = Item.field_111214_ch.field_77779_bT;
            } else if (this.field_71476_x.field_72308_g instanceof EntityItemFrame) {
                EntityItemFrame entityItemFrame = (EntityItemFrame)this.field_71476_x.field_72308_g;
                if (entityItemFrame.func_82335_i() == null) {
                    n = Item.field_82802_bI.field_77779_bT;
                } else {
                    n = entityItemFrame.func_82335_i().field_77993_c;
                    n3 = entityItemFrame.func_82335_i().func_77960_j();
                    bl2 = true;
                }
            } else if (this.field_71476_x.field_72308_g instanceof EntityMinecart) {
                EntityMinecart entityMinecart = (EntityMinecart)this.field_71476_x.field_72308_g;
                n = entityMinecart.func_94087_l() == 2 ? Item.field_77763_aO.field_77779_bT : (entityMinecart.func_94087_l() == 1 ? Item.field_77762_aN.field_77779_bT : (entityMinecart.func_94087_l() == 3 ? Item.field_94582_cb.field_77779_bT : (entityMinecart.func_94087_l() == 5 ? Item.field_96600_cc.field_77779_bT : Item.field_77773_az.field_77779_bT)));
            } else if (this.field_71476_x.field_72308_g instanceof EntityBoat) {
                n = Item.field_77769_aE.field_77779_bT;
            } else {
                n = Item.field_77815_bC.field_77779_bT;
                n3 = EntityList.func_75619_a(this.field_71476_x.field_72308_g);
                bl2 = true;
                if (n3 <= 0 || !EntityList.field_75627_a.containsKey(n3)) {
                    return;
                }
            }
        } else {
            return;
        }
        this.field_71439_g.field_71071_by.func_70433_a(n, n3, bl2, bl);
        if (bl) {
            n2 = this.field_71439_g.field_71069_bz.field_75151_b.size() - 9 + this.field_71439_g.field_71071_by.field_70461_c;
            this.field_71442_b.func_78761_a(this.field_71439_g.field_71071_by.func_70301_a(this.field_71439_g.field_71071_by.field_70461_c), n2);
        }
    }

    public CrashReport func_71396_d(CrashReport p_71396_1_) {
        p_71396_1_.func_85056_g().func_71500_a("Launched Version", new CallableLaunchedVersion(this));
        p_71396_1_.func_85056_g().func_71500_a("LWJGL", new CallableLWJGLVersion(this));
        p_71396_1_.func_85056_g().func_71500_a("OpenGL", new CallableGLInfo(this));
        p_71396_1_.func_85056_g().func_71500_a("Is Modded", new CallableModded(this));
        p_71396_1_.func_85056_g().func_71500_a("Type", new CallableType2(this));
        p_71396_1_.func_85056_g().func_71500_a("Resource Pack", new CallableTexturePack(this));
        p_71396_1_.func_85056_g().func_71500_a("Current Language", new CallableClientProfiler(this));
        p_71396_1_.func_85056_g().func_71500_a("Profiler Position", new CallableClientMemoryStats(this));
        p_71396_1_.func_85056_g().func_71500_a("Vec3 Pool Size", new MinecraftINNER13(this));
        if (this.field_71441_e != null) {
            this.field_71441_e.func_72914_a(p_71396_1_);
        }
        return p_71396_1_;
    }

    public static Minecraft func_71410_x() {
        return field_71432_P;
    }

    @Override
    public void func_70000_a(PlayerUsageSnooper p_70000_1_) {
        p_70000_1_.func_76472_a("fps", field_71470_ab);
        p_70000_1_.func_76472_a("texpack_name", this.field_110448_aq.func_110610_d());
        p_70000_1_.func_76472_a("vsync_enabled", this.field_71474_y.field_74352_v);
        p_70000_1_.func_76472_a("display_frequency", Display.getDisplayMode().getFrequency());
        p_70000_1_.func_76472_a("display_type", this.field_71431_Q ? "fullscreen" : "windowed");
        p_70000_1_.func_76472_a("run_time", (MinecraftServer.func_130071_aq() - p_70000_1_.func_130105_g()) / 60L * 1000L);
        if (this.field_71437_Z != null && this.field_71437_Z.func_80003_ah() != null) {
            p_70000_1_.func_76472_a("snooper_partner", this.field_71437_Z.func_80003_ah().func_80006_f());
        }
    }

    @Override
    public void func_70001_b(PlayerUsageSnooper p_70001_1_) {
        p_70001_1_.func_76472_a("opengl_version", GL11.glGetString((int)7938));
        p_70001_1_.func_76472_a("opengl_vendor", GL11.glGetString((int)7936));
        p_70001_1_.func_76472_a("client_brand", ClientBrandRetriever.getClientModName());
        p_70001_1_.func_76472_a("launched_version", this.field_110447_Z);
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        p_70001_1_.func_76472_a("gl_caps[ARB_multitexture]", contextCapabilities.GL_ARB_multitexture);
        p_70001_1_.func_76472_a("gl_caps[ARB_multisample]", contextCapabilities.GL_ARB_multisample);
        p_70001_1_.func_76472_a("gl_caps[ARB_texture_cube_map]", contextCapabilities.GL_ARB_texture_cube_map);
        p_70001_1_.func_76472_a("gl_caps[ARB_vertex_blend]", contextCapabilities.GL_ARB_vertex_blend);
        p_70001_1_.func_76472_a("gl_caps[ARB_matrix_palette]", contextCapabilities.GL_ARB_matrix_palette);
        p_70001_1_.func_76472_a("gl_caps[ARB_vertex_program]", contextCapabilities.GL_ARB_vertex_program);
        p_70001_1_.func_76472_a("gl_caps[ARB_vertex_shader]", contextCapabilities.GL_ARB_vertex_shader);
        p_70001_1_.func_76472_a("gl_caps[ARB_fragment_program]", contextCapabilities.GL_ARB_fragment_program);
        p_70001_1_.func_76472_a("gl_caps[ARB_fragment_shader]", contextCapabilities.GL_ARB_fragment_shader);
        p_70001_1_.func_76472_a("gl_caps[ARB_shader_objects]", contextCapabilities.GL_ARB_shader_objects);
        p_70001_1_.func_76472_a("gl_caps[ARB_vertex_buffer_object]", contextCapabilities.GL_ARB_vertex_buffer_object);
        p_70001_1_.func_76472_a("gl_caps[ARB_framebuffer_object]", contextCapabilities.GL_ARB_framebuffer_object);
        p_70001_1_.func_76472_a("gl_caps[ARB_pixel_buffer_object]", contextCapabilities.GL_ARB_pixel_buffer_object);
        p_70001_1_.func_76472_a("gl_caps[ARB_uniform_buffer_object]", contextCapabilities.GL_ARB_uniform_buffer_object);
        p_70001_1_.func_76472_a("gl_caps[ARB_texture_non_power_of_two]", contextCapabilities.GL_ARB_texture_non_power_of_two);
        p_70001_1_.func_76472_a("gl_caps[gl_max_vertex_uniforms]", GL11.glGetInteger((int)35658));
        p_70001_1_.func_76472_a("gl_caps[gl_max_fragment_uniforms]", GL11.glGetInteger((int)35657));
        p_70001_1_.func_76472_a("gl_max_texture_size", Minecraft.func_71369_N());
    }

    public static int func_71369_N() {
        for (int i = 16384; i > 0; i >>= 1) {
            GL11.glTexImage2D((int)32868, (int)0, (int)6408, (int)i, (int)i, (int)0, (int)6408, (int)5121, (ByteBuffer)null);
            int n = GL11.glGetTexLevelParameteri((int)32868, (int)0, (int)4096);
            if (n == 0) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean func_70002_Q() {
        return this.field_71474_y.field_74355_t;
    }

    public void func_71351_a(ServerData p_71351_1_) {
        this.field_71422_O = p_71351_1_;
    }

    public boolean func_71387_A() {
        return this.field_71455_al;
    }

    public boolean func_71356_B() {
        return this.field_71455_al && this.field_71437_Z != null;
    }

    public IntegratedServer func_71401_C() {
        return this.field_71437_Z;
    }

    public static void func_71363_D() {
        if (field_71432_P == null) {
            return;
        }
        IntegratedServer integratedServer = field_71432_P.func_71401_C();
        if (integratedServer != null) {
            integratedServer.func_71260_j();
        }
    }

    public PlayerUsageSnooper func_71378_E() {
        return this.field_71427_U;
    }

    public static long func_71386_F() {
        return Sys.getTime() * 1000L / Sys.getTimerResolution();
    }

    public boolean func_71372_G() {
        return this.field_71431_Q;
    }

    @Override
    public ILogAgent func_98033_al() {
        return this.field_94139_O;
    }

    public Session func_110432_I() {
        return this.field_71449_j;
    }

    public Proxy func_110437_J() {
        return this.field_110453_aa;
    }

    public TextureManager func_110434_K() {
        return this.field_71446_o;
    }

    public ResourceManager func_110442_L() {
        return this.field_110451_am;
    }

    public ResourcePackRepository func_110438_M() {
        return this.field_110448_aq;
    }

    public LanguageManager func_135016_M() {
        return this.field_135017_as;
    }

    static /* synthetic */ String func_110431_a(Minecraft p_110431_0_) {
        return p_110431_0_.field_110447_Z;
    }

    static /* synthetic */ LanguageManager func_142024_b(Minecraft p_142024_0_) {
        return p_142024_0_.field_135017_as;
    }
}

