/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.command;

import java.io.File;
import java.io.FileWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.profiler.ProfilerResult;
import net.minecraft.server.MinecraftServer;

public class CommandDebug
extends CommandBase {
    private long field_71551_a;
    private int field_71550_b;

    @Override
    public String func_71517_b() {
        return "debug";
    }

    @Override
    public int func_82362_a() {
        return 3;
    }

    @Override
    public String func_71518_a(ICommandSender p_71518_1_) {
        return "commands.debug.usage";
    }

    @Override
    public void func_71515_b(ICommandSender p_71515_1_, String[] p_71515_2_) {
        if (p_71515_2_.length == 1) {
            if (p_71515_2_[0].equals("start")) {
                CommandDebug.func_71522_a(p_71515_1_, "commands.debug.start", new Object[0]);
                MinecraftServer.func_71276_C().func_71223_ag();
                this.field_71551_a = MinecraftServer.func_130071_aq();
                this.field_71550_b = MinecraftServer.func_71276_C().func_71259_af();
                return;
            }
            if (p_71515_2_[0].equals("stop")) {
                if (!MinecraftServer.func_71276_C().field_71304_b.field_76327_a) {
                    throw new CommandException("commands.debug.notStarted", new Object[0]);
                }
                long l = MinecraftServer.func_130071_aq();
                int n = MinecraftServer.func_71276_C().func_71259_af();
                long l2 = l - this.field_71551_a;
                int n2 = n - this.field_71550_b;
                this.func_71548_a(l2, n2);
                MinecraftServer.func_71276_C().field_71304_b.field_76327_a = false;
                CommandDebug.func_71522_a(p_71515_1_, "commands.debug.stop", Float.valueOf((float)l2 / 1000.0f), n2);
                return;
            }
        }
        throw new WrongUsageException("commands.debug.usage", new Object[0]);
    }

    private void func_71548_a(long p_71548_1_, int p_71548_3_) {
        File file = new File(MinecraftServer.func_71276_C().func_71209_f("debug"), "profile-results-" + new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss").format(new Date()) + ".txt");
        file.getParentFile().mkdirs();
        try {
            FileWriter fileWriter = new FileWriter(file);
            fileWriter.write(this.func_71547_b(p_71548_1_, p_71548_3_));
            fileWriter.close();
        }
        catch (Throwable throwable) {
            MinecraftServer.func_71276_C().func_98033_al().func_98234_c("Could not save profiler results to " + file, throwable);
        }
    }

    private String func_71547_b(long p_71547_1_, int p_71547_3_) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("---- Minecraft Profiler Results ----\n");
        stringBuilder.append("// ");
        stringBuilder.append(CommandDebug.func_71549_c());
        stringBuilder.append("\n\n");
        stringBuilder.append("Time span: ").append(p_71547_1_).append(" ms\n");
        stringBuilder.append("Tick span: ").append(p_71547_3_).append(" ticks\n");
        stringBuilder.append("// This is approximately ").append(String.format("%.2f", Float.valueOf((float)p_71547_3_ / ((float)p_71547_1_ / 1000.0f)))).append(" ticks per second. It should be ").append(20).append(" ticks per second\n\n");
        stringBuilder.append("--- BEGIN PROFILE DUMP ---\n\n");
        this.func_71546_a(0, "root", stringBuilder);
        stringBuilder.append("--- END PROFILE DUMP ---\n\n");
        return stringBuilder.toString();
    }

    private void func_71546_a(int p_71546_1_, String p_71546_2_, StringBuilder p_71546_3_) {
        List list = MinecraftServer.func_71276_C().field_71304_b.func_76321_b(p_71546_2_);
        if (list == null || list.size() < 3) {
            return;
        }
        for (int i = 1; i < list.size(); ++i) {
            ProfilerResult profilerResult = (ProfilerResult)list.get(i);
            p_71546_3_.append(String.format("[%02d] ", p_71546_1_));
            for (int j = 0; j < p_71546_1_; ++j) {
                p_71546_3_.append(" ");
            }
            p_71546_3_.append(profilerResult.field_76331_c);
            p_71546_3_.append(" - ");
            p_71546_3_.append(String.format("%.2f", profilerResult.field_76332_a));
            p_71546_3_.append("%/");
            p_71546_3_.append(String.format("%.2f", profilerResult.field_76330_b));
            p_71546_3_.append("%\n");
            if (profilerResult.field_76331_c.equals("unspecified")) continue;
            try {
                this.func_71546_a(p_71546_1_ + 1, p_71546_2_ + "." + profilerResult.field_76331_c, p_71546_3_);
                continue;
            }
            catch (Exception exception) {
                p_71546_3_.append("[[ EXCEPTION " + exception + " ]]");
            }
        }
    }

    private static String func_71549_c() {
        String[] stringArray = new String[]{"Shiny numbers!", "Am I not running fast enough? :(", "I'm working as hard as I can!", "Will I ever be good enough for you? :(", "Speedy. Zoooooom!", "Hello world", "40% better than a crash report.", "Now with extra numbers", "Now with less numbers", "Now with the same numbers", "You should add flames to things, it makes them go faster!", "Do you feel the need for... optimization?", "*cracks redstone whip*", "Maybe if you treated it better then it'll have more motivation to work faster! Poor server."};
        try {
            return stringArray[(int)(System.nanoTime() % (long)stringArray.length)];
        }
        catch (Throwable throwable) {
            return "Witty comment unavailable :(";
        }
    }

    @Override
    public List func_71516_a(ICommandSender p_71516_1_, String[] p_71516_2_) {
        if (p_71516_2_.length == 1) {
            return CommandDebug.func_71530_a(p_71516_2_, "start", "stop");
        }
        return null;
    }
}

