/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.biome;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityBat;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.util.MathHelper;
import net.minecraft.world.ColorizerFoliage;
import net.minecraft.world.ColorizerGrass;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeDecorator;
import net.minecraft.world.biome.BiomeGenBeach;
import net.minecraft.world.biome.BiomeGenDesert;
import net.minecraft.world.biome.BiomeGenEnd;
import net.minecraft.world.biome.BiomeGenForest;
import net.minecraft.world.biome.BiomeGenHell;
import net.minecraft.world.biome.BiomeGenHills;
import net.minecraft.world.biome.BiomeGenJungle;
import net.minecraft.world.biome.BiomeGenMushroomIsland;
import net.minecraft.world.biome.BiomeGenOcean;
import net.minecraft.world.biome.BiomeGenPlains;
import net.minecraft.world.biome.BiomeGenRiver;
import net.minecraft.world.biome.BiomeGenSnow;
import net.minecraft.world.biome.BiomeGenSwamp;
import net.minecraft.world.biome.BiomeGenTaiga;
import net.minecraft.world.biome.SpawnListEntry;
import net.minecraft.world.gen.feature.WorldGenBigTree;
import net.minecraft.world.gen.feature.WorldGenForest;
import net.minecraft.world.gen.feature.WorldGenSwamp;
import net.minecraft.world.gen.feature.WorldGenTallGrass;
import net.minecraft.world.gen.feature.WorldGenTrees;
import net.minecraft.world.gen.feature.WorldGenerator;

public abstract class BiomeGenBase {
    public static final BiomeGenBase[] field_76773_a = new BiomeGenBase[256];
    public static final BiomeGenBase field_76771_b = new BiomeGenOcean(0).func_76739_b(112).func_76735_a("Ocean").func_76725_b(-1.0f, 0.4f);
    public static final BiomeGenBase field_76772_c = new BiomeGenPlains(1).func_76739_b(9286496).func_76735_a("Plains").func_76732_a(0.8f, 0.4f);
    public static final BiomeGenBase field_76769_d = new BiomeGenDesert(2).func_76739_b(16421912).func_76735_a("Desert").func_76745_m().func_76732_a(2.0f, 0.0f).func_76725_b(0.1f, 0.2f);
    public static final BiomeGenBase field_76770_e = new BiomeGenHills(3).func_76739_b(0x606060).func_76735_a("Extreme Hills").func_76725_b(0.3f, 1.5f).func_76732_a(0.2f, 0.3f);
    public static final BiomeGenBase field_76767_f = new BiomeGenForest(4).func_76739_b(353825).func_76735_a("Forest").func_76733_a(5159473).func_76732_a(0.7f, 0.8f);
    public static final BiomeGenBase field_76768_g = new BiomeGenTaiga(5).func_76739_b(747097).func_76735_a("Taiga").func_76733_a(5159473).func_76742_b().func_76732_a(0.05f, 0.8f).func_76725_b(0.1f, 0.4f);
    public static final BiomeGenBase field_76780_h = new BiomeGenSwamp(6).func_76739_b(522674).func_76735_a("Swampland").func_76733_a(9154376).func_76725_b(-0.2f, 0.1f).func_76732_a(0.8f, 0.9f);
    public static final BiomeGenBase field_76781_i = new BiomeGenRiver(7).func_76739_b(255).func_76735_a("River").func_76725_b(-0.5f, 0.0f);
    public static final BiomeGenBase field_76778_j = new BiomeGenHell(8).func_76739_b(0xFF0000).func_76735_a("Hell").func_76745_m().func_76732_a(2.0f, 0.0f);
    public static final BiomeGenBase field_76779_k = new BiomeGenEnd(9).func_76739_b(0x8080FF).func_76735_a("Sky").func_76745_m();
    public static final BiomeGenBase field_76776_l = new BiomeGenOcean(10).func_76739_b(0x9090A0).func_76735_a("FrozenOcean").func_76742_b().func_76725_b(-1.0f, 0.5f).func_76732_a(0.0f, 0.5f);
    public static final BiomeGenBase field_76777_m = new BiomeGenRiver(11).func_76739_b(0xA0A0FF).func_76735_a("FrozenRiver").func_76742_b().func_76725_b(-0.5f, 0.0f).func_76732_a(0.0f, 0.5f);
    public static final BiomeGenBase field_76774_n = new BiomeGenSnow(12).func_76739_b(0xFFFFFF).func_76735_a("Ice Plains").func_76742_b().func_76732_a(0.0f, 0.5f);
    public static final BiomeGenBase field_76775_o = new BiomeGenSnow(13).func_76739_b(0xA0A0A0).func_76735_a("Ice Mountains").func_76742_b().func_76725_b(0.3f, 1.3f).func_76732_a(0.0f, 0.5f);
    public static final BiomeGenBase field_76789_p = new BiomeGenMushroomIsland(14).func_76739_b(0xFF00FF).func_76735_a("MushroomIsland").func_76732_a(0.9f, 1.0f).func_76725_b(0.2f, 1.0f);
    public static final BiomeGenBase field_76788_q = new BiomeGenMushroomIsland(15).func_76739_b(0xA000FF).func_76735_a("MushroomIslandShore").func_76732_a(0.9f, 1.0f).func_76725_b(-1.0f, 0.1f);
    public static final BiomeGenBase field_76787_r = new BiomeGenBeach(16).func_76739_b(16440917).func_76735_a("Beach").func_76732_a(0.8f, 0.4f).func_76725_b(0.0f, 0.1f);
    public static final BiomeGenBase field_76786_s = new BiomeGenDesert(17).func_76739_b(13786898).func_76735_a("DesertHills").func_76745_m().func_76732_a(2.0f, 0.0f).func_76725_b(0.3f, 0.8f);
    public static final BiomeGenBase field_76785_t = new BiomeGenForest(18).func_76739_b(2250012).func_76735_a("ForestHills").func_76733_a(5159473).func_76732_a(0.7f, 0.8f).func_76725_b(0.3f, 0.7f);
    public static final BiomeGenBase field_76784_u = new BiomeGenTaiga(19).func_76739_b(1456435).func_76735_a("TaigaHills").func_76742_b().func_76733_a(5159473).func_76732_a(0.05f, 0.8f).func_76725_b(0.3f, 0.8f);
    public static final BiomeGenBase field_76783_v = new BiomeGenHills(20).func_76739_b(7501978).func_76735_a("Extreme Hills Edge").func_76725_b(0.2f, 0.8f).func_76732_a(0.2f, 0.3f);
    public static final BiomeGenBase field_76782_w = new BiomeGenJungle(21).func_76739_b(5470985).func_76735_a("Jungle").func_76733_a(5470985).func_76732_a(1.2f, 0.9f).func_76725_b(0.2f, 0.4f);
    public static final BiomeGenBase field_76792_x = new BiomeGenJungle(22).func_76739_b(2900485).func_76735_a("JungleHills").func_76733_a(5470985).func_76732_a(1.2f, 0.9f).func_76725_b(1.8f, 0.5f);
    public String field_76791_y;
    public int field_76790_z;
    public byte field_76752_A;
    public byte field_76753_B;
    public int field_76754_C;
    public float field_76748_D;
    public float field_76749_E;
    public float field_76750_F;
    public float field_76751_G;
    public int field_76759_H;
    public BiomeDecorator field_76760_I;
    protected List field_76761_J;
    protected List field_76762_K;
    protected List field_76755_L;
    protected List field_82914_M;
    private boolean field_76766_R;
    private boolean field_76765_S;
    public final int field_76756_M;
    protected WorldGenTrees field_76757_N;
    protected WorldGenBigTree field_76758_O;
    protected WorldGenForest field_76764_P;
    protected WorldGenSwamp field_76763_Q;

    public BiomeGenBase(int p_i1971_1_) {
        this.field_76752_A = (byte)Block.field_71980_u.field_71990_ca;
        this.field_76753_B = (byte)Block.field_71979_v.field_71990_ca;
        this.field_76754_C = 5169201;
        this.field_76748_D = 0.1f;
        this.field_76749_E = 0.3f;
        this.field_76750_F = 0.5f;
        this.field_76751_G = 0.5f;
        this.field_76759_H = 0xFFFFFF;
        this.field_76761_J = new ArrayList();
        this.field_76762_K = new ArrayList();
        this.field_76755_L = new ArrayList();
        this.field_82914_M = new ArrayList();
        this.field_76765_S = true;
        this.field_76757_N = new WorldGenTrees(false);
        this.field_76758_O = new WorldGenBigTree(false);
        this.field_76764_P = new WorldGenForest(false);
        this.field_76763_Q = new WorldGenSwamp();
        this.field_76756_M = p_i1971_1_;
        BiomeGenBase.field_76773_a[p_i1971_1_] = this;
        this.field_76760_I = this.func_76729_a();
        this.field_76762_K.add(new SpawnListEntry(EntitySheep.class, 12, 4, 4));
        this.field_76762_K.add(new SpawnListEntry(EntityPig.class, 10, 4, 4));
        this.field_76762_K.add(new SpawnListEntry(EntityChicken.class, 10, 4, 4));
        this.field_76762_K.add(new SpawnListEntry(EntityCow.class, 8, 4, 4));
        this.field_76761_J.add(new SpawnListEntry(EntitySpider.class, 10, 4, 4));
        this.field_76761_J.add(new SpawnListEntry(EntityZombie.class, 10, 4, 4));
        this.field_76761_J.add(new SpawnListEntry(EntitySkeleton.class, 10, 4, 4));
        this.field_76761_J.add(new SpawnListEntry(EntityCreeper.class, 10, 4, 4));
        this.field_76761_J.add(new SpawnListEntry(EntitySlime.class, 10, 4, 4));
        this.field_76761_J.add(new SpawnListEntry(EntityEnderman.class, 1, 1, 4));
        this.field_76755_L.add(new SpawnListEntry(EntitySquid.class, 10, 4, 4));
        this.field_82914_M.add(new SpawnListEntry(EntityBat.class, 10, 8, 8));
    }

    public BiomeDecorator func_76729_a() {
        return new BiomeDecorator(this);
    }

    public BiomeGenBase func_76732_a(float p_76732_1_, float p_76732_2_) {
        if (p_76732_1_ > 0.1f && p_76732_1_ < 0.2f) {
            throw new IllegalArgumentException("Please avoid temperatures in the range 0.1 - 0.2 because of snow");
        }
        this.field_76750_F = p_76732_1_;
        this.field_76751_G = p_76732_2_;
        return this;
    }

    public BiomeGenBase func_76725_b(float p_76725_1_, float p_76725_2_) {
        this.field_76748_D = p_76725_1_;
        this.field_76749_E = p_76725_2_;
        return this;
    }

    public BiomeGenBase func_76745_m() {
        this.field_76765_S = false;
        return this;
    }

    public WorldGenerator func_76740_a(Random p_76740_1_) {
        if (p_76740_1_.nextInt(10) == 0) {
            return this.field_76758_O;
        }
        return this.field_76757_N;
    }

    public WorldGenerator func_76730_b(Random p_76730_1_) {
        return new WorldGenTallGrass(Block.field_71962_X.field_71990_ca, 1);
    }

    public BiomeGenBase func_76742_b() {
        this.field_76766_R = true;
        return this;
    }

    public BiomeGenBase func_76735_a(String p_76735_1_) {
        this.field_76791_y = p_76735_1_;
        return this;
    }

    public BiomeGenBase func_76733_a(int p_76733_1_) {
        this.field_76754_C = p_76733_1_;
        return this;
    }

    public BiomeGenBase func_76739_b(int p_76739_1_) {
        this.field_76790_z = p_76739_1_;
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_76731_a(float p_76731_1_) {
        if ((p_76731_1_ /= 3.0f) < -1.0f) {
            p_76731_1_ = -1.0f;
        }
        if (p_76731_1_ > 1.0f) {
            p_76731_1_ = 1.0f;
        }
        return Color.getHSBColor(0.62222224f - p_76731_1_ * 0.05f, 0.5f + p_76731_1_ * 0.1f, 1.0f).getRGB();
    }

    public List func_76747_a(EnumCreatureType p_76747_1_) {
        if (p_76747_1_ == EnumCreatureType.monster) {
            return this.field_76761_J;
        }
        if (p_76747_1_ == EnumCreatureType.creature) {
            return this.field_76762_K;
        }
        if (p_76747_1_ == EnumCreatureType.waterCreature) {
            return this.field_76755_L;
        }
        if (p_76747_1_ == EnumCreatureType.ambient) {
            return this.field_82914_M;
        }
        return null;
    }

    public boolean func_76746_c() {
        return this.field_76766_R;
    }

    public boolean func_76738_d() {
        if (this.field_76766_R) {
            return false;
        }
        return this.field_76765_S;
    }

    public boolean func_76736_e() {
        return this.field_76751_G > 0.85f;
    }

    public float func_76741_f() {
        return 0.1f;
    }

    public final int func_76744_g() {
        return (int)(this.field_76751_G * 65536.0f);
    }

    public final int func_76734_h() {
        return (int)(this.field_76750_F * 65536.0f);
    }

    @SideOnly(value=Side.CLIENT)
    public final float func_76727_i() {
        return this.field_76751_G;
    }

    public final float func_76743_j() {
        return this.field_76750_F;
    }

    public void func_76728_a(World p_76728_1_, Random p_76728_2_, int p_76728_3_, int p_76728_4_) {
        this.field_76760_I.func_76796_a(p_76728_1_, p_76728_2_, p_76728_3_, p_76728_4_);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_76737_k() {
        double d = MathHelper.func_76131_a(this.func_76743_j(), 0.0f, 1.0f);
        double d2 = MathHelper.func_76131_a(this.func_76727_i(), 0.0f, 1.0f);
        return ColorizerGrass.func_77480_a(d, d2);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_76726_l() {
        double d = MathHelper.func_76131_a(this.func_76743_j(), 0.0f, 1.0f);
        double d2 = MathHelper.func_76131_a(this.func_76727_i(), 0.0f, 1.0f);
        return ColorizerFoliage.func_77470_a(d, d2);
    }
}

