/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.command;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandSpreadPlayersPosition;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.PlayerNotFoundException;
import net.minecraft.command.PlayerSelector;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.scoreboard.Team;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ChatMessageComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class CommandSpreadPlayers
extends CommandBase {
    @Override
    public String func_71517_b() {
        return "spreadplayers";
    }

    @Override
    public int func_82362_a() {
        return 2;
    }

    @Override
    public String func_71518_a(ICommandSender p_71518_1_) {
        return "commands.spreadplayers.usage";
    }

    @Override
    public void func_71515_b(ICommandSender p_71515_1_, String[] p_71515_2_) {
        if (p_71515_2_.length < 6) {
            throw new WrongUsageException("commands.spreadplayers.usage", new Object[0]);
        }
        int n = 0;
        double d = CommandSpreadPlayers.func_110666_a(p_71515_1_, Double.NaN, p_71515_2_[n++]);
        double d2 = CommandSpreadPlayers.func_110666_a(p_71515_1_, Double.NaN, p_71515_2_[n++]);
        double d3 = CommandSpreadPlayers.func_110664_a(p_71515_1_, p_71515_2_[n++], 0.0);
        double d4 = CommandSpreadPlayers.func_110664_a(p_71515_1_, p_71515_2_[n++], d3 + 1.0);
        boolean bl = CommandSpreadPlayers.func_110662_c(p_71515_1_, p_71515_2_[n++]);
        ArrayList arrayList = Lists.newArrayList();
        while (n < p_71515_2_.length) {
            Object object;
            String string;
            if (PlayerSelector.func_82378_b(string = p_71515_2_[n++])) {
                object = PlayerSelector.func_82380_c(p_71515_1_, string);
                if (object != null && ((EntityPlayerMP[])object).length != 0) {
                    Collections.addAll(arrayList, object);
                    continue;
                }
                throw new PlayerNotFoundException();
            }
            object = MinecraftServer.func_71276_C().func_71203_ab().func_72361_f(string);
            if (object != null) {
                arrayList.add(object);
                continue;
            }
            throw new PlayerNotFoundException();
        }
        if (arrayList.isEmpty()) {
            throw new PlayerNotFoundException();
        }
        p_71515_1_.func_70006_a(ChatMessageComponent.func_111082_b("commands.spreadplayers.spreading." + (bl ? "teams" : "players"), CommandSpreadPlayers.func_110663_b(arrayList), d, d2, d3, d4));
        this.func_110669_a(p_71515_1_, arrayList, new CommandSpreadPlayersPosition(d, d2), d3, d4, ((EntityLivingBase)arrayList.get((int)0)).field_70170_p, bl);
    }

    private void func_110669_a(ICommandSender p_110669_1_, List p_110669_2_, CommandSpreadPlayersPosition p_110669_3_, double p_110669_4_, double p_110669_6_, World p_110669_8_, boolean p_110669_9_) {
        Random random = new Random();
        double d = p_110669_3_.field_111101_a - p_110669_6_;
        double d2 = p_110669_3_.field_111100_b - p_110669_6_;
        double d3 = p_110669_3_.field_111101_a + p_110669_6_;
        double d4 = p_110669_3_.field_111100_b + p_110669_6_;
        CommandSpreadPlayersPosition[] commandSpreadPlayersPositionArray = this.func_110670_a(random, p_110669_9_ ? this.func_110667_a(p_110669_2_) : p_110669_2_.size(), d, d2, d3, d4);
        int n = this.func_110668_a(p_110669_3_, p_110669_4_, p_110669_8_, random, d, d2, d3, d4, commandSpreadPlayersPositionArray, p_110669_9_);
        double d5 = this.func_110671_a(p_110669_2_, p_110669_8_, commandSpreadPlayersPositionArray, p_110669_9_);
        CommandSpreadPlayers.func_71522_a(p_110669_1_, "commands.spreadplayers.success." + (p_110669_9_ ? "teams" : "players"), commandSpreadPlayersPositionArray.length, p_110669_3_.field_111101_a, p_110669_3_.field_111100_b);
        if (commandSpreadPlayersPositionArray.length > 1) {
            p_110669_1_.func_70006_a(ChatMessageComponent.func_111082_b("commands.spreadplayers.info." + (p_110669_9_ ? "teams" : "players"), String.format("%.2f", d5), n));
        }
    }

    private int func_110667_a(List p_110667_1_) {
        HashSet hashSet = Sets.newHashSet();
        for (EntityLivingBase entityLivingBase : p_110667_1_) {
            if (entityLivingBase instanceof EntityPlayer) {
                hashSet.add(((EntityPlayer)entityLivingBase).func_96124_cp());
                continue;
            }
            hashSet.add(null);
        }
        return hashSet.size();
    }

    private int func_110668_a(CommandSpreadPlayersPosition p_110668_1_, double p_110668_2_, World p_110668_4_, Random p_110668_5_, double p_110668_6_, double p_110668_8_, double p_110668_10_, double p_110668_12_, CommandSpreadPlayersPosition[] p_110668_14_, boolean p_110668_15_) {
        int n;
        boolean bl = true;
        double d = 3.4028234663852886E38;
        for (n = 0; n < 10000 && bl; ++n) {
            bl = false;
            d = 3.4028234663852886E38;
            for (int i = 0; i < p_110668_14_.length; ++i) {
                CommandSpreadPlayersPosition commandSpreadPlayersPosition = p_110668_14_[i];
                int n2 = 0;
                CommandSpreadPlayersPosition commandSpreadPlayersPosition2 = new CommandSpreadPlayersPosition();
                for (int j = 0; j < p_110668_14_.length; ++j) {
                    if (i == j) continue;
                    CommandSpreadPlayersPosition commandSpreadPlayersPosition3 = p_110668_14_[j];
                    double d2 = commandSpreadPlayersPosition.func_111099_a(commandSpreadPlayersPosition3);
                    d = Math.min(d2, d);
                    if (!(d2 < p_110668_2_)) continue;
                    ++n2;
                    commandSpreadPlayersPosition2.field_111101_a += commandSpreadPlayersPosition3.field_111101_a - commandSpreadPlayersPosition.field_111101_a;
                    commandSpreadPlayersPosition2.field_111100_b += commandSpreadPlayersPosition3.field_111100_b - commandSpreadPlayersPosition.field_111100_b;
                }
                if (n2 > 0) {
                    commandSpreadPlayersPosition2.field_111101_a /= (double)n2;
                    commandSpreadPlayersPosition2.field_111100_b /= (double)n2;
                    double d3 = commandSpreadPlayersPosition2.func_111096_b();
                    if (d3 > 0.0) {
                        commandSpreadPlayersPosition2.func_111095_a();
                        commandSpreadPlayersPosition.func_111094_b(commandSpreadPlayersPosition2);
                    } else {
                        commandSpreadPlayersPosition.func_111097_a(p_110668_5_, p_110668_6_, p_110668_8_, p_110668_10_, p_110668_12_);
                    }
                    bl = true;
                }
                if (!commandSpreadPlayersPosition.func_111093_a(p_110668_6_, p_110668_8_, p_110668_10_, p_110668_12_)) continue;
                bl = true;
            }
            if (bl) continue;
            for (CommandSpreadPlayersPosition commandSpreadPlayersPosition2 : p_110668_14_) {
                if (commandSpreadPlayersPosition2.func_111098_b(p_110668_4_)) continue;
                commandSpreadPlayersPosition2.func_111097_a(p_110668_5_, p_110668_6_, p_110668_8_, p_110668_10_, p_110668_12_);
                bl = true;
            }
        }
        if (n >= 10000) {
            throw new CommandException("commands.spreadplayers.failure." + (p_110668_15_ ? "teams" : "players"), p_110668_14_.length, p_110668_1_.field_111101_a, p_110668_1_.field_111100_b, String.format("%.2f", d));
        }
        return n;
    }

    private double func_110671_a(List p_110671_1_, World p_110671_2_, CommandSpreadPlayersPosition[] p_110671_3_, boolean p_110671_4_) {
        double d = 0.0;
        int n = 0;
        HashMap hashMap = Maps.newHashMap();
        for (int i = 0; i < p_110671_1_.size(); ++i) {
            CommandSpreadPlayersPosition commandSpreadPlayersPosition;
            EntityLivingBase entityLivingBase = (EntityLivingBase)p_110671_1_.get(i);
            if (p_110671_4_) {
                Team team;
                Team team2 = team = entityLivingBase instanceof EntityPlayer ? ((EntityPlayer)entityLivingBase).func_96124_cp() : null;
                if (!hashMap.containsKey(team)) {
                    hashMap.put(team, p_110671_3_[n++]);
                }
                commandSpreadPlayersPosition = (CommandSpreadPlayersPosition)hashMap.get(team);
            } else {
                commandSpreadPlayersPosition = p_110671_3_[n++];
            }
            entityLivingBase.func_70634_a((float)MathHelper.func_76128_c(commandSpreadPlayersPosition.field_111101_a) + 0.5f, commandSpreadPlayersPosition.func_111092_a(p_110671_2_), (double)MathHelper.func_76128_c(commandSpreadPlayersPosition.field_111100_b) + 0.5);
            double d2 = Double.MAX_VALUE;
            for (int j = 0; j < p_110671_3_.length; ++j) {
                if (commandSpreadPlayersPosition == p_110671_3_[j]) continue;
                double d3 = commandSpreadPlayersPosition.func_111099_a(p_110671_3_[j]);
                d2 = Math.min(d3, d2);
            }
            d += d2;
        }
        return d /= (double)p_110671_1_.size();
    }

    private CommandSpreadPlayersPosition[] func_110670_a(Random p_110670_1_, int p_110670_2_, double p_110670_3_, double p_110670_5_, double p_110670_7_, double p_110670_9_) {
        CommandSpreadPlayersPosition[] commandSpreadPlayersPositionArray = new CommandSpreadPlayersPosition[p_110670_2_];
        for (int i = 0; i < commandSpreadPlayersPositionArray.length; ++i) {
            CommandSpreadPlayersPosition commandSpreadPlayersPosition = new CommandSpreadPlayersPosition();
            commandSpreadPlayersPosition.func_111097_a(p_110670_1_, p_110670_3_, p_110670_5_, p_110670_7_, p_110670_9_);
            commandSpreadPlayersPositionArray[i] = commandSpreadPlayersPosition;
        }
        return commandSpreadPlayersPositionArray;
    }
}

