/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.texture;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.client.renderer.texture.Stitcher;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureClock;
import net.minecraft.client.renderer.texture.TextureCompass;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.renderer.texture.TickableTextureObject;
import net.minecraft.client.resources.ResourceManager;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.item.Item;
import net.minecraft.util.Icon;
import net.minecraft.util.ReportedException;
import net.minecraft.util.ResourceLocation;

@SideOnly(value=Side.CLIENT)
public class TextureMap
extends AbstractTexture
implements TickableTextureObject,
IconRegister {
    public static final ResourceLocation field_110575_b = new ResourceLocation("textures/atlas/blocks.png");
    public static final ResourceLocation field_110576_c = new ResourceLocation("textures/atlas/items.png");
    private final List field_94258_i = Lists.newArrayList();
    private final Map field_110574_e = Maps.newHashMap();
    private final Map field_94252_e = Maps.newHashMap();
    public final int field_94255_a;
    public final String field_94254_c;
    private final TextureAtlasSprite field_94249_f = new TextureAtlasSprite("missingno");

    public TextureMap(int p_i1281_1_, String p_i1281_2_) {
        this.field_94255_a = p_i1281_1_;
        this.field_94254_c = p_i1281_2_;
        this.func_110573_f();
    }

    private void func_110569_e() {
        this.field_94249_f.func_110968_a(Lists.newArrayList((Object[])new int[][]{TextureUtil.field_110999_b}));
        this.field_94249_f.func_110966_b(16);
        this.field_94249_f.func_110969_c(16);
    }

    @Override
    public void func_110551_a(ResourceManager p_110551_1_) throws IOException {
        this.func_110569_e();
        this.func_110571_b(p_110551_1_);
    }

    public void func_110571_b(ResourceManager p_110571_1_) {
        Object object;
        int n = Minecraft.func_71369_N();
        Stitcher stitcher = new Stitcher(n, n, true);
        this.field_94252_e.clear();
        this.field_94258_i.clear();
        for (Map.Entry iterator : this.field_110574_e.entrySet()) {
            Object object2 = new ResourceLocation((String)iterator.getKey());
            object = (TextureAtlasSprite)iterator.getValue();
            ResourceLocation resourceLocation = new ResourceLocation(((ResourceLocation)object2).func_110624_b(), String.format("%s/%s%s", this.field_94254_c, ((ResourceLocation)object2).func_110623_a(), ".png"));
            try {
                ((TextureAtlasSprite)object).func_130100_a(p_110571_1_.func_110536_a(resourceLocation));
            }
            catch (RuntimeException runtimeException) {
                Minecraft.func_71410_x().func_98033_al().func_98232_c(String.format("Unable to parse animation metadata from %s: %s", resourceLocation, runtimeException.getMessage()));
                continue;
            }
            catch (IOException iOException) {
                Minecraft.func_71410_x().func_98033_al().func_98232_c("Using missing texture, unable to load: " + resourceLocation);
                continue;
            }
            stitcher.func_110934_a((TextureAtlasSprite)object);
        }
        stitcher.func_110934_a(this.field_94249_f);
        stitcher.func_94305_f();
        TextureUtil.func_110991_a(this.func_110552_b(), stitcher.func_110935_a(), stitcher.func_110936_b());
        HashMap hashMap = Maps.newHashMap((Map)this.field_110574_e);
        for (Object object2 : stitcher.func_94309_g()) {
            object = ((TextureAtlasSprite)object2).func_94215_i();
            hashMap.remove(object);
            this.field_94252_e.put(object, object2);
            try {
                TextureUtil.func_110998_a(((TextureAtlasSprite)object2).func_110965_a(0), ((TextureAtlasSprite)object2).func_94211_a(), ((TextureAtlasSprite)object2).func_94216_b(), ((TextureAtlasSprite)object2).func_130010_a(), ((TextureAtlasSprite)object2).func_110967_i(), false, false);
            }
            catch (Throwable throwable) {
                CrashReport iOException = CrashReport.func_85055_a(throwable, "Stitching texture atlas");
                CrashReportCategory crashReportCategory = iOException.func_85058_a("Texture being stitched together");
                crashReportCategory.func_71507_a("Atlas path", this.field_94254_c);
                crashReportCategory.func_71507_a("Sprite", object2);
                throw new ReportedException(iOException);
            }
            if (((TextureAtlasSprite)object2).func_130098_m()) {
                this.field_94258_i.add(object2);
                continue;
            }
            ((TextureAtlasSprite)object2).func_130103_l();
        }
        for (Object object2 : hashMap.values()) {
            ((TextureAtlasSprite)object2).func_94217_a(this.field_94249_f);
        }
    }

    private void func_110573_f() {
        this.field_110574_e.clear();
        if (this.field_94255_a == 0) {
            for (Block object : Block.field_71973_m) {
                if (object == null) continue;
                object.func_94332_a(this);
            }
            Minecraft.func_71410_x().field_71438_f.func_94140_a(this);
            RenderManager.field_78727_a.func_94178_a(this);
        }
        for (Item item : Item.field_77698_e) {
            if (item == null || item.func_94901_k() != this.field_94255_a) continue;
            item.func_94581_a(this);
        }
    }

    public TextureAtlasSprite func_110572_b(String p_110572_1_) {
        TextureAtlasSprite textureAtlasSprite = (TextureAtlasSprite)this.field_94252_e.get(p_110572_1_);
        if (textureAtlasSprite == null) {
            textureAtlasSprite = this.field_94249_f;
        }
        return textureAtlasSprite;
    }

    public void func_94248_c() {
        TextureUtil.func_94277_a(this.func_110552_b());
        for (TextureAtlasSprite textureAtlasSprite : this.field_94258_i) {
            textureAtlasSprite.func_94219_l();
        }
    }

    @Override
    public Icon func_94245_a(String p_94245_1_) {
        TextureAtlasSprite textureAtlasSprite;
        if (p_94245_1_ == null) {
            new RuntimeException("Don't register null!").printStackTrace();
        }
        if ((textureAtlasSprite = (TextureAtlasSprite)this.field_110574_e.get(p_94245_1_)) == null) {
            textureAtlasSprite = this.field_94255_a == 1 ? ("clock".equals(p_94245_1_) ? new TextureClock(p_94245_1_) : ("compass".equals(p_94245_1_) ? new TextureCompass(p_94245_1_) : new TextureAtlasSprite(p_94245_1_))) : new TextureAtlasSprite(p_94245_1_);
            this.field_110574_e.put(p_94245_1_, textureAtlasSprite);
        }
        return textureAtlasSprite;
    }

    public int func_130086_a() {
        return this.field_94255_a;
    }

    @Override
    public void func_110550_d() {
        this.func_94248_c();
    }
}

