/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.command;

import com.google.common.primitives.Doubles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.command.CommandException;
import net.minecraft.command.IAdminCommand;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.NumberInvalidException;
import net.minecraft.command.PlayerNotFoundException;
import net.minecraft.command.PlayerSelector;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;

public abstract class CommandBase
implements ICommand {
    private static IAdminCommand field_71533_a;

    public int func_82362_a() {
        return 4;
    }

    @Override
    public List func_71514_a() {
        return null;
    }

    @Override
    public boolean func_71519_b(ICommandSender p_71519_1_) {
        return p_71519_1_.func_70003_b(this.func_82362_a(), this.func_71517_b());
    }

    @Override
    public List func_71516_a(ICommandSender p_71516_1_, String[] p_71516_2_) {
        return null;
    }

    public static int func_71526_a(ICommandSender p_71526_0_, String p_71526_1_) {
        try {
            return Integer.parseInt(p_71526_1_);
        }
        catch (NumberFormatException numberFormatException) {
            throw new NumberInvalidException("commands.generic.num.invalid", p_71526_1_);
        }
    }

    public static int func_71528_a(ICommandSender p_71528_0_, String p_71528_1_, int p_71528_2_) {
        return CommandBase.func_71532_a(p_71528_0_, p_71528_1_, p_71528_2_, Integer.MAX_VALUE);
    }

    public static int func_71532_a(ICommandSender p_71532_0_, String p_71532_1_, int p_71532_2_, int p_71532_3_) {
        int n = CommandBase.func_71526_a(p_71532_0_, p_71532_1_);
        if (n < p_71532_2_) {
            throw new NumberInvalidException("commands.generic.num.tooSmall", n, p_71532_2_);
        }
        if (n > p_71532_3_) {
            throw new NumberInvalidException("commands.generic.num.tooBig", n, p_71532_3_);
        }
        return n;
    }

    public static double func_82363_b(ICommandSender p_82363_0_, String p_82363_1_) {
        try {
            double d = Double.parseDouble(p_82363_1_);
            if (!Doubles.isFinite((double)d)) {
                throw new NumberInvalidException("commands.generic.double.invalid", p_82363_1_);
            }
            return d;
        }
        catch (NumberFormatException numberFormatException) {
            throw new NumberInvalidException("commands.generic.double.invalid", p_82363_1_);
        }
    }

    public static double func_110664_a(ICommandSender p_110664_0_, String p_110664_1_, double p_110664_2_) {
        return CommandBase.func_110661_a(p_110664_0_, p_110664_1_, p_110664_2_, Double.MAX_VALUE);
    }

    public static double func_110661_a(ICommandSender p_110661_0_, String p_110661_1_, double p_110661_2_, double p_110661_4_) {
        double d = CommandBase.func_82363_b(p_110661_0_, p_110661_1_);
        if (d < p_110661_2_) {
            throw new NumberInvalidException("commands.generic.double.tooSmall", d, p_110661_2_);
        }
        if (d > p_110661_4_) {
            throw new NumberInvalidException("commands.generic.double.tooBig", d, p_110661_4_);
        }
        return d;
    }

    public static boolean func_110662_c(ICommandSender p_110662_0_, String p_110662_1_) {
        if (p_110662_1_.equals("true") || p_110662_1_.equals("1")) {
            return true;
        }
        if (p_110662_1_.equals("false") || p_110662_1_.equals("0")) {
            return false;
        }
        throw new CommandException("commands.generic.boolean.invalid", p_110662_1_);
    }

    public static EntityPlayerMP func_71521_c(ICommandSender p_71521_0_) {
        if (p_71521_0_ instanceof EntityPlayerMP) {
            return (EntityPlayerMP)p_71521_0_;
        }
        throw new PlayerNotFoundException("You must specify which player you wish to perform this action on.", new Object[0]);
    }

    public static EntityPlayerMP func_82359_c(ICommandSender p_82359_0_, String p_82359_1_) {
        EntityPlayerMP entityPlayerMP = PlayerSelector.func_82386_a(p_82359_0_, p_82359_1_);
        if (entityPlayerMP != null) {
            return entityPlayerMP;
        }
        entityPlayerMP = MinecraftServer.func_71276_C().func_71203_ab().func_72361_f(p_82359_1_);
        if (entityPlayerMP == null) {
            throw new PlayerNotFoundException();
        }
        return entityPlayerMP;
    }

    public static String func_96332_d(ICommandSender p_96332_0_, String p_96332_1_) {
        EntityPlayerMP entityPlayerMP = PlayerSelector.func_82386_a(p_96332_0_, p_96332_1_);
        if (entityPlayerMP != null) {
            return entityPlayerMP.func_70023_ak();
        }
        if (PlayerSelector.func_82378_b(p_96332_1_)) {
            throw new PlayerNotFoundException();
        }
        return p_96332_1_;
    }

    public static String func_82360_a(ICommandSender p_82360_0_, String[] p_82360_1_, int p_82360_2_) {
        return CommandBase.func_82361_a(p_82360_0_, p_82360_1_, p_82360_2_, false);
    }

    public static String func_82361_a(ICommandSender p_82361_0_, String[] p_82361_1_, int p_82361_2_, boolean p_82361_3_) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = p_82361_2_; i < p_82361_1_.length; ++i) {
            if (i > p_82361_2_) {
                stringBuilder.append(" ");
            }
            String string = p_82361_1_[i];
            if (p_82361_3_) {
                String string2 = PlayerSelector.func_82385_b(p_82361_0_, string);
                if (string2 != null) {
                    string = string2;
                } else if (PlayerSelector.func_82378_b(string)) {
                    throw new PlayerNotFoundException();
                }
            }
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public static double func_110666_a(ICommandSender p_110666_0_, double p_110666_1_, String p_110666_3_) {
        return CommandBase.func_110665_a(p_110666_0_, p_110666_1_, p_110666_3_, -30000000, 30000000);
    }

    public static double func_110665_a(ICommandSender p_110665_0_, double p_110665_1_, String p_110665_3_, int p_110665_4_, int p_110665_5_) {
        double d;
        boolean bl = p_110665_3_.startsWith("~");
        if (bl && Double.isNaN(p_110665_1_)) {
            throw new NumberInvalidException("commands.generic.num.invalid", p_110665_1_);
        }
        double d2 = d = bl ? p_110665_1_ : 0.0;
        if (!bl || p_110665_3_.length() > 1) {
            boolean bl2 = p_110665_3_.contains(".");
            if (bl) {
                p_110665_3_ = p_110665_3_.substring(1);
            }
            d += CommandBase.func_82363_b(p_110665_0_, p_110665_3_);
            if (!bl2 && !bl) {
                d += 0.5;
            }
        }
        if (p_110665_4_ != 0 || p_110665_5_ != 0) {
            if (d < (double)p_110665_4_) {
                throw new NumberInvalidException("commands.generic.double.tooSmall", d, p_110665_4_);
            }
            if (d > (double)p_110665_5_) {
                throw new NumberInvalidException("commands.generic.double.tooBig", d, p_110665_5_);
            }
        }
        return d;
    }

    public static String func_71527_a(Object[] p_71527_0_) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < p_71527_0_.length; ++i) {
            String string = p_71527_0_[i].toString();
            if (i > 0) {
                if (i == p_71527_0_.length - 1) {
                    stringBuilder.append(" and ");
                } else {
                    stringBuilder.append(", ");
                }
            }
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public static String func_96333_a(Collection p_96333_0_) {
        return CommandBase.func_71527_a(p_96333_0_.toArray(new String[p_96333_0_.size()]));
    }

    public static String func_110663_b(Collection p_110663_0_) {
        Object[] objectArray = new String[p_110663_0_.size()];
        int n = 0;
        for (EntityLivingBase entityLivingBase : p_110663_0_) {
            objectArray[n++] = entityLivingBase.func_96090_ax();
        }
        return CommandBase.func_71527_a(objectArray);
    }

    public static boolean func_71523_a(String p_71523_0_, String p_71523_1_) {
        return p_71523_1_.regionMatches(true, 0, p_71523_0_, 0, p_71523_0_.length());
    }

    public static List func_71530_a(String[] p_71530_0_, String ... p_71530_1_) {
        String string = p_71530_0_[p_71530_0_.length - 1];
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string2 : p_71530_1_) {
            if (!CommandBase.func_71523_a(string, string2)) continue;
            arrayList.add(string2);
        }
        return arrayList;
    }

    public static List func_71531_a(String[] p_71531_0_, Iterable p_71531_1_) {
        String string = p_71531_0_[p_71531_0_.length - 1];
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string2 : p_71531_1_) {
            if (!CommandBase.func_71523_a(string, string2)) continue;
            arrayList.add(string2);
        }
        return arrayList;
    }

    @Override
    public boolean func_82358_a(String[] p_82358_1_, int p_82358_2_) {
        return false;
    }

    public static void func_71522_a(ICommandSender p_71522_0_, String p_71522_1_, Object ... p_71522_2_) {
        CommandBase.func_71524_a(p_71522_0_, 0, p_71522_1_, p_71522_2_);
    }

    public static void func_71524_a(ICommandSender p_71524_0_, int p_71524_1_, String p_71524_2_, Object ... p_71524_3_) {
        if (field_71533_a != null) {
            field_71533_a.func_71563_a(p_71524_0_, p_71524_1_, p_71524_2_, p_71524_3_);
        }
    }

    public static void func_71529_a(IAdminCommand p_71529_0_) {
        field_71533_a = p_71529_0_;
    }

    public int func_71525_a(ICommand p_71525_1_) {
        return this.func_71517_b().compareTo(p_71525_1_.func_71517_b());
    }

    public /* synthetic */ int compareTo(Object p_compareTo_1_) {
        return this.func_71525_a((ICommand)p_compareTo_1_);
    }
}

