/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.chunk.storage;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.chunk.storage.RegionFileChunkBuffer;

public class RegionFile {
    private static final byte[] field_76720_a = new byte[4096];
    private final File field_76718_b;
    private RandomAccessFile field_76719_c;
    private final int[] field_76716_d = new int[1024];
    private final int[] field_76717_e = new int[1024];
    private ArrayList field_76714_f;
    private int field_76715_g;
    private long field_76721_h;

    public RegionFile(File p_i2001_1_) {
        this.field_76718_b = p_i2001_1_;
        this.field_76715_g = 0;
        try {
            int n;
            int n2;
            int n3;
            if (p_i2001_1_.exists()) {
                this.field_76721_h = p_i2001_1_.lastModified();
            }
            this.field_76719_c = new RandomAccessFile(p_i2001_1_, "rw");
            if (this.field_76719_c.length() < 4096L) {
                for (n3 = 0; n3 < 1024; ++n3) {
                    this.field_76719_c.writeInt(0);
                }
                for (n3 = 0; n3 < 1024; ++n3) {
                    this.field_76719_c.writeInt(0);
                }
                this.field_76715_g += 8192;
            }
            if ((this.field_76719_c.length() & 0xFFFL) != 0L) {
                n3 = 0;
                while ((long)n3 < (this.field_76719_c.length() & 0xFFFL)) {
                    this.field_76719_c.write(0);
                    ++n3;
                }
            }
            n3 = (int)this.field_76719_c.length() / 4096;
            this.field_76714_f = new ArrayList(n3);
            for (n2 = 0; n2 < n3; ++n2) {
                this.field_76714_f.add(true);
            }
            this.field_76714_f.set(0, false);
            this.field_76714_f.set(1, false);
            this.field_76719_c.seek(0L);
            for (n2 = 0; n2 < 1024; ++n2) {
                this.field_76716_d[n2] = n = this.field_76719_c.readInt();
                if (n == 0 || (n >> 8) + (n & 0xFF) > this.field_76714_f.size()) continue;
                for (int i = 0; i < (n & 0xFF); ++i) {
                    this.field_76714_f.set((n >> 8) + i, false);
                }
            }
            for (n2 = 0; n2 < 1024; ++n2) {
                this.field_76717_e[n2] = n = this.field_76719_c.readInt();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public synchronized DataInputStream func_76704_a(int p_76704_1_, int p_76704_2_) {
        if (this.func_76705_d(p_76704_1_, p_76704_2_)) {
            return null;
        }
        try {
            int n = this.func_76707_e(p_76704_1_, p_76704_2_);
            if (n == 0) {
                return null;
            }
            int n2 = n >> 8;
            int n3 = n & 0xFF;
            if (n2 + n3 > this.field_76714_f.size()) {
                return null;
            }
            this.field_76719_c.seek(n2 * 4096);
            int n4 = this.field_76719_c.readInt();
            if (n4 > 4096 * n3) {
                return null;
            }
            if (n4 <= 0) {
                return null;
            }
            byte by = this.field_76719_c.readByte();
            if (by == 1) {
                byte[] byArray = new byte[n4 - 1];
                this.field_76719_c.read(byArray);
                return new DataInputStream(new BufferedInputStream(new GZIPInputStream(new ByteArrayInputStream(byArray))));
            }
            if (by == 2) {
                byte[] byArray = new byte[n4 - 1];
                this.field_76719_c.read(byArray);
                return new DataInputStream(new BufferedInputStream(new InflaterInputStream(new ByteArrayInputStream(byArray))));
            }
            return null;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public DataOutputStream func_76710_b(int p_76710_1_, int p_76710_2_) {
        if (this.func_76705_d(p_76710_1_, p_76710_2_)) {
            return null;
        }
        return new DataOutputStream(new DeflaterOutputStream(new RegionFileChunkBuffer(this, p_76710_1_, p_76710_2_)));
    }

    protected synchronized void func_76706_a(int p_76706_1_, int p_76706_2_, byte[] p_76706_3_, int p_76706_4_) {
        try {
            int n = this.func_76707_e(p_76706_1_, p_76706_2_);
            int n2 = n >> 8;
            int n3 = n & 0xFF;
            int n4 = (p_76706_4_ + 5) / 4096 + 1;
            if (n4 >= 256) {
                return;
            }
            if (n2 != 0 && n3 == n4) {
                this.func_76712_a(n2, p_76706_3_, p_76706_4_);
            } else {
                int n5;
                int n6;
                for (n6 = 0; n6 < n3; ++n6) {
                    this.field_76714_f.set(n2 + n6, true);
                }
                n6 = this.field_76714_f.indexOf(true);
                int n7 = 0;
                if (n6 != -1) {
                    for (n5 = n6; n5 < this.field_76714_f.size(); ++n5) {
                        if (n7 != 0) {
                            n7 = ((Boolean)this.field_76714_f.get(n5)).booleanValue() ? ++n7 : 0;
                        } else if (((Boolean)this.field_76714_f.get(n5)).booleanValue()) {
                            n6 = n5;
                            n7 = 1;
                        }
                        if (n7 >= n4) break;
                    }
                }
                if (n7 >= n4) {
                    n2 = n6;
                    this.func_76711_a(p_76706_1_, p_76706_2_, n2 << 8 | n4);
                    for (n5 = 0; n5 < n4; ++n5) {
                        this.field_76714_f.set(n2 + n5, false);
                    }
                    this.func_76712_a(n2, p_76706_3_, p_76706_4_);
                } else {
                    this.field_76719_c.seek(this.field_76719_c.length());
                    n2 = this.field_76714_f.size();
                    for (n5 = 0; n5 < n4; ++n5) {
                        this.field_76719_c.write(field_76720_a);
                        this.field_76714_f.add(false);
                    }
                    this.field_76715_g += 4096 * n4;
                    this.func_76712_a(n2, p_76706_3_, p_76706_4_);
                    this.func_76711_a(p_76706_1_, p_76706_2_, n2 << 8 | n4);
                }
            }
            this.func_76713_b(p_76706_1_, p_76706_2_, (int)(MinecraftServer.func_130071_aq() / 1000L));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void func_76712_a(int p_76712_1_, byte[] p_76712_2_, int p_76712_3_) throws IOException {
        this.field_76719_c.seek(p_76712_1_ * 4096);
        this.field_76719_c.writeInt(p_76712_3_ + 1);
        this.field_76719_c.writeByte(2);
        this.field_76719_c.write(p_76712_2_, 0, p_76712_3_);
    }

    private boolean func_76705_d(int p_76705_1_, int p_76705_2_) {
        return p_76705_1_ < 0 || p_76705_1_ >= 32 || p_76705_2_ < 0 || p_76705_2_ >= 32;
    }

    private int func_76707_e(int p_76707_1_, int p_76707_2_) {
        return this.field_76716_d[p_76707_1_ + p_76707_2_ * 32];
    }

    public boolean func_76709_c(int p_76709_1_, int p_76709_2_) {
        return this.func_76707_e(p_76709_1_, p_76709_2_) != 0;
    }

    private void func_76711_a(int p_76711_1_, int p_76711_2_, int p_76711_3_) throws IOException {
        this.field_76716_d[p_76711_1_ + p_76711_2_ * 32] = p_76711_3_;
        this.field_76719_c.seek((p_76711_1_ + p_76711_2_ * 32) * 4);
        this.field_76719_c.writeInt(p_76711_3_);
    }

    private void func_76713_b(int p_76713_1_, int p_76713_2_, int p_76713_3_) throws IOException {
        this.field_76717_e[p_76713_1_ + p_76713_2_ * 32] = p_76713_3_;
        this.field_76719_c.seek(4096 + (p_76713_1_ + p_76713_2_ * 32) * 4);
        this.field_76719_c.writeInt(p_76713_3_);
    }

    public void func_76708_c() throws IOException {
        if (this.field_76719_c != null) {
            this.field_76719_c.close();
        }
    }
}

