/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.resources;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraft.client.resources.AbstractResourcePack;
import net.minecraft.client.resources.ResourcePackFileNotFoundException;

@SideOnly(value=Side.CLIENT)
public class FileResourcePack
extends AbstractResourcePack
implements Closeable {
    public static final Splitter field_110601_c = Splitter.on((char)'/').omitEmptyStrings().limit(3);
    private ZipFile field_110600_d;

    public FileResourcePack(File p_i1290_1_) {
        super(p_i1290_1_);
    }

    private ZipFile func_110599_c() throws IOException {
        if (this.field_110600_d == null) {
            this.field_110600_d = new ZipFile(this.field_110597_b);
        }
        return this.field_110600_d;
    }

    @Override
    protected InputStream func_110591_a(String p_110591_1_) throws IOException {
        ZipFile zipFile = this.func_110599_c();
        ZipEntry zipEntry = zipFile.getEntry(p_110591_1_);
        if (zipEntry == null) {
            throw new ResourcePackFileNotFoundException(this.field_110597_b, p_110591_1_);
        }
        return zipFile.getInputStream(zipEntry);
    }

    @Override
    public boolean func_110593_b(String p_110593_1_) {
        try {
            return this.func_110599_c().getEntry(p_110593_1_) != null;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    @Override
    public Set func_110587_b() {
        ZipFile zipFile;
        try {
            zipFile = this.func_110599_c();
        }
        catch (IOException iOException) {
            return Collections.emptySet();
        }
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        HashSet hashSet = Sets.newHashSet();
        while (enumeration.hasMoreElements()) {
            ArrayList arrayList;
            ZipEntry zipEntry = enumeration.nextElement();
            String string = zipEntry.getName();
            if (!string.startsWith("assets/") || (arrayList = Lists.newArrayList((Iterable)field_110601_c.split((CharSequence)string))).size() <= 1) continue;
            String string2 = (String)arrayList.get(1);
            if (!string2.equals(string2.toLowerCase())) {
                this.func_110594_c(string2);
                continue;
            }
            hashSet.add(string2);
        }
        return hashSet;
    }

    protected void finalize() {
        this.close();
        super.finalize();
    }

    @Override
    public void close() {
        if (this.field_110600_d != null) {
            this.field_110600_d.close();
            this.field_110600_d = null;
        }
    }
}

