/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.storage;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.MinecraftException;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.chunk.storage.IChunkLoader;
import net.minecraft.world.storage.IPlayerFileData;
import net.minecraft.world.storage.ISaveHandler;
import net.minecraft.world.storage.WorldInfo;

public class SaveHandler
implements ISaveHandler,
IPlayerFileData {
    private final File field_75770_b;
    private final File field_75771_c;
    private final File field_75768_d;
    private final long field_75769_e = MinecraftServer.func_130071_aq();
    private final String field_75767_f;

    public SaveHandler(File p_i2146_1_, String p_i2146_2_, boolean p_i2146_3_) {
        this.field_75770_b = new File(p_i2146_1_, p_i2146_2_);
        this.field_75770_b.mkdirs();
        this.field_75771_c = new File(this.field_75770_b, "players");
        this.field_75768_d = new File(this.field_75770_b, "data");
        this.field_75768_d.mkdirs();
        this.field_75767_f = p_i2146_2_;
        if (p_i2146_3_) {
            this.field_75771_c.mkdirs();
        }
        this.func_75766_h();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void func_75766_h() {
        try {
            File file = new File(this.field_75770_b, "session.lock");
            DataOutputStream dataOutputStream = new DataOutputStream(new FileOutputStream(file));
            try {
                dataOutputStream.writeLong(this.field_75769_e);
            }
            finally {
                dataOutputStream.close();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new RuntimeException("Failed to check session lock, aborting");
        }
    }

    public File func_75765_b() {
        return this.field_75770_b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void func_75762_c() throws MinecraftException {
        try {
            File file = new File(this.field_75770_b, "session.lock");
            DataInputStream dataInputStream = new DataInputStream(new FileInputStream(file));
            try {
                if (dataInputStream.readLong() != this.field_75769_e) {
                    throw new MinecraftException("The save is being accessed from another location, aborting");
                }
            }
            finally {
                dataInputStream.close();
            }
        }
        catch (IOException iOException) {
            throw new MinecraftException("Failed to check session lock, aborting");
        }
    }

    @Override
    public IChunkLoader func_75763_a(WorldProvider p_75763_1_) {
        throw new RuntimeException("Old Chunk Storage is no longer supported.");
    }

    @Override
    public WorldInfo func_75757_d() {
        File file = new File(this.field_75770_b, "level.dat");
        if (file.exists()) {
            try {
                NBTTagCompound nBTTagCompound = CompressedStreamTools.func_74796_a(new FileInputStream(file));
                NBTTagCompound nBTTagCompound2 = nBTTagCompound.func_74775_l("Data");
                return new WorldInfo(nBTTagCompound2);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if ((file = new File(this.field_75770_b, "level.dat_old")).exists()) {
            try {
                NBTTagCompound nBTTagCompound = CompressedStreamTools.func_74796_a(new FileInputStream(file));
                NBTTagCompound nBTTagCompound3 = nBTTagCompound.func_74775_l("Data");
                return new WorldInfo(nBTTagCompound3);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return null;
    }

    @Override
    public void func_75755_a(WorldInfo p_75755_1_, NBTTagCompound p_75755_2_) {
        NBTTagCompound nBTTagCompound = p_75755_1_.func_76082_a(p_75755_2_);
        NBTTagCompound nBTTagCompound2 = new NBTTagCompound();
        nBTTagCompound2.func_74782_a("Data", nBTTagCompound);
        try {
            File file = new File(this.field_75770_b, "level.dat_new");
            File file2 = new File(this.field_75770_b, "level.dat_old");
            File file3 = new File(this.field_75770_b, "level.dat");
            CompressedStreamTools.func_74799_a(nBTTagCompound2, new FileOutputStream(file));
            if (file2.exists()) {
                file2.delete();
            }
            file3.renameTo(file2);
            if (file3.exists()) {
                file3.delete();
            }
            file.renameTo(file3);
            if (file.exists()) {
                file.delete();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void func_75761_a(WorldInfo p_75761_1_) {
        NBTTagCompound nBTTagCompound = p_75761_1_.func_76066_a();
        NBTTagCompound nBTTagCompound2 = new NBTTagCompound();
        nBTTagCompound2.func_74782_a("Data", nBTTagCompound);
        try {
            File file = new File(this.field_75770_b, "level.dat_new");
            File file2 = new File(this.field_75770_b, "level.dat_old");
            File file3 = new File(this.field_75770_b, "level.dat");
            CompressedStreamTools.func_74799_a(nBTTagCompound2, new FileOutputStream(file));
            if (file2.exists()) {
                file2.delete();
            }
            file3.renameTo(file2);
            if (file3.exists()) {
                file3.delete();
            }
            file.renameTo(file3);
            if (file.exists()) {
                file.delete();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void func_75753_a(EntityPlayer p_75753_1_) {
        try {
            NBTTagCompound nBTTagCompound = new NBTTagCompound();
            p_75753_1_.func_70109_d(nBTTagCompound);
            File file = new File(this.field_75771_c, p_75753_1_.func_70005_c_() + ".dat.tmp");
            File file2 = new File(this.field_75771_c, p_75753_1_.func_70005_c_() + ".dat");
            CompressedStreamTools.func_74799_a(nBTTagCompound, new FileOutputStream(file));
            if (file2.exists()) {
                file2.delete();
            }
            file.renameTo(file2);
        }
        catch (Exception exception) {
            MinecraftServer.func_71276_C().func_98033_al().func_98236_b("Failed to save player data for " + p_75753_1_.func_70005_c_());
        }
    }

    @Override
    public NBTTagCompound func_75752_b(EntityPlayer p_75752_1_) {
        NBTTagCompound nBTTagCompound = this.func_75764_a(p_75752_1_.func_70005_c_());
        if (nBTTagCompound != null) {
            p_75752_1_.func_70020_e(nBTTagCompound);
        }
        return nBTTagCompound;
    }

    public NBTTagCompound func_75764_a(String p_75764_1_) {
        try {
            File file = new File(this.field_75771_c, p_75764_1_ + ".dat");
            if (file.exists()) {
                return CompressedStreamTools.func_74796_a(new FileInputStream(file));
            }
        }
        catch (Exception exception) {
            MinecraftServer.func_71276_C().func_98033_al().func_98236_b("Failed to load player data for " + p_75764_1_);
        }
        return null;
    }

    @Override
    public IPlayerFileData func_75756_e() {
        return this;
    }

    @Override
    public String[] func_75754_f() {
        String[] stringArray = this.field_75771_c.list();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].endsWith(".dat")) continue;
            stringArray[i] = stringArray[i].substring(0, stringArray[i].length() - 4);
        }
        return stringArray;
    }

    @Override
    public void func_75759_a() {
    }

    @Override
    public File func_75758_b(String p_75758_1_) {
        return new File(this.field_75768_d, p_75758_1_ + ".dat");
    }

    @Override
    public String func_75760_g() {
        return this.field_75767_f;
    }
}

