/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.helpers;

import javax.annotation.Nonnull;
import mod.chiselsandbits.api.EventBlockBitModification;
import mod.chiselsandbits.helpers.PlayerCopiedInventory;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.eventhandler.Event;

public class ActingPlayer {
    private final IInventory storage;
    private final EntityPlayer innerPlayer;
    private final boolean realPlayer;
    private final EnumHand hand;
    BlockPos lastPos = null;
    Boolean lastPlacement = null;
    ItemStack lastPermissionBit = null;
    Boolean permissionResult = null;

    private ActingPlayer(EntityPlayer player, boolean realPlayer, EnumHand hand) {
        this.innerPlayer = player;
        this.hand = hand;
        this.realPlayer = realPlayer;
        this.storage = realPlayer ? player.field_71071_by : new PlayerCopiedInventory(player.field_71071_by);
    }

    public IInventory getInventory() {
        return this.storage;
    }

    public int getCurrentItem() {
        return this.innerPlayer.field_71071_by.field_70461_c;
    }

    public boolean isCreative() {
        return this.innerPlayer.field_71075_bZ.field_75098_d;
    }

    public ItemStack getCurrentEquippedItem() {
        return this.storage.func_70301_a(this.getCurrentItem());
    }

    public boolean canPlayerManipulate(@Nonnull BlockPos pos, @Nonnull EnumFacing side, @Nonnull ItemStack is, boolean placement) {
        if (this.permissionResult == null || this.lastPermissionBit != is || this.lastPos != pos || placement != this.lastPlacement) {
            this.lastPos = pos;
            this.lastPlacement = placement;
            this.lastPermissionBit = is;
            if (this.innerPlayer.func_175151_a(pos, side, is) && this.innerPlayer.field_70170_p.func_175660_a(this.innerPlayer, pos)) {
                EventBlockBitModification event = new EventBlockBitModification(this.innerPlayer.field_70170_p, pos, this.innerPlayer, this.hand, is, placement);
                MinecraftForge.EVENT_BUS.post((Event)event);
                this.permissionResult = !event.isCanceled();
            } else {
                this.permissionResult = false;
            }
        }
        return this.permissionResult;
    }

    public void damageItem(ItemStack stack, int amount) {
        if (this.realPlayer) {
            stack.func_77972_a(amount, (EntityLivingBase)this.innerPlayer);
        } else {
            stack.func_77964_b(stack.func_77952_i() + amount);
        }
    }

    public void playerDestroyItem(@Nonnull ItemStack stack, EnumHand hand) {
        if (this.realPlayer) {
            ForgeEventFactory.onPlayerDestroyItem((EntityPlayer)this.innerPlayer, (ItemStack)stack, (EnumHand)hand);
        }
    }

    @Nonnull
    public static ActingPlayer actingAs(EntityPlayer player, EnumHand hand) {
        return new ActingPlayer(player, true, hand);
    }

    @Nonnull
    public static ActingPlayer testingAs(EntityPlayer player, EnumHand hand) {
        return new ActingPlayer(player, false, hand);
    }

    public World getWorld() {
        return this.innerPlayer.field_70170_p;
    }

    public EntityPlayer getPlayer() {
        return this.innerPlayer;
    }

    public boolean isReal() {
        return this.realPlayer;
    }

    public EnumHand getHand() {
        return this.hand;
    }
}

