/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.chiseledblock.data;

import io.netty.buffer.Unpooled;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.zip.InflaterInputStream;
import mod.chiselsandbits.chiseledblock.BoxCollection;
import mod.chiselsandbits.chiseledblock.BoxType;
import mod.chiselsandbits.chiseledblock.data.BitOcclusionIterator;
import mod.chiselsandbits.chiseledblock.data.VoxelBlob;
import mod.chiselsandbits.core.Log;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.AxisAlignedBB;

public final class VoxelBlobStateInstance
implements Comparable<VoxelBlobStateInstance> {
    public final int hash;
    public final byte[] voxelBytes;
    private static final int HAS_FLUIDS = 1;
    private static final int HAS_SOLIDS = 2;
    private int generated = 0;
    private SoftReference<AxisAlignedBB[]> fluidBoxes = null;
    private SoftReference<AxisAlignedBB[]> solidBoxes = null;
    protected SoftReference<VoxelBlob> blob;
    private int format = Integer.MIN_VALUE;

    public VoxelBlobStateInstance(byte[] data) {
        this.voxelBytes = data;
        this.hash = Arrays.hashCode(this.voxelBytes);
    }

    public boolean equals(Object obj) {
        return this.compareTo((VoxelBlobStateInstance)obj) == 0;
    }

    public int hashCode() {
        return this.hash;
    }

    @Override
    public int compareTo(VoxelBlobStateInstance o) {
        if (o == null) {
            return -1;
        }
        int r = Integer.compare(this.hash, o.hash);
        if (r == 0) {
            r = this.voxelBytes.length - o.voxelBytes.length;
        }
        if (r == 0) {
            for (int x = 0; x < this.voxelBytes.length && r == 0; ++x) {
                r = this.voxelBytes[x] - o.voxelBytes[x];
            }
        }
        return r;
    }

    public VoxelBlob getBlob() {
        try {
            return this.getBlobCatchable();
        }
        catch (Exception e) {
            Log.logError("Unable to read blob.", e);
            return new VoxelBlob();
        }
    }

    public VoxelBlob getBlobCatchable() throws Exception {
        VoxelBlob vb;
        VoxelBlob voxelBlob = vb = this.blob == null ? null : this.blob.get();
        if (vb == null) {
            vb = new VoxelBlob();
            vb.blobFromBytes(this.voxelBytes);
            this.blob = new SoftReference<VoxelBlob>(vb);
        }
        return new VoxelBlob(vb);
    }

    private AxisAlignedBB[] getBoxType(int type) {
        if ((this.generated & type) == 0) {
            switch (type) {
                case 1: {
                    VoxelBlob fluidBlob = this.getBlob();
                    this.generated |= 1;
                    if (fluidBlob.filterFluids(true)) {
                        AxisAlignedBB[] out = this.generateBoxes(fluidBlob);
                        this.fluidBoxes = new SoftReference<AxisAlignedBB[]>(out);
                        return out;
                    }
                    this.fluidBoxes = null;
                    return null;
                }
                case 2: {
                    VoxelBlob solidBlob = this.getBlob();
                    this.generated |= 2;
                    if (solidBlob.filterFluids(false)) {
                        AxisAlignedBB[] out = this.generateBoxes(solidBlob);
                        this.solidBoxes = new SoftReference<AxisAlignedBB[]>(out);
                        return out;
                    }
                    this.solidBoxes = null;
                    return null;
                }
            }
        }
        AxisAlignedBB[] out = null;
        switch (type) {
            case 1: {
                if (this.fluidBoxes == null) {
                    return null;
                }
                out = this.fluidBoxes.get();
                break;
            }
            case 2: {
                if (this.solidBoxes == null) {
                    return null;
                }
                out = this.solidBoxes.get();
            }
        }
        if (out != null) {
            return out;
        }
        this.generated &= ~type;
        return this.getBoxType(type);
    }

    public Collection<AxisAlignedBB> getBoxes(BoxType type) {
        switch (type) {
            case COLLISION: {
                return new BoxCollection(this.getBoxType(2));
            }
            case OCCLUSION: {
                return new BoxCollection(this.getBoxType(2), this.getBoxType(1));
            }
            case SWIMMING: {
                return new BoxCollection(this.getBoxType(1));
            }
        }
        return Collections.emptyList();
    }

    private AxisAlignedBB[] generateBoxes(VoxelBlob blob) {
        ArrayList<AxisAlignedBB> cache = new ArrayList<AxisAlignedBB>();
        BitOcclusionIterator boi = new BitOcclusionIterator(cache);
        while (boi.hasNext()) {
            if (boi.getNext(blob) != 0) {
                boi.add();
                continue;
            }
            boi.drop();
        }
        return cache.toArray(new AxisAlignedBB[cache.size()]);
    }

    public int getFormat() {
        if (this.format == Integer.MIN_VALUE) {
            if (this.voxelBytes == null || this.voxelBytes.length == 0) {
                this.format = -1;
            } else {
                try {
                    InflaterInputStream arrayPeek = new InflaterInputStream(new ByteArrayInputStream(this.voxelBytes));
                    byte[] peekBytes = new byte[5];
                    arrayPeek.read(peekBytes);
                    PacketBuffer header = new PacketBuffer(Unpooled.wrappedBuffer((byte[])peekBytes));
                    this.format = header.func_150792_a();
                }
                catch (IOException e) {
                    this.format = 0;
                }
            }
        }
        return this.format;
    }
}

