/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.chiseledblock.data;

import javax.annotation.Nonnull;
import mod.chiselsandbits.api.IBitLocation;
import mod.chiselsandbits.helpers.BitOperation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;

public class BitLocation
implements IBitLocation {
    private static final double One32nd = 0.03125;
    @Nonnull
    public final BlockPos blockPos;
    public final int bitX;
    public final int bitY;
    public final int bitZ;

    @Override
    public BlockPos getBlockPos() {
        return this.blockPos;
    }

    @Override
    public int getBitX() {
        return this.bitX;
    }

    @Override
    public int getBitY() {
        return this.bitY;
    }

    @Override
    public int getBitZ() {
        return this.bitZ;
    }

    public int snapToValid(int x) {
        return Math.min(Math.max(0, x), 15);
    }

    public BitLocation(RayTraceResult mop, boolean absHit, BitOperation type) {
        BlockPos absOffset;
        BlockPos blockPos = absOffset = absHit ? mop.func_178782_a() : BlockPos.field_177992_a;
        if (!type.usePlacementOffset()) {
            this.blockPos = mop.func_178782_a();
            double xCoord = mop.field_72307_f.field_72450_a - (double)absOffset.func_177958_n() - (double)mop.field_178784_b.func_82601_c() * 0.03125;
            double yCoord = mop.field_72307_f.field_72448_b - (double)absOffset.func_177956_o() - (double)mop.field_178784_b.func_96559_d() * 0.03125;
            double zCoord = mop.field_72307_f.field_72449_c - (double)absOffset.func_177952_p() - (double)mop.field_178784_b.func_82599_e() * 0.03125;
            this.bitX = this.snapToValid((int)Math.floor(xCoord * 16.0));
            this.bitY = this.snapToValid((int)Math.floor(yCoord * 16.0));
            this.bitZ = this.snapToValid((int)Math.floor(zCoord * 16.0));
        } else {
            double xCoord = mop.field_72307_f.field_72450_a - (double)absOffset.func_177958_n() + (double)mop.field_178784_b.func_82601_c() * 0.03125;
            double yCoord = mop.field_72307_f.field_72448_b - (double)absOffset.func_177956_o() + (double)mop.field_178784_b.func_96559_d() * 0.03125;
            double zCoord = mop.field_72307_f.field_72449_c - (double)absOffset.func_177952_p() + (double)mop.field_178784_b.func_82599_e() * 0.03125;
            int bitXi = (int)Math.floor(xCoord * 16.0);
            int bitYi = (int)Math.floor(yCoord * 16.0);
            int bitZi = (int)Math.floor(zCoord * 16.0);
            if (bitXi < 0 || bitYi < 0 || bitZi < 0 || bitXi >= 16 || bitYi >= 16 || bitZi >= 16) {
                this.blockPos = mop.func_178782_a().func_177972_a(mop.field_178784_b);
                this.bitX = this.snapToValid(bitXi - mop.field_178784_b.func_82601_c() * 16);
                this.bitY = this.snapToValid(bitYi - mop.field_178784_b.func_96559_d() * 16);
                this.bitZ = this.snapToValid(bitZi - mop.field_178784_b.func_82599_e() * 16);
            } else {
                this.blockPos = mop.func_178782_a();
                this.bitX = this.snapToValid(bitXi);
                this.bitY = this.snapToValid(bitYi);
                this.bitZ = this.snapToValid(bitZi);
            }
        }
    }

    public BitLocation(BlockPos pos, int x, int y, int z) {
        this.blockPos = pos;
        this.bitX = x;
        this.bitY = y;
        this.bitZ = z;
    }

    public static BitLocation min(BitLocation from, BitLocation to) {
        int bitX = BitLocation.Min(from.blockPos.func_177958_n(), to.blockPos.func_177958_n(), from.bitX, to.bitX);
        int bitY = BitLocation.Min(from.blockPos.func_177956_o(), to.blockPos.func_177956_o(), from.bitY, to.bitY);
        int bitZ = BitLocation.Min(from.blockPos.func_177952_p(), to.blockPos.func_177952_p(), from.bitZ, to.bitZ);
        return new BitLocation(new BlockPos(Math.min(from.blockPos.func_177958_n(), to.blockPos.func_177958_n()), Math.min(from.blockPos.func_177956_o(), to.blockPos.func_177956_o()), Math.min(from.blockPos.func_177952_p(), to.blockPos.func_177952_p())), bitX, bitY, bitZ);
    }

    public static BitLocation max(BitLocation from, BitLocation to) {
        int bitX = BitLocation.Max(from.blockPos.func_177958_n(), to.blockPos.func_177958_n(), from.bitX, to.bitX);
        int bitY = BitLocation.Max(from.blockPos.func_177956_o(), to.blockPos.func_177956_o(), from.bitY, to.bitY);
        int bitZ = BitLocation.Max(from.blockPos.func_177952_p(), to.blockPos.func_177952_p(), from.bitZ, to.bitZ);
        return new BitLocation(new BlockPos(Math.max(from.blockPos.func_177958_n(), to.blockPos.func_177958_n()), Math.max(from.blockPos.func_177956_o(), to.blockPos.func_177956_o()), Math.max(from.blockPos.func_177952_p(), to.blockPos.func_177952_p())), bitX, bitY, bitZ);
    }

    private static int Min(int x, int x2, int bitX2, int bitX3) {
        if (x < x2) {
            return bitX2;
        }
        if (x2 == x) {
            return Math.min(bitX2, bitX3);
        }
        return bitX3;
    }

    private static int Max(int x, int x2, int bitX2, int bitX3) {
        if (x > x2) {
            return bitX2;
        }
        if (x2 == x) {
            return Math.max(bitX2, bitX3);
        }
        return bitX3;
    }
}

