/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.render.helpers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockFaceUV;
import net.minecraft.client.renderer.block.model.BlockPartFace;
import net.minecraft.client.renderer.block.model.BlockPartRotation;
import net.minecraft.client.renderer.block.model.FaceBakery;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.block.model.ModelRotation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.client.model.pipeline.LightUtil;
import net.minecraftforge.client.model.pipeline.UnpackedBakedQuad;
import org.lwjgl.util.vector.Vector3f;

public class SimpleGeneratedModel
implements IBakedModel {
    final List<BakedQuad>[] face = new List[6];
    final TextureAtlasSprite texture;

    public SimpleGeneratedModel(TextureAtlasSprite texture) {
        this.face[0] = new ArrayList<BakedQuad>();
        this.face[1] = new ArrayList<BakedQuad>();
        this.face[2] = new ArrayList<BakedQuad>();
        this.face[3] = new ArrayList<BakedQuad>();
        this.face[4] = new ArrayList<BakedQuad>();
        this.face[5] = new ArrayList<BakedQuad>();
        this.texture = texture;
        float[] afloat = new float[]{0.0f, 0.0f, 16.0f, 16.0f};
        BlockFaceUV uv = new BlockFaceUV(afloat, 0);
        FaceBakery faceBakery = new FaceBakery();
        Vector3f to = new Vector3f(0.0f, 0.0f, 0.0f);
        Vector3f from = new Vector3f(16.0f, 16.0f, 16.0f);
        BlockPartRotation bpr = null;
        ModelRotation mr = ModelRotation.X0_Y0;
        float maxLightmap = 4.882887E-4f;
        boolean lightValue = false;
        float lightMap = 4.882887E-4f * (float)Math.max(0, Math.min(15, 0));
        for (EnumFacing side : EnumFacing.field_82609_l) {
            Vector3f fromB;
            Vector3f toB;
            BlockPartFace bpf = new BlockPartFace(side, 1, "", uv);
            switch (side) {
                case UP: {
                    toB = new Vector3f(to.x, from.y, to.z);
                    fromB = new Vector3f(from.x, from.y, from.z);
                    break;
                }
                case EAST: {
                    toB = new Vector3f(from.x, to.y, to.z);
                    fromB = new Vector3f(from.x, from.y, from.z);
                    break;
                }
                case NORTH: {
                    toB = new Vector3f(to.x, to.y, to.z);
                    fromB = new Vector3f(from.x, from.y, to.z);
                    break;
                }
                case SOUTH: {
                    toB = new Vector3f(to.x, to.y, from.z);
                    fromB = new Vector3f(from.x, from.y, from.z);
                    break;
                }
                case DOWN: {
                    toB = new Vector3f(to.x, to.y, to.z);
                    fromB = new Vector3f(from.x, to.y, from.z);
                    break;
                }
                case WEST: {
                    toB = new Vector3f(to.x, to.y, to.z);
                    fromB = new Vector3f(to.x, from.y, from.z);
                    break;
                }
                default: {
                    throw new NullPointerException();
                }
            }
            BakedQuad g = faceBakery.func_178414_a(toB, fromB, bpf, texture, side, mr, bpr, false, true);
            this.face[side.ordinal()].add(this.finishFace(g, side, DefaultVertexFormats.field_176600_a));
        }
    }

    private BakedQuad finishFace(BakedQuad g, EnumFacing myFace, VertexFormat format) {
        int[] vertData = g.func_178209_a();
        int wrapAt = vertData.length / 4;
        UnpackedBakedQuad.Builder b = new UnpackedBakedQuad.Builder(format);
        b.setQuadOrientation(myFace);
        b.setQuadTint(1);
        b.setTexture(g.func_187508_a());
        for (int vertNum = 0; vertNum < 4; ++vertNum) {
            block7: for (int elementIndex = 0; elementIndex < format.func_177345_h(); ++elementIndex) {
                VertexFormatElement element = format.func_177348_c(elementIndex);
                switch (element.func_177375_c()) {
                    case POSITION: {
                        b.put(elementIndex, new float[]{Float.intBitsToFloat(vertData[0 + wrapAt * vertNum]), Float.intBitsToFloat(vertData[1 + wrapAt * vertNum]), Float.intBitsToFloat(vertData[2 + wrapAt * vertNum])});
                        continue block7;
                    }
                    case COLOR: {
                        float light = LightUtil.diffuseLight((EnumFacing)myFace);
                        b.put(elementIndex, new float[]{light, light, light, 1.0f});
                        continue block7;
                    }
                    case NORMAL: {
                        b.put(elementIndex, new float[]{myFace.func_82601_c(), myFace.func_96559_d(), myFace.func_82599_e()});
                        continue block7;
                    }
                    case UV: {
                        if (element.func_177369_e() == 1) {
                            b.put(elementIndex, new float[]{0.0f, 0.0f});
                            continue block7;
                        }
                        float u = Float.intBitsToFloat(vertData[4 + wrapAt * vertNum]);
                        float v = Float.intBitsToFloat(vertData[5 + wrapAt * vertNum]);
                        b.put(elementIndex, new float[]{u, v});
                        continue block7;
                    }
                    default: {
                        b.put(elementIndex, new float[0]);
                    }
                }
            }
        }
        return b.build();
    }

    public List<BakedQuad>[] getFace() {
        return this.face;
    }

    public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
        if (side == null) {
            return Collections.emptyList();
        }
        return this.face[side.ordinal()];
    }

    public boolean func_177555_b() {
        return true;
    }

    public boolean func_177556_c() {
        return true;
    }

    public ItemCameraTransforms func_177552_f() {
        return ItemCameraTransforms.field_178357_a;
    }

    public TextureAtlasSprite func_177554_e() {
        return this.texture;
    }

    public boolean func_188618_c() {
        return false;
    }

    public ItemOverrideList func_188617_f() {
        return ItemOverrideList.field_188022_a;
    }
}

