/*
 * Decompiled with CFR 0.152.
 */
package blockworks.items;

import blockworks.Blockworks;
import blockworks.items.WandBase;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.ForgeDirection;

public class CopyWand
extends WandBase {
    public int[][][] blockIDs = new int[0][0][0];
    public int[][][] metadata = new int[0][0][0];
    public HashMap<List, Integer> blockCount = new HashMap();

    public CopyWand(int id) {
        super(id);
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (player.func_70093_af()) {
            this.rotateStructure(player);
        } else {
            this.copyArea((EntityLivingBase)player, stack);
        }
        return stack;
    }

    public boolean onEntitySwing(EntityLivingBase player, ItemStack stack) {
        this.placeCopy(player, stack);
        return true;
    }

    public void rotateStructure(EntityPlayer player) {
        if (!player.field_70170_p.field_72995_K && player instanceof EntityPlayer) {
            player.func_71035_c("Rotating Structure");
        }
        int xLength = this.blockIDs.length;
        int yLength = this.blockIDs[0].length;
        int zLength = this.blockIDs[0][0].length;
        int[][][] tempIDs = new int[zLength][yLength][xLength];
        int[][][] tempMeta = new int[zLength][yLength][xLength];
        for (int y = 0; y < yLength; ++y) {
            for (int x = 0; x < xLength; ++x) {
                for (int z = 0; z < zLength; ++z) {
                    tempIDs[zLength - z - 1][y][x] = this.blockIDs[x][y][z];
                    tempMeta[zLength - z - 1][y][x] = this.metadata[x][y][z];
                }
            }
        }
        this.blockIDs = tempIDs;
        this.metadata = tempMeta;
    }

    boolean inside() {
        return true;
    }

    public void copyArea(EntityLivingBase player, ItemStack stack) {
        MovingObjectPosition mop = this.raytraceFromPlayer(player.field_70170_p, player, false);
        if (mop != null) {
            NBTTagCompound tags;
            byte clicks;
            int xPos = mop.field_72311_b;
            int yPos = mop.field_72312_c;
            int zPos = mop.field_72309_d;
            if (!this.inside()) {
                ForgeDirection sideHit = ForgeDirection.getOrientation((int)mop.field_72310_e);
                switch (sideHit) {
                    case UP: {
                        ++yPos;
                        break;
                    }
                    case DOWN: {
                        --yPos;
                        break;
                    }
                    case NORTH: {
                        --zPos;
                        break;
                    }
                    case SOUTH: {
                        ++zPos;
                        break;
                    }
                    case EAST: {
                        ++xPos;
                        break;
                    }
                    case WEST: {
                        --xPos;
                        break;
                    }
                }
            }
            if ((clicks = (tags = stack.func_77978_p().func_74775_l("Wandworks")).func_74771_c("clicks")) == 0) {
                tags.func_74783_a("clickOne", new int[]{xPos, yPos, zPos});
                if (!player.field_70170_p.field_72995_K && player instanceof EntityPlayer) {
                    ((EntityPlayer)player).func_71035_c("First coord set at X: " + xPos + ", Y: " + yPos + ", Z: " + zPos);
                }
                tags.func_74774_a("clicks", (byte)1);
            } else {
                int[] start = tags.func_74759_k("clickOne");
                int startX = xPos < start[0] ? xPos : start[0];
                int startY = yPos < start[1] ? yPos : start[1];
                int startZ = zPos < start[2] ? zPos : start[2];
                int endX = xPos > start[0] ? xPos : start[0];
                int endY = yPos > start[1] ? yPos : start[1];
                int endZ = zPos > start[2] ? zPos : start[2];
                this.blockIDs = new int[endX - startX + 1][endY - startY + 1][endZ - startZ + 1];
                this.metadata = new int[endX - startX + 1][endY - startY + 1][endZ - startZ + 1];
                this.blockCount.clear();
                for (int x = startX; x <= endX; ++x) {
                    for (int y = startY; y <= endY; ++y) {
                        for (int z = startZ; z <= endZ; ++z) {
                            this.readBlockIntoArray(player.field_70170_p, x, y, z, startX, startY, startZ);
                        }
                    }
                }
                if (!player.field_70170_p.field_72995_K && player instanceof EntityPlayer) {
                    ((EntityPlayer)player).func_71035_c("Second coord set at X: " + xPos + ", Y: " + yPos + ", Z: " + zPos);
                }
                tags.func_74774_a("clicks", (byte)0);
                tags.func_74783_a("clickOne", new int[0]);
            }
        }
    }

    void readBlockIntoArray(World world, int x, int y, int z, int startX, int startY, int startZ) {
        int blockID = world.func_72798_a(x, y, z);
        int meta = world.func_72805_g(x, y, z);
        this.blockIDs[x - startX][y - startY][z - startZ] = blockID;
        this.metadata[x - startX][y - startY][z - startZ] = meta;
        List<Integer> key = Arrays.asList(blockID, meta);
        int amount = 0;
        if (this.blockCount.containsKey(key)) {
            amount = this.blockCount.get(key);
        }
        this.blockCount.put(key, ++amount);
    }

    public void placeCopy(EntityLivingBase player, ItemStack stack) {
        MovingObjectPosition mop;
        if (this.blockIDs.length > 0 && (mop = this.raytraceFromPlayer(player.field_70170_p, player, false)) != null) {
            int xPos = mop.field_72311_b;
            int yPos = mop.field_72312_c;
            int zPos = mop.field_72309_d;
            ForgeDirection sideHit = ForgeDirection.getOrientation((int)mop.field_72310_e);
            switch (sideHit) {
                case UP: {
                    ++yPos;
                    break;
                }
                case DOWN: {
                    --yPos;
                    break;
                }
                case NORTH: {
                    --zPos;
                    break;
                }
                case SOUTH: {
                    ++zPos;
                    break;
                }
                case EAST: {
                    ++xPos;
                    break;
                }
                case WEST: {
                    --xPos;
                    break;
                }
            }
            World world = player.field_70170_p;
            for (int x = 0; x < this.blockIDs.length; ++x) {
                for (int y = 0; y < this.blockIDs[0].length; ++y) {
                    for (int z = 0; z < this.blockIDs[0][0].length; ++z) {
                        world.func_72832_d(xPos + x, yPos + y, zPos + z, this.blockIDs[x][y][z], this.metadata[x][y][z], 3);
                    }
                }
            }
        }
    }

    String structureName() {
        return "structure";
    }

    @Override
    public void saveKey() {
        System.out.println("Saving structure");
        if (this.blockIDs.length > 0) {
            File structure = new File(Blockworks.structureFolder.getAbsolutePath() + "/" + this.structureName() + ".txt");
            try {
                FileOutputStream fos = new FileOutputStream(structure);
                BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)fos, "UTF-8"));
                writer.write("Structure: Test");
                writer.newLine();
                writer.write("Size - x:" + this.blockIDs.length + ", y:" + this.blockIDs[0].length + ", z:" + this.blockIDs[0][0].length);
                writer.newLine();
                this.writeBlockAmounts(writer);
                writer.newLine();
                for (int y = this.blockIDs[0].length - 1; y >= 0; --y) {
                    writer.write("startlayer y:" + y);
                    writer.newLine();
                    for (int x = 0; x < this.blockIDs.length; ++x) {
                        for (int z = 0; z < this.blockIDs[0][0].length; ++z) {
                            writer.write(this.blockIDs[x][y][z] + ":" + this.metadata[x][y][z] + ",");
                        }
                        writer.newLine();
                    }
                    writer.write("endlayer");
                    writer.newLine();
                    writer.newLine();
                }
                writer.close();
                fos.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    void writeBlockAmounts(BufferedWriter writer) throws IOException {
        this.blockCount.remove(Arrays.asList(0, 0));
        for (Map.Entry<List, Integer> pairs : this.blockCount.entrySet()) {
            List list = pairs.getKey();
            Object[] block = list.toArray();
            writer.write(block[0] + ":" + block[1] + " - " + pairs.getValue());
            writer.newLine();
        }
    }

    @Override
    public void loadKey() {
        System.out.println("Loading structure");
        File file = new File(Blockworks.structureFolder.getAbsolutePath() + "/" + this.structureName() + ".txt");
        BufferedReader reader = null;
        Configuration.UnicodeInputStreamReader input = null;
        try {
            input = new Configuration.UnicodeInputStreamReader((InputStream)new FileInputStream(file), "UTF-8");
            reader = new BufferedReader((Reader)input);
            reader.readLine();
            String line = reader.readLine();
            int[] size = new int[3];
            String[] sizeString = line.split(",");
            for (int i = 0; i < 3; ++i) {
                String[] lsize = sizeString[i].split(":");
                size[i] = new Integer(lsize[1]);
            }
            this.blockIDs = new int[size[0]][size[1]][size[2]];
            this.metadata = new int[size[0]][size[1]][size[2]];
            while ((line = reader.readLine()) != null) {
                if (!line.contains("startlayer")) continue;
                String[] split = line.split(":");
                Integer i = new Integer(split[1]);
                this.readLayer(reader, new Integer(split[1]));
            }
            input.close();
            reader.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void readLayer(BufferedReader reader, Integer y) throws IOException {
        String line;
        int z = 0;
        while ((line = reader.readLine()) != null && !line.contains("endlayer")) {
            String[] blocks = line.split(",");
            for (int x = 0; x < blocks.length; ++x) {
                String[] ids = blocks[x].split(":");
                this.blockIDs[x][y.intValue()][z] = new Integer(ids[0]);
                this.metadata[x][y.intValue()][z] = new Integer(ids[1]);
            }
            ++z;
        }
    }

    public void func_77633_a(int id, CreativeTabs tabs, List list) {
        ItemStack stack = new ItemStack(id, 1, 0);
        NBTTagCompound compound = new NBTTagCompound();
        NBTTagCompound tags = new NBTTagCompound();
        compound.func_74766_a("Wandworks", tags);
        stack.func_77982_d(compound);
        list.add(stack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        list.add("\u00a7bCopies the world data between two points");
        list.add("\u00a7bRight-click: Select two points to copy");
        list.add("\u00a7bLeft-click: Paste copied data into the world");
    }
}

