/*
 * Decompiled with CFR 0.152.
 */
package blockworks.items;

import blockworks.Blockworks;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public class WallWand
extends Item {
    public WallWand(int id) {
        super(id);
        this.func_77637_a(Blockworks.tab);
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (player.func_70093_af()) {
            this.chooseNewBlock(player, stack);
        } else {
            this.placeBlock(player, stack);
        }
        return stack;
    }

    public boolean onEntitySwing(EntityLivingBase entityLiving, ItemStack stack) {
        if (entityLiving instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entityLiving;
            this.placeBlock(player, stack);
        }
        return true;
    }

    public void chooseNewBlock(EntityPlayer player, ItemStack stack) {
        World world = player.field_70170_p;
        MovingObjectPosition mop = this.raytraceFromPlayer(world, player, false);
        if (mop != null) {
            int xPos = mop.field_72311_b;
            int yPos = mop.field_72312_c;
            int zPos = mop.field_72309_d;
            int blockID = world.func_72798_a(xPos, yPos, zPos);
            int blockMeta = world.func_72805_g(xPos, yPos, zPos);
            ItemStack blockStack = new ItemStack(blockID, 1, blockMeta);
            if (!player.field_70170_p.field_72995_K) {
                player.func_71035_c("New block: " + blockStack.func_82833_r());
            }
            NBTTagCompound tags = stack.func_77978_p().func_74775_l("Wandworks");
            tags.func_74768_a("mainID", blockID);
            tags.func_74768_a("mainMeta", blockMeta);
        } else {
            int blockID = 0;
            int blockMeta = 0;
            if (!player.field_70170_p.field_72995_K) {
                player.func_71035_c("New block: Air");
            }
            NBTTagCompound tags = stack.func_77978_p().func_74775_l("Wandworks");
            tags.func_74768_a("mainID", blockID);
            tags.func_74768_a("mainMeta", blockMeta);
        }
    }

    public void placeBlock(EntityPlayer player, ItemStack stack) {
        MovingObjectPosition mop = this.raytraceFromPlayer(player.field_70170_p, player, false);
        if (mop != null) {
            int xPos = mop.field_72311_b;
            int yPos = mop.field_72312_c;
            int zPos = mop.field_72309_d;
            ForgeDirection sideHit = ForgeDirection.getOrientation((int)mop.field_72310_e);
            switch (sideHit) {
                case UP: {
                    ++yPos;
                    break;
                }
                case DOWN: {
                    --yPos;
                    break;
                }
                case NORTH: {
                    --zPos;
                    break;
                }
                case SOUTH: {
                    ++zPos;
                    break;
                }
                case EAST: {
                    ++xPos;
                    break;
                }
                case WEST: {
                    --xPos;
                    break;
                }
            }
            NBTTagCompound tags = stack.func_77978_p().func_74775_l("Wandworks");
            byte clicks = tags.func_74771_c("clicks");
            if (clicks == 0) {
                tags.func_74783_a("clickOne", new int[]{xPos, yPos, zPos});
                if (!player.field_70170_p.field_72995_K) {
                    player.func_71035_c("First coord set at X: " + xPos + ", Y: " + yPos + ", Z: " + zPos);
                }
                tags.func_74774_a("clicks", (byte)1);
            } else {
                int[] start = tags.func_74759_k("clickOne");
                int startX = xPos < start[0] ? xPos : start[0];
                int startY = yPos < start[1] ? yPos : start[1];
                int startZ = zPos < start[2] ? zPos : start[2];
                int endX = xPos > start[0] ? xPos : start[0];
                int endY = yPos > start[1] ? yPos : start[1];
                int endZ = zPos > start[2] ? zPos : start[2];
                for (int x = startX; x <= endX; ++x) {
                    for (int y = startY; y <= endY; ++y) {
                        for (int z = startZ; z <= endZ; ++z) {
                            player.field_70170_p.func_72832_d(x, y, z, tags.func_74762_e("mainID"), tags.func_74762_e("mainMeta"), 3);
                        }
                    }
                }
                if (!player.field_70170_p.field_72995_K) {
                    player.func_71035_c("Second coord set at X: " + xPos + ", Y: " + yPos + ", Z: " + zPos);
                }
                tags.func_74774_a("clicks", (byte)0);
                tags.func_74783_a("clickOne", new int[0]);
            }
        }
    }

    public MovingObjectPosition raytraceFromPlayer(World par1World, EntityPlayer par2EntityPlayer, boolean par3) {
        float f = 1.0f;
        float f1 = par2EntityPlayer.field_70127_C + (par2EntityPlayer.field_70125_A - par2EntityPlayer.field_70127_C) * f;
        float f2 = par2EntityPlayer.field_70126_B + (par2EntityPlayer.field_70177_z - par2EntityPlayer.field_70126_B) * f;
        double d0 = par2EntityPlayer.field_70169_q + (par2EntityPlayer.field_70165_t - par2EntityPlayer.field_70169_q) * (double)f;
        double d1 = par2EntityPlayer.field_70167_r + (par2EntityPlayer.field_70163_u - par2EntityPlayer.field_70167_r) * (double)f + 1.62 - (double)par2EntityPlayer.field_70129_M;
        double d2 = par2EntityPlayer.field_70166_s + (par2EntityPlayer.field_70161_v - par2EntityPlayer.field_70166_s) * (double)f;
        Vec3 vec3 = par1World.func_82732_R().func_72345_a(d0, d1, d2);
        float f3 = MathHelper.func_76134_b((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = MathHelper.func_76126_a((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
        float f5 = -MathHelper.func_76134_b((float)(-f1 * ((float)Math.PI / 180)));
        float f6 = MathHelper.func_76126_a((float)(-f1 * ((float)Math.PI / 180)));
        float f7 = f4 * f5;
        float f8 = f3 * f5;
        double d3 = 500.0;
        Vec3 vec31 = vec3.func_72441_c((double)f7 * d3, (double)f6 * d3, (double)f8 * d3);
        return par1World.func_72831_a(vec3, vec31, par3, !par3);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IconRegister par1IconRegister) {
        this.field_77791_bV = par1IconRegister.func_94245_a("blockworks:wallwand");
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        list.add("\u00a7bCreates a wall of blocks");
        list.add("\u00a7bbetween two points");
        NBTTagCompound tags = stack.func_77978_p().func_74775_l("Wandworks");
        int mainID = tags.func_74762_e("mainID");
        if (mainID == 0) {
            list.add("Selected block: Air");
        } else {
            ItemStack blockStack = new ItemStack(mainID, 1, tags.func_74762_e("mainMeta"));
            list.add("Selected block: " + blockStack.func_82833_r());
        }
    }

    public void func_77633_a(int id, CreativeTabs tabs, List list) {
        ItemStack stack = new ItemStack(id, 1, 0);
        NBTTagCompound compound = new NBTTagCompound();
        NBTTagCompound tags = new NBTTagCompound();
        compound.func_74766_a("Wandworks", tags);
        tags.func_74768_a("Height", 1);
        tags.func_74768_a("Width", 1);
        tags.func_74768_a("Length", 1);
        tags.func_74774_a("mode", (byte)1);
        tags.func_74774_a("clicks", (byte)0);
        tags.func_74768_a("mainID", Block.field_71939_E.field_71990_ca);
        tags.func_74768_a("mainMeta", 0);
        tags.func_74768_a("altID", 0);
        tags.func_74768_a("altMeta", 0);
        stack.func_77982_d(compound);
        list.add(stack);
    }
}

