/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jruby.RubyInstanceConfig;
import org.jruby.ir.IRClassBody;
import org.jruby.ir.IRMetaClassBody;
import org.jruby.ir.IRModuleBody;
import org.jruby.ir.IRScope;
import org.jruby.ir.listeners.IRScopeListener;
import org.jruby.ir.listeners.InstructionsListener;
import org.jruby.ir.operands.BooleanLiteral;
import org.jruby.ir.operands.Nil;
import org.jruby.ir.passes.BasicCompilerPassListener;
import org.jruby.ir.passes.CompilerPass;
import org.jruby.ir.passes.CompilerPassListener;
import org.jruby.ir.passes.CompilerPassScheduler;

public class IRManager {
    public static String DEFAULT_COMPILER_PASSES = "OptimizeTempVarsPass,LocalOptimizationPass,LinearizeCFG";
    public static String DEFAULT_INLINING_COMPILER_PASSES = "LocalOptimizationPass";
    private int dummyMetaClassCount = 0;
    private final IRModuleBody classMetaClass = new IRMetaClassBody(this, null, this.getMetaClassName(), "", 0, null);
    private final IRModuleBody object = new IRClassBody(this, null, "Object", "", 0, null);
    private final Nil nil = new Nil();
    private final BooleanLiteral trueObject = new BooleanLiteral(true);
    private final BooleanLiteral falseObject = new BooleanLiteral(false);
    private Set<CompilerPassListener> passListeners = new HashSet<CompilerPassListener>();
    private CompilerPassListener defaultListener = new BasicCompilerPassListener();
    private InstructionsListener instrsListener = null;
    private IRScopeListener irScopeListener = null;
    private List<CompilerPass> compilerPasses = new ArrayList<CompilerPass>();
    private List<CompilerPass> inliningCompilerPasses = new ArrayList<CompilerPass>();
    private boolean dryRun = false;

    public IRManager() {
        this.compilerPasses = CompilerPass.getPassesFromString(RubyInstanceConfig.IR_COMPILER_PASSES, DEFAULT_COMPILER_PASSES);
        this.inliningCompilerPasses = CompilerPass.getPassesFromString(RubyInstanceConfig.IR_COMPILER_PASSES, DEFAULT_INLINING_COMPILER_PASSES);
    }

    public boolean isDryRun() {
        return this.dryRun;
    }

    public void setDryRun(boolean value2) {
        this.dryRun = value2;
    }

    public Nil getNil() {
        return this.nil;
    }

    public BooleanLiteral getTrue() {
        return this.trueObject;
    }

    public BooleanLiteral getFalse() {
        return this.falseObject;
    }

    public IRModuleBody getObject() {
        return this.object;
    }

    public CompilerPassScheduler schedulePasses() {
        CompilerPassScheduler scheduler = new CompilerPassScheduler(){
            private Iterator<CompilerPass> iterator;
            {
                this.iterator = IRManager.this.compilerPasses.iterator();
            }

            @Override
            public Iterator<CompilerPass> iterator() {
                return this.iterator;
            }
        };
        return scheduler;
    }

    public List<CompilerPass> getCompilerPasses(IRScope scope) {
        return this.compilerPasses;
    }

    public List<CompilerPass> getInliningCompilerPasses(IRScope scope) {
        return this.inliningCompilerPasses;
    }

    public Set<CompilerPassListener> getListeners() {
        if (RubyInstanceConfig.IR_COMPILER_DEBUG) {
            this.addListener(this.defaultListener);
        } else {
            this.removeListener(this.defaultListener);
        }
        return this.passListeners;
    }

    public InstructionsListener getInstructionsListener() {
        return this.instrsListener;
    }

    public IRScopeListener getIRScopeListener() {
        return this.irScopeListener;
    }

    public void addListener(CompilerPassListener listener) {
        this.passListeners.add(listener);
    }

    public void removeListener(CompilerPassListener listener) {
        this.passListeners.remove(listener);
    }

    public void addListener(InstructionsListener listener) {
        if (RubyInstanceConfig.IR_COMPILER_DEBUG || RubyInstanceConfig.IR_VISUALIZER) {
            if (this.instrsListener != null) {
                throw new RuntimeException("InstructionsListener is set and other are currently not allowed");
            }
            this.instrsListener = listener;
        }
    }

    public void removeListener(InstructionsListener listener) {
        if (this.instrsListener.equals(listener)) {
            this.instrsListener = null;
        }
    }

    public void addListener(IRScopeListener listener) {
        if (RubyInstanceConfig.IR_COMPILER_DEBUG || RubyInstanceConfig.IR_VISUALIZER) {
            if (this.irScopeListener != null) {
                throw new RuntimeException("IRScopeListener is set and other are currently not allowed");
            }
            this.irScopeListener = listener;
        }
    }

    public void removeListener(IRScopeListener listener) {
        if (this.irScopeListener.equals(listener)) {
            this.irScopeListener = null;
        }
    }

    public IRModuleBody getClassMetaClass() {
        return this.classMetaClass;
    }

    public String getMetaClassName() {
        return "<DUMMY_MC:" + this.dummyMetaClassCount++ + ">";
    }
}

