/*
 * Decompiled with CFR 0.152.
 */
package mods.quiddity.redux;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.Channel;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import mods.quiddity.redux.Engines.Ruby.ReduxJRubyEngine;
import mods.quiddity.redux.ReduxCommands;
import mods.quiddity.redux.ReduxCommonProxy;
import mods.quiddity.redux.ReduxEventDispatcher;
import mods.quiddity.redux.ReduxLogger;
import mods.quiddity.redux.json.JSONSingleton;
import mods.quiddity.redux.json.model.Config;
import mods.quiddity.redux.loader.ReduxPackLoader;
import net.minecraft.command.ICommand;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import org.apache.logging.log4j.Logger;

@Mod(modid="redux", version="${version}", acceptedMinecraftVersions="[1.8]")
public class Redux {
    public static final String MODID = "redux";
    public static final String VERSION = "${version}";
    public static final String GROUP = "mods/quiddity";
    public static File reduxFolder;
    public static final Class engineType;
    @Mod.Instance(value="redux")
    public static Redux instance;
    @SidedProxy(clientSide="mods.quiddity.redux.ReduxClientProxy", serverSide="mods.quiddity.redux.ReduxCommonProxy")
    public static ReduxCommonProxy proxy;
    private Config reduxConfiguration = null;
    private final ReduxLogger logger = new ReduxLogger("redux");

    public Redux() {
        instance = this;
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event2) {
        reduxFolder = new File(event2.getModConfigurationDirectory(), MODID);
        if (!reduxFolder.exists()) {
            reduxFolder.mkdirs();
        }
        try {
            this.reduxConfiguration = JSONSingleton.getInstance().loadConfig();
        }
        catch (JSONSingleton.JSONLoadException e) {
            this.logger.fatal("Error loading configuration!", e);
        }
        this.logger.loadConfigLevel();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event2) {
        new ReduxPackLoader(this.reduxConfiguration).loadPacks();
    }

    @Mod.EventHandler
    public void onServerStart(FMLServerStartingEvent event2) {
        ReduxEventDispatcher.getInstance();
        for (ICommand command : ReduxCommands.getCommands()) {
            event2.registerServerCommand(command);
        }
    }

    public Logger getLogger() {
        return this.logger;
    }

    public Config getReduxConfiguration() {
        return this.reduxConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyResource(String sourceFile, File destFile) throws IOException {
        if (!destFile.exists()) {
            destFile.createNewFile();
        }
        Channel source2 = null;
        AbstractInterruptibleChannel destination = null;
        FileOutputStream fileOutput = null;
        InputStream resource2 = null;
        try {
            resource2 = Redux.class.getClassLoader().getResourceAsStream(sourceFile);
            source2 = Channels.newChannel(resource2);
            fileOutput = new FileOutputStream(destFile);
            destination = fileOutput.getChannel();
            ((FileChannel)destination).transferFrom((ReadableByteChannel)source2, 0L, resource2.available());
        }
        finally {
            if (source2 != null) {
                source2.close();
            }
            if (destination != null) {
                destination.close();
            }
            if (fileOutput != null) {
                fileOutput.close();
            }
            if (resource2 != null) {
                resource2.close();
            }
        }
    }

    static {
        engineType = ReduxJRubyEngine.class;
        instance = null;
    }
}

