/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.opto;

import org.jruby.RubyModule;
import org.jruby.compiler.CacheCompiler;
import org.jruby.compiler.InvocationCompiler;
import org.jruby.compiler.impl.BaseBodyCompiler;
import org.jruby.compiler.impl.InheritedCacheCompiler;
import org.jruby.compiler.impl.InvokeDynamicCacheCompiler;
import org.jruby.compiler.impl.InvokeDynamicInvocationCompiler;
import org.jruby.compiler.impl.SkinnyMethodAdapter;
import org.jruby.compiler.impl.StandardASMCompiler;
import org.jruby.compiler.impl.StandardInvocationCompiler;
import org.jruby.runtime.opto.FailoverSwitchPointInvalidator;
import org.jruby.runtime.opto.GenerationAndSwitchPointInvalidator;
import org.jruby.runtime.opto.GenerationInvalidator;
import org.jruby.runtime.opto.Invalidator;
import org.jruby.runtime.opto.ObjectIdentityInvalidator;
import org.jruby.runtime.opto.SwitchPointInvalidator;
import org.jruby.util.cli.Options;

public class OptoFactory {
    public static InvocationCompiler newInvocationCompiler(BaseBodyCompiler bodyCompiler, SkinnyMethodAdapter method2) {
        if (OptoFactory.indyEnabled().booleanValue()) {
            try {
                return new InvokeDynamicInvocationCompiler(bodyCompiler, method2);
            }
            catch (Error e) {
                OptoFactory.disableIndy();
                throw e;
            }
            catch (Throwable t) {
                OptoFactory.disableIndy();
            }
        }
        return new StandardInvocationCompiler(bodyCompiler, method2);
    }

    public static CacheCompiler newCacheCompiler(StandardASMCompiler scriptCompiler) {
        if (OptoFactory.indyEnabled().booleanValue()) {
            try {
                return new InvokeDynamicCacheCompiler(scriptCompiler);
            }
            catch (Error e) {
                OptoFactory.disableIndy();
                throw e;
            }
            catch (Throwable t) {
                OptoFactory.disableIndy();
            }
        }
        return new InheritedCacheCompiler(scriptCompiler);
    }

    public static Invalidator newConstantInvalidator() {
        if (OptoFactory.indyEnabled().booleanValue() && OptoFactory.indyConstants().booleanValue()) {
            try {
                return new SwitchPointInvalidator();
            }
            catch (Error e) {
                OptoFactory.disableIndy();
                throw e;
            }
            catch (Throwable t) {
                OptoFactory.disableIndy();
            }
        }
        return new ObjectIdentityInvalidator();
    }

    private static Boolean indyEnabled() {
        return Options.COMPILE_INVOKEDYNAMIC.load();
    }

    public static Invalidator newGlobalInvalidator(int maxFailures) {
        if (OptoFactory.indyEnabled().booleanValue() && OptoFactory.indyConstants().booleanValue()) {
            try {
                return new FailoverSwitchPointInvalidator(maxFailures);
            }
            catch (Error e) {
                OptoFactory.disableIndy();
                throw e;
            }
            catch (Throwable t) {
                OptoFactory.disableIndy();
            }
        }
        return new ObjectIdentityInvalidator();
    }

    public static Invalidator newMethodInvalidator(RubyModule module) {
        if (OptoFactory.indyEnabled().booleanValue() && OptoFactory.indyInvocationSwitchpoint().booleanValue()) {
            try {
                return new GenerationAndSwitchPointInvalidator(module);
            }
            catch (Error e) {
                OptoFactory.disableIndy();
                throw e;
            }
            catch (Throwable t) {
                OptoFactory.disableIndy();
            }
        }
        return new GenerationInvalidator(module);
    }

    private static Boolean indyConstants() {
        return Options.INVOKEDYNAMIC_CACHE_CONSTANTS.load();
    }

    private static Boolean indyInvocationSwitchpoint() {
        return Options.INVOKEDYNAMIC_INVOCATION_SWITCHPOINT.load();
    }

    private static void disableIndy() {
        Options.COMPILE_INVOKEDYNAMIC.force("false");
    }
}

