/*
 * Decompiled with CFR 0.152.
 */
package mods.quiddity.redux;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import mods.quiddity.redux.json.model.Trigger;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;

public class ReduxCommands {
    public static final ReduxCommand TEST_FOR_TRIGGER = new ReduxCommand("testfortrigger", "/testfortrigger <trigger type>", new ReduxCommandRunnable(){

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void run(ICommandSender sender, String ... args) throws CommandException {
            if (args.length < 1) {
                throw new CommandException("Incorrect parameters", new Object[0]);
            }
            String trigger = args[0];
            try {
                Trigger.TriggerEvent event = Trigger.TriggerEvent.valueOf(trigger);
                if (event == null) throw new CommandException("failure", new Object[0]);
            }
            catch (IllegalArgumentException ignored) {
                throw new CommandException("Trigger type %s does not exist!", new Object[]{trigger});
            }
            throw new CommandException("failure", new Object[0]);
        }
    });
    public static final ReduxCommand TEST_FOR_PROPERTY = new ReduxCommand("testforproperty", "/testforproperty <property name> <integer value>", new ReduxCommandRunnable(){

        @Override
        public void run(ICommandSender sender, String ... args) throws CommandException {
            if (args.length < 2) {
                throw new CommandException("Incorrect parameters", new Object[0]);
            }
            try {
                int testValue = Integer.parseInt(args[1]);
            }
            catch (NumberFormatException e) {
                throw new CommandException("Second parameter must be an integer!", new Object[0]);
            }
            throw new CommandException("failure", new Object[0]);
        }
    });
    public static final ReduxCommand SET_PROPERTY = new ReduxCommand("setproperty", "/setproperty <property name> <integer value>", new ReduxCommandRunnable(){

        @Override
        public void run(ICommandSender sender, String ... args) throws CommandException {
            if (args.length < 2) {
                throw new CommandException("Incorrect parameters", new Object[0]);
            }
            try {
                int setValue = Integer.parseInt(args[1]);
            }
            catch (NumberFormatException e) {
                throw new CommandException("Second parameter must be an integer!", new Object[0]);
            }
            throw new CommandException("failure", new Object[0]);
        }
    });
    public static final ReduxCommand TEST = new ReduxCommand("test", "/test <value(string or integer) 1> <operation> <value(string or integer) 2>", new ReduxCommandRunnable(){

        @Override
        public void run(ICommandSender sender, String ... args) throws CommandException {
            if (args.length < 3) {
                throw new CommandException("Incorrect parameters", new Object[0]);
            }
            int result = 0;
            try {
                if (args[1].equalsIgnoreCase("&&")) {
                    result = Boolean.valueOf(args[0]) != false && Boolean.valueOf(args[2]) != false ? 1 : 0;
                } else if (args[1].equalsIgnoreCase("||")) {
                    result = Boolean.valueOf(args[0]) != false || Boolean.valueOf(args[2]) != false ? 1 : 0;
                } else if (args[1].equalsIgnoreCase("==")) {
                    result = Integer.valueOf(args[0]).equals(Integer.valueOf(args[2])) ? 1 : 0;
                } else if (args[1].equalsIgnoreCase("!=")) {
                    result = !Integer.valueOf(args[0]).equals(Integer.valueOf(args[2])) ? 1 : 0;
                } else if (args[1].equalsIgnoreCase("<")) {
                    result = Integer.valueOf(args[0]).compareTo(Integer.valueOf(args[2])) > 0 ? 1 : 0;
                } else if (args[1].equalsIgnoreCase(">")) {
                    result = Integer.valueOf(args[0]).compareTo(Integer.valueOf(args[2])) < 0 ? 1 : 0;
                } else if (args[1].equalsIgnoreCase("<=")) {
                    result = Integer.valueOf(args[0]).compareTo(Integer.valueOf(args[2])) >= 0 ? 1 : 0;
                } else if (args[1].equalsIgnoreCase("=>")) {
                    result = Integer.valueOf(args[0]).compareTo(Integer.valueOf(args[2])) <= 0 ? 1 : 0;
                } else if (args[1].equalsIgnoreCase("&")) {
                    result = Integer.valueOf(args[0]) & Integer.valueOf(args[2]);
                } else if (args[1].equalsIgnoreCase("|")) {
                    result = Integer.valueOf(args[0]) | Integer.valueOf(args[2]);
                }
                if (args[1].equalsIgnoreCase("^")) {
                    result = Integer.valueOf(args[0]) ^ Integer.valueOf(args[2]);
                }
            }
            catch (NumberFormatException e) {
                result = args[1].equalsIgnoreCase("==") ? (args[0].equalsIgnoreCase(args[2]) ? 1 : 0) : (args[0].equalsIgnoreCase(args[2]) ? 0 : 1);
            }
            sender.addChatMessage((IChatComponent)new ChatComponentText(String.valueOf(result)));
            if (result == 0) {
                throw new CommandException("failure", new Object[0]);
            }
        }
    });
    public static final ReduxCommand RANDOM = new ReduxCommand("random", "/random <lower> <upper>", new ReduxCommandRunnable(){
        private final Random random = new Random();

        @Override
        public void run(ICommandSender sender, String ... args) throws CommandException {
            if (args.length < 2) {
                throw new CommandException("Incorrect parameters", new Object[0]);
            }
            try {
                int lower = Integer.parseInt(args[0]);
                int upper = Integer.parseInt(args[1]);
                int rand = lower + this.random.nextInt(upper - lower + 1);
                sender.addChatMessage((IChatComponent)new ChatComponentText(String.valueOf(rand)));
            }
            catch (NumberFormatException e) {
                throw new CommandException("First and Second parameters must be integers!", new Object[0]);
            }
        }
    });
    private static final List<ICommand> commands = new ArrayList<ICommand>();

    public static List<ICommand> getCommands() {
        return ImmutableList.copyOf(commands);
    }

    static {
        commands.add((ICommand)TEST_FOR_TRIGGER);
        commands.add((ICommand)TEST_FOR_PROPERTY);
        commands.add((ICommand)SET_PROPERTY);
        commands.add((ICommand)TEST);
        commands.add((ICommand)RANDOM);
    }

    public static class ReduxCommand
    extends CommandBase {
        private final String name;
        private final String commandUsage;
        private final ReduxCommandRunnable commandRunnable;

        public ReduxCommand(String name, String usage, ReduxCommandRunnable runnable) {
            this.name = name;
            this.commandUsage = usage;
            this.commandRunnable = runnable;
        }

        public int getRequiredPermissionLevel() {
            return 2;
        }

        public String getName() {
            return this.name;
        }

        public String getCommandUsage(ICommandSender sender) {
            return this.commandUsage;
        }

        public void execute(ICommandSender sender, String[] args) throws CommandException {
            this.commandRunnable.run(sender, args);
        }
    }

    private static abstract class ReduxCommandRunnable {
        private ReduxCommandRunnable() {
        }

        public abstract void run(ICommandSender var1, String ... var2) throws CommandException;
    }
}

