/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.socket;

import java.io.IOException;
import org.jruby.Ruby;
import org.jruby.ext.socket.Addrinfo;
import org.jruby.ext.socket.Option;
import org.jruby.ext.socket.RubyBasicSocket;
import org.jruby.ext.socket.RubyIPSocket;
import org.jruby.ext.socket.RubyServerSocket;
import org.jruby.ext.socket.RubySocket;
import org.jruby.ext.socket.RubyTCPServer;
import org.jruby.ext.socket.RubyTCPSocket;
import org.jruby.ext.socket.RubyUDPSocket;
import org.jruby.ext.socket.RubyUNIXServer;
import org.jruby.ext.socket.RubyUNIXSocket;
import org.jruby.platform.Platform;
import org.jruby.runtime.load.Library;

public class SocketLibrary
implements Library {
    @Override
    public void load(Ruby runtime, boolean wrap2) throws IOException {
        runtime.defineClass("SocketError", runtime.getStandardError(), runtime.getStandardError().getAllocator());
        RubyBasicSocket.createBasicSocket(runtime);
        RubySocket.createSocket(runtime);
        RubyServerSocket.createServerSocket(runtime);
        if (runtime.getInstanceConfig().isNativeEnabled() && !Platform.IS_WINDOWS) {
            RubyUNIXSocket.createUNIXSocket(runtime);
            RubyUNIXServer.createUNIXServer(runtime);
        }
        RubyIPSocket.createIPSocket(runtime);
        RubyTCPSocket.createTCPSocket(runtime);
        RubyTCPServer.createTCPServer(runtime);
        RubyUDPSocket.createUDPSocket(runtime);
        if (runtime.is1_9()) {
            Addrinfo.createAddrinfo(runtime);
            Option.createOption(runtime);
        }
    }
}

